/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.ComplementDate;
import net.sourceforge.plantuml.project.lang.ComplementPattern;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verb;
import net.sourceforge.plantuml.project.lang.VerbPattern;
import net.sourceforge.plantuml.project.time.Day;

public class VerbProjectStarts
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementDate());
    }

    public IRegex toRegexOld() {
        return new RegexLeaf("starts[%s]*(the[%s]*|on[%s]*)*");
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("start"), new RegexOptional((IRegex)new RegexLeaf("s")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexOr(new RegexLeaf("on"), new RegexLeaf("for"), new RegexLeaf("the"), new RegexLeaf("at"))));
    }

    @Override
    public Verb getVerb(final GanttDiagram project, RegexResult arg) {
        return new Verb(){

            @Override
            public CommandExecutionResult execute(Subject subject, Complement complement) {
                Day start = (Day)complement;
                assert (project == subject);
                project.setStartingDate(start);
                return CommandExecutionResult.ok();
            }
        };
    }
}

