/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Line2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;

public class DriverLineEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverLineEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, EpsGraphics eps) {
        ULine shape = (ULine)ushape;
        double x2 = x + shape.getDX();
        double y2 = y + shape.getDY();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Line2D.Double line = clip.getClippedLine(new Line2D.Double(x, y, x2, y2));
            if (line == null) {
                return;
            }
            x = line.x1;
            y = line.y1;
            x2 = line.x2;
            y2 = line.y2;
        }
        eps.setStrokeColor(mapper.getMappedColor(param.getColor()));
        eps.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashVisible(), param.getStroke().getDashSpace());
        eps.epsLine(x, y, x2, y2);
    }
}

