/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverEllipseG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;
    private static final double ROU = 5.0;

    public DriverEllipseG2d(double dpiFactor, EnsureVisible visible) {
        this.dpiFactor = dpiFactor;
        this.visible = visible;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        UEllipse ellipse = (UEllipse)ushape;
        g2d.setStroke(new BasicStroke((float)param.getStroke().getThickness()));
        this.visible.ensureVisible(x, y);
        this.visible.ensureVisible(x + ellipse.getWidth(), y + ellipse.getHeight());
        HColor color = param.getColor();
        if (ellipse.getStart() == 0.0 && ellipse.getExtend() == 0.0) {
            HColor back;
            Ellipse2D.Double shape = new Ellipse2D.Double(x, y, ellipse.getWidth(), ellipse.getHeight());
            if (ellipse.getDeltaShadow() != 0.0) {
                this.drawShadow(g2d, shape, ellipse.getDeltaShadow(), this.dpiFactor);
            }
            if ((back = param.getBackcolor()) instanceof HColorGradient) {
                GradientPaint paint = DriverRectangleG2d.getPaintGradient(x, y, mapper, ellipse.getWidth(), ellipse.getHeight(), back);
                g2d.setPaint(paint);
                g2d.fill(shape);
                DriverRectangleG2d.drawBorder(param, color, mapper, ellipse, shape, g2d, x, y);
            } else {
                if (back != null) {
                    g2d.setColor(mapper.getMappedColor(param.getBackcolor()));
                    DriverRectangleG2d.managePattern(param, g2d);
                    g2d.fill(shape);
                }
                if (color != null && !color.equals(param.getBackcolor())) {
                    DriverRectangleG2d.drawBorder(param, color, mapper, ellipse, shape, g2d, x, y);
                }
            }
        } else {
            Arc2D.Double arc = new Arc2D.Double(x, y, ellipse.getWidth(), ellipse.getHeight(), DriverEllipseG2d.round(ellipse.getStart()), DriverEllipseG2d.round(ellipse.getExtend()), 0);
            if (color != null) {
                g2d.setColor(mapper.getMappedColor(color));
                g2d.draw(arc);
            }
        }
    }

    static double round(double value) {
        return value;
    }
}

