/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.ApplePathWatchers;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.DirectoryRegistryImpl;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.PathWatcher;
import com.swoval.files.PlatformWatcher;
import com.swoval.files.PollingPathWatcher;
import com.swoval.files.RegisterableWatchService;
import com.swoval.files.TypedPath;
import com.swoval.logging.Logger;
import com.swoval.logging.Loggers;
import com.swoval.runtime.Platform;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

public class PathWatchers {
    private PathWatchers() {
    }

    public static PathWatcher<Event> get(boolean bl) throws IOException, InterruptedException {
        return PathWatchers.get(bl, new DirectoryRegistryImpl(), Loggers.getLogger());
    }

    public static PathWatcher<Event> polling(FileTreeDataViews.Converter<Long> converter, boolean bl, long l, TimeUnit timeUnit) throws InterruptedException {
        return new PollingPathWatcher(converter, bl, l, timeUnit);
    }

    public static PathWatcher<Event> polling(boolean bl, long l, TimeUnit timeUnit) throws InterruptedException {
        return new PollingPathWatcher(bl, l, timeUnit);
    }

    static PathWatcher<Event> get(boolean bl, DirectoryRegistry directoryRegistry, Logger logger) throws InterruptedException, IOException {
        return Platform.isMac() ? ApplePathWatchers.get(bl, directoryRegistry, logger) : PlatformWatcher.make(bl, directoryRegistry, logger);
    }

    static PathWatcher<Event> get(boolean bl, RegisterableWatchService registerableWatchService, DirectoryRegistry directoryRegistry) throws InterruptedException, IOException {
        return PlatformWatcher.make(bl, registerableWatchService, directoryRegistry, Loggers.getLogger());
    }

    static PathWatcher<Event> get(boolean bl, RegisterableWatchService registerableWatchService, DirectoryRegistry directoryRegistry, Logger logger) throws InterruptedException, IOException {
        return PlatformWatcher.make(bl, registerableWatchService, directoryRegistry, logger);
    }

    public static final class Event {
        private final TypedPath typedPath;
        private final Kind kind;

        public TypedPath getTypedPath() {
            return this.typedPath;
        }

        public Kind getKind() {
            return this.kind;
        }

        public Event(TypedPath typedPath, Kind kind) {
            this.typedPath = typedPath;
            this.kind = kind;
        }

        public boolean equals(Object object) {
            if (object instanceof Event) {
                Event event = (Event)object;
                return this.typedPath.equals(event.typedPath) && this.kind.equals(event.kind);
            }
            return false;
        }

        public int hashCode() {
            return this.typedPath.hashCode() ^ this.kind.hashCode();
        }

        public String toString() {
            return "Event(" + this.typedPath.getPath() + ", " + this.kind + ")";
        }

        public static class Kind {
            public static final Kind Create = new Kind("Create");
            public static final Kind Delete = new Kind("Delete");
            public static final Kind Error = new Kind("Error");
            public static final Kind Modify = new Kind("Modify");
            public static final Kind Overflow = new Kind("Overflow");
            private final String name;

            Kind(String string) {
                this.name = string;
            }

            public String toString() {
                return this.name;
            }

            public boolean equals(Object object) {
                return object instanceof Kind && ((Kind)object).name.equals(this.name);
            }

            public int hashCode() {
                return this.name.hashCode();
            }
        }
    }

    static final class Overflow {
        private final Path path;

        Overflow(Path path) {
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }
    }
}

