/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkix.jcajce;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.PKIXCRLStore;
import org.bouncycastle.jcajce.PKIXCRLStoreSelector;
import org.bouncycastle.jcajce.PKIXCertStore;
import org.bouncycastle.jcajce.PKIXCertStoreSelector;
import org.bouncycastle.jcajce.PKIXExtendedParameters;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.pkix.jcajce.AnnotatedException;
import org.bouncycastle.pkix.jcajce.CRLNotFoundException;
import org.bouncycastle.pkix.jcajce.CertStatus;
import org.bouncycastle.pkix.jcajce.PKIXCRLUtil;
import org.bouncycastle.pkix.jcajce.RFC3280CertPathUtilities;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RevocationUtilities {
    protected static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    protected static final String CERTIFICATE_POLICIES = Extension.certificatePolicies.getId();
    protected static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
    protected static final String POLICY_MAPPINGS = Extension.policyMappings.getId();
    protected static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
    protected static final String NAME_CONSTRAINTS = Extension.nameConstraints.getId();
    protected static final String KEY_USAGE = Extension.keyUsage.getId();
    protected static final String INHIBIT_ANY_POLICY = Extension.inhibitAnyPolicy.getId();
    protected static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
    protected static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
    protected static final String POLICY_CONSTRAINTS = Extension.policyConstraints.getId();
    protected static final String FRESHEST_CRL = Extension.freshestCRL.getId();
    protected static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    protected static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    protected static final String ANY_POLICY = "2.5.29.32.0";
    protected static final String CRL_NUMBER = Extension.cRLNumber.getId();
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    RevocationUtilities() {
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate x509Certificate, Set set) throws AnnotatedException {
        return RevocationUtilities.findTrustAnchor(x509Certificate, set, null);
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate x509Certificate, Set set, String string) throws AnnotatedException {
        TrustAnchor trustAnchor = null;
        PublicKey publicKey = null;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        X500Name x500Name = RevocationUtilities.getIssuer(x509Certificate);
        try {
            x509CertSelector.setSubject(x500Name.getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Cannot set subject search criteria for trust anchor.", iOException);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && trustAnchor == null) {
            block15: {
                trustAnchor = (TrustAnchor)iterator.next();
                if (trustAnchor.getTrustedCert() != null) {
                    if (x509CertSelector.match(trustAnchor.getTrustedCert())) {
                        publicKey = trustAnchor.getTrustedCert().getPublicKey();
                    } else {
                        trustAnchor = null;
                    }
                } else if (trustAnchor.getCAName() != null && trustAnchor.getCAPublicKey() != null) {
                    try {
                        X500Name x500Name2 = RevocationUtilities.getX500Name(trustAnchor.getCA());
                        if (x500Name.equals((Object)x500Name2)) {
                            publicKey = trustAnchor.getCAPublicKey();
                            break block15;
                        }
                        trustAnchor = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        trustAnchor = null;
                    }
                } else {
                    trustAnchor = null;
                }
            }
            if (publicKey == null) continue;
            try {
                RevocationUtilities.verifyX509Certificate(x509Certificate, publicKey, string);
            }
            catch (Exception exception2) {
                exception = exception2;
                trustAnchor = null;
                publicKey = null;
            }
        }
        if (trustAnchor == null && exception != null) {
            throw new AnnotatedException("TrustAnchor found but certificate validation failed.", exception);
        }
        return trustAnchor;
    }

    static boolean isIssuerTrustAnchor(X509Certificate x509Certificate, Set set, String string) throws AnnotatedException {
        try {
            return RevocationUtilities.findTrustAnchor(x509Certificate, set, string) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static List<PKIXCertStore> getAdditionalStoresFromAltNames(byte[] byArray, Map<GeneralName, PKIXCertStore> map) throws CertificateParsingException {
        if (byArray != null) {
            GeneralNames generalNames = GeneralNames.getInstance((Object)ASN1OctetString.getInstance((Object)byArray).getOctets());
            GeneralName[] generalNameArray = generalNames.getNames();
            ArrayList<PKIXCertStore> arrayList = new ArrayList<PKIXCertStore>();
            for (int i = 0; i != generalNameArray.length; ++i) {
                GeneralName generalName = generalNameArray[i];
                PKIXCertStore pKIXCertStore = map.get(generalName);
                if (pKIXCertStore == null) continue;
                arrayList.add(pKIXCertStore);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    protected static Date getValidDate(PKIXExtendedParameters pKIXExtendedParameters) {
        Date date = pKIXExtendedParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    protected static boolean isSelfIssued(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    protected static ASN1Primitive getExtensionValue(X509Extension x509Extension, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws AnnotatedException {
        byte[] byArray = x509Extension.getExtensionValue(aSN1ObjectIdentifier.getId());
        if (byArray == null) {
            return null;
        }
        return RevocationUtilities.getObject(aSN1ObjectIdentifier, byArray);
    }

    private static ASN1Primitive getObject(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws AnnotatedException {
        try {
            return ASN1Primitive.fromByteArray((byte[])ASN1OctetString.getInstance((Object)byArray).getOctets());
        }
        catch (Exception exception) {
            throw new AnnotatedException("exception processing extension " + aSN1ObjectIdentifier, exception);
        }
    }

    protected static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithm();
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("subject public key cannot be decoded", exception);
        }
    }

    protected static Collection findCertificates(PKIXCertStoreSelector pKIXCertStoreSelector, List list) throws AnnotatedException {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object e : list) {
            Object object;
            if (e instanceof Store) {
                object = (Store)e;
                try {
                    linkedHashSet.addAll(object.getMatches((Selector)pKIXCertStoreSelector));
                    continue;
                }
                catch (StoreException storeException) {
                    throw new AnnotatedException("Problem while picking certificates from X.509 store.", storeException);
                }
            }
            object = (CertStore)e;
            try {
                linkedHashSet.addAll(PKIXCertStoreSelector.getCertificates((PKIXCertStoreSelector)pKIXCertStoreSelector, (CertStore)object));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", certStoreException);
            }
        }
        return linkedHashSet;
    }

    static List<PKIXCRLStore> getAdditionalStoresFromCRLDistributionPoint(CRLDistPoint cRLDistPoint, Map<GeneralName, PKIXCRLStore> map) throws AnnotatedException {
        if (cRLDistPoint != null) {
            DistributionPoint[] distributionPointArray = null;
            try {
                distributionPointArray = cRLDistPoint.getDistributionPoints();
            }
            catch (Exception exception) {
                throw new AnnotatedException("Distribution points could not be read.", exception);
            }
            ArrayList<PKIXCRLStore> arrayList = new ArrayList<PKIXCRLStore>();
            for (int i = 0; i < distributionPointArray.length; ++i) {
                DistributionPointName distributionPointName = distributionPointArray[i].getDistributionPoint();
                if (distributionPointName == null || distributionPointName.getType() != 0) continue;
                GeneralName[] generalNameArray = GeneralNames.getInstance((Object)distributionPointName.getName()).getNames();
                for (int j = 0; j < generalNameArray.length; ++j) {
                    PKIXCRLStore pKIXCRLStore = map.get(generalNameArray[j]);
                    if (pKIXCRLStore == null) continue;
                    arrayList.add(pKIXCRLStore);
                }
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    protected static void getCRLIssuersFromDistributionPoint(DistributionPoint distributionPoint, Collection collection, X509CRLSelector x509CRLSelector) throws AnnotatedException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (distributionPoint.getCRLIssuer() != null) {
            object = distributionPoint.getCRLIssuer().getNames();
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (object[i].getTagNo() != 4) continue;
                try {
                    arrayList.add(X500Name.getInstance((Object)object[i].getName()));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", illegalArgumentException);
                }
            }
        } else {
            if (distributionPoint.getDistributionPoint() == null) {
                throw new AnnotatedException("CRL issuer is omitted from distribution point but no distributionPoint field present.");
            }
            object = collection.iterator();
            while (object.hasNext()) {
                arrayList.add(object.next());
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                x509CRLSelector.addIssuerName(((X500Name)object.next()).getEncoded());
            }
            catch (IOException iOException) {
                throw new AnnotatedException("Cannot decode CRL issuer information.", iOException);
            }
        }
    }

    protected static void getCertStatus(Date date, X509CRL x509CRL, Object object, CertStatus certStatus) throws AnnotatedException {
        X500Principal x500Principal;
        Date date2;
        Object object2;
        boolean bl;
        try {
            bl = RevocationUtilities.isIndirectCRL(x509CRL);
        }
        catch (CRLException cRLException) {
            throw new AnnotatedException("Failed check for indirect CRL.", cRLException);
        }
        X509Certificate x509Certificate = (X509Certificate)object;
        X500Name x500Name = RevocationUtilities.getIssuer(x509Certificate);
        if (!bl && !x500Name.equals(object2 = RevocationUtilities.getIssuer(x509CRL))) {
            return;
        }
        object2 = x509CRL.getRevokedCertificate(x509Certificate.getSerialNumber());
        if (null == object2) {
            return;
        }
        if (bl && !x500Name.equals((Object)(date2 = null == (x500Principal = ((X509CRLEntry)object2).getCertificateIssuer()) ? RevocationUtilities.getIssuer(x509CRL) : RevocationUtilities.getX500Name(x500Principal)))) {
            return;
        }
        int n = 0;
        if (((X509CRLEntry)object2).hasExtensions()) {
            try {
                date2 = RevocationUtilities.getExtensionValue((X509Extension)object2, Extension.reasonCode);
                ASN1Enumerated aSN1Enumerated = ASN1Enumerated.getInstance((Object)date2);
                if (null != aSN1Enumerated) {
                    n = aSN1Enumerated.intValueExact();
                }
            }
            catch (Exception exception) {
                throw new AnnotatedException("Reason code CRL entry extension could not be decoded.", exception);
            }
        }
        if (date.before(date2 = ((X509CRLEntry)object2).getRevocationDate())) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 10: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        certStatus.setCertStatus(n);
        certStatus.setRevocationDate(date2);
    }

    protected static Set getDeltaCRLs(Date date, X509CRL x509CRL, List<CertStore> list, List<PKIXCRLStore> list2) throws AnnotatedException {
        Object object;
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            x509CRLSelector.addIssuerName(x509CRL.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("cannot extract issuer from CRL.", iOException);
        }
        BigInteger bigInteger = null;
        try {
            object = RevocationUtilities.getExtensionValue(x509CRL, Extension.cRLNumber);
            if (object != null) {
                bigInteger = ASN1Integer.getInstance((Object)object).getPositiveValue();
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("cannot extract CRL number extension from CRL", exception);
        }
        object = null;
        try {
            object = x509CRL.getExtensionValue(ISSUING_DISTRIBUTION_POINT);
        }
        catch (Exception exception) {
            throw new AnnotatedException("issuing distribution point extension value could not be read", exception);
        }
        x509CRLSelector.setMinCRLNumber(bigInteger == null ? null : bigInteger.add(BigInteger.valueOf(1L)));
        PKIXCRLStoreSelector.Builder builder = new PKIXCRLStoreSelector.Builder((CRLSelector)x509CRLSelector);
        builder.setIssuingDistributionPoint((byte[])object);
        builder.setIssuingDistributionPointEnabled(true);
        builder.setMaxBaseCRLNumber(bigInteger);
        PKIXCRLStoreSelector pKIXCRLStoreSelector = builder.build();
        Set set = CRL_UTIL.findCRLs(pKIXCRLStoreSelector, date, list, list2);
        HashSet<X509CRL> hashSet = new HashSet<X509CRL>();
        for (X509CRL x509CRL2 : set) {
            if (!RevocationUtilities.isDeltaCRL(x509CRL2)) continue;
            hashSet.add(x509CRL2);
        }
        return hashSet;
    }

    private static boolean isDeltaCRL(X509CRL x509CRL) {
        Set<String> set = x509CRL.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        return set.contains(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
    }

    protected static Set getCompleteCRLs(DistributionPoint distributionPoint, Object object, Date date, List list, List list2) throws AnnotatedException, CRLNotFoundException {
        PKIXCRLStoreSelector pKIXCRLStoreSelector;
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            pKIXCRLStoreSelector = new HashSet();
            pKIXCRLStoreSelector.add(RevocationUtilities.getIssuer((X509Certificate)object));
            RevocationUtilities.getCRLIssuersFromDistributionPoint(distributionPoint, pKIXCRLStoreSelector, x509CRLSelector);
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Could not get issuer information from distribution point.", annotatedException);
        }
        if (object instanceof X509Certificate) {
            x509CRLSelector.setCertificateChecking((X509Certificate)object);
        }
        pKIXCRLStoreSelector = new PKIXCRLStoreSelector.Builder((CRLSelector)x509CRLSelector).setCompleteCRLEnabled(true).build();
        Set set = CRL_UTIL.findCRLs(pKIXCRLStoreSelector, date, list, list2);
        RevocationUtilities.checkCRLsNotEmpty(set, object);
        return set;
    }

    protected static Date getValidCertDateFromValidityModel(PKIXExtendedParameters pKIXExtendedParameters, CertPath certPath, int n) throws AnnotatedException {
        if (pKIXExtendedParameters.getValidityModel() == 1) {
            if (n <= 0) {
                return RevocationUtilities.getValidDate(pKIXExtendedParameters);
            }
            if (n - 1 == 0) {
                ASN1GeneralizedTime aSN1GeneralizedTime = null;
                try {
                    byte[] byArray = ((X509Certificate)certPath.getCertificates().get(n - 1)).getExtensionValue(ISISMTTObjectIdentifiers.id_isismtt_at_dateOfCertGen.getId());
                    if (byArray != null) {
                        aSN1GeneralizedTime = ASN1GeneralizedTime.getInstance((Object)ASN1Primitive.fromByteArray((byte[])byArray));
                    }
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                if (aSN1GeneralizedTime != null) {
                    try {
                        return aSN1GeneralizedTime.getDate();
                    }
                    catch (ParseException parseException) {
                        throw new AnnotatedException("Date from date of cert gen extension could not be parsed.", parseException);
                    }
                }
                return ((X509Certificate)certPath.getCertificates().get(n - 1)).getNotBefore();
            }
            return ((X509Certificate)certPath.getCertificates().get(n - 1)).getNotBefore();
        }
        return RevocationUtilities.getValidDate(pKIXExtendedParameters);
    }

    protected static PublicKey getNextWorkingKey(List list, int n, JcaJceHelper jcaJceHelper) throws CertPathValidatorException {
        Certificate certificate = (Certificate)list.get(n);
        PublicKey publicKey = certificate.getPublicKey();
        if (!(publicKey instanceof DSAPublicKey)) {
            return publicKey;
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        if (dSAPublicKey.getParams() != null) {
            return dSAPublicKey;
        }
        for (int i = n + 1; i < list.size(); ++i) {
            X509Certificate x509Certificate = (X509Certificate)list.get(i);
            publicKey = x509Certificate.getPublicKey();
            if (!(publicKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
            }
            DSAPublicKey dSAPublicKey2 = (DSAPublicKey)publicKey;
            if (dSAPublicKey2.getParams() == null) continue;
            DSAParams dSAParams = dSAPublicKey2.getParams();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            try {
                KeyFactory keyFactory = jcaJceHelper.createKeyFactory("DSA");
                return keyFactory.generatePublic(dSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }

    static Collection findIssuerCerts(X509Certificate x509Certificate, List<CertStore> list, List<PKIXCertStore> list2) throws AnnotatedException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(x509Certificate.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate could not be set.", iOException);
        }
        try {
            object3 = x509Certificate.getExtensionValue(AUTHORITY_KEY_IDENTIFIER);
            if (object3 != null && (object2 = AuthorityKeyIdentifier.getInstance((Object)(object = ASN1OctetString.getInstance((Object)object3)).getOctets()).getKeyIdentifier()) != null) {
                x509CertSelector.setSubjectKeyIdentifier(new DEROctetString((byte[])object2).getEncoded());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = new PKIXCertStoreSelector.Builder((CertSelector)x509CertSelector).build();
        object = new LinkedHashSet();
        try {
            serializable = new ArrayList();
            serializable.addAll(RevocationUtilities.findCertificates((PKIXCertStoreSelector)object3, list));
            serializable.addAll(RevocationUtilities.findCertificates((PKIXCertStoreSelector)object3, list2));
            object2 = serializable.iterator();
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Issuer certificate cannot be searched.", annotatedException);
        }
        serializable = null;
        while (object2.hasNext()) {
            serializable = (X509Certificate)object2.next();
            object.add(serializable);
        }
        return object;
    }

    protected static void verifyX509Certificate(X509Certificate x509Certificate, PublicKey publicKey, String string) throws GeneralSecurityException {
        if (string == null) {
            x509Certificate.verify(publicKey);
        } else {
            x509Certificate.verify(publicKey, string);
        }
    }

    static void checkCRLsNotEmpty(Set set, Object object) throws CRLNotFoundException {
        if (set.isEmpty()) {
            X500Name x500Name = RevocationUtilities.getIssuer((X509Certificate)object);
            throw new CRLNotFoundException("No CRLs found for issuer \"" + RFC4519Style.INSTANCE.toString(x500Name) + "\"");
        }
    }

    public static boolean isIndirectCRL(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(Extension.issuingDistributionPoint.getId());
            return byArray != null && IssuingDistributionPoint.getInstance((Object)ASN1OctetString.getInstance((Object)byArray).getOctets()).isIndirectCRL();
        }
        catch (Exception exception) {
            throw new CRLException("exception reading IssuingDistributionPoint", exception);
        }
    }

    private static X500Name getIssuer(X509Certificate x509Certificate) {
        return RevocationUtilities.getX500Name(x509Certificate.getIssuerX500Principal());
    }

    private static X500Name getIssuer(X509CRL x509CRL) {
        return RevocationUtilities.getX500Name(x509CRL.getIssuerX500Principal());
    }

    private static X500Name getX500Name(X500Principal x500Principal) {
        return X500Name.getInstance((Object)x500Principal.getEncoded());
    }
}

