/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.netbeans.modules.profiler.v2.Bundle;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerFeatures;
import org.netbeans.modules.profiler.v2.ProfilerPlugins;
import org.netbeans.modules.profiler.v2.ProfilerSessions;
import org.netbeans.modules.profiler.v2.ProfilerWindow;
import org.netbeans.modules.profiler.v2.SessionStorage;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class ProfilerSession {
    private static ProfilerSession CURRENT_SESSION;
    private static final Object CURRENT_SESSION_LOCK;
    private Lookup context;
    private final Profiler profiler;
    private ProfilerWindow window;
    private ProfilingSettings profilingSettings;
    private AttachSettings attachSettings;
    private boolean isAttach;
    private SessionStorage storage;
    private final Set<ProfilingStateListener> profilingStateListeners = new HashSet<ProfilingStateListener>();
    private ProfilerFeatures features;
    private ProfilerPlugins plugins;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilerSession currentSession() {
        Object object = CURRENT_SESSION_LOCK;
        synchronized (object) {
            return CURRENT_SESSION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfilerSession forContext(Lookup lookup) {
        Object object = CURRENT_SESSION_LOCK;
        synchronized (object) {
            if (CURRENT_SESSION != null) {
                if (CURRENT_SESSION.isCompatibleContext(lookup)) {
                    CURRENT_SESSION.setContext(lookup);
                    return CURRENT_SESSION;
                }
                if (!CURRENT_SESSION.close()) {
                    return null;
                }
            }
        }
        if (!ProfilerSessions.waitForProfiler()) {
            return null;
        }
        object = (Provider)Lookup.getDefault().lookup(Provider.class);
        ProfilerSession profilerSession = object == null ? null : ((Provider)object).createSession(lookup);
        Object object2 = CURRENT_SESSION_LOCK;
        synchronized (object2) {
            CURRENT_SESSION = profilerSession;
        }
        ProfilerSession.notifyStopAction();
        return profilerSession;
    }

    public static void findAndConfigure(Lookup lookup, Lookup.Provider provider, String string) {
        ProfilerSession profilerSession = ProfilerSession.currentSession();
        if (profilerSession != null) {
            ProfilerSessions.configure(profilerSession, lookup, string);
        } else {
            ProfilerSessions.createAndConfigure(lookup, provider, string);
        }
    }

    protected ProfilerSession(Profiler profiler, Lookup lookup) {
        if (profiler == null) {
            throw new IllegalArgumentException("Profiler cannot be null");
        }
        this.profiler = profiler;
        this.setContext(lookup);
    }

    protected final synchronized Lookup getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setContext(Lookup lookup) {
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            this.context = lookup;
        }
        this.notifyWindow();
    }

    protected abstract boolean start();

    protected abstract boolean modify();

    protected abstract boolean stop();

    public abstract Lookup.Provider getProject();

    public abstract FileObject getFile();

    protected abstract boolean isCompatibleContext(Lookup var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttach(final boolean bl) {
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            if (bl == this.isAttach) {
                return;
            }
        }
        boolean bl2 = this.inProgress();
        if (bl2 && !this.confirmedStop()) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    ProfilerSession.this.isAttach = bl;
                }
                ProfilerSession.notifyStopAction();
                ProfilerSession.this.notifyWindow();
            }
        };
        if (!bl2) {
            runnable.run();
        } else {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)runnable);
        }
    }

    public final synchronized boolean isAttach() {
        return this.isAttach;
    }

    public final Profiler getProfiler() {
        return this.profiler;
    }

    public final ProfilingSettings getProfilingSettings() {
        return this.profilingSettings;
    }

    public final AttachSettings getAttachSettings() {
        return this.attachSettings;
    }

    public final synchronized SessionStorage getStorage() {
        if (this.storage == null) {
            this.storage = new SessionStorage(this.getProject());
        }
        return this.storage;
    }

    public final void open() {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProfilerWindow profilerWindow = ProfilerSession.this.getWindow();
                profilerWindow.open();
                profilerWindow.requestActive();
            }
        });
    }

    public final int getState() {
        return this.profiler.getProfilingState();
    }

    public final boolean inProgress() {
        return this.getState() != 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(ProfilingStateListener profilingStateListener) {
        Profiler profiler = this.profiler;
        synchronized (profiler) {
            this.profiler.addProfilingStateListener(profilingStateListener);
            this.profilingStateListeners.add(profilingStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(ProfilingStateListener profilingStateListener) {
        Profiler profiler = this.profiler;
        synchronized (profiler) {
            this.profiler.removeProfilingStateListener(profilingStateListener);
            this.profilingStateListeners.remove(profilingStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanupAllListeners() {
        Profiler profiler = this.profiler;
        synchronized (profiler) {
            for (ProfilingStateListener profilingStateListener : this.profilingStateListeners) {
                this.profiler.removeProfilingStateListener(profilingStateListener);
            }
        }
    }

    final boolean doStart(ProfilingSettings profilingSettings, AttachSettings attachSettings) {
        this.profilingSettings = profilingSettings;
        this.attachSettings = attachSettings;
        this.plugins.notifyStarting();
        return this.start();
    }

    final boolean doModify(ProfilingSettings profilingSettings) {
        this.profilingSettings = profilingSettings;
        return this.modify();
    }

    final boolean doStop() {
        this.plugins.notifyStopping();
        return this.stop();
    }

    private final boolean confirmedStop() {
        if (this.inProgress()) {
            if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerWindow_terminateMsg(), (String)Bundle.ProfilerWindow_terminateCaption())) {
                return false;
            }
            if (!this.doStop()) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean close() {
        if (!this.confirmedStop()) {
            return false;
        }
        Object object = CURRENT_SESSION_LOCK;
        synchronized (object) {
            if (CURRENT_SESSION == this) {
                CURRENT_SESSION = null;
            }
        }
        ProfilerSession.notifyStopAction();
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProfilerSession.this.window != null) {
                    if (!((ProfilerSession)ProfilerSession.this).window.closing && ProfilerSession.this.window.isOpened()) {
                        ((ProfilerSession)ProfilerSession.this).window.closing = true;
                        ProfilerSession.this.window.close();
                    }
                } else {
                    ProfilerSession.this.cleanup();
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ProfilerFeatures getFeatures() {
        assert (!SwingUtilities.isEventDispatchThread());
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            if (this.features == null) {
                this.features = new ProfilerFeatures(this);
            }
        }
        return this.features;
    }

    final void selectFeature(final ProfilerFeature profilerFeature) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProfilerSession.this.getWindow().selectFeature(profilerFeature);
            }
        };
        UIUtils.runInEventDispatchThread((Runnable)runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ProfilerPlugins getPlugins() {
        assert (!SwingUtilities.isEventDispatchThread());
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            if (this.plugins == null) {
                this.plugins = new ProfilerPlugins(this);
            }
        }
        return this.plugins;
    }

    final synchronized void persistStorage(boolean bl) {
        if (this.storage != null) {
            this.storage.persist(bl);
        }
    }

    private ProfilerWindow getWindow() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.window == null) {
            this.window = new ProfilerWindow(this){

                @Override
                protected void componentClosed() {
                    super.componentClosed();
                    ProfilerSession.this.window = null;
                    ProfilerSession.this.cleanup();
                }
            };
        }
        return this.window;
    }

    private void notifyWindow() {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProfilerSession.this.window != null) {
                    ProfilerSession.this.window.updateSession();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        ProfilerSession profilerSession = this;
        synchronized (profilerSession) {
            if (this.features != null) {
                this.features.sessionFinished();
            }
        }
        this.cleanupAllListeners();
        ResetResultsAction.getInstance().performAction();
        this.persistStorage(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyStopAction() {
        ProfilerSession profilerSession;
        Object object = CURRENT_SESSION_LOCK;
        synchronized (object) {
            profilerSession = CURRENT_SESSION;
        }
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProfilerSessions.StopAction.getInstance().setSession(profilerSession);
            }
        });
    }

    static {
        CURRENT_SESSION_LOCK = new Object();
    }

    public static abstract class Provider {
        public abstract ProfilerSession createSession(Lookup var1);
    }
}

