/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.shared.utils.xml.PrettyPrintXMLWriter;
import org.apache.maven.shared.utils.xml.Xpp3DomUtils;
import org.apache.maven.shared.utils.xml.Xpp3DomWriter;

public class Xpp3Dom
implements Iterable<Xpp3Dom> {
    private static final long serialVersionUID = 2567894443061173996L;
    private String name;
    private String value;
    private Map<String, String> attributes;
    final List<Xpp3Dom> childList;
    final Map<String, Xpp3Dom> childMap;
    private Xpp3Dom parent;
    public static final String CHILDREN_COMBINATION_MODE_ATTRIBUTE = "combine.children";
    private static final String CHILDREN_COMBINATION_MERGE = "merge";
    public static final String CHILDREN_COMBINATION_APPEND = "append";
    private static final String DEFAULT_CHILDREN_COMBINATION_MODE = "merge";
    public static final String SELF_COMBINATION_MODE_ATTRIBUTE = "combine.self";
    public static final String SELF_COMBINATION_OVERRIDE = "override";
    public static final String SELF_COMBINATION_MERGE = "merge";
    private static final String DEFAULT_SELF_COMBINATION_MODE = "merge";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Xpp3Dom[] EMPTY_DOM_ARRAY = new Xpp3Dom[0];

    public Xpp3Dom(String name2) {
        this.name = name2;
        this.childList = new ArrayList<Xpp3Dom>();
        this.childMap = new HashMap<String, Xpp3Dom>();
    }

    public Xpp3Dom(Xpp3Dom source2) {
        this(source2, source2.getName());
    }

    public Xpp3Dom(@Nonnull Xpp3Dom src, String name2) {
        this.name = name2;
        int size = src.getChildCount();
        this.childList = new ArrayList<Xpp3Dom>(size);
        this.childMap = new HashMap<String, Xpp3Dom>();
        this.setValue(src.getValue());
        for (String attributeName : src.getAttributeNames()) {
            this.setAttribute(attributeName, src.getAttribute(attributeName));
        }
        for (Xpp3Dom xpp3Dom : src.getChildren()) {
            this.addChild(new Xpp3Dom(xpp3Dom));
        }
    }

    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    public void setValue(@Nonnull String value) {
        this.value = value;
    }

    public String[] getAttributeNames() {
        boolean isNothing = this.attributes == null || this.attributes.isEmpty();
        return isNothing ? EMPTY_STRING_ARRAY : this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String getAttribute(String nameParameter) {
        return this.attributes != null ? this.attributes.get(nameParameter) : null;
    }

    public void setAttribute(@Nonnull String nameParameter, @Nonnull String valueParameter) {
        if (valueParameter == null) {
            throw new NullPointerException("value can not be null");
        }
        if (nameParameter == null) {
            throw new NullPointerException("name can not be null");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(nameParameter, valueParameter);
    }

    public Xpp3Dom getChild(int i) {
        return this.childList.get(i);
    }

    public Xpp3Dom getChild(String nameParameter) {
        return this.childMap.get(nameParameter);
    }

    public void addChild(Xpp3Dom child) {
        child.setParent(this);
        this.childList.add(child);
        this.childMap.put(child.getName(), child);
    }

    public Xpp3Dom[] getChildren() {
        boolean isNothing = this.childList == null || this.childList.isEmpty();
        return isNothing ? EMPTY_DOM_ARRAY : this.childList.toArray(new Xpp3Dom[this.childList.size()]);
    }

    private List<Xpp3Dom> getChildrenList() {
        boolean isNothing = this.childList == null || this.childList.isEmpty();
        return isNothing ? Collections.emptyList() : this.childList;
    }

    public Xpp3Dom[] getChildren(String nameParameter) {
        List<Xpp3Dom> children2 = this.getChildrenList(nameParameter);
        return children2.toArray(new Xpp3Dom[children2.size()]);
    }

    List<Xpp3Dom> getChildrenList(String nameParameter) {
        if (this.childList == null) {
            return Collections.emptyList();
        }
        ArrayList<Xpp3Dom> children2 = new ArrayList<Xpp3Dom>();
        for (Xpp3Dom aChildList : this.childList) {
            if (!nameParameter.equals(aChildList.getName())) continue;
            children2.add(aChildList);
        }
        return children2;
    }

    public int getChildCount() {
        if (this.childList == null) {
            return 0;
        }
        return this.childList.size();
    }

    public void removeChild(int i) {
        Xpp3Dom child = this.childList.remove(i);
        this.childMap.values().remove(child);
        child.setParent(null);
    }

    public Xpp3Dom getParent() {
        return this.parent;
    }

    public void setParent(Xpp3Dom parent) {
        this.parent = parent;
    }

    private static Xpp3Dom merge(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        return Xpp3DomUtils.merge(dominant, recessive, childMergeOverride);
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        return Xpp3DomUtils.mergeXpp3Dom(dominant, recessive, childMergeOverride);
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive) {
        return Xpp3DomUtils.mergeXpp3Dom(dominant, recessive);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Xpp3Dom)) {
            return false;
        }
        Xpp3Dom dom = (Xpp3Dom)obj;
        return !((this.name != null ? !this.name.equals(dom.name) : dom.name != null) || (this.value != null ? !this.value.equals(dom.value) : dom.value != null) || (this.attributes != null ? !this.attributes.equals(dom.attributes) : dom.attributes != null) || (this.childList != null ? !this.childList.equals(dom.childList) : dom.childList != null));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 37 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 37 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 37 * result + (this.childList != null ? this.childList.hashCode() : 0);
        return result;
    }

    public String toString() {
        try {
            StringWriter writer2 = new StringWriter();
            Xpp3DomWriter.write(this.getPrettyPrintXMLWriter(writer2), this);
            return writer2.toString();
        }
        catch (IOException e2) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unexpected IOException from StringWriter."))).initCause(e2));
        }
    }

    public String toUnescapedString() {
        try {
            StringWriter writer2 = new StringWriter();
            Xpp3DomWriter.write(this.getPrettyPrintXMLWriter(writer2), this, false);
            return writer2.toString();
        }
        catch (IOException e2) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unexpected IOException from StringWriter."))).initCause(e2));
        }
    }

    private PrettyPrintXMLWriter getPrettyPrintXMLWriter(StringWriter writer2) {
        return new PrettyPrintXMLWriter(writer2, "UTF-8", null);
    }

    public static boolean isNotEmpty(String str2) {
        return str2 != null && str2.length() > 0;
    }

    public static boolean isEmpty(String str2) {
        return str2 == null || str2.trim().length() == 0;
    }

    @Override
    public Iterator<Xpp3Dom> iterator() {
        return this.getChildrenList().iterator();
    }
}

