/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public abstract class ComboMultiSelect
extends KeyedItem {
    private static final Renderer RENDERER = new Renderer();
    public String values;
    public String values_from;
    public String values_context;
    public boolean values_no_i18n;
    public boolean values_sort = true;
    public String display_values;
    public String locale_display_values;
    public String short_descriptions;
    public String locale_short_descriptions;
    public String default_;
    public char delimiter = (char)59;
    public byte use_last_as_default;
    public boolean values_searchable;
    protected JComponent component;
    protected final Set<PresetListEntry> presetListEntries = new CopyOnWriteArraySet<PresetListEntry>();
    private boolean initialized;
    protected KeyedItem.Usage usage;
    protected Object originalValue;

    public static String[] splitEscaped(char delimiter, String s) {
        if (s == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean backslash = false;
        StringBuilder item = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (backslash) {
                item.append(ch);
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            if (ch == delimiter) {
                result.add(item.toString());
                item.setLength(0);
                continue;
            }
            item.append(ch);
        }
        if (item.length() > 0) {
            result.add(item.toString());
        }
        return result.toArray(new String[0]);
    }

    protected abstract Object getSelectedItem();

    protected abstract void addToPanelAnchor(JPanel var1, String var2, boolean var3);

    @Override
    public Collection<String> getValues() {
        this.initListEntries(false);
        return this.presetListEntries.stream().map(x -> x.value).collect(Collectors.toSet());
    }

    public Collection<String> getDisplayValues() {
        this.initListEntries(false);
        return this.presetListEntries.stream().map(PresetListEntry::getDisplayValue).collect(Collectors.toList());
    }

    @Override
    public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
        this.initListEntries(true);
        this.usage = ComboMultiSelect.determineTextUsage(sel, this.key);
        if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
            this.presetListEntries.add(new PresetListEntry(DIFFERENT));
        }
        JLabel label = new JLabel(I18n.tr("{0}:", this.locale_text));
        label.setToolTipText(this.getKeyTooltipText());
        label.setComponentPopupMenu(this.getPopupMenu());
        p.add((Component)label, GBC.std().insets(0, 0, 10, 0));
        this.addToPanelAnchor(p, this.default_, presetInitiallyMatches);
        label.setLabelFor(this.component);
        this.component.setToolTipText(this.getKeyTooltipText());
        return true;
    }

    private void initListEntries(boolean cleanup) {
        if (this.initialized) {
            if (cleanup) {
                this.presetListEntries.remove(new PresetListEntry(DIFFERENT));
            }
            return;
        }
        if (this.presetListEntries.isEmpty()) {
            this.initListEntriesFromAttributes();
        } else {
            if (this.values != null) {
                Logging.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "values", "list_entry"));
            }
            if (this.display_values != null || this.locale_display_values != null) {
                Logging.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "display_values", "list_entry"));
            }
            if (this.short_descriptions != null || this.locale_short_descriptions != null) {
                Logging.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "short_descriptions", "list_entry"));
            }
            for (PresetListEntry e : this.presetListEntries) {
                if (e.value_context != null) continue;
                e.value_context = this.values_context;
            }
        }
        this.initializeLocaleText(null);
        this.initialized = true;
    }

    private void initListEntriesFromAttributes() {
        String descr;
        Object[] shortDescriptionsArray;
        String[] classMethod;
        Object[] valueArray = null;
        if (this.values_from != null && (classMethod = this.values_from.split("#")).length == 2) {
            try {
                Method method = Class.forName(classMethod[0]).getMethod(classMethod[1], new Class[0]);
                int mod = method.getModifiers();
                if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && method.getReturnType().equals(String[].class) && method.getParameterTypes().length == 0) {
                    valueArray = (String[])method.invoke(null, new Object[0]);
                } else {
                    Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' is not \"{2}\"", this.key, this.text, "public static String[] methodName()"));
                }
            }
            catch (ReflectiveOperationException e) {
                Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' threw {2} ({3})", this.key, this.text, e.getClass().getName(), e.getMessage()));
                Logging.debug(e);
            }
        }
        if (valueArray == null) {
            valueArray = ComboMultiSelect.splitEscaped(this.delimiter, this.values);
            this.values = null;
        }
        Object[] displayArray = valueArray;
        if (!this.values_no_i18n) {
            String displ = Utils.firstNonNull(this.locale_display_values, this.display_values);
            displayArray = displ == null ? valueArray : ComboMultiSelect.splitEscaped(this.delimiter, displ);
        }
        Object[] objectArray = shortDescriptionsArray = (descr = Utils.firstNonNull(this.locale_short_descriptions, this.short_descriptions)) == null ? null : ComboMultiSelect.splitEscaped(this.delimiter, descr);
        if (displayArray.length != valueArray.length) {
            Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''display_values'' must be the same as in ''values''", this.key, this.text));
            Logging.error(I18n.tr("Detailed information: {0} <> {1}", Arrays.toString(displayArray), Arrays.toString(valueArray)));
            displayArray = valueArray;
        }
        if (shortDescriptionsArray != null && shortDescriptionsArray.length != valueArray.length) {
            Logging.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''short_descriptions'' must be the same as in ''values''", this.key, this.text));
            Logging.error(I18n.tr("Detailed information: {0} <> {1}", Arrays.toString(shortDescriptionsArray), Arrays.toString(valueArray)));
            shortDescriptionsArray = null;
        }
        ArrayList<PresetListEntry> entries = new ArrayList<PresetListEntry>(valueArray.length);
        for (int i = 0; i < valueArray.length; ++i) {
            PresetListEntry e = new PresetListEntry(valueArray[i]);
            Object value = this.locale_display_values != null || this.values_no_i18n ? displayArray[i] : I18n.trc(this.values_context, ComboMultiSelect.fixPresetString((String)displayArray[i]));
            String string = e.locale_display_value = value == null ? null : ((String)value).intern();
            if (shortDescriptionsArray != null) {
                Object description = this.locale_short_descriptions != null ? shortDescriptionsArray[i] : I18n.tr(ComboMultiSelect.fixPresetString((String)shortDescriptionsArray[i]), new Object[0]);
                e.locale_short_description = description == null ? null : ((String)description).intern();
            }
            entries.add(e);
        }
        if (this.values_sort && Config.getPref().getBoolean("taggingpreset.sortvalues", true)) {
            Collections.sort(entries);
        }
        this.addListEntries(entries);
    }

    protected String getDisplayIfNull() {
        return null;
    }

    protected String getSelectedValue() {
        String display;
        Object obj = this.getSelectedItem();
        String string = display = obj == null ? this.getDisplayIfNull() : obj.toString();
        if (display == null) {
            return "";
        }
        return this.presetListEntries.stream().filter(entry -> Objects.equals(entry.toString(), display)).findFirst().map(entry -> entry.value).map(Utils::removeWhiteSpaces).orElse(display);
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
        String value = this.getSelectedValue();
        if (this.originalValue == null ? value.isEmpty() : value.equals(this.originalValue.toString())) {
            return;
        }
        if (this.isUseLastAsDefault()) {
            LAST_VALUES.put(this.key, value);
        }
        changedTags.add(new Tag(this.key, value));
    }

    public void setUse_last_as_default(String v) {
        this.use_last_as_default = "force".equals(v) ? (byte)2 : ("true".equals(v) ? (byte)1 : 0);
    }

    protected boolean isUseLastAsDefault() {
        return this.use_last_as_default > 0;
    }

    protected boolean isForceUseLastAsDefault() {
        return this.use_last_as_default == 2;
    }

    public void addListEntry(PresetListEntry e) {
        this.presetListEntries.add(e);
    }

    public void addListEntries(Collection<PresetListEntry> e) {
        for (PresetListEntry i : e) {
            this.addListEntry(i);
        }
    }

    protected PresetListEntry getListEntry(String value) {
        return this.presetListEntries.stream().filter(e -> Objects.equals(e.value, value)).findFirst().orElse(null);
    }

    protected ListCellRenderer<PresetListEntry> getListCellRenderer() {
        return RENDERER;
    }

    @Override
    public KeyedItem.MatchType getDefaultMatch() {
        return KeyedItem.MatchType.NONE;
    }

    public static class PresetListEntry
    implements Comparable<PresetListEntry> {
        public String value;
        public String value_context;
        public String display_value;
        public String short_description;
        public String icon;
        public short icon_size;
        public String locale_display_value;
        public String locale_short_description;
        public short preferredWidth = (short)-1;
        public short preferredHeight = (short)-1;

        public PresetListEntry() {
        }

        public PresetListEntry(String value) {
            this.value = value;
        }

        public String getListDisplay() {
            if (this.value.equals(KeyedItem.DIFFERENT)) {
                return "<b>" + Utils.escapeReservedCharactersHTML(KeyedItem.DIFFERENT) + "</b>";
            }
            String displayValue = Utils.escapeReservedCharactersHTML(this.getDisplayValue());
            String shortDescription = this.getShortDescription(true);
            if (displayValue.isEmpty() && (shortDescription == null || shortDescription.isEmpty())) {
                return "&nbsp;";
            }
            StringBuilder res = new StringBuilder("<b>").append(displayValue).append("</b>");
            if (shortDescription != null) {
                res.append("<div style=\"width:300px; padding:0 0 5px 5px\">").append(shortDescription).append("</div>");
            }
            return res.toString();
        }

        public ImageIcon getIcon() {
            return this.icon == null ? null : ComboMultiSelect.loadImageIcon(this.icon, TaggingPresetReader.getZipIcons(), Integer.valueOf(this.icon_size));
        }

        public String getDisplayValue() {
            return Utils.firstNonNull(this.locale_display_value, I18n.tr(this.display_value, new Object[0]), I18n.trc(this.value_context, this.value));
        }

        public String getShortDescription(boolean translated) {
            return translated ? Utils.firstNonNull(this.locale_short_description, I18n.tr(this.short_description, new Object[0])) : this.short_description;
        }

        public String toString() {
            if (KeyedItem.DIFFERENT.equals(this.value)) {
                return KeyedItem.DIFFERENT;
            }
            String displayValue = this.getDisplayValue();
            return displayValue != null ? displayValue.replaceAll("<.*>", "") : "";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PresetListEntry that = (PresetListEntry)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public int compareTo(PresetListEntry o) {
            return AlphanumComparator.getInstance().compare(this.getDisplayValue(), o.getDisplayValue());
        }
    }

    protected static class ConcatenatingJList
    extends JList<PresetListEntry> {
        private final char delimiter;

        protected ConcatenatingJList(char del, PresetListEntry ... o) {
            super(o);
            this.delimiter = del;
        }

        public void setSelectedItem(Object o) {
            if (o == null) {
                this.clearSelection();
            } else {
                String s = o.toString();
                TreeSet<String> parts = new TreeSet<String>(Arrays.asList(s.split(String.valueOf(this.delimiter))));
                ListModel lm = this.getModel();
                int[] intParts = new int[lm.getSize()];
                int j = 0;
                for (int i = 0; i < lm.getSize(); ++i) {
                    String value = ((PresetListEntry)lm.getElementAt((int)i)).value;
                    if (!parts.contains(value)) continue;
                    intParts[j++] = i;
                    parts.remove(value);
                }
                this.setSelectedIndices(Arrays.copyOf(intParts, j));
                this.setEnabled(parts.isEmpty());
            }
        }

        public String getSelectedItem() {
            ListModel lm = this.getModel();
            int[] si = this.getSelectedIndices();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < si.length; ++i) {
                if (i > 0) {
                    builder.append(this.delimiter);
                }
                builder.append(((PresetListEntry)lm.getElementAt((int)si[i])).value);
            }
            return builder.toString();
        }
    }

    private static final class Renderer
    implements ListCellRenderer<PresetListEntry> {
        private final JLabel lbl = new JLabel();

        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PresetListEntry> list, PresetListEntry item, int index, boolean isSelected, boolean cellHasFocus) {
            if (list == null || item == null) {
                return this.lbl;
            }
            if (!list.isShowing() && item.preferredWidth != -1 && item.preferredHeight != -1) {
                if (index == -1) {
                    this.lbl.setPreferredSize(new Dimension(item.preferredWidth, 10));
                } else {
                    this.lbl.setPreferredSize(new Dimension(item.preferredWidth, item.preferredHeight));
                }
                return this.lbl;
            }
            this.lbl.setPreferredSize(null);
            if (isSelected) {
                this.lbl.setBackground(list.getSelectionBackground());
                this.lbl.setForeground(list.getSelectionForeground());
            } else {
                this.lbl.setBackground(list.getBackground());
                this.lbl.setForeground(list.getForeground());
            }
            this.lbl.setOpaque(true);
            this.lbl.setFont(this.lbl.getFont().deriveFont(0));
            this.lbl.setText("<html>" + item.getListDisplay() + "</html>");
            this.lbl.setIcon(item.getIcon());
            this.lbl.setEnabled(list.isEnabled());
            item.preferredWidth = (short)this.lbl.getPreferredSize().width;
            item.preferredHeight = (short)this.lbl.getPreferredSize().height;
            if (index == -1) {
                this.lbl.setPreferredSize(new Dimension(this.lbl.getPreferredSize().width, 10));
            }
            return this.lbl;
        }
    }
}

