# -*- coding: utf-8 -*-
info = {
    "name": "hr",
    "date_order": "DMY",
    "january": [
        "siječanj",
        "sij",
        "siječnja"
    ],
    "february": [
        "veljača",
        "velj",
        "veljače"
    ],
    "march": [
        "ožujak",
        "ožu",
        "ožujka"
    ],
    "april": [
        "travanj",
        "tra",
        "travnja"
    ],
    "may": [
        "svibanj",
        "svi",
        "svibnja"
    ],
    "june": [
        "lipanj",
        "lip",
        "lipnja"
    ],
    "july": [
        "srpanj",
        "srp",
        "srpnja"
    ],
    "august": [
        "kolovoz",
        "kol",
        "kolovoza"
    ],
    "september": [
        "rujan",
        "ruj",
        "rujna"
    ],
    "october": [
        "listopad",
        "lis",
        "listopada"
    ],
    "november": [
        "studeni",
        "stu",
        "studenoga"
    ],
    "december": [
        "prosinac",
        "pro",
        "prosinca"
    ],
    "monday": [
        "ponedjeljak",
        "pon"
    ],
    "tuesday": [
        "utorak",
        "uto"
    ],
    "wednesday": [
        "srijeda",
        "sri"
    ],
    "thursday": [
        "četvrtak",
        "čet"
    ],
    "friday": [
        "petak",
        "pet"
    ],
    "saturday": [
        "subota",
        "sub"
    ],
    "sunday": [
        "nedjelja",
        "ned"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "godina",
        "g"
    ],
    "month": [
        "mjesec",
        "mj",
        "m"
    ],
    "week": [
        "tjedan",
        "tj"
    ],
    "day": [
        "dan",
        "d"
    ],
    "hour": [
        "sat",
        "h"
    ],
    "minute": [
        "minuta",
        "min"
    ],
    "second": [
        "sekunda",
        "s"
    ],
    "relative-type": {
        "1 year ago": [
            "prošle godine",
            "prošle god",
            "prošle g"
        ],
        "0 year ago": [
            "ove godine",
            "ove god",
            "ove g"
        ],
        "in 1 year": [
            "sljedeće godine",
            "sljedeće god",
            "sljedeće g"
        ],
        "1 month ago": [
            "prošli mjesec",
            "prošli mj"
        ],
        "0 month ago": [
            "ovaj mjesec",
            "ovaj mj"
        ],
        "in 1 month": [
            "sljedeći mjesec",
            "sljedeći mj"
        ],
        "1 week ago": [
            "prošli tjedan",
            "prošli tj"
        ],
        "0 week ago": [
            "ovaj tjedan",
            "ovaj tj"
        ],
        "in 1 week": [
            "sljedeći tjedan",
            "sljedeći tj"
        ],
        "1 day ago": [
            "jučer"
        ],
        "0 day ago": [
            "danas"
        ],
        "in 1 day": [
            "sutra"
        ],
        "0 hour ago": [
            "ovaj sat"
        ],
        "0 minute ago": [
            "ova minuta"
        ],
        "0 second ago": [
            "sad"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "za (\\d+) godinu",
            "za (\\d+) godina",
            "za (\\d+) g"
        ],
        "\\1 year ago": [
            "prije (\\d+) godinu",
            "prije (\\d+) godina",
            "prije (\\d+) g"
        ],
        "in \\1 month": [
            "za (\\d+) mjesec",
            "za (\\d+) mjeseci",
            "za (\\d+) mj"
        ],
        "\\1 month ago": [
            "prije (\\d+) mjesec",
            "prije (\\d+) mjeseci",
            "prije (\\d+) mj"
        ],
        "in \\1 week": [
            "za (\\d+) tjedan",
            "za (\\d+) tjedana",
            "za (\\d+) tj"
        ],
        "\\1 week ago": [
            "prije (\\d+) tjedan",
            "prije (\\d+) tjedana",
            "prije (\\d+) tj"
        ],
        "in \\1 day": [
            "za (\\d+) dan",
            "za (\\d+) dana",
            "za (\\d+) d"
        ],
        "\\1 day ago": [
            "prije (\\d+) dan",
            "prije (\\d+) dana",
            "prije (\\d+) d"
        ],
        "in \\1 hour": [
            "za (\\d+) sat",
            "za (\\d+) sati",
            "za (\\d+) h"
        ],
        "\\1 hour ago": [
            "prije (\\d+) sat",
            "prije (\\d+) sati",
            "prije (\\d+) h"
        ],
        "in \\1 minute": [
            "za (\\d+) minutu",
            "za (\\d+) minuta",
            "za (\\d+) min"
        ],
        "\\1 minute ago": [
            "prije (\\d+) minutu",
            "prije (\\d+) minuta",
            "prije (\\d+) min"
        ],
        "in \\1 second": [
            "za (\\d+) sekundu",
            "za (\\d+) sekundi",
            "za (\\d+) s"
        ],
        "\\1 second ago": [
            "prije (\\d+) sekundu",
            "prije (\\d+) sekundi",
            "prije (\\d+) s"
        ]
    },
    "locale_specific": {
        "hr-BA": {
            "name": "hr-BA"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
