/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.DaysAsDates;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.ComplementName;
import net.sourceforge.plantuml.project.lang.ComplementNamed;
import net.sourceforge.plantuml.project.lang.ComplementPattern;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verb;
import net.sourceforge.plantuml.project.lang.VerbPattern;
import net.sourceforge.plantuml.project.time.Day;

public class VerbIsOrAreNamed
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementNamed());
    }

    @Override
    public IRegex toRegex() {
        return new RegexLeaf("(is|are)[%s]+named");
    }

    @Override
    public Verb getVerb(final GanttDiagram project, RegexResult arg) {
        return new Verb(){

            @Override
            public CommandExecutionResult execute(Subject subject, Complement complement) {
                ComplementName named = (ComplementName)complement;
                String name = named.getName();
                DaysAsDates days = (DaysAsDates)subject;
                for (Day d : days) {
                    project.nameDay(d, name);
                }
                return CommandExecutionResult.ok();
            }
        };
    }
}

