/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import sun.misc.SharedSecrets;

public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA = new Object[0];
    private static final Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new Object[0];
    transient Object[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ArrayList(int n) {
        if (n > 0) {
            this.elementData = new Object[n];
        } else if (n == 0) {
            this.elementData = EMPTY_ELEMENTDATA;
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
    }

    public ArrayList() {
        this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    }

    public ArrayList(Collection<? extends E> collection) {
        this.elementData = collection.toArray();
        this.size = this.elementData.length;
        if (this.size != 0) {
            if (this.elementData.getClass() != Object[].class) {
                this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
            }
        } else {
            this.elementData = EMPTY_ELEMENTDATA;
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = this.size == 0 ? EMPTY_ELEMENTDATA : Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int n) {
        int n2;
        int n3 = n2 = this.elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA ? 0 : 10;
        if (n > n2) {
            this.ensureExplicitCapacity(n);
        }
    }

    private static int calculateCapacity(Object[] objectArray, int n) {
        if (objectArray == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            return Math.max(10, n);
        }
        return n;
    }

    private void ensureCapacityInternal(int n) {
        this.ensureExplicitCapacity(ArrayList.calculateCapacity(this.elementData, n));
    }

    private void ensureExplicitCapacity(int n) {
        ++this.modCount;
        if (n - this.elementData.length > 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.elementData.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = ArrayList.hugeCapacity(n);
        }
        this.elementData = Arrays.copyOf(this.elementData, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayList arrayList = (ArrayList)super.clone();
            arrayList.elementData = Arrays.copyOf(this.elementData, this.size);
            arrayList.modCount = 0;
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, TArray.getClass());
        }
        System.arraycopy(this.elementData, 0, TArray, 0, this.size);
        if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        return TArray;
    }

    E elementData(int n) {
        return (E)this.elementData[n];
    }

    @Override
    public E get(int n) {
        this.rangeCheck(n);
        return this.elementData(n);
    }

    @Override
    public E set(int n, E e) {
        this.rangeCheck(n);
        E e2 = this.elementData(n);
        this.elementData[n] = e;
        return e2;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int n, E e) {
        this.rangeCheckForAdd(n);
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = e;
        ++this.size;
    }

    @Override
    public E remove(int n) {
        this.rangeCheck(n);
        ++this.modCount;
        E e = this.elementData(n);
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return e;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                this.fastRemove(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                this.fastRemove(i);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int n) {
        ++this.modCount;
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        this.ensureCapacityInternal(this.size + n);
        System.arraycopy(objectArray, 0, this.elementData, this.size, n);
        this.size += n;
        return n != 0;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.rangeCheckForAdd(n);
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacityInternal(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        System.arraycopy(objectArray, 0, this.elementData, n, n2);
        this.size += n2;
        return n2 != 0;
    }

    @Override
    protected void removeRange(int n, int n2) {
        int n3;
        ++this.modCount;
        int n4 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n4);
        for (int i = n3 = this.size - (n2 - n); i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = n3;
    }

    private void rangeCheck(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private void rangeCheckForAdd(int n) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        return this.batchRemove(collection, false);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        return this.batchRemove(collection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> collection, boolean bl) {
        boolean bl2;
        int n;
        block8: {
            int n2;
            Object[] objectArray = this.elementData;
            n = 0;
            bl2 = false;
            try {
                for (n2 = 0; n2 < this.size; ++n2) {
                    if (collection.contains(objectArray[n2]) != bl) continue;
                    objectArray[n++] = objectArray[n2];
                }
                if (n2 == this.size) break block8;
            }
            catch (Throwable throwable) {
                if (n2 != this.size) {
                    System.arraycopy(objectArray, n2, objectArray, n, this.size - n2);
                    n += this.size - n2;
                }
                if (n != this.size) {
                    for (int i = n; i < this.size; ++i) {
                        objectArray[i] = null;
                    }
                    this.modCount += this.size - n;
                    this.size = n;
                    bl2 = true;
                }
                throw throwable;
            }
            System.arraycopy(objectArray, n2, objectArray, n, this.size - n2);
            n += this.size - n2;
        }
        if (n != this.size) {
            for (int i = n; i < this.size; ++i) {
                objectArray[i] = null;
            }
            this.modCount += this.size - n;
            this.size = n;
            bl2 = true;
        }
        return bl2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.modCount;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.elementData[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.elementData = EMPTY_ELEMENTDATA;
        objectInputStream.defaultReadObject();
        objectInputStream.readInt();
        if (this.size > 0) {
            int n = ArrayList.calculateCapacity(this.elementData, this.size);
            SharedSecrets.getJavaOISAccess().checkArray(objectInputStream, Object[].class, n);
            this.ensureCapacityInternal(this.size);
            Object[] objectArray = this.elementData;
            for (int i = 0; i < this.size; ++i) {
                objectArray[i] = objectInputStream.readObject();
            }
        }
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new ListItr(n);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public List<E> subList(int n, int n2) {
        ArrayList.subListRangeCheck(n, n2, this.size);
        return new SubList(this, 0, n, n2);
    }

    static void subListRangeCheck(int n, int n2, int n3) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Objects.requireNonNull(consumer);
        int n = this.modCount;
        Object[] objectArray = this.elementData;
        int n2 = this.size;
        for (int i = 0; this.modCount == n && i < n2; ++i) {
            consumer.accept(objectArray[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ArrayListSpliterator(this, 0, -1, 0);
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        int n;
        Objects.requireNonNull(predicate);
        int n2 = 0;
        BitSet bitSet = new BitSet(this.size);
        int n3 = this.modCount;
        int n4 = this.size;
        for (n = 0; this.modCount == n3 && n < n4; ++n) {
            Object object = this.elementData[n];
            if (!predicate.test(object)) continue;
            bitSet.set(n);
            ++n2;
        }
        if (this.modCount != n3) {
            throw new ConcurrentModificationException();
        }
        int n5 = n = n2 > 0 ? 1 : 0;
        if (n != 0) {
            int n6 = n4 - n2;
            int n7 = 0;
            for (int i = 0; n7 < n4 && i < n6; ++n7, ++i) {
                n7 = bitSet.nextClearBit(n7);
                this.elementData[i] = this.elementData[n7];
            }
            for (n7 = n6; n7 < n4; ++n7) {
                this.elementData[n7] = null;
            }
            this.size = n6;
            if (this.modCount != n3) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
        }
        return n != 0;
    }

    @Override
    public void replaceAll(UnaryOperator<E> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        int n = this.modCount;
        int n2 = this.size;
        for (int i = 0; this.modCount == n && i < n2; ++i) {
            this.elementData[i] = unaryOperator.apply(this.elementData[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        int n = this.modCount;
        Arrays.sort(this.elementData, 0, this.size, comparator);
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    static final class ArrayListSpliterator<E>
    implements Spliterator<E> {
        private final ArrayList<E> list;
        private int index;
        private int fence;
        private int expectedModCount;

        ArrayListSpliterator(ArrayList<E> arrayList, int n, int n2, int n3) {
            this.list = arrayList;
            this.index = n;
            this.fence = n2;
            this.expectedModCount = n3;
        }

        private int getFence() {
            int n = this.fence;
            if (n < 0) {
                ArrayList<E> arrayList = this.list;
                if (arrayList == null) {
                    this.fence = 0;
                    n = 0;
                } else {
                    this.expectedModCount = arrayList.modCount;
                    n = this.fence = ((ArrayList)arrayList).size;
                }
            }
            return n;
        }

        @Override
        public ArrayListSpliterator<E> trySplit() {
            ArrayListSpliterator<E> arrayListSpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3) {
                arrayListSpliterator = null;
            } else {
                this.index = n3;
                ArrayListSpliterator<E> arrayListSpliterator2 = new ArrayListSpliterator<E>(this.list, n, this.index, this.expectedModCount);
                arrayListSpliterator = arrayListSpliterator2;
            }
            return arrayListSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            int n = this.index;
            int n2 = this.getFence();
            if (n < n2) {
                this.index = n + 1;
                Object object = this.list.elementData[n];
                consumer.accept(object);
                if (this.list.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            ArrayList<E> arrayList = this.list;
            if (arrayList != null) {
                Object[] objectArray = arrayList.elementData;
                if (arrayList.elementData != null) {
                    int n;
                    int n2;
                    int n3 = this.fence;
                    if (n3 < 0) {
                        n2 = arrayList.modCount;
                        n3 = ((ArrayList)arrayList).size;
                    } else {
                        n2 = this.expectedModCount;
                    }
                    if (n >= 0 && (this.index = n3) <= objectArray.length) {
                        for (n = this.index; n < n3; ++n) {
                            Object object = objectArray[n];
                            consumer.accept(object);
                        }
                        if (arrayList.modCount == n2) {
                            return;
                        }
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    private class SubList
    extends AbstractList<E>
    implements RandomAccess {
        private final AbstractList<E> parent;
        private final int parentOffset;
        private final int offset;
        int size;

        SubList(AbstractList<E> abstractList, int n, int n2, int n3) {
            this.parent = abstractList;
            this.parentOffset = n2;
            this.offset = n + n2;
            this.size = n3 - n2;
            this.modCount = ArrayList.this.modCount;
        }

        @Override
        public E set(int n, E e) {
            this.rangeCheck(n);
            this.checkForComodification();
            Object e2 = ArrayList.this.elementData(this.offset + n);
            ArrayList.this.elementData[this.offset + n] = e;
            return e2;
        }

        @Override
        public E get(int n) {
            this.rangeCheck(n);
            this.checkForComodification();
            return ArrayList.this.elementData(this.offset + n);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int n, E e) {
            this.rangeCheckForAdd(n);
            this.checkForComodification();
            this.parent.add(this.parentOffset + n, e);
            this.modCount = this.parent.modCount;
            ++this.size;
        }

        @Override
        public E remove(int n) {
            this.rangeCheck(n);
            this.checkForComodification();
            Object e = this.parent.remove(this.parentOffset + n);
            this.modCount = this.parent.modCount;
            --this.size;
            return e;
        }

        @Override
        protected void removeRange(int n, int n2) {
            this.checkForComodification();
            this.parent.removeRange(this.parentOffset + n, this.parentOffset + n2);
            this.modCount = this.parent.modCount;
            this.size -= n2 - n;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            return this.addAll(this.size, collection);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            this.rangeCheckForAdd(n);
            int n2 = collection.size();
            if (n2 == 0) {
                return false;
            }
            this.checkForComodification();
            this.parent.addAll(this.parentOffset + n, collection);
            this.modCount = this.parent.modCount;
            this.size += n2;
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int n) {
            this.checkForComodification();
            this.rangeCheckForAdd(n);
            final int n2 = this.offset;
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = n;
                    this.lastRet = -1;
                    this.expectedModCount = ArrayList.this.modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != SubList.this.size;
                }

                @Override
                public E next() {
                    this.checkForComodification();
                    int n3 = this.cursor;
                    if (n3 >= SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    Object[] objectArray = ArrayList.this.elementData;
                    if (n2 + n3 >= objectArray.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = n3 + 1;
                    this.lastRet = n3;
                    return objectArray[n2 + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    this.checkForComodification();
                    int n3 = this.cursor - 1;
                    if (n3 < 0) {
                        throw new NoSuchElementException();
                    }
                    Object[] objectArray = ArrayList.this.elementData;
                    if (n2 + n3 >= objectArray.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = n3;
                    this.lastRet = n3;
                    return objectArray[n2 + this.lastRet];
                }

                @Override
                public void forEachRemaining(Consumer<? super E> consumer) {
                    Objects.requireNonNull(consumer);
                    int n3 = SubList.this.size;
                    int n22 = this.cursor;
                    if (n22 >= n3) {
                        return;
                    }
                    Object[] objectArray = ArrayList.this.elementData;
                    if (n2 + n22 >= objectArray.length) {
                        throw new ConcurrentModificationException();
                    }
                    while (n22 != n3 && SubList.this.modCount == this.expectedModCount) {
                        consumer.accept(objectArray[n2 + n22++]);
                    }
                    this.lastRet = this.cursor = n22;
                    this.checkForComodification();
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        SubList.this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        ArrayList.this.set(n2 + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(E e) {
                    this.checkForComodification();
                    try {
                        int n3 = this.cursor;
                        SubList.this.add(n3, e);
                        this.cursor = n3 + 1;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new ConcurrentModificationException();
                    }
                }

                final void checkForComodification() {
                    if (this.expectedModCount != ArrayList.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            ArrayList.subListRangeCheck(n, n2, this.size);
            return new SubList(this, this.offset, n, n2);
        }

        private void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
            }
        }

        private void rangeCheckForAdd(int n) {
            if (n < 0 || n > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
            }
        }

        private String outOfBoundsMsg(int n) {
            return "Index: " + n + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (ArrayList.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public Spliterator<E> spliterator() {
            this.checkForComodification();
            return new ArrayListSpliterator(ArrayList.this, this.offset, this.offset + this.size, this.modCount);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int n = this.cursor - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.elementData;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = n;
            this.lastRet = n;
            return objectArray[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int n = this.cursor;
                ArrayList.this.add(n, e);
                this.cursor = n + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        Itr() {
            this.expectedModCount = ArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int n = this.cursor;
            if (n >= ArrayList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.elementData;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = n + 1;
            this.lastRet = n;
            return objectArray[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            Objects.requireNonNull(consumer);
            int n = ArrayList.this.size;
            int n2 = this.cursor;
            if (n2 >= n) {
                return;
            }
            Object[] objectArray = ArrayList.this.elementData;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            while (n2 != n && ArrayList.this.modCount == this.expectedModCount) {
                consumer.accept(objectArray[n2++]);
            }
            this.cursor = n2;
            this.lastRet = n2 - 1;
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (ArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

