#ifndef _EFL_GFX_ARRANGEMENT_EO_H_
#define _EFL_GFX_ARRANGEMENT_EO_H_

#ifndef _EFL_GFX_ARRANGEMENT_EO_CLASS_TYPE
#define _EFL_GFX_ARRANGEMENT_EO_CLASS_TYPE

typedef Eo Efl_Gfx_Arrangement;

#endif

#ifndef _EFL_GFX_ARRANGEMENT_EO_TYPES
#define _EFL_GFX_ARRANGEMENT_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** This interface provides methods for manipulating how contents are arranged
 * within a container, providing more granularity for content positioning.
 *
 * @since 1.23
 *
 * @ingroup Efl_Gfx_Arrangement
 */
#define EFL_GFX_ARRANGEMENT_INTERFACE efl_gfx_arrangement_interface_get()

EWAPI const Efl_Class *efl_gfx_arrangement_interface_get(void);

/**
 * @brief This property determines how contents will be aligned within a
 * container if there is unused space.
 *
 * It is different than the @ref efl_gfx_hint_align_get property in that it
 * affects the position of all the contents within the container. For example,
 * if a box widget has extra space on the horizontal axis, this property can be
 * used to align the box's contents to the left or the right side.
 *
 * See also @ref efl_gfx_hint_align_get.
 *
 * @param[in] obj The object.
 * @param[in] align_horiz Double, ranging from 0.0 to 1.0, where 0.0 is at the
 * start of the horizontal axis and 1.0 is at the end.
 * @param[in] align_vert Double, ranging from 0.0 to 1.0, where 0.0 is at the
 * start of the vertical axis and 1.0 is at the end.
 *
 * @since 1.23
 *
 * @ingroup Efl_Gfx_Arrangement
 */
EOAPI void efl_gfx_arrangement_content_align_set(Eo *obj, double align_horiz, double align_vert);

/**
 * @brief This property determines how contents will be aligned within a
 * container if there is unused space.
 *
 * It is different than the @ref efl_gfx_hint_align_get property in that it
 * affects the position of all the contents within the container. For example,
 * if a box widget has extra space on the horizontal axis, this property can be
 * used to align the box's contents to the left or the right side.
 *
 * See also @ref efl_gfx_hint_align_get.
 *
 * @param[in] obj The object.
 * @param[out] align_horiz Double, ranging from 0.0 to 1.0, where 0.0 is at the
 * start of the horizontal axis and 1.0 is at the end.
 * @param[out] align_vert Double, ranging from 0.0 to 1.0, where 0.0 is at the
 * start of the vertical axis and 1.0 is at the end.
 *
 * @since 1.23
 *
 * @ingroup Efl_Gfx_Arrangement
 */
EOAPI void efl_gfx_arrangement_content_align_get(const Eo *obj, double *align_horiz, double *align_vert);

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief This property determines the space between a container's content
 * items.
 *
 * It is different than the @ref efl_gfx_hint_margin_get property in that it is
 * applied to each content item within the container instead of a single item.
 * The calculation for these two properties is cumulative.
 *
 * See also @ref efl_gfx_hint_margin_get.
 *
 * @param[in] obj The object.
 * @param[in] pad_horiz Horizontal padding.
 * @param[in] pad_vert Vertical padding.
 * @param[in] scalable @c true if scalable.
 *
 * @since 1.23
 *
 * @ingroup Efl_Gfx_Arrangement
 */
EOAPI void efl_gfx_arrangement_content_padding_set(Eo *obj, double pad_horiz, double pad_vert, Eina_Bool scalable);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief This property determines the space between a container's content
 * items.
 *
 * It is different than the @ref efl_gfx_hint_margin_get property in that it is
 * applied to each content item within the container instead of a single item.
 * The calculation for these two properties is cumulative.
 *
 * See also @ref efl_gfx_hint_margin_get.
 *
 * @param[in] obj The object.
 * @param[out] pad_horiz Horizontal padding.
 * @param[out] pad_vert Vertical padding.
 * @param[out] scalable @c true if scalable.
 *
 * @since 1.23
 *
 * @ingroup Efl_Gfx_Arrangement
 */
EOAPI void efl_gfx_arrangement_content_padding_get(const Eo *obj, double *pad_horiz, double *pad_vert, Eina_Bool *scalable);
#endif /* EFL_BETA_API_SUPPORT */
#endif /* EFL_BETA_API_SUPPORT */

#endif
