/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCClob
implements Clob {
    private static final FrameworkLogger LOG = FrameworkLogger.getLog(JDBCClob.class);
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private boolean m_closed;
    private String m_data;
    private final boolean m_createdByConnection;

    @Override
    public long length() throws SQLException {
        return this.getData().length();
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        String string = this.getData();
        int n2 = string.length();
        if (l == 1L && n == n2) {
            return string;
        }
        if (l < 1L || l > (long)n2) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        long l2 = l - 1L;
        if (n < 0 || (long)n > (long)n2 - l2) {
            throw JDBCUtil.outOfRangeArgument("length: " + n);
        }
        return string.substring((int)l2, (int)l2 + n);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.getData());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(this.getData().getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.warning(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            return null;
        }
    }

    @Override
    public long position(String string, long l) throws SQLException {
        String string2 = this.getData();
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        if (string == null || l > 0x80000000L) {
            return -1L;
        }
        int n = string2.indexOf(string, (int)l - 1);
        return n == -1 ? -1L : (long)(n + 1);
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        long l2;
        String string = this.getData();
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l);
        }
        if (clob == null) {
            return -1L;
        }
        long l3 = l - 1L;
        long l4 = string.length();
        if (l3 > l4 - (l2 = clob.length())) {
            return -1L;
        }
        String string2 = clob instanceof JDBCClob ? ((JDBCClob)clob).getData() : clob.getSubString(1L, (int)l2);
        int n = string.indexOf(string2, (int)l3);
        return n == -1 ? -1L : (long)(n + 1);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string == null ? 0 : string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        char[] cArray;
        this.checkReadonly();
        String string2 = this.getData();
        if (string == null) {
            throw JDBCUtil.nullArgument("str");
        }
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = (int)(l - 1L);
        if (n == 0 && n2 == n3 && n5 == 0 && n2 >= n4) {
            this.setData(string);
            return n2;
        }
        if (n < 0 || n > n3) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n);
        }
        if (n2 < 0 || n2 > n3 - n) {
            throw JDBCUtil.outOfRangeArgument("len: " + n2);
        }
        if (l < 1L || l - 1L > (long)(Integer.MAX_VALUE - n2)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        long l2 = l + (long)n2;
        if (l > (long)n4) {
            cArray = new char[(int)l2 - 1];
            string2.getChars(0, n4, cArray, 0);
            for (int i = n4; i < n5; ++i) {
                cArray[i] = 32;
            }
            string.getChars(n, n + n2, cArray, n5);
        } else if (l2 > (long)n4) {
            cArray = new char[(int)l2 - 1];
            string2.getChars(0, n5, cArray, 0);
            string.getChars(n, n + n2, cArray, n5);
        } else {
            cArray = new char[n4];
            string2.getChars(0, n5, cArray, 0);
            string.getChars(n, n + n2, cArray, n5);
            int n6 = n5 + n2;
            string2.getChars(n6, n4, cArray, n6);
        }
        this.setData(new String(cArray));
        return n2;
    }

    @Override
    public OutputStream setAsciiStream(final long l) throws SQLException {
        this.checkReadonly();
        this.checkClosed();
        if (l < 1L || l > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        return new ByteArrayOutputStream(){
            boolean closed = false;

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                byte[] byArray = this.buf;
                int n = this.count;
                this.buf = null;
                this.count = 0;
                try {
                    String string = new String(byArray, 0, n, "US-ASCII");
                    JDBCClob.this.setString(l, string);
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
            }
        };
    }

    @Override
    public Writer setCharacterStream(final long l) throws SQLException {
        this.checkReadonly();
        this.checkClosed();
        if (l < 1L || l > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        return new StringWriter(){
            private boolean closed = false;

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                StringBuffer stringBuffer = super.getBuffer();
                try {
                    JDBCClob.this.setStringBuffer(l, stringBuffer, 0, stringBuffer.length());
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
                finally {
                    stringBuffer.setLength(0);
                    stringBuffer.trimToSize();
                }
            }
        };
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.checkReadonly();
        String string = this.getData();
        long l2 = string.length();
        if (l == l2) {
            return;
        }
        if (l < 0L || l > l2) {
            throw JDBCUtil.outOfRangeArgument("len: " + l);
        }
        this.setData(string.substring(0, (int)l));
    }

    @Override
    public synchronized void free() throws SQLException {
        this.m_closed = true;
        this.m_data = null;
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("length: " + l2);
        }
        String string = this.getData();
        int n = string.length();
        if (l == 1L && l2 == (long)n) {
            return new StringReader(string);
        }
        if (l < 1L || l > (long)n) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        long l3 = l - 1L;
        if (l2 < 0L || l2 > (long)n - l3) {
            throw JDBCUtil.outOfRangeArgument("length: " + l2);
        }
        int n2 = (int)(l3 + l2);
        char[] cArray = new char[(int)l2];
        string.getChars((int)l3, n2, cArray, 0);
        return new CharArrayReader(cArray);
    }

    public JDBCClob(String string) throws SQLException {
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        this.m_data = string;
        this.m_createdByConnection = false;
    }

    protected JDBCClob() {
        this.m_data = "";
        this.m_createdByConnection = true;
    }

    protected void checkReadonly() throws SQLException {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.sqlException(3706, "Clob is read-only");
        }
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    synchronized String getData() throws SQLException {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(String string) throws SQLException {
        this.checkClosed();
        this.m_data = string;
    }

    public int setStringBuffer(long l, StringBuffer stringBuffer, int n, int n2) throws SQLException {
        char[] cArray;
        this.checkReadonly();
        String string = this.getData();
        if (stringBuffer == null) {
            throw JDBCUtil.nullArgument("sb");
        }
        int n3 = stringBuffer.length();
        int n4 = string.length();
        int n5 = (int)(l - 1L);
        if (n == 0 && n2 == n3 && n5 == 0 && n2 >= n4) {
            this.setData(stringBuffer.toString());
            return n2;
        }
        if (n < 0 || n > n3) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n);
        }
        if (n2 > n3 - n) {
            throw JDBCUtil.outOfRangeArgument("len: " + n2);
        }
        if (l < 1L || l - 1L > (long)(Integer.MAX_VALUE - n2)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        long l2 = l + (long)n2;
        if (l > (long)n4) {
            cArray = new char[(int)l2 - 1];
            string.getChars(0, n4, cArray, 0);
            for (int i = n4; i < n5; ++i) {
                cArray[i] = 32;
            }
            stringBuffer.getChars(n, n + n2, cArray, n5);
        } else if (l2 > (long)n4) {
            cArray = new char[(int)l2 - 1];
            string.getChars(0, n5, cArray, 0);
            stringBuffer.getChars(n, n + n2, cArray, n5);
        } else {
            cArray = new char[n4];
            string.getChars(0, n5, cArray, 0);
            stringBuffer.getChars(n, n + n2, cArray, n5);
            int n6 = n5 + n2;
            string.getChars(n6, n4, cArray, n6);
        }
        this.setData(new String(cArray));
        return n2;
    }
}

