/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.DaysAsDates;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.ComplementDate;
import net.sourceforge.plantuml.project.lang.ComplementDates;
import net.sourceforge.plantuml.project.lang.ComplementPattern;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verb;
import net.sourceforge.plantuml.project.lang.VerbPattern;
import net.sourceforge.plantuml.project.time.Day;

public class VerbIsOn
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementDate(), new ComplementDates());
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("is"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("on"), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexLeaf("on"), new RegexLeaf("for"), new RegexLeaf("the"), new RegexLeaf("at")));
    }

    @Override
    public Verb getVerb(final GanttDiagram project, RegexResult arg) {
        return new Verb(){

            @Override
            public CommandExecutionResult execute(Subject subject, Complement complement) {
                Resource resource = (Resource)subject;
                if (complement instanceof DaysAsDates) {
                    for (Day when : (DaysAsDates)complement) {
                        resource.addForceOnDay(project.convert(when));
                    }
                } else {
                    Day when = (Day)complement;
                    resource.addForceOnDay(project.convert(when));
                }
                return CommandExecutionResult.ok();
            }
        };
    }
}

