/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.TimeProjected;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.PlayerFrame;

public abstract class Player
implements TimeProjected {
    protected final ISkinParam skinParam;
    protected final TimingRuler ruler;
    private final Display title;

    public Player(String title, ISkinParam skinParam, TimingRuler ruler) {
        this.skinParam = skinParam;
        this.ruler = ruler;
        this.title = Display.getWithNewlines(title);
    }

    protected final FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.TIMING, null);
    }

    protected final TextBlock getTitle() {
        return this.title.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public abstract void addNote(TimeTick var1, Display var2, Position var3);

    public abstract void defineState(String var1, String var2);

    public abstract void setState(TimeTick var1, String var2, Colors var3, String ... var4);

    public abstract void createConstraint(TimeTick var1, TimeTick var2, String var3);

    public abstract PlayerFrame getPlayerFrame();

    public abstract TextBlock getPart1();

    public abstract UDrawable getPart2();

    public abstract double getFullHeight(StringBounder var1);
}

