/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Mix;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class BezierScroller
extends AnimatingControlsSurface {
    private static String[] appletStrs = new String[]{" ", "J2Ddemo", "BezierScroller - Animated Bezier Curve shape with images", "For README.txt file scrolling run in application mode", " "};
    private static final int NUMPTS = 6;
    private static Color greenBlend = new Color(0, 255, 0, 100);
    private static Color blueBlend = new Color(0, 0, 255, 100);
    private static Font font = new Font("Serif", 0, 12);
    private static BasicStroke bs = new BasicStroke(3.0f);
    private static Image hotj_img;
    private static BufferedImage img;
    private static final int UP = 0;
    private static final int DOWN = 1;
    private float[] animpts = new float[12];
    private float[] deltas = new float[12];
    private BufferedReader reader;
    private int nStrs;
    private int strH;
    private int yy;
    private int ix;
    private int iy;
    private int imgX;
    private List<String> vector;
    private List<String> appletVector;
    private float alpha = 0.2f;
    private int alphaDirection;
    protected boolean doImage;
    protected boolean doShape;
    protected boolean doText;
    protected boolean buttonToggle;

    private Image scaled(Image src) {
        int sw = src.getWidth(null);
        int sh = src.getHeight(null);
        int dw = sw / 5;
        int dh = sh / 5;
        BufferedImage bi = new BufferedImage(dw, dh, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.drawImage(src, 0, 0, dw, dh, 0, 0, sw, sh, null);
        g2d.dispose();
        return bi;
    }

    public BezierScroller() {
        this.setBackground(Color.WHITE);
        this.doText = true;
        this.doShape = true;
        hotj_img = this.scaled(this.getImage("globe.png"));
        Image image = this.getImage("jumptojavastrip.png");
        int iw = image.getWidth(this);
        int ih = image.getHeight(this);
        img = new BufferedImage(iw, ih, 1);
        img.createGraphics().drawImage(image, 0, 0, this);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void animate(float[] pts, float[] deltas, int index, int limit) {
        float newpt = pts[index] + deltas[index];
        if (newpt <= 0.0f) {
            newpt = -newpt;
            deltas[index] = (float)(Math.random() * 4.0 + 2.0);
        } else if (newpt >= (float)limit) {
            newpt = 2.0f * (float)limit - newpt;
            deltas[index] = -((float)(Math.random() * 4.0 + 2.0));
        }
        pts[index] = newpt;
    }

    public void getFile() {
        try {
            String fName = "README.txt";
            this.reader = new BufferedReader(new FileReader(fName));
            if (this.reader != null) {
                this.getLine();
            }
        }
        catch (Exception e) {
            this.reader = null;
        }
        if (this.reader == null) {
            this.appletVector = new ArrayList<String>(100);
            for (int i = 0; i < 100; ++i) {
                this.appletVector.add(appletStrs[i % appletStrs.length]);
            }
            this.getLine();
        }
        this.buttonToggle = true;
    }

    public String getLine() {
        String str = null;
        if (this.reader != null) {
            try {
                str = this.reader.readLine();
                if (str != null) {
                    if (str.length() == 0) {
                        str = " ";
                    }
                    this.vector.add(str);
                }
            }
            catch (Exception e) {
                Logger.getLogger(BezierScroller.class.getName()).log(Level.SEVERE, null, e);
                this.reader = null;
            }
        } else if (!this.appletVector.isEmpty()) {
            str = this.appletVector.remove(0);
            this.vector.add(str);
        }
        return str;
    }

    @Override
    public void reset(int w, int h) {
        for (int i = 0; i < this.animpts.length; i += 2) {
            this.animpts[i + 0] = (float)(Math.random() * (double)w);
            this.animpts[i + 1] = (float)(Math.random() * (double)h);
            this.deltas[i + 0] = (float)(Math.random() * 6.0 + 4.0);
            this.deltas[i + 1] = (float)(Math.random() * 6.0 + 4.0);
            if (this.animpts[i + 0] > (float)w / 2.0f) {
                this.deltas[i + 0] = -this.deltas[i + 0];
            }
            if (!(this.animpts[i + 1] > (float)h / 2.0f)) continue;
            this.deltas[i + 1] = -this.deltas[i + 1];
        }
        FontMetrics fm = this.getFontMetrics(font);
        this.strH = fm.getAscent() + fm.getDescent();
        this.nStrs = h / this.strH + 2;
        this.vector = new ArrayList<String>(this.nStrs);
        this.ix = (int)(Math.random() * (double)(w - 80));
        this.iy = (int)(Math.random() * (double)(h - 80));
    }

    @Override
    public void step(int w, int h) {
        if (this.doText && this.vector.isEmpty()) {
            this.getFile();
        }
        if (this.doText) {
            String s = this.getLine();
            if (s == null || this.vector.size() == this.nStrs && !this.vector.isEmpty()) {
                this.vector.remove(0);
            }
            this.yy = s == null ? 0 : h - this.vector.size() * this.strH;
        }
        for (int i = 0; i < this.animpts.length && this.doShape; i += 2) {
            this.animate(this.animpts, this.deltas, i + 0, w);
            this.animate(this.animpts, this.deltas, i + 1, h);
        }
        if (this.doImage && this.alphaDirection == 0) {
            float f;
            this.alpha = (float)((double)this.alpha + 0.025);
            if ((double)f > 0.99) {
                this.alphaDirection = 1;
                this.alpha = 1.0f;
            }
        } else if (this.doImage && this.alphaDirection == 1) {
            float f;
            this.alpha = (float)((double)this.alpha - 0.02);
            if ((double)f < 0.01) {
                this.alphaDirection = 0;
                this.alpha = 0.0f;
                this.ix = (int)(Math.random() * (double)(w - 80));
                this.iy = (int)(Math.random() * (double)(h - 80));
            }
        }
        if (this.doImage && (this.imgX += 80) == 800) {
            this.imgX = 0;
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        if (this.doText) {
            g2.setColor(Color.LIGHT_GRAY);
            g2.setFont(font);
            float y = this.yy;
            for (String string : this.vector) {
                g2.drawString(string, 1.0f, y += (float)this.strH);
            }
        }
        if (this.doShape) {
            float[] ctrlpts = this.animpts;
            int len = ctrlpts.length;
            float prevx = ctrlpts[len - 2];
            float prevy = ctrlpts[len - 1];
            float curx = ctrlpts[0];
            float cury = ctrlpts[1];
            float midx = (curx + prevx) / 2.0f;
            float midy = (cury + prevy) / 2.0f;
            GeneralPath gp = new GeneralPath(1);
            gp.moveTo(midx, midy);
            for (int i = 2; i <= ctrlpts.length; i += 2) {
                float x1 = (midx + curx) / 2.0f;
                float y1 = (midy + cury) / 2.0f;
                prevx = curx;
                prevy = cury;
                if (i < ctrlpts.length) {
                    curx = ctrlpts[i + 0];
                    cury = ctrlpts[i + 1];
                } else {
                    curx = ctrlpts[0];
                    cury = ctrlpts[1];
                }
                midx = (curx + prevx) / 2.0f;
                midy = (cury + prevy) / 2.0f;
                float x2 = (prevx + midx) / 2.0f;
                float y2 = (prevy + midy) / 2.0f;
                gp.curveTo(x1, y1, x2, y2, midx, midy);
            }
            gp.closePath();
            g2.setColor(blueBlend);
            g2.setStroke(bs);
            g2.draw(gp);
            g2.setColor(greenBlend);
            g2.fill(gp);
            PathIterator pi = gp.getPathIterator(null);
            float[] pts = new float[6];
            while (!pi.isDone()) {
                if (pi.currentSegment(pts) == 3) {
                    g2.drawImage(hotj_img, (int)pts[0], (int)pts[1], this);
                }
                pi.next();
            }
        }
        if (this.doImage) {
            AlphaComposite ac = AlphaComposite.getInstance(3, this.alpha);
            g2.setComposite(ac);
            g2.drawImage((Image)img.getSubimage(this.imgX, 0, 80, 80), this.ix, this.iy, this);
        }
    }

    public static void main(String[] argv) {
        BezierScroller.createDemoFrame(new BezierScroller());
    }

    static final class DemoControls
    extends CustomControls
    implements ActionListener {
        BezierScroller demo;
        JToolBar toolbar;
        JComboBox combo;

        public DemoControls(BezierScroller demo) {
            super(demo.name);
            this.demo = demo;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Image", false);
            this.addTool("Shape", true);
            this.addTool("Text", true);
        }

        public void addTool(String str, boolean state) {
            JToggleButton b = (JToggleButton)this.toolbar.add(new JToggleButton(str));
            b.setFocusPainted(false);
            b.setSelected(state);
            b.addActionListener(this);
            int width = b.getPreferredSize().width;
            Dimension prefSize = new Dimension(width, 21);
            b.setPreferredSize(prefSize);
            b.setMaximumSize(prefSize);
            b.setMinimumSize(prefSize);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton b = (JToggleButton)e.getSource();
            if (b.getText().equals("Image")) {
                this.demo.doImage = b.isSelected();
            } else if (b.getText().equals("Shape")) {
                this.demo.doShape = b.isSelected();
            } else {
                this.demo.doText = b.isSelected();
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            int i = 0;
            while (this.thread == me) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (!this.demo.buttonToggle) continue;
                ((AbstractButton)this.toolbar.getComponentAtIndex(i++ % 2)).doClick();
                this.demo.buttonToggle = false;
            }
            this.thread = null;
        }
    }
}

