/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.StayOpenPopupMenu;

public class ToggleButtonMenuItem
extends StayOpenPopupMenu.Item {
    private final JLabel label;
    private final Icon selectedIcon;
    private final Icon unselectedIcon;
    private boolean pressed;

    public ToggleButtonMenuItem(String string, Icon icon) {
        super(ToggleButtonMenuItem.sizeText(string));
        this.setLayout(null);
        this.selectedIcon = ToggleButtonMenuItem.createSelectedIcon(icon);
        this.unselectedIcon = ToggleButtonMenuItem.createUnselectedIcon(icon);
        this.label = new JLabel(this.unselectedIcon, 10);
        this.add(this.label, "West");
    }

    public void setPressed(boolean bl) {
        if (this.pressed == bl) {
            return;
        }
        this.pressed = bl;
        this.label.setIcon(bl ? this.selectedIcon : this.unselectedIcon);
        this.repaint();
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = Math.max(dimension.height, this.getComponent((int)0).getPreferredSize().height);
        return dimension;
    }

    public void doLayout() {
        this.getComponent(0).setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    private static Icon createSelectedIcon(Icon icon) {
        JComponent jComponent = new JToggleButton(){
            {
                this.setSelected(true);
                if (UIUtils.isAquaLookAndFeel()) {
                    this.putClientProperty("JButton.buttonType", "textured");
                }
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (UIUtils.isOracleLookAndFeel()) {
                    Color color = UIManager.getColor("List.selectionBackground");
                    graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 140));
                    graphics.fillRect(1, 1, this.getWidth() - 3, this.getHeight() - 2);
                }
            }
        };
        if (UIUtils.isWindowsLookAndFeel() || UIUtils.isMetalLookAndFeel() || UIUtils.isOracleLookAndFeel()) {
            JToolBar jToolBar = new JToolBar(){
                {
                    this.setLayout(null);
                    this.setOpaque(false);
                    this.setRollover(true);
                    this.setFloatable(false);
                    this.setBorderPainted(false);
                }

                @Override
                public void setSize(int n, int n2) {
                    super.setSize(n, n2);
                    if (this.getComponentCount() > 0) {
                        this.getComponent(0).setBounds(0, 0, n, n2);
                    }
                }
            };
            jToolBar.removeAll();
            jToolBar.add(jComponent);
            jComponent = jToolBar;
        }
        return ToggleButtonMenuItem.createMenuIcon(icon, jComponent);
    }

    private static Icon createUnselectedIcon(Icon icon) {
        return ToggleButtonMenuItem.createMenuIcon(icon, null);
    }

    private static Icon createMenuIcon(Icon icon, Component component) {
        int n = ToggleButtonMenuItem.menuIconSize();
        int n2 = UIUtils.isAquaLookAndFeel() ? n + 4 : n;
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics graphics = bufferedImage.getGraphics();
        if (component != null) {
            component.setSize(n2, n);
            component.paint(graphics);
        }
        icon.paintIcon(null, graphics, (n2 - icon.getIconWidth()) / 2, (n - icon.getIconHeight()) / 2);
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }

    private static int menuIconSize() {
        if (UIUtils.isMetalLookAndFeel()) {
            return 23;
        }
        if (UIUtils.isAquaLookAndFeel()) {
            return 26;
        }
        if (UIUtils.isGTKLookAndFeel()) {
            return 24;
        }
        if (UIUtils.isNimbus()) {
            return 25;
        }
        if (UIUtils.isOracleLookAndFeel()) {
            return 21;
        }
        return 22;
    }

    private static String sizeText(String string) {
        if (UIUtils.isMetalLookAndFeel()) {
            return "  " + string;
        }
        if (UIUtils.isAquaLookAndFeel()) {
            return "   " + string;
        }
        if (UIUtils.isGTKLookAndFeel()) {
            return " " + string;
        }
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            return "  " + string;
        }
        return string;
    }
}

