/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.common.NamedObject;
import freemind.controller.filter.condition.AttributeCompareCondition;
import freemind.controller.filter.condition.AttributeExistsCondition;
import freemind.controller.filter.condition.AttributeNotExistsCondition;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.ConditionNotSatisfiedDecorator;
import freemind.controller.filter.condition.ConjunctConditions;
import freemind.controller.filter.condition.DisjunctConditions;
import freemind.controller.filter.condition.IconContainedCondition;
import freemind.controller.filter.condition.IconNotContainedCondition;
import freemind.controller.filter.condition.IgnoreCaseNodeContainsCondition;
import freemind.controller.filter.condition.JCondition;
import freemind.controller.filter.condition.NodeCompareCondition;
import freemind.controller.filter.condition.NodeContainsCondition;
import freemind.main.Resources;
import freemind.main.XMLElement;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ConditionFactory {
    static final String FILTER_ICON = "filter_icon";
    static final String FILTER_NODE = "filter_node";
    static final String FILTER_DOES_NOT_EXIST = "filter_does_not_exist";
    static final String FILTER_EXIST = "filter_exist";
    static final String FILTER_CONTAINS = "filter_contains";
    static final String FILTER_NOT_CONTAINS = "filter_not_contains";
    static final String FILTER_IS_NOT_EQUAL_TO = "filter_is_not_equal_to";
    static final String FILTER_IS_EQUAL_TO = "filter_is_equal_to";
    static final String FILTER_LE = "<=";
    static final String FILTER_LT = "<";
    static final String FILTER_GE = ">=";
    static final String FILTER_GT = ">";
    static final String FILTER_IGNORE_CASE = "filter_ignore_case";

    static String createDescription(String attribute, String simpleCondition, String value, boolean ignoreCase) {
        String description = attribute + " " + simpleCondition + (value != null ? " \"" + value + "\"" : "") + (ignoreCase && value != null ? ", " + Resources.getInstance().getResourceString(FILTER_IGNORE_CASE) : "");
        return description;
    }

    public Condition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("node_contains_condition")) {
            return NodeContainsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("ignore_case_node_contains_condition")) {
            return IgnoreCaseNodeContainsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("node_compare_condition")) {
            return NodeCompareCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_compare_condition")) {
            return AttributeCompareCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_exists_condition")) {
            return AttributeExistsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_not_exists_condition")) {
            return AttributeNotExistsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("icon_contained_condition")) {
            return IconContainedCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("icon_not_contained_condition")) {
            return IconNotContainedCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("negate_condition")) {
            return ConditionNotSatisfiedDecorator.load(element);
        }
        if (element.getName().equalsIgnoreCase("conjunct_condition")) {
            return ConjunctConditions.load(element);
        }
        if (element.getName().equalsIgnoreCase("disjunct_condition")) {
            return DisjunctConditions.load(element);
        }
        return null;
    }

    public Condition createAttributeCondition(String attribute, NamedObject simpleCondition, String value, boolean ignoreCase) {
        if (simpleCondition.equals(FILTER_EXIST)) {
            return new AttributeExistsCondition(attribute);
        }
        if (simpleCondition.equals(FILTER_DOES_NOT_EXIST)) {
            return new AttributeNotExistsCondition(attribute);
        }
        if (ignoreCase) {
            if (simpleCondition.equals(FILTER_IS_EQUAL_TO)) {
                return new AttributeCompareCondition(attribute, value, true, 0, true);
            }
            if (simpleCondition.equals(FILTER_IS_NOT_EQUAL_TO)) {
                return new AttributeCompareCondition(attribute, value, true, 0, false);
            }
            if (simpleCondition.equals(FILTER_GT)) {
                return new AttributeCompareCondition(attribute, value, true, 1, true);
            }
            if (simpleCondition.equals(FILTER_GE)) {
                return new AttributeCompareCondition(attribute, value, true, -1, false);
            }
            if (simpleCondition.equals(FILTER_LT)) {
                return new AttributeCompareCondition(attribute, value, true, -1, true);
            }
            if (simpleCondition.equals(FILTER_LE)) {
                return new AttributeCompareCondition(attribute, value, true, 1, false);
            }
        } else {
            if (simpleCondition.equals(FILTER_IS_EQUAL_TO)) {
                return new AttributeCompareCondition(attribute, value, false, 0, true);
            }
            if (simpleCondition.equals(FILTER_IS_NOT_EQUAL_TO)) {
                return new AttributeCompareCondition(attribute, value, false, 0, false);
            }
            if (simpleCondition.equals(FILTER_GT)) {
                return new AttributeCompareCondition(attribute, value, false, 1, true);
            }
            if (simpleCondition.equals(FILTER_GE)) {
                return new AttributeCompareCondition(attribute, value, false, -1, false);
            }
            if (simpleCondition.equals(FILTER_LT)) {
                return new AttributeCompareCondition(attribute, value, false, -1, true);
            }
            if (simpleCondition.equals(FILTER_LE)) {
                return new AttributeCompareCondition(attribute, value, false, 1, false);
            }
        }
        return null;
    }

    public Condition createCondition(NamedObject attribute, NamedObject simpleCondition, String value, boolean ignoreCase) {
        if (attribute.equals(FILTER_ICON) && simpleCondition.equals(FILTER_CONTAINS)) {
            return new IconContainedCondition(value);
        }
        if (attribute.equals(FILTER_ICON) && simpleCondition.equals(FILTER_NOT_CONTAINS)) {
            return new IconNotContainedCondition(value);
        }
        if (attribute.equals(FILTER_NODE)) {
            return this.createNodeCondition(simpleCondition, value, ignoreCase);
        }
        return null;
    }

    public NamedObject[] getNodeConditionNames() {
        return new NamedObject[]{Resources.getInstance().createTranslatedString(FILTER_CONTAINS), Resources.getInstance().createTranslatedString(FILTER_IS_EQUAL_TO), Resources.getInstance().createTranslatedString(FILTER_IS_NOT_EQUAL_TO), NamedObject.literal(FILTER_GT), NamedObject.literal(FILTER_GE), NamedObject.literal(FILTER_LE), NamedObject.literal(FILTER_LT)};
    }

    public Object[] getIconConditionNames() {
        return new NamedObject[]{Resources.getInstance().createTranslatedString(FILTER_CONTAINS), Resources.getInstance().createTranslatedString(FILTER_NOT_CONTAINS)};
    }

    public NamedObject[] getAttributeConditionNames() {
        return new NamedObject[]{Resources.getInstance().createTranslatedString(FILTER_EXIST), Resources.getInstance().createTranslatedString(FILTER_DOES_NOT_EXIST), Resources.getInstance().createTranslatedString(FILTER_IS_EQUAL_TO), Resources.getInstance().createTranslatedString(FILTER_IS_NOT_EQUAL_TO), NamedObject.literal(FILTER_GT), NamedObject.literal(FILTER_GE), NamedObject.literal(FILTER_LE), NamedObject.literal(FILTER_LT)};
    }

    protected Condition createNodeCondition(NamedObject simpleCondition, String value, boolean ignoreCase) {
        if (ignoreCase) {
            if (simpleCondition.equals(FILTER_CONTAINS)) {
                if (value.equals("")) {
                    return null;
                }
                return new IgnoreCaseNodeContainsCondition(value);
            }
            if (simpleCondition.equals(FILTER_IS_EQUAL_TO)) {
                return new NodeCompareCondition(value, true, 0, true);
            }
            if (simpleCondition.equals(FILTER_IS_NOT_EQUAL_TO)) {
                return new NodeCompareCondition(value, true, 0, false);
            }
            if (simpleCondition.equals(FILTER_GT)) {
                return new NodeCompareCondition(value, true, 1, true);
            }
            if (simpleCondition.equals(FILTER_GE)) {
                return new NodeCompareCondition(value, true, -1, false);
            }
            if (simpleCondition.equals(FILTER_LT)) {
                return new NodeCompareCondition(value, true, -1, true);
            }
            if (simpleCondition.equals(FILTER_LE)) {
                return new NodeCompareCondition(value, true, 1, false);
            }
        } else {
            if (simpleCondition.equals(FILTER_CONTAINS)) {
                if (value.equals("")) {
                    return null;
                }
                return new NodeContainsCondition(value);
            }
            if (simpleCondition.equals(FILTER_IS_EQUAL_TO)) {
                return new NodeCompareCondition(value, false, 0, true);
            }
            if (simpleCondition.equals(FILTER_IS_NOT_EQUAL_TO)) {
                return new NodeCompareCondition(value, false, 0, false);
            }
            if (simpleCondition.equals(FILTER_GT)) {
                return new NodeCompareCondition(value, false, 1, true);
            }
            if (simpleCondition.equals(FILTER_GE)) {
                return new NodeCompareCondition(value, false, -1, false);
            }
            if (simpleCondition.equals(FILTER_LT)) {
                return new NodeCompareCondition(value, false, -1, true);
            }
            if (simpleCondition.equals(FILTER_LE)) {
                return new NodeCompareCondition(value, false, 1, false);
            }
        }
        return null;
    }

    public static JComponent createCellRendererComponent(String description) {
        JCondition component = new JCondition();
        JLabel label = new JLabel(description);
        component.add(label);
        return component;
    }
}

