/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import javax.swing.filechooser.FileSystemView;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;

public class FileRootsVFS
extends VFS {
    public static final String PROTOCOL = "roots";
    private static FileSystemView fsView = FileSystemView.getFileSystemView();

    public FileRootsVFS() {
        super(PROTOCOL, 324, new String[]{"type"});
    }

    @Override
    public String getParentOfPath(String string) {
        return "roots:";
    }

    @Override
    public VFSFile[] _listFiles(Object object, String string, Component component) {
        File[] fileArray = FileRootsVFS.listRoots();
        if (fileArray == null) {
            return null;
        }
        VFSFile[] vFSFileArray = new VFSFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            vFSFileArray[i] = new Root(fileArray[i]);
        }
        return vFSFileArray;
    }

    @Override
    public VFSFile _getFile(Object object, String string, Component component) {
        return new Root(new File(string));
    }

    private static File[] listRoots() {
        if (OperatingSystem.isMacOS()) {
            File[] fileArray = new File("/Volumes").listFiles();
            LinkedList<File> linkedList = new LinkedList<File>();
            linkedList.add(new File("/"));
            for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                linkedList.add(file);
            }
            return linkedList.toArray(new File[linkedList.size()]);
        }
        File[] fileArray = File.listRoots();
        File[] fileArray2 = fsView.getRoots();
        if (fileArray2 == null) {
            return fileArray;
        }
        File[] fileArray3 = new File[fileArray.length + fileArray2.length];
        System.arraycopy(fileArray2, 0, fileArray3, 0, fileArray2.length);
        System.arraycopy(fileArray, 0, fileArray3, 1, fileArray.length);
        return fileArray3;
    }

    static class Root
    extends VFSFile {
        Root(File file) {
            String string = file.getPath();
            this.setPath(string);
            this.setDeletePath(string);
            this.setSymlinkPath(string);
            if (fsView.isFloppyDrive(file)) {
                this.setType(2);
                this.setName(string);
            } else if (fsView.isDrive(file)) {
                this.setType(2);
                this.setName(string + ' ' + fsView.getSystemDisplayName(file));
            } else if (file.isDirectory()) {
                if (fsView.isFileSystemRoot(file)) {
                    this.setType(1);
                } else {
                    this.setType(2);
                }
                if (OperatingSystem.isMacOS()) {
                    this.setName(MiscUtilities.getFileName(string));
                } else {
                    this.setName(string);
                }
            } else {
                this.setType(0);
            }
        }

        @Override
        public String getExtendedAttribute(String string) {
            if (string.equals("type")) {
                return super.getExtendedAttribute(string);
            }
            return null;
        }
    }
}

