/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.Segment;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Balloon
implements UDrawable {
    private final Point2D center;
    private final double radius;

    public Balloon(Point2D center, double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException();
        }
        this.center = center;
        this.radius = radius;
    }

    public static Balloon fromRadiusSegment(Segment centerToContact) {
        throw new UnsupportedOperationException();
    }

    public Point2D getPointOnCircle(double a) {
        return new Point2D.Double(this.center.getX() + this.radius * Math.cos(a), this.center.getY() + this.radius * Math.sin(a));
    }

    public Segment getSegmentCenterToPointOnCircle(double a) {
        return new Segment(this.center, this.getPointOnCircle(a));
    }

    public Balloon translate(UTranslate translate) {
        return new Balloon(translate.getTranslated(this.center), this.radius);
    }

    public Balloon rotate(RotationZoom rotationZoom) {
        return new Balloon(rotationZoom.getPoint(this.center), rotationZoom.applyZoom(this.radius));
    }

    public String toString() {
        return "Balloon(" + this.center + "," + this.radius + ")";
    }

    public Point2D getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(2.0 * this.radius, 2.0 * this.radius);
        ug.apply(new UTranslate(this.center.getX() - circle.getWidth() / 2.0, this.center.getY() - circle.getHeight() / 2.0)).draw(circle);
    }

    public Balloon getInsideTangentBalloon1(double angle, double curvation) {
        double f = this.radius - curvation;
        double e = (this.radius * this.radius - f * f) / 2.0 / this.radius;
        RotationZoom rotation = RotationZoom.rotationInRadians(angle);
        Point2D.Double p1 = rotation.getPoint(f, e);
        Point2D.Double newCenter = new Point2D.Double(this.center.getX() + ((Point2D)p1).getX(), this.center.getY() + ((Point2D)p1).getY());
        return new Balloon(newCenter, e);
    }

    public Balloon getInsideTangentBalloon2(double angle, double curvation) {
        double f = this.radius - curvation;
        double e = (this.radius * this.radius - f * f) / 2.0 / this.radius;
        RotationZoom rotation = RotationZoom.rotationInRadians(angle);
        Point2D.Double p1 = rotation.getPoint(f, -e);
        Point2D.Double newCenter = new Point2D.Double(this.center.getX() + ((Point2D)p1).getX(), this.center.getY() + ((Point2D)p1).getY());
        return new Balloon(newCenter, e);
    }

    public Point2D getPointOnCirclePassingByThisPoint(Point2D passingBy) {
        Segment seg = new Segment(this.center, passingBy);
        return seg.getFromAtoB(this.radius);
    }

    public Point2D getPointOnCircleOppositeToThisPoint(Point2D passingBy) {
        Segment seg = new Segment(this.center, passingBy);
        return seg.getFromAtoB(-this.radius);
    }
}

