/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.internal;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Transient;

final class FieldColumnInfo {
    private final Class<?> clazz;
    private final String propertyName;
    final Field field;
    final Class<?> fieldType;
    private boolean isDelimited;
    private Boolean updatable;
    private Boolean insertable;
    private String columnName;
    String columnTableName = "";
    EnumType enumType;
    Map<Object, Object> enumConstants;
    private AttributeConverter converter;
    private String caseSensitiveColumnName;
    boolean isGeneratedId;
    boolean isIdField;
    private boolean isJoinColumn;
    boolean isTransient;
    private boolean isEnumerated;
    private boolean isColumnAnnotated;
    private String delimitedFieldName;
    private final String fullyQualifiedDelimitedFieldName;

    public FieldColumnInfo(Field field, Class<?> clazz) {
        this.field = field;
        this.clazz = clazz;
        this.propertyName = field.getName();
        this.fieldType = this.getFieldType();
        this.extractAnnotations();
        this.processFieldAnnotations();
        this.fullyQualifiedDelimitedFieldName = this.columnTableName.isEmpty() ? this.delimitedFieldName : this.columnTableName + "." + this.delimitedFieldName;
    }

    private Class<?> getFieldType() {
        Class<?> type = this.field.getType();
        if (type == Date.class) {
            return Timestamp.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        return type;
    }

    private void processFieldAnnotations() {
        if (this.isColumnAnnotated) {
            this.processColumnAnnotation();
        } else if (this.isJoinColumn) {
            this.processJoinColumnAnnotation();
        } else if (this.isIdField) {
            this.setColumnName(this.field.getName());
        } else {
            this.setColumnName(this.field.getName());
        }
        this.processConvertAnnotation();
    }

    private void extractAnnotations() {
        Column columnAnnotation;
        Transient transientAnnotation;
        JoinColumn joinColumnAnnotation;
        Enumerated enumAnnotation;
        Id idAnnotation = this.field.getAnnotation(Id.class);
        if (idAnnotation != null) {
            this.isIdField = true;
            GeneratedValue generatedAnnotation = this.field.getAnnotation(GeneratedValue.class);
            boolean bl = this.isGeneratedId = generatedAnnotation != null;
        }
        if ((enumAnnotation = this.field.getAnnotation(Enumerated.class)) != null) {
            this.isEnumerated = true;
            this.setEnumConstants(enumAnnotation.value());
        }
        if ((joinColumnAnnotation = this.field.getAnnotation(JoinColumn.class)) != null) {
            this.isJoinColumn = true;
        }
        if ((transientAnnotation = this.field.getAnnotation(Transient.class)) != null) {
            this.isTransient = true;
        }
        if ((columnAnnotation = this.field.getAnnotation(Column.class)) != null) {
            this.isColumnAnnotated = true;
        }
    }

    private void processConvertAnnotation() {
        Convert convertAnnotation = this.field.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            Class converterClass = convertAnnotation.converter();
            if (!AttributeConverter.class.isAssignableFrom(converterClass)) {
                throw new RuntimeException("Convert annotation only supports converters implementing AttributeConverter");
            }
            try {
                this.setConverter((AttributeConverter)converterClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void processColumnAnnotation() {
        Column columnAnnotation = this.field.getAnnotation(Column.class);
        String columnName = columnAnnotation.name();
        this.setColumnName(columnName);
        this.columnTableName = columnAnnotation.table();
        this.insertable = columnAnnotation.insertable();
        this.updatable = columnAnnotation.updatable();
    }

    private void processJoinColumnAnnotation() {
        JoinColumn joinColumnAnnotation = this.field.getAnnotation(JoinColumn.class);
        if (this.field.getType() != this.clazz) {
            throw new RuntimeException("JoinColumn annotations can only be self-referencing: " + this.field.getType().getCanonicalName() + " != " + this.clazz.getCanonicalName());
        }
        this.setColumnName(joinColumnAnnotation.name());
    }

    private boolean isNotDelimited(String columnName) {
        return !columnName.startsWith("\"") || !columnName.endsWith("\"");
    }

    private void setColumnName(String columnName) {
        String colName;
        String string = colName = columnName.isEmpty() ? this.field.getName() : columnName;
        if (this.isNotDelimited(colName)) {
            this.columnName = colName.toLowerCase();
            this.caseSensitiveColumnName = colName;
            this.delimitedFieldName = colName;
        } else {
            this.caseSensitiveColumnName = this.columnName = colName.substring(1, colName.length() - 1);
            this.delimitedFieldName = colName;
            this.isDelimited = true;
        }
    }

    <T extends Enum<?>> void setEnumConstants(EnumType type) {
        Enum[] enums;
        this.enumType = type;
        this.enumConstants = new HashMap<Object, Object>();
        for (Enum enumConst : enums = (Enum[])this.field.getType().getEnumConstants()) {
            Object key = type == EnumType.ORDINAL ? Integer.valueOf(enumConst.ordinal()) : enumConst.name();
            this.enumConstants.put(key, enumConst);
        }
    }

    public String toString() {
        return this.field.getName() + "->" + this.getColumnName();
    }

    public void setConverter(AttributeConverter converter) {
        this.converter = converter;
    }

    public AttributeConverter getConverter() {
        return this.converter;
    }

    boolean isSelfJoinField() {
        return this.isJoinColumn && this.field.getType() == this.clazz;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getCaseSensitiveColumnName() {
        return this.caseSensitiveColumnName;
    }

    public String getDelimitedColumnName() {
        return this.delimitedFieldName;
    }

    public String getFullyQualifiedDelimitedFieldName(String ... tablePrefix) {
        return this.columnTableName.isEmpty() && tablePrefix.length > 0 ? tablePrefix[0] + "." + this.fullyQualifiedDelimitedFieldName : this.fullyQualifiedDelimitedFieldName;
    }

    public boolean isDelimited() {
        return this.isDelimited;
    }

    public boolean isEnumerated() {
        return this.isEnumerated;
    }

    Boolean isUpdatable() {
        return this.updatable;
    }

    Boolean isInsertable() {
        return this.insertable;
    }
}

