/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx;

import javafx.application.Platform;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import mediathek.mainwindow.MediathekGui;
import org.tbee.javafx.scene.layout.MigPane;

public class ShutdownDialog {
    private Label lblStatusText;
    private Stage stage;
    private ProgressBar progress;
    private final double maxTasks;
    private final MediathekGui gui;
    private boolean hidden = false;

    public ShutdownDialog(MediathekGui gui, int maxTasks) {
        this.maxTasks = maxTasks;
        this.gui = gui;
        Platform.runLater(() -> {
            this.stage = new Stage();
            this.stage.setOnHidden(e -> {
                this.hidden = true;
            });
            this.stage.setAlwaysOnTop(true);
            this.stage.setResizable(false);
            this.stage.setOnCloseRequest(Event::consume);
            this.stage.initStyle(StageStyle.UNDECORATED);
            this.stage.setTitle("Programm beenden");
            this.stage.setScene(this.createScene());
        });
    }

    public void show() {
        Platform.runLater(() -> {
            this.stage.show();
            this.stage.centerOnScreen();
        });
        this.gui.setEnabled(false);
    }

    public void hide() {
        Platform.runLater(() -> {
            if (!this.hidden) {
                this.stage.hide();
            }
        });
        this.gui.setEnabled(true);
    }

    public void setStatusText(int task, String text) {
        Platform.runLater(() -> {
            double percent = (double)task / this.maxTasks;
            this.progress.setProgress(percent);
            String message = "(" + task + "/" + (int)this.maxTasks + ") " + text;
            this.lblStatusText.setText(message);
        });
        try {
            Thread.sleep(125L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Scene createScene() {
        MigPane migPane = new MigPane("hidemode 3", "[fill][fill]", "[][][]");
        this.progress = new ProgressBar();
        this.progress.setProgress(0.0);
        this.progress.setPrefWidth(450.0);
        this.progress.setMinWidth(350.0);
        migPane.add((Node)new ProgressIndicator(), "cell 0 0 1 3");
        this.lblStatusText = new Label("Offene Operationen m\u00fcssen noch beendet werden.");
        migPane.add((Node)this.lblStatusText, "cell 1 0");
        migPane.add((Node)this.progress, "cell 1 1");
        migPane.add((Node)new Label(""), "cell 1 2");
        return new Scene(migPane);
    }
}

