/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.util.NoSuchElementException;

public class CircularBuffer {
    private final double[] elements;
    private int start = -1;
    private int end = -1;
    private final int capacity;

    public void add(double num) {
        this.end = (this.end + 1) % this.capacity;
        this.elements[this.end] = num;
        if (this.start == this.end || this.start == -1) {
            this.start = (this.start + 1) % this.capacity;
        }
    }

    public double get(int index) {
        if (index >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[(this.start + index) % this.capacity];
    }

    public boolean isEmpty() {
        return this.start == -1 && this.end == -1;
    }

    public CircularBuffer(int capacity) {
        this.capacity = capacity;
        this.elements = new double[capacity];
    }

    public double min() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        double out = this.get(0);
        for (int i = 1; i < this.size(); ++i) {
            out = Math.min(out, this.get(i));
        }
        return out;
    }

    public double max() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        double out = this.get(0);
        for (int i = 1; i < this.size(); ++i) {
            out = Math.max(out, this.get(i));
        }
        return out;
    }

    public int size() {
        if (this.end == -1) {
            return 0;
        }
        return (this.end - this.start + this.capacity) % this.capacity + 1;
    }

    public int capacity() {
        return this.capacity;
    }
}

