/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.EventQueue;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class DownloadTaskList {
    private final List<DownloadTask> tasks = new LinkedList<DownloadTask>();
    private final List<Future<?>> taskFutures = new LinkedList();
    private final boolean zoomAfterDownload;
    private ProgressMonitor progressMonitor;

    public DownloadTaskList() {
        this(true);
    }

    public DownloadTaskList(boolean zoomAfterDownload) {
        this.zoomAfterDownload = zoomAfterDownload;
    }

    private void addDownloadTask(ProgressMonitor progressMonitor, DownloadTask dt, Rectangle2D td, int i, int n) {
        ProgressMonitor childProgress = progressMonitor.createSubTaskMonitor(1, false);
        childProgress.setCustomText(I18n.tr("Download {0} of {1} ({2} left)", i, n, n - i));
        dt.setZoomAfterDownload(this.zoomAfterDownload);
        Future<?> future = dt.download(new DownloadParams(), new Bounds(td), childProgress);
        this.taskFutures.add(future);
        this.tasks.add(dt);
    }

    public Future<?> download(boolean newLayer, List<Rectangle2D> rects, boolean osmData, boolean gpxData, ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        if (newLayer) {
            OsmDataLayer l = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            MainApplication.getLayerManager().addLayer(l);
            MainApplication.getLayerManager().setActiveLayer(l);
        }
        int n = (osmData && gpxData ? 2 : 1) * rects.size();
        progressMonitor.beginTask(null, n);
        int i = 0;
        for (Rectangle2D td : rects) {
            ++i;
            if (osmData) {
                this.addDownloadTask(progressMonitor, new DownloadOsmTask(), td, i, n);
            }
            if (!gpxData) continue;
            this.addDownloadTask(progressMonitor, new DownloadGpsTask(), td, i, n);
        }
        progressMonitor.addCancelListener(() -> {
            for (DownloadTask dt : this.tasks) {
                dt.cancel();
            }
        });
        return MainApplication.worker.submit(new PostDownloadProcessor(osmData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> download(boolean newLayer, Collection<Area> areas, boolean osmData, boolean gpxData, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr("Updating data", new Object[0]));
        try {
            List<Rectangle2D> rects = areas.stream().map(Area::getBounds2D).collect(Collectors.toList());
            Future<?> future = this.download(newLayer, rects, osmData, gpxData, progressMonitor.createSubTaskMonitor(-1, false));
            return future;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected Set<OsmPrimitive> getCompletePrimitives(DataSet ds) {
        return ds.allPrimitives().stream().filter(p -> !p.isIncomplete() && !p.isNew()).collect(Collectors.toSet());
    }

    protected void updatePotentiallyDeletedPrimitives(Set<OsmPrimitive> potentiallyDeleted) {
        List toSelect = potentiallyDeleted.stream().filter(Objects::nonNull).collect(Collectors.toList());
        EventQueue.invokeLater(() -> UpdateSelectionAction.updatePrimitives(toSelect));
    }

    protected void handlePotentiallyDeletedPrimitives(Set<OsmPrimitive> potentiallyDeleted) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Check on the server", new Object[0]), new ImageProvider("ok"), I18n.tr("Click to check whether objects in your local dataset are deleted on the server", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Ignore", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to abort and to resume editing", new Object[0]), null)};
        String message = "<html>" + I18n.trn("There is {0} object in your local dataset which might be deleted on the server.<br>If you later try to delete or update this the server is likely to report a conflict.", "There are {0} objects in your local dataset which might be deleted on the server.<br>If you later try to delete or update them the server is likely to report a conflict.", potentiallyDeleted.size(), potentiallyDeleted.size()) + "<br>" + I18n.trn("Click <strong>{0}</strong> to check the state of this object on the server.", "Click <strong>{0}</strong> to check the state of these objects on the server.", potentiallyDeleted.size(), options[0].text) + "<br>" + I18n.tr("Click <strong>{0}</strong> to ignore.</html>", options[1].text);
        int ret = HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), message, I18n.tr("Deleted or moved objects", new Object[0]), 2, null, options, options[0], HelpUtil.ht("/Action/UpdateData#SyncPotentiallyDeletedObjects"));
        if (ret != 0) {
            return;
        }
        this.updatePotentiallyDeletedPrimitives(potentiallyDeleted);
    }

    public Set<OsmPrimitive> getDownloadedPrimitives() {
        return this.tasks.stream().filter(t -> t instanceof DownloadOsmTask).map(t -> (DataSet)((DownloadOsmTask)t).getDownloadedData()).filter(Objects::nonNull).flatMap(ds -> ds.allPrimitives().stream()).collect(Collectors.toSet());
    }

    class PostDownloadProcessor
    implements Runnable {
        private final boolean osmData;

        PostDownloadProcessor(boolean osmData) {
            this.osmData = osmData;
        }

        @Override
        public void run() {
            DownloadTaskList.this.progressMonitor.finishTask();
            for (Future future : DownloadTaskList.this.taskFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    Logging.error(e);
                    return;
                }
            }
            Set errors = DownloadTaskList.this.tasks.stream().flatMap(t -> t.getErrorObjects().stream()).collect(Collectors.toSet());
            if (!errors.isEmpty()) {
                ArrayList<String> items = new ArrayList<String>();
                for (Object error : errors) {
                    if (error instanceof String) {
                        items.add((String)error);
                        continue;
                    }
                    if (!(error instanceof Exception)) continue;
                    items.add(ExceptionUtil.explainException((Exception)error));
                }
                GuiHelper.runInEDT(() -> {
                    if (items.size() == 1 && PostDownloadHandler.isNoDataErrorMessage(items.iterator().next())) {
                        new Notification((String)items.iterator().next()).setIcon(2).show();
                    } else {
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), "<html>" + I18n.tr("The following errors occurred during mass download: {0}", Utils.joinAsHtmlUnorderedList(items)) + "</html>", I18n.tr("Errors during download", new Object[0]), 0);
                    }
                });
                return;
            }
            if (Utils.filteredCollection(DownloadTaskList.this.tasks, AbstractDownloadTask.class).stream().anyMatch(absTask -> absTask.isCanceled() || absTask.isFailed())) {
                return;
            }
            DataSet editDataSet = MainApplication.getLayerManager().getEditDataSet();
            if (editDataSet != null && this.osmData) {
                List osmTasks = DownloadTaskList.this.tasks.stream().filter(t -> t instanceof DownloadOsmTask).map(t -> (DownloadOsmTask)t).filter(t -> t.getDownloadedData() != null).collect(Collectors.toList());
                Set tasksBounds = osmTasks.stream().flatMap(t -> ((DataSet)t.getDownloadedData()).getDataSourceBounds().stream()).collect(Collectors.toSet());
                LinkedHashSet<Bounds> layerBounds = new LinkedHashSet<Bounds>(editDataSet.getDataSourceBounds());
                LinkedHashSet<OsmPrimitive> myPrimitives = new LinkedHashSet<OsmPrimitive>();
                if (layerBounds.equals(tasksBounds)) {
                    myPrimitives.addAll(DownloadTaskList.this.getCompletePrimitives(editDataSet));
                    for (DownloadOsmTask task : osmTasks) {
                        ((DataSet)task.getDownloadedData()).allPrimitives().forEach(myPrimitives::remove);
                    }
                } else {
                    for (DownloadOsmTask task : osmTasks) {
                        myPrimitives.addAll(task.searchPotentiallyDeletedPrimitives(editDataSet));
                    }
                }
                if (!myPrimitives.isEmpty()) {
                    GuiHelper.runInEDT(() -> DownloadTaskList.this.handlePotentiallyDeletedPrimitives(myPrimitives));
                }
            }
        }
    }
}

