/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryViewerPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.RelationMemberTableColumnModel;
import org.openstreetmap.josm.gui.history.ReversedChangeListener;
import org.openstreetmap.josm.gui.history.ShowHistoryAction;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;

public class RelationMemberListViewer
extends HistoryViewerPanel {
    @Override
    protected JTable buildTable(PointInTimeType pointInTimeType) {
        DiffTableModel tableModel = this.model.getRelationMemberTableModel(pointInTimeType);
        RelationMemberTableColumnModel columnModel = new RelationMemberTableColumnModel();
        JTable table = new JTable(tableModel, columnModel);
        tableModel.addTableModelListener(new ReversedChangeListener(table, columnModel, I18n.tr("The members of this relation are in reverse order", new Object[0])));
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.getTableHeader().setReorderingAllowed(false);
        table.addMouseListener(new InternalPopupMenuLauncher());
        table.getModel().addTableModelListener(e -> {
            Rectangle rect = table.getCellRect(((DiffTableModel)e.getSource()).getFirstChange(), 0, true);
            table.scrollRectToVisible(rect);
        });
        table.addMouseListener(new ShowHistoryAction.DoubleClickAdapter(e -> {
            int row = table.rowAtPoint(e.getPoint());
            return RelationMemberListViewer.primitiveIdAtRow(tableModel, row);
        }));
        return table;
    }

    public RelationMemberListViewer(HistoryBrowserModel model) {
        super(model);
    }

    private static PrimitiveId primitiveIdAtRow(DiffTableModel model, int row) {
        if (row < 0) {
            return null;
        }
        RelationMemberData rm = (RelationMemberData)model.getValueAt((int)row, (int)0).value;
        if (rm == null) {
            return null;
        }
        return new SimplePrimitiveId(rm.getUniqueId(), rm.getType());
    }

    static class InternalPopupMenuLauncher
    extends PopupMenuLauncher {
        InternalPopupMenuLauncher() {
            super(new HistoryViewerPanel.ListPopupMenu(I18n.tr("Zoom to member", new Object[0]), I18n.tr("Zoom to this member in the current data layer", new Object[0])));
        }

        @Override
        protected int checkTableSelection(JTable table, Point p) {
            int row = super.checkTableSelection(table, p);
            ((HistoryViewerPanel.ListPopupMenu)this.menu).prepare(RelationMemberListViewer.primitiveIdAtRow((DiffTableModel)table.getModel(), row));
            return row;
        }
    }
}

