/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.util.ManyToMany;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AptSourceLocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class AnnotationDiscoveryVisitor
extends ASTVisitor {
    final BaseProcessingEnvImpl _env;
    final Factory _factory;
    final ManyToMany<TypeElement, Element> _annoToElement;

    public AnnotationDiscoveryVisitor(BaseProcessingEnvImpl baseProcessingEnvImpl) {
        this._env = baseProcessingEnvImpl;
        this._factory = baseProcessingEnvImpl.getFactory();
        this._annoToElement = new ManyToMany();
    }

    @Override
    public boolean visit(Argument argument, BlockScope blockScope) {
        Annotation[] annotationArray = argument.annotations;
        ReferenceContext referenceContext = blockScope.referenceContext();
        if (referenceContext instanceof AbstractMethodDeclaration) {
            MethodBinding methodBinding = ((AbstractMethodDeclaration)referenceContext).binding;
            if (methodBinding != null) {
                TypeDeclaration typeDeclaration = blockScope.referenceType();
                typeDeclaration.binding.resolveTypesFor(methodBinding);
                if (argument.binding != null) {
                    argument.binding = new AptSourceLocalVariableBinding(argument.binding, methodBinding);
                }
            }
            if (annotationArray != null && argument.binding != null) {
                this.resolveAnnotations(blockScope, annotationArray, argument.binding);
            }
        }
        return false;
    }

    @Override
    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope classScope) {
        Argument[] argumentArray;
        int n;
        TypeParameter[] typeParameterArray;
        Annotation[] annotationArray = constructorDeclaration.annotations;
        if (annotationArray != null) {
            typeParameterArray = constructorDeclaration.binding;
            if (typeParameterArray == null) {
                return false;
            }
            ((SourceTypeBinding)typeParameterArray.declaringClass).resolveTypesFor((MethodBinding)typeParameterArray);
            this.resolveAnnotations(constructorDeclaration.scope, annotationArray, (Binding)typeParameterArray);
        }
        if ((typeParameterArray = constructorDeclaration.typeParameters) != null) {
            int n2 = typeParameterArray.length;
            for (n = 0; n < n2; ++n) {
                typeParameterArray[n].traverse((ASTVisitor)this, constructorDeclaration.scope);
            }
        }
        if ((argumentArray = constructorDeclaration.arguments) != null) {
            n = argumentArray.length;
            for (int i = 0; i < n; ++i) {
                argumentArray[i].traverse((ASTVisitor)this, constructorDeclaration.scope);
            }
        }
        return false;
    }

    @Override
    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope methodScope) {
        Annotation[] annotationArray = fieldDeclaration.annotations;
        if (annotationArray != null) {
            FieldBinding fieldBinding = fieldDeclaration.binding;
            if (fieldBinding == null) {
                return false;
            }
            ((SourceTypeBinding)fieldBinding.declaringClass).resolveTypeFor(fieldBinding);
            this.resolveAnnotations(methodScope, annotationArray, fieldBinding);
        }
        return false;
    }

    @Override
    public boolean visit(TypeParameter typeParameter, ClassScope classScope) {
        Annotation[] annotationArray = typeParameter.annotations;
        if (annotationArray != null) {
            TypeVariableBinding typeVariableBinding = typeParameter.binding;
            if (typeVariableBinding == null) {
                return false;
            }
            this.resolveAnnotations(classScope.referenceContext.initializerScope, annotationArray, typeVariableBinding);
        }
        return false;
    }

    @Override
    public boolean visit(TypeParameter typeParameter, BlockScope blockScope) {
        Annotation[] annotationArray = typeParameter.annotations;
        if (annotationArray != null) {
            TypeVariableBinding typeVariableBinding = typeParameter.binding;
            if (typeVariableBinding == null) {
                return false;
            }
            MethodBinding methodBinding = (MethodBinding)typeVariableBinding.declaringElement;
            ((SourceTypeBinding)methodBinding.declaringClass).resolveTypesFor(methodBinding);
            this.resolveAnnotations(blockScope, annotationArray, typeVariableBinding);
        }
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration, ClassScope classScope) {
        Argument[] argumentArray;
        int n;
        TypeParameter[] typeParameterArray;
        Annotation[] annotationArray = methodDeclaration.annotations;
        if (annotationArray != null) {
            typeParameterArray = methodDeclaration.binding;
            if (typeParameterArray == null) {
                return false;
            }
            ((SourceTypeBinding)typeParameterArray.declaringClass).resolveTypesFor((MethodBinding)typeParameterArray);
            this.resolveAnnotations(methodDeclaration.scope, annotationArray, (Binding)typeParameterArray);
        }
        if ((typeParameterArray = methodDeclaration.typeParameters) != null) {
            int n2 = typeParameterArray.length;
            for (n = 0; n < n2; ++n) {
                typeParameterArray[n].traverse((ASTVisitor)this, methodDeclaration.scope);
            }
        }
        if ((argumentArray = methodDeclaration.arguments) != null) {
            n = argumentArray.length;
            for (int i = 0; i < n; ++i) {
                argumentArray[i].traverse((ASTVisitor)this, methodDeclaration.scope);
            }
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        if (sourceTypeBinding == null) {
            return false;
        }
        Annotation[] annotationArray = typeDeclaration.annotations;
        if (annotationArray != null) {
            this.resolveAnnotations(typeDeclaration.staticInitializerScope, annotationArray, sourceTypeBinding);
        }
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope compilationUnitScope) {
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        if (sourceTypeBinding == null) {
            return false;
        }
        Annotation[] annotationArray = typeDeclaration.annotations;
        if (annotationArray != null) {
            this.resolveAnnotations(typeDeclaration.staticInitializerScope, annotationArray, sourceTypeBinding);
        }
        return true;
    }

    private void resolveAnnotations(BlockScope blockScope, Annotation[] annotationArray, Binding binding) {
        AnnotationBinding[] annotationBindingArray;
        int n;
        int n2 = n = annotationArray == null ? 0 : annotationArray.length;
        if (n == 0) {
            return;
        }
        boolean bl = blockScope.insideTypeAnnotation;
        blockScope.insideTypeAnnotation = true;
        binding.getAnnotationTagBits();
        blockScope.insideTypeAnnotation = bl;
        ElementImpl elementImpl = (ElementImpl)this._factory.newElement(binding);
        for (AnnotationBinding annotationBinding : annotationBindingArray = elementImpl.getPackedAnnotationBindings()) {
            ReferenceBinding referenceBinding = annotationBinding.getAnnotationType();
            if (annotationBinding == null || !Annotation.isAnnotationTargetAllowed(blockScope, referenceBinding, binding)) continue;
            TypeElement typeElement = (TypeElement)this._factory.newElement(referenceBinding);
            this._annoToElement.put(typeElement, elementImpl);
        }
    }
}

