/**
 * SECTION:tpf-persona-store
 * @short_description: A persona store which is associated with a single Telepathy account. It will create <link linkend="TpfPersona"><type>TpfPersona</type></link>s for each of the contacts in the account&apos;s contact list.
 * 
 * <para>User must define contact features it wants on the #TpSimpleClientFactory of the default #TpAccountManager returned by tp_account_manager_dup() *before* preparing telepathy stores. Note that this is a behaviour change since 0.7.0, folks won&apos;t force preparing any feature anymore.</para>
 */
/**
 * TPF_TYPE_PERSONA_STORE:
 * 
 * The type for <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link>.
 */
/**
 * tpf_persona_store_new:
 * @account: (in): &nbsp;.  <para>the Telepathy account being represented by the persona store </para>
 * 
 * Create a new PersonaStore.
 * 
 * <para>Create a new persona store to store the <link linkend="TpfPersona"><type>TpfPersona</type></link>s for the contacts in the Telepathy account provided by <code>account</code>.</para>
 */
/**
 * TpfPersonaStore:account:
 * 
 * The Telepathy account this store is based upon.
 */
/**
 * tpf_persona_store_get_account:
 * @self: the <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="TpfPersonaStore--account"><type>"account"</type></link> property.
 * 
 * The Telepathy account this store is based upon.
 * 
 * Returns: the value of the <link linkend="TpfPersonaStore--account"><type>"account"</type></link> property
 */
/**
 * tpf_persona_store_list_persona_stores:
 * 
 * Get a map of all the currently constructed <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link>s.
 * 
 * <para>If a <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> has been prepared, this map will be complete, containing every store known to the Telepathy account manager. If no <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> has been prepared, this map will only contain the stores which have been created by calling <link linkend="tpf-persona-store-dup-for-account"><function>tpf_persona_store_dup_for_account()</function></link>.</para><para>This map is read-only. Use <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> or <link linkend="tpf-persona-store-dup-for-account"><function>tpf_persona_store_dup_for_account()</function></link> to add stores.</para>
 * 
 * Returns: (transfer none): <para>map from <link linkend="FolksPersonaStore--id"><type>"id"</type></link> to <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link> </para>
 *
 * Since: 0.6.6
 */
/**
 * tpf_persona_store_dup_for_account:
 * @account: (in): &nbsp;.  <para>the Telepathy account of the persona store </para>
 * 
 * Look up a <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link> by its <link linkend="TpAccount"><type>TpAccount</type></link>.
 * 
 * <para>If found, a new reference to the persona store will be returned. If not found, a new <link linkend="TpfPersonaStore"><type>TpfPersonaStore</type></link> will be created for the account.</para><para>See the documentation for <link linkend="tpf-persona-store-list-persona-stores"><function>tpf_persona_store_list_persona_stores()</function></link> for information on the lifecycle of these stores when a <link linkend="FolksBackendStore"><type>FolksBackendStore</type></link> is and is not present.</para>
 * 
 * Returns: <para>the persona store associated with the account </para>
 *
 * Since: 0.6.6
 */
/**
 * TpfPersonaStore:
 * 
 * A persona store which is associated with a single Telepathy account. It will create <link linkend="TpfPersona"><type>TpfPersona</type></link>s for each of the contacts in the account&apos;s contact list.
 * 
 * <para>User must define contact features it wants on the #TpSimpleClientFactory of the default #TpAccountManager returned by tp_account_manager_dup() *before* preparing telepathy stores. Note that this is a behaviour change since 0.7.0, folks won&apos;t force preparing any feature anymore.</para>
 */
/**
 * TpfPersonaStoreClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="TPF-TYPE-PERSONA-STORE:CAPS"><literal>TPF_TYPE_PERSONA_STORE</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
