/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Float;
import org.jpl7.Integer;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.JRef;
import org.jpl7.Query;
import org.jpl7.Rational;
import org.jpl7.Variable;
import org.jpl7.fli.DoubleHolder;
import org.jpl7.fli.Int64Holder;
import org.jpl7.fli.IntHolder;
import org.jpl7.fli.ObjectHolder;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.StringHolder;
import org.jpl7.fli.term_t;

public abstract class Term {
    protected Term() {
    }

    public Term arg(int n) {
        throw new JPLException("arg(int) is undefined for " + this.typeName() + " instances");
    }

    public Term[] args() {
        throw new JPLException("args() is undefined for " + this.typeName());
    }

    public int arity() {
        return 0;
    }

    public String atomType() {
        throw new JPLException("atomType() is undefined for " + this.typeName());
    }

    public String name() {
        throw new JPLException("name() is undefined for " + this.typeName());
    }

    public void setName(String string) {
        throw new JPLException("name() is undefined for " + this.typeName());
    }

    public static Term textToTerm(String string) {
        Query query = new Query(new Compound("atom_to_term", new Term[]{new Atom(string), new Variable("T"), new Variable("NVdict")}));
        query.open();
        if (query.hasMoreSolutions()) {
            Term[] termArray;
            Map<String, Term> map = query.nextSolution();
            for (Term term : termArray = Term.listToTermArray(map.get("NVdict"))) {
                String string2 = term.arg(1).name();
                Variable variable = (Variable)term.arg(2);
                variable.setName(string2);
            }
            query.close();
            return map.get("T");
        }
        query.close();
        return null;
    }

    public static Term textParamsToTerm(String string, Term[] termArray) {
        return Term.textToTerm(string).putParams(termArray);
    }

    public int intValue() {
        throw new JPLException("intValue() is undefined for " + this.typeName());
    }

    public long longValue() {
        throw new JPLException("longValue() is undefined for " + this.typeName());
    }

    public BigInteger bigValue() {
        throw new JPLException("bigValue() is undefined for " + this.typeName());
    }

    public double doubleValue() {
        throw new JPLException("doubleValue() is undefined for " + this.typeName());
    }

    public float floatValue() {
        throw new JPLException("floatValue() is undefined for " + this.typeName());
    }

    protected static Term getTerm(Map<term_t, Variable> map, term_t term_t2) {
        switch (Prolog.term_type(term_t2)) {
            case 1: {
                for (term_t term_t3 : map.keySet()) {
                    if (Prolog.compare(term_t3, term_t2) != 0) continue;
                    return map.get(term_t3);
                }
                Variable variable = new Variable();
                variable.term_ = term_t2;
                map.put(term_t2, variable);
                return variable;
            }
            case 2: {
                StringHolder stringHolder = new StringHolder();
                Prolog.get_atom_chars(term_t2, stringHolder);
                return new Atom(stringHolder.value, "text");
            }
            case 6: {
                StringHolder stringHolder = new StringHolder();
                Prolog.get_string_chars(term_t2, stringHolder);
                return new Atom(stringHolder.value, "string");
            }
            case 3: {
                Int64Holder int64Holder = new Int64Holder();
                if (Prolog.get_integer(term_t2, int64Holder)) {
                    return new Integer(int64Holder.value);
                }
                StringHolder stringHolder = new StringHolder();
                if (Prolog.get_integer_big(term_t2, stringHolder)) {
                    return new Integer(new BigInteger(stringHolder.value));
                }
                return new Integer(-3L);
            }
            case 4: {
                StringHolder stringHolder = new StringHolder();
                if (Prolog.get_rational(term_t2, stringHolder)) {
                    return new Rational(stringHolder.value);
                }
                return new Integer(-3L);
            }
            case 5: {
                DoubleHolder doubleHolder = new DoubleHolder();
                Prolog.get_float(term_t2, doubleHolder);
                return new Float(doubleHolder.value);
            }
            case 7: 
            case 10: {
                StringHolder stringHolder = new StringHolder();
                IntHolder intHolder = new IntHolder();
                Prolog.get_name_arity(term_t2, stringHolder, intHolder);
                Term[] termArray = new Term[intHolder.value];
                for (int i = 1; i <= intHolder.value; ++i) {
                    term_t term_t4 = Prolog.new_term_ref();
                    Prolog.get_arg(i, term_t2, term_t4);
                    termArray[i - 1] = Term.getTerm(map, term_t4);
                }
                return new Compound(stringHolder.value, termArray);
            }
            case 8: {
                return JPL.LIST_NIL;
            }
            case 9: {
                ObjectHolder objectHolder = new ObjectHolder();
                if (Prolog.get_jref_object(term_t2, objectHolder)) {
                    if (objectHolder.value == null) {
                        return JPL.JNULL;
                    }
                    return new JRef(objectHolder.value);
                }
                throw new JPLException("unsupported blob type passed from Prolog");
            }
        }
        throw new JPLException("unknown term type=" + Prolog.term_type(term_t2));
    }

    protected static Term getTerm(term_t term_t2) {
        return Term.getTerm(new HashMap<term_t, Variable>(), term_t2);
    }

    public boolean hasFunctor(String string, int n) {
        return false;
    }

    public boolean hasFunctor(long l, int n) {
        return false;
    }

    public boolean hasFunctor(BigInteger bigInteger, int n) {
        return false;
    }

    public boolean hasFunctor(double d, int n) {
        return false;
    }

    public final boolean isAtom() {
        return this instanceof Atom;
    }

    protected boolean isAtomOfNameType(String string, String string2) {
        return false;
    }

    public boolean isBig() {
        throw new JPLException("isBig() is undefined for " + this.typeName());
    }

    public boolean isBigInteger() {
        return this instanceof Integer && ((Integer)this).isBig();
    }

    public final boolean isCompound() {
        return this instanceof Compound;
    }

    public final boolean isFloat() {
        return this instanceof Float;
    }

    public final boolean isInteger() {
        return this instanceof Integer;
    }

    public boolean isJFalse() {
        return false;
    }

    public boolean isJNull() {
        return false;
    }

    public final boolean isJRef() {
        return this instanceof JRef;
    }

    public boolean isJTrue() {
        return false;
    }

    public boolean isJVoid() {
        return false;
    }

    public final boolean isVariable() {
        return this instanceof Variable;
    }

    public Object object() {
        if (this == JPL.JNULL) {
            return null;
        }
        throw new JPLException("term is neither a JRef nor a Compound representing @(null)");
    }

    @Deprecated
    public static final Term objectToJRef(Object object) {
        return JPL.newJRef(object);
    }

    protected void put(term_t term_t2) {
        this.put(new HashMap<String, term_t>(), term_t2);
    }

    protected abstract void put(Map<String, term_t> var1, term_t var2);

    public Term putParams(Term[] termArray) {
        IntHolder intHolder = new IntHolder();
        intHolder.value = 0;
        Term term = this.putParams1(intHolder, termArray);
        if (intHolder.value != termArray.length) {
            throw new JPLException("more actual params than formal");
        }
        return term;
    }

    protected Term putParams(Term term) {
        Term[] termArray = term.listToTermArray();
        return this.putParams(termArray);
    }

    protected Term putParams1(IntHolder intHolder, Term[] termArray) {
        switch (this.type()) {
            case 7: {
                return new Compound(this.name(), Term.putParams2(this.args(), intHolder, termArray));
            }
            case 2: {
                if (!this.name().equals("?")) {
                    return this;
                }
                if (intHolder.value >= termArray.length) {
                    throw new JPLException("fewer actual params than formal params");
                }
                return termArray[intHolder.value++];
            }
        }
        return this;
    }

    protected static Term[] putParams2(Term[] termArray, IntHolder intHolder, Term[] termArray2) {
        int n = termArray.length;
        Term[] termArray3 = new Term[n];
        for (int i = 0; i < n; ++i) {
            termArray3[i] = termArray[i].putParams1(intHolder, termArray2);
        }
        return termArray3;
    }

    public static void putTerm(Object object, term_t term_t2) {
        if (!(object instanceof Term)) {
            throw new JPLException("not a Term");
        }
        ((Term)object).put(term_t2);
    }

    protected static term_t putTerms(Map<String, term_t> map, Term[] termArray) {
        term_t term_t2 = Prolog.new_term_refs(termArray.length);
        long l = term_t2.value;
        for (int i = 0; i < termArray.length; ++i) {
            term_t term_t3 = new term_t();
            term_t3.value = l++;
            termArray[i].put(map, term_t3);
        }
        return term_t2;
    }

    @Deprecated
    public Object ref() {
        throw new JPLException("this Term is not a JRef");
    }

    @Deprecated
    public Object jrefToObject() {
        return this.object();
    }

    protected void getSubst(Map<String, Term> map, Map<term_t, Variable> map2) {
    }

    protected static void getSubsts(Map<String, Term> map, Map<term_t, Variable> map2, Term[] termArray) {
        for (int i = 0; i < termArray.length; ++i) {
            termArray[i].getSubst(map, map2);
        }
    }

    public static String toString(Term[] termArray) {
        Object object = "";
        for (int i = 0; i < termArray.length; ++i) {
            object = (String)object + termArray[i].toString();
            if (i == termArray.length - 1) continue;
            object = (String)object + ", ";
        }
        return object;
    }

    public abstract int type();

    public abstract String typeName();

    public boolean isListNil() {
        return false;
    }

    public boolean isListPair() {
        return false;
    }

    public final boolean isList() {
        return Term.isList(this);
    }

    public static final boolean isList(Term term) {
        return Term.listLength(term) >= 0;
    }

    public static int listLength(Term term) {
        int n = 0;
        Term term2 = term;
        while (term2.isListPair()) {
            ++n;
            term2 = term2.arg(2);
        }
        return term2.isListNil() ? n : -1;
    }

    public int listLength() {
        return Term.listLength(this);
    }

    public static Term stringArrayToList(String[] stringArray) {
        Term term = JPL.LIST_NIL;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{new Atom(stringArray[i]), term});
        }
        return term;
    }

    public static Term intArrayToList(int[] nArray) {
        Term term = JPL.LIST_NIL;
        for (int i = nArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{new Integer(nArray[i]), term});
        }
        return term;
    }

    public static Term intArrayArrayToList(int[][] nArray) {
        Term term = JPL.LIST_NIL;
        for (int i = nArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{Term.intArrayToList(nArray[i]), term});
        }
        return term;
    }

    public static Term termArrayToList(Term[] termArray) {
        Term term = JPL.LIST_NIL;
        for (int i = termArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{termArray[i], term});
        }
        return term;
    }

    public static String[] atomListToStringArray(Term term) {
        int n = Term.listLength(term);
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        Term term2 = term;
        while (term2.isListPair()) {
            Term term3 = term2.arg(1);
            if (!term3.isAtom()) {
                return null;
            }
            stringArray[n2++] = term3.name();
            term2 = term2.arg(2);
        }
        return term2.isListNil() ? stringArray : null;
    }

    public static Term[] listToTermArray(Term term) {
        int n = Term.listLength(term);
        if (n < 0) {
            throw new JPLException("term is not a proper list");
        }
        Term[] termArray = new Term[n];
        for (int i = 0; i < n; ++i) {
            termArray[i] = term.arg(1);
            term = term.arg(2);
        }
        return termArray;
    }

    public final Term[] listToTermArray() {
        return Term.listToTermArray(this);
    }

    @Deprecated
    public final Term[] toTermArray() {
        return this.listToTermArray();
    }
}

