/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.obr.xml;

import java.text.ParseException;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.BundleCapability;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.BundleInfo;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.core.ExportPackage;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.obr.xml.Capability;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.obr.xml.CapabilityProperty;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.osgi.util.Version;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.StringUtils;

public class CapabilityAdapter {
    public static void adapt(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String name;
        switch (name = capability.getName()) {
            case "package": {
                bundleInfo.addCapability(CapabilityAdapter.getExportPackage(bundleInfo, capability));
                break;
            }
            case "bundle": {
                break;
            }
            case "service": {
                bundleInfo.addCapability(CapabilityAdapter.getOSGiService(bundleInfo, capability));
                break;
            }
            default: {
                Message.warn("Unsupported capability '" + name + "' on the bundle '" + bundleInfo.getSymbolicName() + "'");
            }
        }
    }

    private static ExportPackage getExportPackage(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String pkgName = null;
        Version version = null;
        String uses = null;
        block10: for (CapabilityProperty property : capability.getProperties()) {
            String propName;
            switch (propName = property.getName()) {
                case "package": {
                    pkgName = property.getValue();
                    continue block10;
                }
                case "uses": {
                    uses = property.getValue();
                    continue block10;
                }
                case "version": {
                    version = new Version(property.getValue());
                    continue block10;
                }
            }
            Message.warn("Unsupported property '" + propName + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (pkgName == null) {
            throw new ParseException("No package name for the capability", 0);
        }
        ExportPackage exportPackage = new ExportPackage(pkgName, version);
        if (uses != null) {
            for (String use : StringUtils.splitToArray(uses)) {
                exportPackage.addUse(use);
            }
        }
        return exportPackage;
    }

    private static BundleCapability getOSGiService(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String name = null;
        Version version = null;
        block8: for (CapabilityProperty property : capability.getProperties()) {
            String propName;
            switch (propName = property.getName()) {
                case "service": {
                    name = property.getValue();
                    continue block8;
                }
                case "version": {
                    version = new Version(property.getValue());
                    continue block8;
                }
            }
            Message.warn("Unsupported property '" + propName + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (name == null) {
            throw new ParseException("No service name for the capability", 0);
        }
        return new BundleCapability("service", name, version);
    }
}

