# Copyright (c) Facebook, Inc. and its affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

# pyre-strict

# This file was generated by libcst.codegen.gen_matcher_classes
from abc import ABC
from dataclasses import dataclass
from typing import Callable, Sequence, Union

from typing_extensions import Literal

import libcst as cst
from libcst.matchers._decorators import call_if_inside, call_if_not_inside, leave, visit
from libcst.matchers._matcher_base import (
    AllOf,
    AtLeastN,
    AtMostN,
    BaseMatcherNode,
    DoesNotMatch,
    DoNotCare,
    DoNotCareSentinel,
    MatchIfTrue,
    MatchMetadata,
    MatchMetadataIfTrue,
    MatchRegex,
    OneOf,
    SaveMatchedNode,
    ZeroOrMore,
    ZeroOrOne,
    extract,
    extractall,
    findall,
    matches,
    replace,
)
from libcst.matchers._visitors import (
    MatchDecoratorMismatch,
    MatcherDecoratableTransformer,
    MatcherDecoratableVisitor,
)


class BaseAssignTargetExpression(ABC):
    pass


class BaseAugOp(ABC):
    pass


class BaseBinaryOp(ABC):
    pass


class BaseBooleanOp(ABC):
    pass


class BaseComp(ABC):
    pass


class BaseCompOp(ABC):
    pass


class BaseCompoundStatement(ABC):
    pass


class BaseDelTargetExpression(ABC):
    pass


class BaseDict(ABC):
    pass


class BaseDictElement(ABC):
    pass


class BaseElement(ABC):
    pass


class BaseExpression(ABC):
    pass


class BaseFormattedStringContent(ABC):
    pass


class BaseList(ABC):
    pass


class BaseMetadataProvider(ABC):
    pass


class BaseNumber(ABC):
    pass


class BaseParenthesizableWhitespace(ABC):
    pass


class BaseSet(ABC):
    pass


class BaseSimpleComp(ABC):
    pass


class BaseSlice(ABC):
    pass


class BaseSmallStatement(ABC):
    pass


class BaseStatement(ABC):
    pass


class BaseString(ABC):
    pass


class BaseSuite(ABC):
    pass


class BaseUnaryOp(ABC):
    pass


MetadataMatchType = Union[MatchMetadata, MatchMetadataIfTrue]


BaseParenthesizableWhitespaceMatchType = Union[
    "BaseParenthesizableWhitespace",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.BaseParenthesizableWhitespace], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Add(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AddAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class And(BaseBooleanOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseExpressionMatchType = Union[
    "BaseExpression",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.BaseExpression], bool]],
]
AnnotationMatchType = Union[
    "Annotation", MetadataMatchType, MatchIfTrue[Callable[[cst.Annotation], bool]]
]
BaseExpressionOrNoneMatchType = Union[
    "BaseExpression",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.BaseExpression, None]], bool]],
]
AssignEqualMatchType = Union[
    "AssignEqual", MetadataMatchType, MatchIfTrue[Callable[[cst.AssignEqual], bool]]
]
SemicolonMatchType = Union[
    "Semicolon", MetadataMatchType, MatchIfTrue[Callable[[cst.Semicolon], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AnnAssign(BaseSmallStatement, BaseMatcherNode):
    target: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    annotation: Union[
        AnnotationMatchType,
        DoNotCareSentinel,
        OneOf[AnnotationMatchType],
        AllOf[AnnotationMatchType],
    ] = DoNotCare()
    value: Union[
        BaseExpressionOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrNoneMatchType],
        AllOf[BaseExpressionOrNoneMatchType],
    ] = DoNotCare()
    equal: Union[
        AssignEqualMatchType,
        DoNotCareSentinel,
        OneOf[AssignEqualMatchType],
        AllOf[AssignEqualMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Annotation(BaseMatcherNode):
    annotation: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    whitespace_before_indicator: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_indicator: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


NameOrNoneMatchType = Union[
    "Name",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Name, None]], bool]],
]
CommaMatchType = Union[
    "Comma", MetadataMatchType, MatchIfTrue[Callable[[cst.Comma], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Arg(BaseMatcherNode):
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    keyword: Union[
        NameOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[NameOrNoneMatchType],
        AllOf[NameOrNoneMatchType],
    ] = DoNotCare()
    equal: Union[
        AssignEqualMatchType,
        DoNotCareSentinel,
        OneOf[AssignEqualMatchType],
        AllOf[AssignEqualMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    star: Union[
        Literal["", "*", "**"],
        MetadataMatchType,
        MatchIfTrue[Callable[[Literal["", "*", "**"]], bool]],
        DoNotCareSentinel,
        OneOf[
            Union[
                Literal["", "*", "**"],
                MetadataMatchType,
                MatchIfTrue[Callable[[Literal["", "*", "**"]], bool]],
            ]
        ],
        AllOf[
            Union[
                Literal["", "*", "**"],
                MetadataMatchType,
                MatchIfTrue[Callable[[Literal["", "*", "**"]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_star: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_arg: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


NameOrTupleOrListMatchType = Union[
    "Name",
    "Tuple",
    "List",
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Name, cst.Tuple, cst.List]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AsName(BaseMatcherNode):
    name: Union[
        NameOrTupleOrListMatchType,
        DoNotCareSentinel,
        OneOf[NameOrTupleOrListMatchType],
        AllOf[NameOrTupleOrListMatchType],
    ] = DoNotCare()
    whitespace_before_as: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_as: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


SimpleWhitespaceMatchType = Union[
    "SimpleWhitespace",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.SimpleWhitespace], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Assert(BaseSmallStatement, BaseMatcherNode):
    test: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    msg: Union[
        BaseExpressionOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrNoneMatchType],
        AllOf[BaseExpressionOrNoneMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    whitespace_after_assert: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


AssignTargetMatchType = Union[
    "AssignTarget", MetadataMatchType, MatchIfTrue[Callable[[cst.AssignTarget], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Assign(BaseSmallStatement, BaseMatcherNode):
    targets: Union[
        Sequence[
            Union[
                AssignTargetMatchType,
                DoNotCareSentinel,
                OneOf[AssignTargetMatchType],
                AllOf[AssignTargetMatchType],
                AtLeastN[
                    Union[
                        AssignTargetMatchType,
                        DoNotCareSentinel,
                        OneOf[AssignTargetMatchType],
                        AllOf[AssignTargetMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        AssignTargetMatchType,
                        DoNotCareSentinel,
                        OneOf[AssignTargetMatchType],
                        AllOf[AssignTargetMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.AssignTarget]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        AssignTargetMatchType,
                        OneOf[AssignTargetMatchType],
                        AllOf[AssignTargetMatchType],
                        AtLeastN[
                            Union[
                                AssignTargetMatchType,
                                OneOf[AssignTargetMatchType],
                                AllOf[AssignTargetMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                AssignTargetMatchType,
                                OneOf[AssignTargetMatchType],
                                AllOf[AssignTargetMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.AssignTarget]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        AssignTargetMatchType,
                        OneOf[AssignTargetMatchType],
                        AllOf[AssignTargetMatchType],
                        AtLeastN[
                            Union[
                                AssignTargetMatchType,
                                OneOf[AssignTargetMatchType],
                                AllOf[AssignTargetMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                AssignTargetMatchType,
                                OneOf[AssignTargetMatchType],
                                AllOf[AssignTargetMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.AssignTarget]], bool]],
            ]
        ],
    ] = DoNotCare()
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AssignEqual(BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseAssignTargetExpressionMatchType = Union[
    "BaseAssignTargetExpression",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.BaseAssignTargetExpression], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AssignTarget(BaseMatcherNode):
    target: Union[
        BaseAssignTargetExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseAssignTargetExpressionMatchType],
        AllOf[BaseAssignTargetExpressionMatchType],
    ] = DoNotCare()
    whitespace_before_equal: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_equal: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Asynchronous(BaseMatcherNode):
    whitespace_after: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


NameMatchType = Union[
    "Name", MetadataMatchType, MatchIfTrue[Callable[[cst.Name], bool]]
]
DotMatchType = Union["Dot", MetadataMatchType, MatchIfTrue[Callable[[cst.Dot], bool]]]
LeftParenMatchType = Union[
    "LeftParen", MetadataMatchType, MatchIfTrue[Callable[[cst.LeftParen], bool]]
]
RightParenMatchType = Union[
    "RightParen", MetadataMatchType, MatchIfTrue[Callable[[cst.RightParen], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Attribute(
    BaseAssignTargetExpression, BaseDelTargetExpression, BaseExpression, BaseMatcherNode
):
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    attr: Union[
        NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]
    ] = DoNotCare()
    dot: Union[
        DotMatchType, DoNotCareSentinel, OneOf[DotMatchType], AllOf[DotMatchType]
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseAugOpMatchType = Union[
    "BaseAugOp", MetadataMatchType, MatchIfTrue[Callable[[cst.BaseAugOp], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AugAssign(BaseSmallStatement, BaseMatcherNode):
    target: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    operator: Union[
        BaseAugOpMatchType,
        DoNotCareSentinel,
        OneOf[BaseAugOpMatchType],
        AllOf[BaseAugOpMatchType],
    ] = DoNotCare()
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Await(BaseExpression, BaseMatcherNode):
    expression: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_await: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseBinaryOpMatchType = Union[
    "BaseBinaryOp", MetadataMatchType, MatchIfTrue[Callable[[cst.BaseBinaryOp], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BinaryOperation(BaseExpression, BaseMatcherNode):
    left: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    operator: Union[
        BaseBinaryOpMatchType,
        DoNotCareSentinel,
        OneOf[BaseBinaryOpMatchType],
        AllOf[BaseBinaryOpMatchType],
    ] = DoNotCare()
    right: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitAnd(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitAndAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitInvert(BaseUnaryOp, BaseMatcherNode):
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitOr(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitOrAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitXor(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitXorAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseBooleanOpMatchType = Union[
    "BaseBooleanOp", MetadataMatchType, MatchIfTrue[Callable[[cst.BaseBooleanOp], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BooleanOperation(BaseExpression, BaseMatcherNode):
    left: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    operator: Union[
        BaseBooleanOpMatchType,
        DoNotCareSentinel,
        OneOf[BaseBooleanOpMatchType],
        AllOf[BaseBooleanOpMatchType],
    ] = DoNotCare()
    right: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Break(BaseSmallStatement, BaseMatcherNode):
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


ArgMatchType = Union["Arg", MetadataMatchType, MatchIfTrue[Callable[[cst.Arg], bool]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Call(BaseExpression, BaseMatcherNode):
    func: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    args: Union[
        Sequence[
            Union[
                ArgMatchType,
                DoNotCareSentinel,
                OneOf[ArgMatchType],
                AllOf[ArgMatchType],
                AtLeastN[
                    Union[
                        ArgMatchType,
                        DoNotCareSentinel,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        ArgMatchType,
                        DoNotCareSentinel,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.Arg]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        ArgMatchType,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                        AtLeastN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                        AtMostN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Arg]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        ArgMatchType,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                        AtLeastN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                        AtMostN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Arg]], bool]],
            ]
        ],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_func: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_args: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseSuiteMatchType = Union[
    "BaseSuite", MetadataMatchType, MatchIfTrue[Callable[[cst.BaseSuite], bool]]
]
DecoratorMatchType = Union[
    "Decorator", MetadataMatchType, MatchIfTrue[Callable[[cst.Decorator], bool]]
]
EmptyLineMatchType = Union[
    "EmptyLine", MetadataMatchType, MatchIfTrue[Callable[[cst.EmptyLine], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ClassDef(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    name: Union[
        NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]
    ] = DoNotCare()
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    bases: Union[
        Sequence[
            Union[
                ArgMatchType,
                DoNotCareSentinel,
                OneOf[ArgMatchType],
                AllOf[ArgMatchType],
                AtLeastN[
                    Union[
                        ArgMatchType,
                        DoNotCareSentinel,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        ArgMatchType,
                        DoNotCareSentinel,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.Arg]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        ArgMatchType,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                        AtLeastN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                        AtMostN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Arg]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        ArgMatchType,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                        AtLeastN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                        AtMostN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Arg]], bool]],
            ]
        ],
    ] = DoNotCare()
    keywords: Union[
        Sequence[
            Union[
                ArgMatchType,
                DoNotCareSentinel,
                OneOf[ArgMatchType],
                AllOf[ArgMatchType],
                AtLeastN[
                    Union[
                        ArgMatchType,
                        DoNotCareSentinel,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        ArgMatchType,
                        DoNotCareSentinel,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.Arg]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        ArgMatchType,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                        AtLeastN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                        AtMostN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Arg]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        ArgMatchType,
                        OneOf[ArgMatchType],
                        AllOf[ArgMatchType],
                        AtLeastN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                        AtMostN[
                            Union[
                                ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Arg]], bool]],
            ]
        ],
    ] = DoNotCare()
    decorators: Union[
        Sequence[
            Union[
                DecoratorMatchType,
                DoNotCareSentinel,
                OneOf[DecoratorMatchType],
                AllOf[DecoratorMatchType],
                AtLeastN[
                    Union[
                        DecoratorMatchType,
                        DoNotCareSentinel,
                        OneOf[DecoratorMatchType],
                        AllOf[DecoratorMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        DecoratorMatchType,
                        DoNotCareSentinel,
                        OneOf[DecoratorMatchType],
                        AllOf[DecoratorMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.Decorator]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        DecoratorMatchType,
                        OneOf[DecoratorMatchType],
                        AllOf[DecoratorMatchType],
                        AtLeastN[
                            Union[
                                DecoratorMatchType,
                                OneOf[DecoratorMatchType],
                                AllOf[DecoratorMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                DecoratorMatchType,
                                OneOf[DecoratorMatchType],
                                AllOf[DecoratorMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Decorator]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        DecoratorMatchType,
                        OneOf[DecoratorMatchType],
                        AllOf[DecoratorMatchType],
                        AtLeastN[
                            Union[
                                DecoratorMatchType,
                                OneOf[DecoratorMatchType],
                                AllOf[DecoratorMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                DecoratorMatchType,
                                OneOf[DecoratorMatchType],
                                AllOf[DecoratorMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Decorator]], bool]],
            ]
        ],
    ] = DoNotCare()
    lpar: Union[
        LeftParenMatchType,
        DoNotCareSentinel,
        OneOf[LeftParenMatchType],
        AllOf[LeftParenMatchType],
    ] = DoNotCare()
    rpar: Union[
        RightParenMatchType,
        DoNotCareSentinel,
        OneOf[RightParenMatchType],
        AllOf[RightParenMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    lines_after_decorators: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_class: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_name: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Colon(BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Comma(BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


strMatchType = Union[str, MetadataMatchType, MatchIfTrue[Callable[[str], bool]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Comment(BaseMatcherNode):
    value: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


CompIfMatchType = Union[
    "CompIf", MetadataMatchType, MatchIfTrue[Callable[[cst.CompIf], bool]]
]
CompForOrNoneMatchType = Union[
    "CompFor",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.CompFor, None]], bool]],
]
AsynchronousOrNoneMatchType = Union[
    "Asynchronous",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Asynchronous, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class CompFor(BaseMatcherNode):
    target: Union[
        BaseAssignTargetExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseAssignTargetExpressionMatchType],
        AllOf[BaseAssignTargetExpressionMatchType],
    ] = DoNotCare()
    iter: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    ifs: Union[
        Sequence[
            Union[
                CompIfMatchType,
                DoNotCareSentinel,
                OneOf[CompIfMatchType],
                AllOf[CompIfMatchType],
                AtLeastN[
                    Union[
                        CompIfMatchType,
                        DoNotCareSentinel,
                        OneOf[CompIfMatchType],
                        AllOf[CompIfMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        CompIfMatchType,
                        DoNotCareSentinel,
                        OneOf[CompIfMatchType],
                        AllOf[CompIfMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.CompIf]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        CompIfMatchType,
                        OneOf[CompIfMatchType],
                        AllOf[CompIfMatchType],
                        AtLeastN[
                            Union[
                                CompIfMatchType,
                                OneOf[CompIfMatchType],
                                AllOf[CompIfMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                CompIfMatchType,
                                OneOf[CompIfMatchType],
                                AllOf[CompIfMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.CompIf]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        CompIfMatchType,
                        OneOf[CompIfMatchType],
                        AllOf[CompIfMatchType],
                        AtLeastN[
                            Union[
                                CompIfMatchType,
                                OneOf[CompIfMatchType],
                                AllOf[CompIfMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                CompIfMatchType,
                                OneOf[CompIfMatchType],
                                AllOf[CompIfMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.CompIf]], bool]],
            ]
        ],
    ] = DoNotCare()
    inner_for_in: Union[
        CompForOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[CompForOrNoneMatchType],
        AllOf[CompForOrNoneMatchType],
    ] = DoNotCare()
    asynchronous: Union[
        AsynchronousOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AsynchronousOrNoneMatchType],
        AllOf[AsynchronousOrNoneMatchType],
    ] = DoNotCare()
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_for: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_in: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_in: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class CompIf(BaseMatcherNode):
    test: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_test: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


ComparisonTargetMatchType = Union[
    "ComparisonTarget",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.ComparisonTarget], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Comparison(BaseExpression, BaseMatcherNode):
    left: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    comparisons: Union[
        Sequence[
            Union[
                ComparisonTargetMatchType,
                DoNotCareSentinel,
                OneOf[ComparisonTargetMatchType],
                AllOf[ComparisonTargetMatchType],
                AtLeastN[
                    Union[
                        ComparisonTargetMatchType,
                        DoNotCareSentinel,
                        OneOf[ComparisonTargetMatchType],
                        AllOf[ComparisonTargetMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        ComparisonTargetMatchType,
                        DoNotCareSentinel,
                        OneOf[ComparisonTargetMatchType],
                        AllOf[ComparisonTargetMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.ComparisonTarget]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        ComparisonTargetMatchType,
                        OneOf[ComparisonTargetMatchType],
                        AllOf[ComparisonTargetMatchType],
                        AtLeastN[
                            Union[
                                ComparisonTargetMatchType,
                                OneOf[ComparisonTargetMatchType],
                                AllOf[ComparisonTargetMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ComparisonTargetMatchType,
                                OneOf[ComparisonTargetMatchType],
                                AllOf[ComparisonTargetMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.ComparisonTarget]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        ComparisonTargetMatchType,
                        OneOf[ComparisonTargetMatchType],
                        AllOf[ComparisonTargetMatchType],
                        AtLeastN[
                            Union[
                                ComparisonTargetMatchType,
                                OneOf[ComparisonTargetMatchType],
                                AllOf[ComparisonTargetMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ComparisonTargetMatchType,
                                OneOf[ComparisonTargetMatchType],
                                AllOf[ComparisonTargetMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.ComparisonTarget]], bool]],
            ]
        ],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseCompOpMatchType = Union[
    "BaseCompOp", MetadataMatchType, MatchIfTrue[Callable[[cst.BaseCompOp], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ComparisonTarget(BaseMatcherNode):
    operator: Union[
        BaseCompOpMatchType,
        DoNotCareSentinel,
        OneOf[BaseCompOpMatchType],
        AllOf[BaseCompOpMatchType],
    ] = DoNotCare()
    comparator: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


SimpleStringOrFormattedStringMatchType = Union[
    "SimpleString",
    "FormattedString",
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.SimpleString, cst.FormattedString]], bool]],
]
SimpleStringOrFormattedStringOrConcatenatedStringMatchType = Union[
    "SimpleString",
    "FormattedString",
    "ConcatenatedString",
    MetadataMatchType,
    MatchIfTrue[
        Callable[
            [Union[cst.SimpleString, cst.FormattedString, cst.ConcatenatedString]], bool
        ]
    ],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ConcatenatedString(BaseExpression, BaseString, BaseMatcherNode):
    left: Union[
        SimpleStringOrFormattedStringMatchType,
        DoNotCareSentinel,
        OneOf[SimpleStringOrFormattedStringMatchType],
        AllOf[SimpleStringOrFormattedStringMatchType],
    ] = DoNotCare()
    right: Union[
        SimpleStringOrFormattedStringOrConcatenatedStringMatchType,
        DoNotCareSentinel,
        OneOf[SimpleStringOrFormattedStringOrConcatenatedStringMatchType],
        AllOf[SimpleStringOrFormattedStringOrConcatenatedStringMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_between: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Continue(BaseSmallStatement, BaseMatcherNode):
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


NameOrAttributeOrCallMatchType = Union[
    "Name",
    "Attribute",
    "Call",
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Name, cst.Attribute, cst.Call]], bool]],
]
TrailingWhitespaceMatchType = Union[
    "TrailingWhitespace",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.TrailingWhitespace], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Decorator(BaseMatcherNode):
    decorator: Union[
        NameOrAttributeOrCallMatchType,
        DoNotCareSentinel,
        OneOf[NameOrAttributeOrCallMatchType],
        AllOf[NameOrAttributeOrCallMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_at: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    trailing_whitespace: Union[
        TrailingWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[TrailingWhitespaceMatchType],
        AllOf[TrailingWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseDelTargetExpressionMatchType = Union[
    "BaseDelTargetExpression",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.BaseDelTargetExpression], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Del(BaseSmallStatement, BaseMatcherNode):
    target: Union[
        BaseDelTargetExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseDelTargetExpressionMatchType],
        AllOf[BaseDelTargetExpressionMatchType],
    ] = DoNotCare()
    whitespace_after_del: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseDictElementMatchType = Union[
    "BaseDictElement",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.BaseDictElement], bool]],
]
LeftCurlyBraceMatchType = Union[
    "LeftCurlyBrace",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.LeftCurlyBrace], bool]],
]
RightCurlyBraceMatchType = Union[
    "RightCurlyBrace",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.RightCurlyBrace], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Dict(BaseDict, BaseExpression, BaseMatcherNode):
    elements: Union[
        Sequence[
            Union[
                BaseDictElementMatchType,
                DoNotCareSentinel,
                OneOf[BaseDictElementMatchType],
                AllOf[BaseDictElementMatchType],
                AtLeastN[
                    Union[
                        BaseDictElementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseDictElementMatchType],
                        AllOf[BaseDictElementMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        BaseDictElementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseDictElementMatchType],
                        AllOf[BaseDictElementMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.BaseDictElement]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        BaseDictElementMatchType,
                        OneOf[BaseDictElementMatchType],
                        AllOf[BaseDictElementMatchType],
                        AtLeastN[
                            Union[
                                BaseDictElementMatchType,
                                OneOf[BaseDictElementMatchType],
                                AllOf[BaseDictElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseDictElementMatchType,
                                OneOf[BaseDictElementMatchType],
                                AllOf[BaseDictElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseDictElement]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        BaseDictElementMatchType,
                        OneOf[BaseDictElementMatchType],
                        AllOf[BaseDictElementMatchType],
                        AtLeastN[
                            Union[
                                BaseDictElementMatchType,
                                OneOf[BaseDictElementMatchType],
                                AllOf[BaseDictElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseDictElementMatchType,
                                OneOf[BaseDictElementMatchType],
                                AllOf[BaseDictElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseDictElement]], bool]],
            ]
        ],
    ] = DoNotCare()
    lbrace: Union[
        LeftCurlyBraceMatchType,
        DoNotCareSentinel,
        OneOf[LeftCurlyBraceMatchType],
        AllOf[LeftCurlyBraceMatchType],
    ] = DoNotCare()
    rbrace: Union[
        RightCurlyBraceMatchType,
        DoNotCareSentinel,
        OneOf[RightCurlyBraceMatchType],
        AllOf[RightCurlyBraceMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


CompForMatchType = Union[
    "CompFor", MetadataMatchType, MatchIfTrue[Callable[[cst.CompFor], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class DictComp(BaseComp, BaseDict, BaseExpression, BaseMatcherNode):
    key: Union[
        BaseAssignTargetExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseAssignTargetExpressionMatchType],
        AllOf[BaseAssignTargetExpressionMatchType],
    ] = DoNotCare()
    value: Union[
        BaseAssignTargetExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseAssignTargetExpressionMatchType],
        AllOf[BaseAssignTargetExpressionMatchType],
    ] = DoNotCare()
    for_in: Union[
        CompForMatchType,
        DoNotCareSentinel,
        OneOf[CompForMatchType],
        AllOf[CompForMatchType],
    ] = DoNotCare()
    lbrace: Union[
        LeftCurlyBraceMatchType,
        DoNotCareSentinel,
        OneOf[LeftCurlyBraceMatchType],
        AllOf[LeftCurlyBraceMatchType],
    ] = DoNotCare()
    rbrace: Union[
        RightCurlyBraceMatchType,
        DoNotCareSentinel,
        OneOf[RightCurlyBraceMatchType],
        AllOf[RightCurlyBraceMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_colon: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class DictElement(BaseDictElement, BaseMatcherNode):
    key: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    whitespace_before_colon: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_colon: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Divide(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class DivideAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Dot(BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Element(BaseElement, BaseMatcherNode):
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Ellipsis(BaseExpression, BaseMatcherNode):
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Else(BaseMatcherNode):
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


boolMatchType = Union[bool, MetadataMatchType, MatchIfTrue[Callable[[bool], bool]]]
CommentOrNoneMatchType = Union[
    "Comment",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Comment, None]], bool]],
]
NewlineMatchType = Union[
    "Newline", MetadataMatchType, MatchIfTrue[Callable[[cst.Newline], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class EmptyLine(BaseMatcherNode):
    indent: Union[
        boolMatchType, DoNotCareSentinel, OneOf[boolMatchType], AllOf[boolMatchType]
    ] = DoNotCare()
    whitespace: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    comment: Union[
        CommentOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[CommentOrNoneMatchType],
        AllOf[CommentOrNoneMatchType],
    ] = DoNotCare()
    newline: Union[
        NewlineMatchType,
        DoNotCareSentinel,
        OneOf[NewlineMatchType],
        AllOf[NewlineMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Equal(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


AsNameOrNoneMatchType = Union[
    "AsName",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.AsName, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ExceptHandler(BaseMatcherNode):
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    type: Union[
        BaseExpressionOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrNoneMatchType],
        AllOf[BaseExpressionOrNoneMatchType],
    ] = DoNotCare()
    name: Union[
        AsNameOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AsNameOrNoneMatchType],
        AllOf[AsNameOrNoneMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_except: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Expr(BaseSmallStatement, BaseMatcherNode):
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Finally(BaseMatcherNode):
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Float(BaseExpression, BaseNumber, BaseMatcherNode):
    value: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FloorDivide(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FloorDivideAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


ElseOrNoneMatchType = Union[
    "Else",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Else, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class For(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    target: Union[
        BaseAssignTargetExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseAssignTargetExpressionMatchType],
        AllOf[BaseAssignTargetExpressionMatchType],
    ] = DoNotCare()
    iter: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    orelse: Union[
        ElseOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[ElseOrNoneMatchType],
        AllOf[ElseOrNoneMatchType],
    ] = DoNotCare()
    asynchronous: Union[
        AsynchronousOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AsynchronousOrNoneMatchType],
        AllOf[AsynchronousOrNoneMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_for: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_in: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_in: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseFormattedStringContentMatchType = Union[
    "BaseFormattedStringContent",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.BaseFormattedStringContent], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FormattedString(BaseExpression, BaseString, BaseMatcherNode):
    parts: Union[
        Sequence[
            Union[
                BaseFormattedStringContentMatchType,
                DoNotCareSentinel,
                OneOf[BaseFormattedStringContentMatchType],
                AllOf[BaseFormattedStringContentMatchType],
                AtLeastN[
                    Union[
                        BaseFormattedStringContentMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseFormattedStringContentMatchType],
                        AllOf[BaseFormattedStringContentMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        BaseFormattedStringContentMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseFormattedStringContentMatchType],
                        AllOf[BaseFormattedStringContentMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.BaseFormattedStringContent]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        BaseFormattedStringContentMatchType,
                        OneOf[BaseFormattedStringContentMatchType],
                        AllOf[BaseFormattedStringContentMatchType],
                        AtLeastN[
                            Union[
                                BaseFormattedStringContentMatchType,
                                OneOf[BaseFormattedStringContentMatchType],
                                AllOf[BaseFormattedStringContentMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseFormattedStringContentMatchType,
                                OneOf[BaseFormattedStringContentMatchType],
                                AllOf[BaseFormattedStringContentMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseFormattedStringContent]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        BaseFormattedStringContentMatchType,
                        OneOf[BaseFormattedStringContentMatchType],
                        AllOf[BaseFormattedStringContentMatchType],
                        AtLeastN[
                            Union[
                                BaseFormattedStringContentMatchType,
                                OneOf[BaseFormattedStringContentMatchType],
                                AllOf[BaseFormattedStringContentMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseFormattedStringContentMatchType,
                                OneOf[BaseFormattedStringContentMatchType],
                                AllOf[BaseFormattedStringContentMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseFormattedStringContent]], bool]],
            ]
        ],
    ] = DoNotCare()
    start: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    end: Union[
        Literal['"', "'", '"""', "'''"],
        MetadataMatchType,
        MatchIfTrue[Callable[[Literal['"', "'", '"""', "'''"]], bool]],
        DoNotCareSentinel,
        OneOf[
            Union[
                Literal['"', "'", '"""', "'''"],
                MetadataMatchType,
                MatchIfTrue[Callable[[Literal['"', "'", '"""', "'''"]], bool]],
            ]
        ],
        AllOf[
            Union[
                Literal['"', "'", '"""', "'''"],
                MetadataMatchType,
                MatchIfTrue[Callable[[Literal['"', "'", '"""', "'''"]], bool]],
            ]
        ],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


strOrNoneMatchType = Union[
    str, None, MetadataMatchType, MatchIfTrue[Callable[[Union[str, None]], bool]]
]
AssignEqualOrNoneMatchType = Union[
    "AssignEqual",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.AssignEqual, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FormattedStringExpression(BaseFormattedStringContent, BaseMatcherNode):
    expression: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    conversion: Union[
        strOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[strOrNoneMatchType],
        AllOf[strOrNoneMatchType],
    ] = DoNotCare()
    format_spec: Union[
        Union[
            Sequence[
                Union[
                    BaseFormattedStringContentMatchType,
                    DoNotCareSentinel,
                    OneOf[BaseFormattedStringContentMatchType],
                    AllOf[BaseFormattedStringContentMatchType],
                    AtLeastN[
                        Union[
                            BaseFormattedStringContentMatchType,
                            DoNotCareSentinel,
                            OneOf[BaseFormattedStringContentMatchType],
                            AllOf[BaseFormattedStringContentMatchType],
                        ]
                    ],
                    AtMostN[
                        Union[
                            BaseFormattedStringContentMatchType,
                            DoNotCareSentinel,
                            OneOf[BaseFormattedStringContentMatchType],
                            AllOf[BaseFormattedStringContentMatchType],
                        ]
                    ],
                ]
            ],
            DoNotCareSentinel,
            MatchIfTrue[Callable[[Sequence[cst.BaseFormattedStringContent]], bool]],
            OneOf[
                Union[
                    Sequence[
                        Union[
                            BaseFormattedStringContentMatchType,
                            OneOf[BaseFormattedStringContentMatchType],
                            AllOf[BaseFormattedStringContentMatchType],
                            AtLeastN[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                ]
                            ],
                            AtMostN[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                ]
                            ],
                        ]
                    ],
                    MatchIfTrue[
                        Callable[[Sequence[cst.BaseFormattedStringContent]], bool]
                    ],
                ]
            ],
            AllOf[
                Union[
                    Sequence[
                        Union[
                            BaseFormattedStringContentMatchType,
                            OneOf[BaseFormattedStringContentMatchType],
                            AllOf[BaseFormattedStringContentMatchType],
                            AtLeastN[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                ]
                            ],
                            AtMostN[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                ]
                            ],
                        ]
                    ],
                    MatchIfTrue[
                        Callable[[Sequence[cst.BaseFormattedStringContent]], bool]
                    ],
                ]
            ],
        ],
        None,
        MetadataMatchType,
        MatchIfTrue[
            Callable[
                [
                    Union[
                        Sequence[cst.BaseFormattedStringContent],
                        None,
                        OneOf[Union[Sequence[cst.BaseFormattedStringContent], None]],
                        AllOf[Union[Sequence[cst.BaseFormattedStringContent], None]],
                    ]
                ],
                bool,
            ]
        ],
        DoNotCareSentinel,
        OneOf[
            Union[
                Union[
                    Sequence[
                        Union[
                            BaseFormattedStringContentMatchType,
                            OneOf[BaseFormattedStringContentMatchType],
                            AllOf[BaseFormattedStringContentMatchType],
                            AtLeastN[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                ]
                            ],
                            AtMostN[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                ]
                            ],
                        ]
                    ],
                    MatchIfTrue[
                        Callable[[Sequence[cst.BaseFormattedStringContent]], bool]
                    ],
                    OneOf[
                        Union[
                            Sequence[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                    AtLeastN[
                                        Union[
                                            BaseFormattedStringContentMatchType,
                                            OneOf[BaseFormattedStringContentMatchType],
                                            AllOf[BaseFormattedStringContentMatchType],
                                        ]
                                    ],
                                    AtMostN[
                                        Union[
                                            BaseFormattedStringContentMatchType,
                                            OneOf[BaseFormattedStringContentMatchType],
                                            AllOf[BaseFormattedStringContentMatchType],
                                        ]
                                    ],
                                ]
                            ],
                            MatchIfTrue[
                                Callable[
                                    [Sequence[cst.BaseFormattedStringContent]], bool
                                ]
                            ],
                        ]
                    ],
                    AllOf[
                        Union[
                            Sequence[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                    AtLeastN[
                                        Union[
                                            BaseFormattedStringContentMatchType,
                                            OneOf[BaseFormattedStringContentMatchType],
                                            AllOf[BaseFormattedStringContentMatchType],
                                        ]
                                    ],
                                    AtMostN[
                                        Union[
                                            BaseFormattedStringContentMatchType,
                                            OneOf[BaseFormattedStringContentMatchType],
                                            AllOf[BaseFormattedStringContentMatchType],
                                        ]
                                    ],
                                ]
                            ],
                            MatchIfTrue[
                                Callable[
                                    [Sequence[cst.BaseFormattedStringContent]], bool
                                ]
                            ],
                        ]
                    ],
                ],
                None,
                MetadataMatchType,
                MatchIfTrue[
                    Callable[
                        [
                            Union[
                                Sequence[cst.BaseFormattedStringContent],
                                None,
                                OneOf[
                                    Union[
                                        Sequence[cst.BaseFormattedStringContent], None
                                    ]
                                ],
                                AllOf[
                                    Union[
                                        Sequence[cst.BaseFormattedStringContent], None
                                    ]
                                ],
                            ]
                        ],
                        bool,
                    ]
                ],
            ]
        ],
        AllOf[
            Union[
                Union[
                    Sequence[
                        Union[
                            BaseFormattedStringContentMatchType,
                            OneOf[BaseFormattedStringContentMatchType],
                            AllOf[BaseFormattedStringContentMatchType],
                            AtLeastN[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                ]
                            ],
                            AtMostN[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                ]
                            ],
                        ]
                    ],
                    MatchIfTrue[
                        Callable[[Sequence[cst.BaseFormattedStringContent]], bool]
                    ],
                    OneOf[
                        Union[
                            Sequence[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                    AtLeastN[
                                        Union[
                                            BaseFormattedStringContentMatchType,
                                            OneOf[BaseFormattedStringContentMatchType],
                                            AllOf[BaseFormattedStringContentMatchType],
                                        ]
                                    ],
                                    AtMostN[
                                        Union[
                                            BaseFormattedStringContentMatchType,
                                            OneOf[BaseFormattedStringContentMatchType],
                                            AllOf[BaseFormattedStringContentMatchType],
                                        ]
                                    ],
                                ]
                            ],
                            MatchIfTrue[
                                Callable[
                                    [Sequence[cst.BaseFormattedStringContent]], bool
                                ]
                            ],
                        ]
                    ],
                    AllOf[
                        Union[
                            Sequence[
                                Union[
                                    BaseFormattedStringContentMatchType,
                                    OneOf[BaseFormattedStringContentMatchType],
                                    AllOf[BaseFormattedStringContentMatchType],
                                    AtLeastN[
                                        Union[
                                            BaseFormattedStringContentMatchType,
                                            OneOf[BaseFormattedStringContentMatchType],
                                            AllOf[BaseFormattedStringContentMatchType],
                                        ]
                                    ],
                                    AtMostN[
                                        Union[
                                            BaseFormattedStringContentMatchType,
                                            OneOf[BaseFormattedStringContentMatchType],
                                            AllOf[BaseFormattedStringContentMatchType],
                                        ]
                                    ],
                                ]
                            ],
                            MatchIfTrue[
                                Callable[
                                    [Sequence[cst.BaseFormattedStringContent]], bool
                                ]
                            ],
                        ]
                    ],
                ],
                None,
                MetadataMatchType,
                MatchIfTrue[
                    Callable[
                        [
                            Union[
                                Sequence[cst.BaseFormattedStringContent],
                                None,
                                OneOf[
                                    Union[
                                        Sequence[cst.BaseFormattedStringContent], None
                                    ]
                                ],
                                AllOf[
                                    Union[
                                        Sequence[cst.BaseFormattedStringContent], None
                                    ]
                                ],
                            ]
                        ],
                        bool,
                    ]
                ],
            ]
        ],
    ] = DoNotCare()
    whitespace_before_expression: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_expression: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    equal: Union[
        AssignEqualOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AssignEqualOrNoneMatchType],
        AllOf[AssignEqualOrNoneMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FormattedStringText(BaseFormattedStringContent, BaseMatcherNode):
    value: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class From(BaseMatcherNode):
    item: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    whitespace_before_from: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_from: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


ParametersMatchType = Union[
    "Parameters", MetadataMatchType, MatchIfTrue[Callable[[cst.Parameters], bool]]
]
AnnotationOrNoneMatchType = Union[
    "Annotation",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Annotation, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FunctionDef(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    name: Union[
        NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]
    ] = DoNotCare()
    params: Union[
        ParametersMatchType,
        DoNotCareSentinel,
        OneOf[ParametersMatchType],
        AllOf[ParametersMatchType],
    ] = DoNotCare()
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    decorators: Union[
        Sequence[
            Union[
                DecoratorMatchType,
                DoNotCareSentinel,
                OneOf[DecoratorMatchType],
                AllOf[DecoratorMatchType],
                AtLeastN[
                    Union[
                        DecoratorMatchType,
                        DoNotCareSentinel,
                        OneOf[DecoratorMatchType],
                        AllOf[DecoratorMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        DecoratorMatchType,
                        DoNotCareSentinel,
                        OneOf[DecoratorMatchType],
                        AllOf[DecoratorMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.Decorator]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        DecoratorMatchType,
                        OneOf[DecoratorMatchType],
                        AllOf[DecoratorMatchType],
                        AtLeastN[
                            Union[
                                DecoratorMatchType,
                                OneOf[DecoratorMatchType],
                                AllOf[DecoratorMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                DecoratorMatchType,
                                OneOf[DecoratorMatchType],
                                AllOf[DecoratorMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Decorator]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        DecoratorMatchType,
                        OneOf[DecoratorMatchType],
                        AllOf[DecoratorMatchType],
                        AtLeastN[
                            Union[
                                DecoratorMatchType,
                                OneOf[DecoratorMatchType],
                                AllOf[DecoratorMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                DecoratorMatchType,
                                OneOf[DecoratorMatchType],
                                AllOf[DecoratorMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Decorator]], bool]],
            ]
        ],
    ] = DoNotCare()
    returns: Union[
        AnnotationOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AnnotationOrNoneMatchType],
        AllOf[AnnotationOrNoneMatchType],
    ] = DoNotCare()
    asynchronous: Union[
        AsynchronousOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AsynchronousOrNoneMatchType],
        AllOf[AsynchronousOrNoneMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    lines_after_decorators: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_def: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_name: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_params: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class GeneratorExp(BaseComp, BaseExpression, BaseSimpleComp, BaseMatcherNode):
    elt: Union[
        BaseAssignTargetExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseAssignTargetExpressionMatchType],
        AllOf[BaseAssignTargetExpressionMatchType],
    ] = DoNotCare()
    for_in: Union[
        CompForMatchType,
        DoNotCareSentinel,
        OneOf[CompForMatchType],
        AllOf[CompForMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


NameItemMatchType = Union[
    "NameItem", MetadataMatchType, MatchIfTrue[Callable[[cst.NameItem], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Global(BaseSmallStatement, BaseMatcherNode):
    names: Union[
        Sequence[
            Union[
                NameItemMatchType,
                DoNotCareSentinel,
                OneOf[NameItemMatchType],
                AllOf[NameItemMatchType],
                AtLeastN[
                    Union[
                        NameItemMatchType,
                        DoNotCareSentinel,
                        OneOf[NameItemMatchType],
                        AllOf[NameItemMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        NameItemMatchType,
                        DoNotCareSentinel,
                        OneOf[NameItemMatchType],
                        AllOf[NameItemMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.NameItem]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        NameItemMatchType,
                        OneOf[NameItemMatchType],
                        AllOf[NameItemMatchType],
                        AtLeastN[
                            Union[
                                NameItemMatchType,
                                OneOf[NameItemMatchType],
                                AllOf[NameItemMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                NameItemMatchType,
                                OneOf[NameItemMatchType],
                                AllOf[NameItemMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.NameItem]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        NameItemMatchType,
                        OneOf[NameItemMatchType],
                        AllOf[NameItemMatchType],
                        AtLeastN[
                            Union[
                                NameItemMatchType,
                                OneOf[NameItemMatchType],
                                AllOf[NameItemMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                NameItemMatchType,
                                OneOf[NameItemMatchType],
                                AllOf[NameItemMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.NameItem]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_global: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class GreaterThan(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class GreaterThanEqual(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


IfOrElseOrNoneMatchType = Union[
    "If",
    "Else",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.If, cst.Else, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class If(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    test: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    orelse: Union[
        IfOrElseOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[IfOrElseOrNoneMatchType],
        AllOf[IfOrElseOrNoneMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_before_test: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_test: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class IfExp(BaseExpression, BaseMatcherNode):
    test: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    body: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    orelse: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_before_if: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_if: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_else: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_else: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Imaginary(BaseExpression, BaseNumber, BaseMatcherNode):
    value: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


ImportAliasMatchType = Union[
    "ImportAlias", MetadataMatchType, MatchIfTrue[Callable[[cst.ImportAlias], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Import(BaseSmallStatement, BaseMatcherNode):
    names: Union[
        Sequence[
            Union[
                ImportAliasMatchType,
                DoNotCareSentinel,
                OneOf[ImportAliasMatchType],
                AllOf[ImportAliasMatchType],
                AtLeastN[
                    Union[
                        ImportAliasMatchType,
                        DoNotCareSentinel,
                        OneOf[ImportAliasMatchType],
                        AllOf[ImportAliasMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        ImportAliasMatchType,
                        DoNotCareSentinel,
                        OneOf[ImportAliasMatchType],
                        AllOf[ImportAliasMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        ImportAliasMatchType,
                        OneOf[ImportAliasMatchType],
                        AllOf[ImportAliasMatchType],
                        AtLeastN[
                            Union[
                                ImportAliasMatchType,
                                OneOf[ImportAliasMatchType],
                                AllOf[ImportAliasMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ImportAliasMatchType,
                                OneOf[ImportAliasMatchType],
                                AllOf[ImportAliasMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        ImportAliasMatchType,
                        OneOf[ImportAliasMatchType],
                        AllOf[ImportAliasMatchType],
                        AtLeastN[
                            Union[
                                ImportAliasMatchType,
                                OneOf[ImportAliasMatchType],
                                AllOf[ImportAliasMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ImportAliasMatchType,
                                OneOf[ImportAliasMatchType],
                                AllOf[ImportAliasMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
            ]
        ],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    whitespace_after_import: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


AttributeOrNameMatchType = Union[
    "Attribute",
    "Name",
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Attribute, cst.Name]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ImportAlias(BaseMatcherNode):
    name: Union[
        AttributeOrNameMatchType,
        DoNotCareSentinel,
        OneOf[AttributeOrNameMatchType],
        AllOf[AttributeOrNameMatchType],
    ] = DoNotCare()
    asname: Union[
        AsNameOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AsNameOrNoneMatchType],
        AllOf[AsNameOrNoneMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


AttributeOrNameOrNoneMatchType = Union[
    "Attribute",
    "Name",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Attribute, cst.Name, None]], bool]],
]
LeftParenOrNoneMatchType = Union[
    "LeftParen",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.LeftParen, None]], bool]],
]
RightParenOrNoneMatchType = Union[
    "RightParen",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.RightParen, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ImportFrom(BaseSmallStatement, BaseMatcherNode):
    module: Union[
        AttributeOrNameOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AttributeOrNameOrNoneMatchType],
        AllOf[AttributeOrNameOrNoneMatchType],
    ] = DoNotCare()
    names: Union[
        Union[
            Sequence[
                Union[
                    ImportAliasMatchType,
                    DoNotCareSentinel,
                    OneOf[ImportAliasMatchType],
                    AllOf[ImportAliasMatchType],
                    AtLeastN[
                        Union[
                            ImportAliasMatchType,
                            DoNotCareSentinel,
                            OneOf[ImportAliasMatchType],
                            AllOf[ImportAliasMatchType],
                        ]
                    ],
                    AtMostN[
                        Union[
                            ImportAliasMatchType,
                            DoNotCareSentinel,
                            OneOf[ImportAliasMatchType],
                            AllOf[ImportAliasMatchType],
                        ]
                    ],
                ]
            ],
            DoNotCareSentinel,
            MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
            OneOf[
                Union[
                    Sequence[
                        Union[
                            ImportAliasMatchType,
                            OneOf[ImportAliasMatchType],
                            AllOf[ImportAliasMatchType],
                            AtLeastN[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                ]
                            ],
                            AtMostN[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                ]
                            ],
                        ]
                    ],
                    MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
                ]
            ],
            AllOf[
                Union[
                    Sequence[
                        Union[
                            ImportAliasMatchType,
                            OneOf[ImportAliasMatchType],
                            AllOf[ImportAliasMatchType],
                            AtLeastN[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                ]
                            ],
                            AtMostN[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                ]
                            ],
                        ]
                    ],
                    MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
                ]
            ],
        ],
        "ImportStar",
        MetadataMatchType,
        MatchIfTrue[
            Callable[
                [
                    Union[
                        Sequence[cst.ImportAlias],
                        cst.ImportStar,
                        OneOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]],
                        AllOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]],
                    ]
                ],
                bool,
            ]
        ],
        DoNotCareSentinel,
        OneOf[
            Union[
                Union[
                    Sequence[
                        Union[
                            ImportAliasMatchType,
                            OneOf[ImportAliasMatchType],
                            AllOf[ImportAliasMatchType],
                            AtLeastN[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                ]
                            ],
                            AtMostN[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                ]
                            ],
                        ]
                    ],
                    MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
                    OneOf[
                        Union[
                            Sequence[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                    AtLeastN[
                                        Union[
                                            ImportAliasMatchType,
                                            OneOf[ImportAliasMatchType],
                                            AllOf[ImportAliasMatchType],
                                        ]
                                    ],
                                    AtMostN[
                                        Union[
                                            ImportAliasMatchType,
                                            OneOf[ImportAliasMatchType],
                                            AllOf[ImportAliasMatchType],
                                        ]
                                    ],
                                ]
                            ],
                            MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
                        ]
                    ],
                    AllOf[
                        Union[
                            Sequence[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                    AtLeastN[
                                        Union[
                                            ImportAliasMatchType,
                                            OneOf[ImportAliasMatchType],
                                            AllOf[ImportAliasMatchType],
                                        ]
                                    ],
                                    AtMostN[
                                        Union[
                                            ImportAliasMatchType,
                                            OneOf[ImportAliasMatchType],
                                            AllOf[ImportAliasMatchType],
                                        ]
                                    ],
                                ]
                            ],
                            MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
                        ]
                    ],
                ],
                "ImportStar",
                MetadataMatchType,
                MatchIfTrue[
                    Callable[
                        [
                            Union[
                                Sequence[cst.ImportAlias],
                                cst.ImportStar,
                                OneOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]],
                                AllOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]],
                            ]
                        ],
                        bool,
                    ]
                ],
            ]
        ],
        AllOf[
            Union[
                Union[
                    Sequence[
                        Union[
                            ImportAliasMatchType,
                            OneOf[ImportAliasMatchType],
                            AllOf[ImportAliasMatchType],
                            AtLeastN[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                ]
                            ],
                            AtMostN[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                ]
                            ],
                        ]
                    ],
                    MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
                    OneOf[
                        Union[
                            Sequence[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                    AtLeastN[
                                        Union[
                                            ImportAliasMatchType,
                                            OneOf[ImportAliasMatchType],
                                            AllOf[ImportAliasMatchType],
                                        ]
                                    ],
                                    AtMostN[
                                        Union[
                                            ImportAliasMatchType,
                                            OneOf[ImportAliasMatchType],
                                            AllOf[ImportAliasMatchType],
                                        ]
                                    ],
                                ]
                            ],
                            MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
                        ]
                    ],
                    AllOf[
                        Union[
                            Sequence[
                                Union[
                                    ImportAliasMatchType,
                                    OneOf[ImportAliasMatchType],
                                    AllOf[ImportAliasMatchType],
                                    AtLeastN[
                                        Union[
                                            ImportAliasMatchType,
                                            OneOf[ImportAliasMatchType],
                                            AllOf[ImportAliasMatchType],
                                        ]
                                    ],
                                    AtMostN[
                                        Union[
                                            ImportAliasMatchType,
                                            OneOf[ImportAliasMatchType],
                                            AllOf[ImportAliasMatchType],
                                        ]
                                    ],
                                ]
                            ],
                            MatchIfTrue[Callable[[Sequence[cst.ImportAlias]], bool]],
                        ]
                    ],
                ],
                "ImportStar",
                MetadataMatchType,
                MatchIfTrue[
                    Callable[
                        [
                            Union[
                                Sequence[cst.ImportAlias],
                                cst.ImportStar,
                                OneOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]],
                                AllOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]],
                            ]
                        ],
                        bool,
                    ]
                ],
            ]
        ],
    ] = DoNotCare()
    relative: Union[
        Sequence[
            Union[
                DotMatchType,
                DoNotCareSentinel,
                OneOf[DotMatchType],
                AllOf[DotMatchType],
                AtLeastN[
                    Union[
                        DotMatchType,
                        DoNotCareSentinel,
                        OneOf[DotMatchType],
                        AllOf[DotMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        DotMatchType,
                        DoNotCareSentinel,
                        OneOf[DotMatchType],
                        AllOf[DotMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.Dot]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        DotMatchType,
                        OneOf[DotMatchType],
                        AllOf[DotMatchType],
                        AtLeastN[
                            Union[
                                DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType]
                            ]
                        ],
                        AtMostN[
                            Union[
                                DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType]
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Dot]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        DotMatchType,
                        OneOf[DotMatchType],
                        AllOf[DotMatchType],
                        AtLeastN[
                            Union[
                                DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType]
                            ]
                        ],
                        AtMostN[
                            Union[
                                DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType]
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Dot]], bool]],
            ]
        ],
    ] = DoNotCare()
    lpar: Union[
        LeftParenOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[LeftParenOrNoneMatchType],
        AllOf[LeftParenOrNoneMatchType],
    ] = DoNotCare()
    rpar: Union[
        RightParenOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[RightParenOrNoneMatchType],
        AllOf[RightParenOrNoneMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    whitespace_after_from: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_import: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_import: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ImportStar(BaseMatcherNode):
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class In(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseStatementMatchType = Union[
    "BaseStatement", MetadataMatchType, MatchIfTrue[Callable[[cst.BaseStatement], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class IndentedBlock(BaseSuite, BaseMatcherNode):
    body: Union[
        Sequence[
            Union[
                BaseStatementMatchType,
                DoNotCareSentinel,
                OneOf[BaseStatementMatchType],
                AllOf[BaseStatementMatchType],
                AtLeastN[
                    Union[
                        BaseStatementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseStatementMatchType],
                        AllOf[BaseStatementMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        BaseStatementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseStatementMatchType],
                        AllOf[BaseStatementMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.BaseStatement]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        BaseStatementMatchType,
                        OneOf[BaseStatementMatchType],
                        AllOf[BaseStatementMatchType],
                        AtLeastN[
                            Union[
                                BaseStatementMatchType,
                                OneOf[BaseStatementMatchType],
                                AllOf[BaseStatementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseStatementMatchType,
                                OneOf[BaseStatementMatchType],
                                AllOf[BaseStatementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseStatement]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        BaseStatementMatchType,
                        OneOf[BaseStatementMatchType],
                        AllOf[BaseStatementMatchType],
                        AtLeastN[
                            Union[
                                BaseStatementMatchType,
                                OneOf[BaseStatementMatchType],
                                AllOf[BaseStatementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseStatementMatchType,
                                OneOf[BaseStatementMatchType],
                                AllOf[BaseStatementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseStatement]], bool]],
            ]
        ],
    ] = DoNotCare()
    header: Union[
        TrailingWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[TrailingWhitespaceMatchType],
        AllOf[TrailingWhitespaceMatchType],
    ] = DoNotCare()
    indent: Union[
        strOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[strOrNoneMatchType],
        AllOf[strOrNoneMatchType],
    ] = DoNotCare()
    footer: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Index(BaseSlice, BaseMatcherNode):
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Integer(BaseExpression, BaseNumber, BaseMatcherNode):
    value: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Is(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class IsNot(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_between: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


ColonMatchType = Union[
    "Colon", MetadataMatchType, MatchIfTrue[Callable[[cst.Colon], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Lambda(BaseExpression, BaseMatcherNode):
    params: Union[
        ParametersMatchType,
        DoNotCareSentinel,
        OneOf[ParametersMatchType],
        AllOf[ParametersMatchType],
    ] = DoNotCare()
    body: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    colon: Union[
        ColonMatchType, DoNotCareSentinel, OneOf[ColonMatchType], AllOf[ColonMatchType]
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_lambda: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftCurlyBrace(BaseMatcherNode):
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftParen(BaseMatcherNode):
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftShift(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftShiftAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftSquareBracket(BaseMatcherNode):
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LessThan(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LessThanEqual(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseElementMatchType = Union[
    "BaseElement", MetadataMatchType, MatchIfTrue[Callable[[cst.BaseElement], bool]]
]
LeftSquareBracketMatchType = Union[
    "LeftSquareBracket",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.LeftSquareBracket], bool]],
]
RightSquareBracketMatchType = Union[
    "RightSquareBracket",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.RightSquareBracket], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class List(
    BaseAssignTargetExpression,
    BaseDelTargetExpression,
    BaseExpression,
    BaseList,
    BaseMatcherNode,
):
    elements: Union[
        Sequence[
            Union[
                BaseElementMatchType,
                DoNotCareSentinel,
                OneOf[BaseElementMatchType],
                AllOf[BaseElementMatchType],
                AtLeastN[
                    Union[
                        BaseElementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        BaseElementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.BaseElement]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        BaseElementMatchType,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                        AtLeastN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseElement]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        BaseElementMatchType,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                        AtLeastN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseElement]], bool]],
            ]
        ],
    ] = DoNotCare()
    lbracket: Union[
        LeftSquareBracketMatchType,
        DoNotCareSentinel,
        OneOf[LeftSquareBracketMatchType],
        AllOf[LeftSquareBracketMatchType],
    ] = DoNotCare()
    rbracket: Union[
        RightSquareBracketMatchType,
        DoNotCareSentinel,
        OneOf[RightSquareBracketMatchType],
        AllOf[RightSquareBracketMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ListComp(BaseComp, BaseExpression, BaseList, BaseSimpleComp, BaseMatcherNode):
    elt: Union[
        BaseAssignTargetExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseAssignTargetExpressionMatchType],
        AllOf[BaseAssignTargetExpressionMatchType],
    ] = DoNotCare()
    for_in: Union[
        CompForMatchType,
        DoNotCareSentinel,
        OneOf[CompForMatchType],
        AllOf[CompForMatchType],
    ] = DoNotCare()
    lbracket: Union[
        LeftSquareBracketMatchType,
        DoNotCareSentinel,
        OneOf[LeftSquareBracketMatchType],
        AllOf[LeftSquareBracketMatchType],
    ] = DoNotCare()
    rbracket: Union[
        RightSquareBracketMatchType,
        DoNotCareSentinel,
        OneOf[RightSquareBracketMatchType],
        AllOf[RightSquareBracketMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatrixMultiply(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatrixMultiplyAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Minus(BaseUnaryOp, BaseMatcherNode):
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


SimpleStatementLineOrBaseCompoundStatementMatchType = Union[
    "SimpleStatementLine",
    "BaseCompoundStatement",
    MetadataMatchType,
    MatchIfTrue[
        Callable[[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement]], bool]
    ],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Module(BaseMatcherNode):
    body: Union[
        Sequence[
            Union[
                SimpleStatementLineOrBaseCompoundStatementMatchType,
                DoNotCareSentinel,
                OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                AtLeastN[
                    Union[
                        SimpleStatementLineOrBaseCompoundStatementMatchType,
                        DoNotCareSentinel,
                        OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                        AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        SimpleStatementLineOrBaseCompoundStatementMatchType,
                        DoNotCareSentinel,
                        OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                        AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[
            Callable[
                [
                    Sequence[
                        Union[
                            cst.SimpleStatementLine,
                            cst.BaseCompoundStatement,
                            OneOf[
                                Union[
                                    cst.SimpleStatementLine, cst.BaseCompoundStatement
                                ]
                            ],
                            AllOf[
                                Union[
                                    cst.SimpleStatementLine, cst.BaseCompoundStatement
                                ]
                            ],
                        ]
                    ]
                ],
                bool,
            ]
        ],
        OneOf[
            Union[
                Sequence[
                    Union[
                        SimpleStatementLineOrBaseCompoundStatementMatchType,
                        OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                        AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                        AtLeastN[
                            Union[
                                SimpleStatementLineOrBaseCompoundStatementMatchType,
                                OneOf[
                                    SimpleStatementLineOrBaseCompoundStatementMatchType
                                ],
                                AllOf[
                                    SimpleStatementLineOrBaseCompoundStatementMatchType
                                ],
                            ]
                        ],
                        AtMostN[
                            Union[
                                SimpleStatementLineOrBaseCompoundStatementMatchType,
                                OneOf[
                                    SimpleStatementLineOrBaseCompoundStatementMatchType
                                ],
                                AllOf[
                                    SimpleStatementLineOrBaseCompoundStatementMatchType
                                ],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[
                    Callable[
                        [
                            Sequence[
                                Union[
                                    cst.SimpleStatementLine,
                                    cst.BaseCompoundStatement,
                                    OneOf[
                                        Union[
                                            cst.SimpleStatementLine,
                                            cst.BaseCompoundStatement,
                                        ]
                                    ],
                                    AllOf[
                                        Union[
                                            cst.SimpleStatementLine,
                                            cst.BaseCompoundStatement,
                                        ]
                                    ],
                                ]
                            ]
                        ],
                        bool,
                    ]
                ],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        SimpleStatementLineOrBaseCompoundStatementMatchType,
                        OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                        AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType],
                        AtLeastN[
                            Union[
                                SimpleStatementLineOrBaseCompoundStatementMatchType,
                                OneOf[
                                    SimpleStatementLineOrBaseCompoundStatementMatchType
                                ],
                                AllOf[
                                    SimpleStatementLineOrBaseCompoundStatementMatchType
                                ],
                            ]
                        ],
                        AtMostN[
                            Union[
                                SimpleStatementLineOrBaseCompoundStatementMatchType,
                                OneOf[
                                    SimpleStatementLineOrBaseCompoundStatementMatchType
                                ],
                                AllOf[
                                    SimpleStatementLineOrBaseCompoundStatementMatchType
                                ],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[
                    Callable[
                        [
                            Sequence[
                                Union[
                                    cst.SimpleStatementLine,
                                    cst.BaseCompoundStatement,
                                    OneOf[
                                        Union[
                                            cst.SimpleStatementLine,
                                            cst.BaseCompoundStatement,
                                        ]
                                    ],
                                    AllOf[
                                        Union[
                                            cst.SimpleStatementLine,
                                            cst.BaseCompoundStatement,
                                        ]
                                    ],
                                ]
                            ]
                        ],
                        bool,
                    ]
                ],
            ]
        ],
    ] = DoNotCare()
    header: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    footer: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    encoding: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    default_indent: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    default_newline: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    has_trailing_newline: Union[
        boolMatchType, DoNotCareSentinel, OneOf[boolMatchType], AllOf[boolMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Modulo(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ModuloAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Multiply(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MultiplyAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Name(
    BaseAssignTargetExpression, BaseDelTargetExpression, BaseExpression, BaseMatcherNode
):
    value: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class NameItem(BaseMatcherNode):
    name: Union[
        NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class NamedExpr(BaseExpression, BaseMatcherNode):
    target: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_before_walrus: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_walrus: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Newline(BaseMatcherNode):
    value: Union[
        strOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[strOrNoneMatchType],
        AllOf[strOrNoneMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Nonlocal(BaseSmallStatement, BaseMatcherNode):
    names: Union[
        Sequence[
            Union[
                NameItemMatchType,
                DoNotCareSentinel,
                OneOf[NameItemMatchType],
                AllOf[NameItemMatchType],
                AtLeastN[
                    Union[
                        NameItemMatchType,
                        DoNotCareSentinel,
                        OneOf[NameItemMatchType],
                        AllOf[NameItemMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        NameItemMatchType,
                        DoNotCareSentinel,
                        OneOf[NameItemMatchType],
                        AllOf[NameItemMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.NameItem]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        NameItemMatchType,
                        OneOf[NameItemMatchType],
                        AllOf[NameItemMatchType],
                        AtLeastN[
                            Union[
                                NameItemMatchType,
                                OneOf[NameItemMatchType],
                                AllOf[NameItemMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                NameItemMatchType,
                                OneOf[NameItemMatchType],
                                AllOf[NameItemMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.NameItem]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        NameItemMatchType,
                        OneOf[NameItemMatchType],
                        AllOf[NameItemMatchType],
                        AtLeastN[
                            Union[
                                NameItemMatchType,
                                OneOf[NameItemMatchType],
                                AllOf[NameItemMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                NameItemMatchType,
                                OneOf[NameItemMatchType],
                                AllOf[NameItemMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.NameItem]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_nonlocal: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Not(BaseUnaryOp, BaseMatcherNode):
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class NotEqual(BaseCompOp, BaseMatcherNode):
    value: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class NotIn(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_between: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Or(BaseBooleanOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Param(BaseMatcherNode):
    name: Union[
        NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]
    ] = DoNotCare()
    annotation: Union[
        AnnotationOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AnnotationOrNoneMatchType],
        AllOf[AnnotationOrNoneMatchType],
    ] = DoNotCare()
    equal: Union[
        AssignEqualMatchType,
        DoNotCareSentinel,
        OneOf[AssignEqualMatchType],
        AllOf[AssignEqualMatchType],
    ] = DoNotCare()
    default: Union[
        BaseExpressionOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrNoneMatchType],
        AllOf[BaseExpressionOrNoneMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    star: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    whitespace_after_star: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after_param: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ParamSlash(BaseMatcherNode):
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ParamStar(BaseMatcherNode):
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


ParamMatchType = Union[
    "Param", MetadataMatchType, MatchIfTrue[Callable[[cst.Param], bool]]
]
ParamOrParamStarMatchType = Union[
    "Param",
    "ParamStar",
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Param, cst.ParamStar]], bool]],
]
ParamOrNoneMatchType = Union[
    "Param",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Param, None]], bool]],
]
ParamSlashMatchType = Union[
    "ParamSlash", MetadataMatchType, MatchIfTrue[Callable[[cst.ParamSlash], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Parameters(BaseMatcherNode):
    params: Union[
        Sequence[
            Union[
                ParamMatchType,
                DoNotCareSentinel,
                OneOf[ParamMatchType],
                AllOf[ParamMatchType],
                AtLeastN[
                    Union[
                        ParamMatchType,
                        DoNotCareSentinel,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        ParamMatchType,
                        DoNotCareSentinel,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.Param]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        ParamMatchType,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                        AtLeastN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Param]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        ParamMatchType,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                        AtLeastN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Param]], bool]],
            ]
        ],
    ] = DoNotCare()
    star_arg: Union[
        ParamOrParamStarMatchType,
        DoNotCareSentinel,
        OneOf[ParamOrParamStarMatchType],
        AllOf[ParamOrParamStarMatchType],
    ] = DoNotCare()
    kwonly_params: Union[
        Sequence[
            Union[
                ParamMatchType,
                DoNotCareSentinel,
                OneOf[ParamMatchType],
                AllOf[ParamMatchType],
                AtLeastN[
                    Union[
                        ParamMatchType,
                        DoNotCareSentinel,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        ParamMatchType,
                        DoNotCareSentinel,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.Param]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        ParamMatchType,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                        AtLeastN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Param]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        ParamMatchType,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                        AtLeastN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Param]], bool]],
            ]
        ],
    ] = DoNotCare()
    star_kwarg: Union[
        ParamOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[ParamOrNoneMatchType],
        AllOf[ParamOrNoneMatchType],
    ] = DoNotCare()
    posonly_params: Union[
        Sequence[
            Union[
                ParamMatchType,
                DoNotCareSentinel,
                OneOf[ParamMatchType],
                AllOf[ParamMatchType],
                AtLeastN[
                    Union[
                        ParamMatchType,
                        DoNotCareSentinel,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        ParamMatchType,
                        DoNotCareSentinel,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.Param]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        ParamMatchType,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                        AtLeastN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Param]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        ParamMatchType,
                        OneOf[ParamMatchType],
                        AllOf[ParamMatchType],
                        AtLeastN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ParamMatchType,
                                OneOf[ParamMatchType],
                                AllOf[ParamMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.Param]], bool]],
            ]
        ],
    ] = DoNotCare()
    posonly_ind: Union[
        ParamSlashMatchType,
        DoNotCareSentinel,
        OneOf[ParamSlashMatchType],
        AllOf[ParamSlashMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ParenthesizedWhitespace(BaseParenthesizableWhitespace, BaseMatcherNode):
    first_line: Union[
        TrailingWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[TrailingWhitespaceMatchType],
        AllOf[TrailingWhitespaceMatchType],
    ] = DoNotCare()
    empty_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    indent: Union[
        boolMatchType, DoNotCareSentinel, OneOf[boolMatchType], AllOf[boolMatchType]
    ] = DoNotCare()
    last_line: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Pass(BaseSmallStatement, BaseMatcherNode):
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Plus(BaseUnaryOp, BaseMatcherNode):
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Power(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class PowerAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


FromOrNoneMatchType = Union[
    "From",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.From, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Raise(BaseSmallStatement, BaseMatcherNode):
    exc: Union[
        BaseExpressionOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrNoneMatchType],
        AllOf[BaseExpressionOrNoneMatchType],
    ] = DoNotCare()
    cause: Union[
        FromOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[FromOrNoneMatchType],
        AllOf[FromOrNoneMatchType],
    ] = DoNotCare()
    whitespace_after_raise: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Return(BaseSmallStatement, BaseMatcherNode):
    value: Union[
        BaseExpressionOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrNoneMatchType],
        AllOf[BaseExpressionOrNoneMatchType],
    ] = DoNotCare()
    whitespace_after_return: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    semicolon: Union[
        SemicolonMatchType,
        DoNotCareSentinel,
        OneOf[SemicolonMatchType],
        AllOf[SemicolonMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightCurlyBrace(BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightParen(BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightShift(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightShiftAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightSquareBracket(BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Semicolon(BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Set(BaseExpression, BaseSet, BaseMatcherNode):
    elements: Union[
        Sequence[
            Union[
                BaseElementMatchType,
                DoNotCareSentinel,
                OneOf[BaseElementMatchType],
                AllOf[BaseElementMatchType],
                AtLeastN[
                    Union[
                        BaseElementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        BaseElementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.BaseElement]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        BaseElementMatchType,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                        AtLeastN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseElement]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        BaseElementMatchType,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                        AtLeastN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseElement]], bool]],
            ]
        ],
    ] = DoNotCare()
    lbrace: Union[
        LeftCurlyBraceMatchType,
        DoNotCareSentinel,
        OneOf[LeftCurlyBraceMatchType],
        AllOf[LeftCurlyBraceMatchType],
    ] = DoNotCare()
    rbrace: Union[
        RightCurlyBraceMatchType,
        DoNotCareSentinel,
        OneOf[RightCurlyBraceMatchType],
        AllOf[RightCurlyBraceMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SetComp(BaseComp, BaseExpression, BaseSet, BaseSimpleComp, BaseMatcherNode):
    elt: Union[
        BaseAssignTargetExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseAssignTargetExpressionMatchType],
        AllOf[BaseAssignTargetExpressionMatchType],
    ] = DoNotCare()
    for_in: Union[
        CompForMatchType,
        DoNotCareSentinel,
        OneOf[CompForMatchType],
        AllOf[CompForMatchType],
    ] = DoNotCare()
    lbrace: Union[
        LeftCurlyBraceMatchType,
        DoNotCareSentinel,
        OneOf[LeftCurlyBraceMatchType],
        AllOf[LeftCurlyBraceMatchType],
    ] = DoNotCare()
    rbrace: Union[
        RightCurlyBraceMatchType,
        DoNotCareSentinel,
        OneOf[RightCurlyBraceMatchType],
        AllOf[RightCurlyBraceMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseSmallStatementMatchType = Union[
    "BaseSmallStatement",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.BaseSmallStatement], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SimpleStatementLine(BaseStatement, BaseMatcherNode):
    body: Union[
        Sequence[
            Union[
                BaseSmallStatementMatchType,
                DoNotCareSentinel,
                OneOf[BaseSmallStatementMatchType],
                AllOf[BaseSmallStatementMatchType],
                AtLeastN[
                    Union[
                        BaseSmallStatementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseSmallStatementMatchType],
                        AllOf[BaseSmallStatementMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        BaseSmallStatementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseSmallStatementMatchType],
                        AllOf[BaseSmallStatementMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.BaseSmallStatement]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        BaseSmallStatementMatchType,
                        OneOf[BaseSmallStatementMatchType],
                        AllOf[BaseSmallStatementMatchType],
                        AtLeastN[
                            Union[
                                BaseSmallStatementMatchType,
                                OneOf[BaseSmallStatementMatchType],
                                AllOf[BaseSmallStatementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseSmallStatementMatchType,
                                OneOf[BaseSmallStatementMatchType],
                                AllOf[BaseSmallStatementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseSmallStatement]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        BaseSmallStatementMatchType,
                        OneOf[BaseSmallStatementMatchType],
                        AllOf[BaseSmallStatementMatchType],
                        AtLeastN[
                            Union[
                                BaseSmallStatementMatchType,
                                OneOf[BaseSmallStatementMatchType],
                                AllOf[BaseSmallStatementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseSmallStatementMatchType,
                                OneOf[BaseSmallStatementMatchType],
                                AllOf[BaseSmallStatementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseSmallStatement]], bool]],
            ]
        ],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    trailing_whitespace: Union[
        TrailingWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[TrailingWhitespaceMatchType],
        AllOf[TrailingWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SimpleStatementSuite(BaseSuite, BaseMatcherNode):
    body: Union[
        Sequence[
            Union[
                BaseSmallStatementMatchType,
                DoNotCareSentinel,
                OneOf[BaseSmallStatementMatchType],
                AllOf[BaseSmallStatementMatchType],
                AtLeastN[
                    Union[
                        BaseSmallStatementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseSmallStatementMatchType],
                        AllOf[BaseSmallStatementMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        BaseSmallStatementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseSmallStatementMatchType],
                        AllOf[BaseSmallStatementMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.BaseSmallStatement]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        BaseSmallStatementMatchType,
                        OneOf[BaseSmallStatementMatchType],
                        AllOf[BaseSmallStatementMatchType],
                        AtLeastN[
                            Union[
                                BaseSmallStatementMatchType,
                                OneOf[BaseSmallStatementMatchType],
                                AllOf[BaseSmallStatementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseSmallStatementMatchType,
                                OneOf[BaseSmallStatementMatchType],
                                AllOf[BaseSmallStatementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseSmallStatement]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        BaseSmallStatementMatchType,
                        OneOf[BaseSmallStatementMatchType],
                        AllOf[BaseSmallStatementMatchType],
                        AtLeastN[
                            Union[
                                BaseSmallStatementMatchType,
                                OneOf[BaseSmallStatementMatchType],
                                AllOf[BaseSmallStatementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseSmallStatementMatchType,
                                OneOf[BaseSmallStatementMatchType],
                                AllOf[BaseSmallStatementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseSmallStatement]], bool]],
            ]
        ],
    ] = DoNotCare()
    leading_whitespace: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    trailing_whitespace: Union[
        TrailingWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[TrailingWhitespaceMatchType],
        AllOf[TrailingWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SimpleString(BaseExpression, BaseString, BaseMatcherNode):
    value: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SimpleWhitespace(BaseParenthesizableWhitespace, BaseMatcherNode):
    value: Union[
        strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Slice(BaseSlice, BaseMatcherNode):
    lower: Union[
        BaseExpressionOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrNoneMatchType],
        AllOf[BaseExpressionOrNoneMatchType],
    ] = DoNotCare()
    upper: Union[
        BaseExpressionOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrNoneMatchType],
        AllOf[BaseExpressionOrNoneMatchType],
    ] = DoNotCare()
    step: Union[
        BaseExpressionOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrNoneMatchType],
        AllOf[BaseExpressionOrNoneMatchType],
    ] = DoNotCare()
    first_colon: Union[
        ColonMatchType, DoNotCareSentinel, OneOf[ColonMatchType], AllOf[ColonMatchType]
    ] = DoNotCare()
    second_colon: Union[
        ColonMatchType, DoNotCareSentinel, OneOf[ColonMatchType], AllOf[ColonMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class StarredDictElement(BaseDictElement, BaseMatcherNode):
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    whitespace_before_value: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class StarredElement(BaseElement, BaseMatcherNode):
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_before_value: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


SubscriptElementMatchType = Union[
    "SubscriptElement",
    MetadataMatchType,
    MatchIfTrue[Callable[[cst.SubscriptElement], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Subscript(
    BaseAssignTargetExpression, BaseDelTargetExpression, BaseExpression, BaseMatcherNode
):
    value: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    slice: Union[
        Sequence[
            Union[
                SubscriptElementMatchType,
                DoNotCareSentinel,
                OneOf[SubscriptElementMatchType],
                AllOf[SubscriptElementMatchType],
                AtLeastN[
                    Union[
                        SubscriptElementMatchType,
                        DoNotCareSentinel,
                        OneOf[SubscriptElementMatchType],
                        AllOf[SubscriptElementMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        SubscriptElementMatchType,
                        DoNotCareSentinel,
                        OneOf[SubscriptElementMatchType],
                        AllOf[SubscriptElementMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.SubscriptElement]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        SubscriptElementMatchType,
                        OneOf[SubscriptElementMatchType],
                        AllOf[SubscriptElementMatchType],
                        AtLeastN[
                            Union[
                                SubscriptElementMatchType,
                                OneOf[SubscriptElementMatchType],
                                AllOf[SubscriptElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                SubscriptElementMatchType,
                                OneOf[SubscriptElementMatchType],
                                AllOf[SubscriptElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.SubscriptElement]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        SubscriptElementMatchType,
                        OneOf[SubscriptElementMatchType],
                        AllOf[SubscriptElementMatchType],
                        AtLeastN[
                            Union[
                                SubscriptElementMatchType,
                                OneOf[SubscriptElementMatchType],
                                AllOf[SubscriptElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                SubscriptElementMatchType,
                                OneOf[SubscriptElementMatchType],
                                AllOf[SubscriptElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.SubscriptElement]], bool]],
            ]
        ],
    ] = DoNotCare()
    lbracket: Union[
        LeftSquareBracketMatchType,
        DoNotCareSentinel,
        OneOf[LeftSquareBracketMatchType],
        AllOf[LeftSquareBracketMatchType],
    ] = DoNotCare()
    rbracket: Union[
        RightSquareBracketMatchType,
        DoNotCareSentinel,
        OneOf[RightSquareBracketMatchType],
        AllOf[RightSquareBracketMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_value: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseSliceMatchType = Union[
    "BaseSlice", MetadataMatchType, MatchIfTrue[Callable[[cst.BaseSlice], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SubscriptElement(BaseMatcherNode):
    slice: Union[
        BaseSliceMatchType,
        DoNotCareSentinel,
        OneOf[BaseSliceMatchType],
        AllOf[BaseSliceMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Subtract(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SubtractAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_after: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class TrailingWhitespace(BaseMatcherNode):
    whitespace: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    comment: Union[
        CommentOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[CommentOrNoneMatchType],
        AllOf[CommentOrNoneMatchType],
    ] = DoNotCare()
    newline: Union[
        NewlineMatchType,
        DoNotCareSentinel,
        OneOf[NewlineMatchType],
        AllOf[NewlineMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


ExceptHandlerMatchType = Union[
    "ExceptHandler", MetadataMatchType, MatchIfTrue[Callable[[cst.ExceptHandler], bool]]
]
FinallyOrNoneMatchType = Union[
    "Finally",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.Finally, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Try(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    handlers: Union[
        Sequence[
            Union[
                ExceptHandlerMatchType,
                DoNotCareSentinel,
                OneOf[ExceptHandlerMatchType],
                AllOf[ExceptHandlerMatchType],
                AtLeastN[
                    Union[
                        ExceptHandlerMatchType,
                        DoNotCareSentinel,
                        OneOf[ExceptHandlerMatchType],
                        AllOf[ExceptHandlerMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        ExceptHandlerMatchType,
                        DoNotCareSentinel,
                        OneOf[ExceptHandlerMatchType],
                        AllOf[ExceptHandlerMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.ExceptHandler]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        ExceptHandlerMatchType,
                        OneOf[ExceptHandlerMatchType],
                        AllOf[ExceptHandlerMatchType],
                        AtLeastN[
                            Union[
                                ExceptHandlerMatchType,
                                OneOf[ExceptHandlerMatchType],
                                AllOf[ExceptHandlerMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ExceptHandlerMatchType,
                                OneOf[ExceptHandlerMatchType],
                                AllOf[ExceptHandlerMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.ExceptHandler]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        ExceptHandlerMatchType,
                        OneOf[ExceptHandlerMatchType],
                        AllOf[ExceptHandlerMatchType],
                        AtLeastN[
                            Union[
                                ExceptHandlerMatchType,
                                OneOf[ExceptHandlerMatchType],
                                AllOf[ExceptHandlerMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                ExceptHandlerMatchType,
                                OneOf[ExceptHandlerMatchType],
                                AllOf[ExceptHandlerMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.ExceptHandler]], bool]],
            ]
        ],
    ] = DoNotCare()
    orelse: Union[
        ElseOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[ElseOrNoneMatchType],
        AllOf[ElseOrNoneMatchType],
    ] = DoNotCare()
    finalbody: Union[
        FinallyOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[FinallyOrNoneMatchType],
        AllOf[FinallyOrNoneMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Tuple(
    BaseAssignTargetExpression, BaseDelTargetExpression, BaseExpression, BaseMatcherNode
):
    elements: Union[
        Sequence[
            Union[
                BaseElementMatchType,
                DoNotCareSentinel,
                OneOf[BaseElementMatchType],
                AllOf[BaseElementMatchType],
                AtLeastN[
                    Union[
                        BaseElementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        BaseElementMatchType,
                        DoNotCareSentinel,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.BaseElement]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        BaseElementMatchType,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                        AtLeastN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseElement]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        BaseElementMatchType,
                        OneOf[BaseElementMatchType],
                        AllOf[BaseElementMatchType],
                        AtLeastN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                BaseElementMatchType,
                                OneOf[BaseElementMatchType],
                                AllOf[BaseElementMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.BaseElement]], bool]],
            ]
        ],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseUnaryOpMatchType = Union[
    "BaseUnaryOp", MetadataMatchType, MatchIfTrue[Callable[[cst.BaseUnaryOp], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class UnaryOperation(BaseExpression, BaseMatcherNode):
    operator: Union[
        BaseUnaryOpMatchType,
        DoNotCareSentinel,
        OneOf[BaseUnaryOpMatchType],
        AllOf[BaseUnaryOpMatchType],
    ] = DoNotCare()
    expression: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class While(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    test: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    orelse: Union[
        ElseOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[ElseOrNoneMatchType],
        AllOf[ElseOrNoneMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_while: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


WithItemMatchType = Union[
    "WithItem", MetadataMatchType, MatchIfTrue[Callable[[cst.WithItem], bool]]
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class With(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    items: Union[
        Sequence[
            Union[
                WithItemMatchType,
                DoNotCareSentinel,
                OneOf[WithItemMatchType],
                AllOf[WithItemMatchType],
                AtLeastN[
                    Union[
                        WithItemMatchType,
                        DoNotCareSentinel,
                        OneOf[WithItemMatchType],
                        AllOf[WithItemMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        WithItemMatchType,
                        DoNotCareSentinel,
                        OneOf[WithItemMatchType],
                        AllOf[WithItemMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.WithItem]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        WithItemMatchType,
                        OneOf[WithItemMatchType],
                        AllOf[WithItemMatchType],
                        AtLeastN[
                            Union[
                                WithItemMatchType,
                                OneOf[WithItemMatchType],
                                AllOf[WithItemMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                WithItemMatchType,
                                OneOf[WithItemMatchType],
                                AllOf[WithItemMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.WithItem]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        WithItemMatchType,
                        OneOf[WithItemMatchType],
                        AllOf[WithItemMatchType],
                        AtLeastN[
                            Union[
                                WithItemMatchType,
                                OneOf[WithItemMatchType],
                                AllOf[WithItemMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                WithItemMatchType,
                                OneOf[WithItemMatchType],
                                AllOf[WithItemMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.WithItem]], bool]],
            ]
        ],
    ] = DoNotCare()
    body: Union[
        BaseSuiteMatchType,
        DoNotCareSentinel,
        OneOf[BaseSuiteMatchType],
        AllOf[BaseSuiteMatchType],
    ] = DoNotCare()
    asynchronous: Union[
        AsynchronousOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AsynchronousOrNoneMatchType],
        AllOf[AsynchronousOrNoneMatchType],
    ] = DoNotCare()
    leading_lines: Union[
        Sequence[
            Union[
                EmptyLineMatchType,
                DoNotCareSentinel,
                OneOf[EmptyLineMatchType],
                AllOf[EmptyLineMatchType],
                AtLeastN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        EmptyLineMatchType,
                        DoNotCareSentinel,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        EmptyLineMatchType,
                        OneOf[EmptyLineMatchType],
                        AllOf[EmptyLineMatchType],
                        AtLeastN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                EmptyLineMatchType,
                                OneOf[EmptyLineMatchType],
                                AllOf[EmptyLineMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.EmptyLine]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_with: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    whitespace_before_colon: Union[
        SimpleWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[SimpleWhitespaceMatchType],
        AllOf[SimpleWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class WithItem(BaseMatcherNode):
    item: Union[
        BaseExpressionMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionMatchType],
        AllOf[BaseExpressionMatchType],
    ] = DoNotCare()
    asname: Union[
        AsNameOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[AsNameOrNoneMatchType],
        AllOf[AsNameOrNoneMatchType],
    ] = DoNotCare()
    comma: Union[
        CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


BaseExpressionOrFromOrNoneMatchType = Union[
    "BaseExpression",
    "From",
    None,
    MetadataMatchType,
    MatchIfTrue[Callable[[Union[cst.BaseExpression, cst.From, None]], bool]],
]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Yield(BaseExpression, BaseMatcherNode):
    value: Union[
        BaseExpressionOrFromOrNoneMatchType,
        DoNotCareSentinel,
        OneOf[BaseExpressionOrFromOrNoneMatchType],
        AllOf[BaseExpressionOrFromOrNoneMatchType],
    ] = DoNotCare()
    lpar: Union[
        Sequence[
            Union[
                LeftParenMatchType,
                DoNotCareSentinel,
                OneOf[LeftParenMatchType],
                AllOf[LeftParenMatchType],
                AtLeastN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        LeftParenMatchType,
                        DoNotCareSentinel,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        LeftParenMatchType,
                        OneOf[LeftParenMatchType],
                        AllOf[LeftParenMatchType],
                        AtLeastN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                LeftParenMatchType,
                                OneOf[LeftParenMatchType],
                                AllOf[LeftParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.LeftParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    rpar: Union[
        Sequence[
            Union[
                RightParenMatchType,
                DoNotCareSentinel,
                OneOf[RightParenMatchType],
                AllOf[RightParenMatchType],
                AtLeastN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
                AtMostN[
                    Union[
                        RightParenMatchType,
                        DoNotCareSentinel,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                    ]
                ],
            ]
        ],
        DoNotCareSentinel,
        MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
        OneOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
        AllOf[
            Union[
                Sequence[
                    Union[
                        RightParenMatchType,
                        OneOf[RightParenMatchType],
                        AllOf[RightParenMatchType],
                        AtLeastN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                        AtMostN[
                            Union[
                                RightParenMatchType,
                                OneOf[RightParenMatchType],
                                AllOf[RightParenMatchType],
                            ]
                        ],
                    ]
                ],
                MatchIfTrue[Callable[[Sequence[cst.RightParen]], bool]],
            ]
        ],
    ] = DoNotCare()
    whitespace_after_yield: Union[
        BaseParenthesizableWhitespaceMatchType,
        DoNotCareSentinel,
        OneOf[BaseParenthesizableWhitespaceMatchType],
        AllOf[BaseParenthesizableWhitespaceMatchType],
    ] = DoNotCare()
    metadata: Union[
        MetadataMatchType,
        DoNotCareSentinel,
        OneOf[MetadataMatchType],
        AllOf[MetadataMatchType],
    ] = DoNotCare()


__all__ = [
    "Add",
    "AddAssign",
    "AllOf",
    "And",
    "AnnAssign",
    "Annotation",
    "Arg",
    "AsName",
    "Assert",
    "Assign",
    "AssignEqual",
    "AssignTarget",
    "Asynchronous",
    "AtLeastN",
    "AtMostN",
    "Attribute",
    "AugAssign",
    "Await",
    "BaseAssignTargetExpression",
    "BaseAugOp",
    "BaseBinaryOp",
    "BaseBooleanOp",
    "BaseComp",
    "BaseCompOp",
    "BaseCompoundStatement",
    "BaseDelTargetExpression",
    "BaseDict",
    "BaseDictElement",
    "BaseElement",
    "BaseExpression",
    "BaseFormattedStringContent",
    "BaseList",
    "BaseMatcherNode",
    "BaseMetadataProvider",
    "BaseNumber",
    "BaseParenthesizableWhitespace",
    "BaseSet",
    "BaseSimpleComp",
    "BaseSlice",
    "BaseSmallStatement",
    "BaseStatement",
    "BaseString",
    "BaseSuite",
    "BaseUnaryOp",
    "BinaryOperation",
    "BitAnd",
    "BitAndAssign",
    "BitInvert",
    "BitOr",
    "BitOrAssign",
    "BitXor",
    "BitXorAssign",
    "BooleanOperation",
    "Break",
    "Call",
    "ClassDef",
    "Colon",
    "Comma",
    "Comment",
    "CompFor",
    "CompIf",
    "Comparison",
    "ComparisonTarget",
    "ConcatenatedString",
    "Continue",
    "Decorator",
    "Del",
    "Dict",
    "DictComp",
    "DictElement",
    "Divide",
    "DivideAssign",
    "DoNotCare",
    "DoNotCareSentinel",
    "DoesNotMatch",
    "Dot",
    "Element",
    "Ellipsis",
    "Else",
    "EmptyLine",
    "Equal",
    "ExceptHandler",
    "Expr",
    "Finally",
    "Float",
    "FloorDivide",
    "FloorDivideAssign",
    "For",
    "FormattedString",
    "FormattedStringExpression",
    "FormattedStringText",
    "From",
    "FunctionDef",
    "GeneratorExp",
    "Global",
    "GreaterThan",
    "GreaterThanEqual",
    "If",
    "IfExp",
    "Imaginary",
    "Import",
    "ImportAlias",
    "ImportFrom",
    "ImportStar",
    "In",
    "IndentedBlock",
    "Index",
    "Integer",
    "Is",
    "IsNot",
    "Lambda",
    "LeftCurlyBrace",
    "LeftParen",
    "LeftShift",
    "LeftShiftAssign",
    "LeftSquareBracket",
    "LessThan",
    "LessThanEqual",
    "List",
    "ListComp",
    "MatchDecoratorMismatch",
    "MatchIfTrue",
    "MatchMetadata",
    "MatchMetadataIfTrue",
    "MatchRegex",
    "MatcherDecoratableTransformer",
    "MatcherDecoratableVisitor",
    "MatrixMultiply",
    "MatrixMultiplyAssign",
    "Minus",
    "Module",
    "Modulo",
    "ModuloAssign",
    "Multiply",
    "MultiplyAssign",
    "Name",
    "NameItem",
    "NamedExpr",
    "Newline",
    "Nonlocal",
    "Not",
    "NotEqual",
    "NotIn",
    "OneOf",
    "Or",
    "Param",
    "ParamSlash",
    "ParamStar",
    "Parameters",
    "ParenthesizedWhitespace",
    "Pass",
    "Plus",
    "Power",
    "PowerAssign",
    "Raise",
    "Return",
    "RightCurlyBrace",
    "RightParen",
    "RightShift",
    "RightShiftAssign",
    "RightSquareBracket",
    "SaveMatchedNode",
    "Semicolon",
    "Set",
    "SetComp",
    "SimpleStatementLine",
    "SimpleStatementSuite",
    "SimpleString",
    "SimpleWhitespace",
    "Slice",
    "StarredDictElement",
    "StarredElement",
    "Subscript",
    "SubscriptElement",
    "Subtract",
    "SubtractAssign",
    "TrailingWhitespace",
    "Try",
    "Tuple",
    "UnaryOperation",
    "While",
    "With",
    "WithItem",
    "Yield",
    "ZeroOrMore",
    "ZeroOrOne",
    "call_if_inside",
    "call_if_not_inside",
    "extract",
    "extractall",
    "findall",
    "leave",
    "matches",
    "replace",
    "visit",
]
