"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.rt = require("raml-typesystem");
var typeSystem = exports.rt.nominalTypes;
function getSchemaUtils() {
    return exports.rt.getSchemaUtils();
}
exports.getSchemaUtils = getSchemaUtils;
function registerAdapters(a) {
    if (a["isUnion"]) {
        a.addAdapter(new RAMLService(a));
    }
    else if (a["range"]) {
        a.addAdapter(new RAMLPropertyService(a));
    }
}
exports.TOP_LEVEL_EXTRA = exports.rt.TOP_LEVEL_EXTRA;
exports.DEFINED_IN_TYPES_EXTRA = exports.rt.DEFINED_IN_TYPES_EXTRA;
exports.USER_DEFINED_EXTRA = exports.rt.USER_DEFINED_EXTRA;
exports.SOURCE_EXTRA = exports.rt.SOURCE_EXTRA;
exports.tsInterfaces = exports.rt.tsInterfaces;
// export function instanceOfHasExtra(instance : any) : instance is rt.IHasExtra {
//     return rt.instanceOfHasExtra(instance);
// }
exports.injector = {
    inject: function (a) {
        registerAdapters(a);
    }
};
typeSystem.registerInjector(exports.injector);
var AbstractType = /** @class */ (function (_super) {
    __extends(AbstractType, _super);
    function AbstractType() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return AbstractType;
}(typeSystem.AbstractType));
exports.AbstractType = AbstractType;
var ValueType = /** @class */ (function (_super) {
    __extends(ValueType, _super);
    function ValueType() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return ValueType;
}(typeSystem.ValueType));
exports.ValueType = ValueType;
var SourceProvider = /** @class */ (function () {
    function SourceProvider() {
    }
    SourceProvider.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == SourceProvider.CLASS_IDENTIFIER)
                    return true;
            }
        }
        return false;
    };
    SourceProvider.prototype.getClassIdentifier = function () {
        var superIdentifiers = [];
        return superIdentifiers.concat(SourceProvider.CLASS_IDENTIFIER);
    };
    SourceProvider.prototype.getSource = function () {
        return null;
    };
    SourceProvider.CLASS_IDENTIFIER = "definitionSystem.SourceProvider";
    return SourceProvider;
}());
exports.SourceProvider = SourceProvider;
function isSourceProvider(object) {
    return object.getSource && typeof (object.getSource) == "function";
}
exports.isSourceProvider = isSourceProvider;
var EnumType = /** @class */ (function (_super) {
    __extends(EnumType, _super);
    function EnumType() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.values = [];
        return _this;
    }
    EnumType.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == EnumType.CLASS_IDENTIFIER)
                    return true;
            }
        }
        return false;
    };
    EnumType.prototype.getClassIdentifier = function () {
        var superIdentifiers = [];
        return superIdentifiers.concat(EnumType.CLASS_IDENTIFIER);
    };
    EnumType.CLASS_IDENTIFIER = "definitionSystem.EnumType";
    return EnumType;
}(ValueType));
exports.EnumType = EnumType;
var ReferenceType = /** @class */ (function (_super) {
    __extends(ReferenceType, _super);
    function ReferenceType(name, path, referenceTo, _universe) {
        var _this = _super.call(this, name, _universe, path) || this;
        _this.referenceTo = referenceTo;
        return _this;
    }
    ReferenceType.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == ReferenceType.CLASS_IDENTIFIER)
                    return true;
            }
        }
        return false;
    };
    ReferenceType.prototype.getClassIdentifier = function () {
        var superIdentifiers = [];
        return superIdentifiers.concat(ReferenceType.CLASS_IDENTIFIER);
    };
    ReferenceType.prototype.getReferencedType = function () {
        return this.universe().type(this.referenceTo);
    };
    ReferenceType.prototype.hasStructure = function () {
        return true;
    };
    ReferenceType.CLASS_IDENTIFIER = "definitionSystem.ReferenceType";
    return ReferenceType;
}(ValueType));
exports.ReferenceType = ReferenceType;
var NodeClass = /** @class */ (function (_super) {
    __extends(NodeClass, _super);
    function NodeClass(_name, universe, path, _description) {
        if (_description === void 0) { _description = ""; }
        return _super.call(this, _name, universe, path) || this;
    }
    NodeClass.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == NodeClass.CLASS_IDENTIFIER)
                    return true;
            }
        }
        return false;
    };
    NodeClass.prototype.getClassIdentifier = function () {
        var superIdentifiers = [];
        return superIdentifiers.concat(NodeClass.CLASS_IDENTIFIER);
    };
    NodeClass.prototype.allProperties = function (v) {
        if (v === void 0) { v = {}; }
        return _super.prototype.allProperties.call(this, v);
    };
    NodeClass.CLASS_IDENTIFIER = "definitionSystem.NodeClass";
    return NodeClass;
}(typeSystem.StructuredType));
exports.NodeClass = NodeClass;
var UserDefinedClass = /** @class */ (function (_super) {
    __extends(UserDefinedClass, _super);
    function UserDefinedClass(name, universe, hl, path, description) {
        var _this = _super.call(this, name, universe, path, description) || this;
        _this.getAdapter(RAMLService).setDeclaringNode(hl);
        return _this;
    }
    UserDefinedClass.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == UserDefinedClass.CLASS_IDENTIFIER_UserDefinedClass)
                    return true;
            }
        }
        return false;
    };
    UserDefinedClass.prototype.getClassIdentifier = function () {
        var superIdentifiers = _super.prototype.getClassIdentifier.call(this);
        return superIdentifiers.concat(UserDefinedClass.CLASS_IDENTIFIER_UserDefinedClass);
    };
    UserDefinedClass.prototype.key = function () {
        return null;
    };
    UserDefinedClass.prototype.isUserDefined = function () {
        return true;
    };
    UserDefinedClass.prototype.typeId = function () {
        var rs = this.nameId();
        var node = this.getAdapter(RAMLService).getDeclaringNode();
        if (node) {
            rs = rs + node.lowLevel().start();
            var unit = node.lowLevel().unit();
            if (unit) {
                rs = rs + unit.absolutePath();
            }
        }
        return rs;
    };
    UserDefinedClass.prototype.hasValueTypeInHierarchy = function () {
        if (this._value) {
            return true;
        }
        if (this.isAssignableFrom("ObjectTypeDeclaration")) {
            return false;
        }
        return false;
    };
    /**
     * Returns whether this type contain genuine user defined type in its hierarchy.
     * Genuine user defined type is a type user intentionally defined and filled with
     * properties or facets, or having user-defined name as opposed to a synthetic user-defined type.
     */
    UserDefinedClass.prototype.isGenuineUserDefinedType = function () {
        return this.genuineUserDefinedType() != null;
    };
    /**
     * Returns nearest genuine user-define type in the hierarchy.
     * Genuine user defined type is a type user intentionally defined and filled with
     * properties or facets, or having user-defined name as opposed to a synthetic user-defined type.
     */
    UserDefinedClass.prototype.genuineUserDefinedType = function () {
        var declaringNode = this.getAdapter(RAMLService).getDeclaringNode();
        if (!declaringNode) {
            return null;
        }
        return this;
    };
    UserDefinedClass.CLASS_IDENTIFIER_UserDefinedClass = "definitionSystem.UserDefinedClass";
    return UserDefinedClass;
}(NodeClass));
exports.UserDefinedClass = UserDefinedClass;
/**
 * Instanceof for UserDefinedClass class.
 * @param clazz
 * @returns
 */
function isUserDefinedClass(clazz) {
    var anyClazz = clazz;
    return anyClazz.genuineUserDefinedType && anyClazz.isUserDefined
        && anyClazz.isUserDefined();
}
exports.isUserDefinedClass = isUserDefinedClass;
var AnnotationType = /** @class */ (function (_super) {
    __extends(AnnotationType, _super);
    function AnnotationType() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AnnotationType.prototype.allProperties = function (ps) {
        if (ps === void 0) { ps = {}; }
        var rs = this.superTypes()[0].allProperties();
        if (rs.length == 0) {
            var node = this.getAdapter(RAMLService).getDeclaringNode();
            var up = new UserDefinedProp("value", node);
            up.withDomain(this);
            up.withCanBeValue();
            up.withRequired(false);
            var tp = this.superTypes()[0];
            rs = [];
            up.withRange(up.node().asElement().definition().universe().type("string"));
            rs.push(up);
        }
        return rs;
    };
    AnnotationType.prototype.isAnnotationType = function () {
        return true;
    };
    return AnnotationType;
}(UserDefinedClass));
exports.AnnotationType = AnnotationType;
var Universe = /** @class */ (function (_super) {
    __extends(Universe, _super);
    function Universe(dec, name, _parent, v) {
        if (name === void 0) { name = ""; }
        if (_parent === void 0) { _parent = null; }
        if (v === void 0) { v = "RAML08"; }
        var _this = _super.call(this, name) || this;
        _this._parent = _parent;
        _this._classes = [];
        _this._uversion = "RAML08";
        _this.aMap = {};
        _this.matchedObjects = dec;
        _this._uversion = v;
        return _this;
    }
    Universe.prototype.matched = function () {
        if (this.matchedObjects) {
            return this.matchedObjects;
        }
        if (this._parent) {
            return this._parent.matched();
        }
    };
    Universe.prototype.setTopLevel = function (t) {
        this._topLevel = t;
    };
    Universe.prototype.getTopLevel = function () {
        return this._topLevel;
    };
    Universe.prototype.setOriginalTopLevelText = function (t) {
        this._originalTopLevelText = t;
    };
    Universe.prototype.getOriginalTopLevelText = function () {
        return this._originalTopLevelText;
    };
    Universe.prototype.setTypedVersion = function (tv) {
        this._typedVersion = tv;
    };
    Universe.prototype.getTypedVersion = function () {
        return this._typedVersion;
    };
    Universe.prototype.version = function () {
        return this._uversion;
    };
    Universe.prototype.setUniverseVersion = function (version) {
        this._uversion = version;
    };
    Universe.prototype.types = function () {
        var result = [].concat(this._classes);
        if (this._parent != null) {
            result = result.concat(this._parent.types());
        }
        return result;
    };
    Universe.prototype.type = function (name) {
        if (this.aMap[name]) {
            return this.aMap[name];
        }
        var tp;
        for (var i = 0; i < this._classes.length; i++) {
            if (this._classes[i].nameId() == name) {
                tp = this._classes[i];
                break;
            }
        }
        if (tp == null) {
            if (this._parent) {
                var tp = this._parent.type(name);
                if (tp instanceof AbstractType) {
                    var at = tp;
                    at._universe = this; //FIXME
                }
            }
        }
        return tp;
    };
    Universe.prototype.register = function (t) {
        this._classes.push(t);
        if (t instanceof NodeClass) {
            this._classes.forEach(function (x) {
                if (x instanceof NodeClass) {
                    var nc = x;
                    if (nc.getAdapter(RAMLService).getExtendedType() == t) {
                        t.getAdapter(RAMLService).getRuntimeExtenders().push(x);
                    }
                }
            });
        }
        return this;
    };
    Universe.prototype.registerAlias = function (a, t) {
        this.aMap[a] = t;
    };
    Universe.prototype.unregister = function (t) {
        this._classes = this._classes.filter(function (x) { return x != t; });
        var st = t.superTypes();
        st.forEach(function (x) {
            var a = x;
            a._superTypes = a._superTypes.filter(function (x) { return x != t; });
        });
        st = t.subTypes();
        st.forEach(function (x) {
            var a = x;
            a._subTypes = a._subTypes.filter(function (x) { return x != t; });
        });
        return this;
    };
    Universe.prototype.registerSuperClass = function (t0, t1) {
        var a0 = t0;
        var a1 = t1;
        a0._superTypes.push(t1);
        a1._subTypes.push(t0);
    };
    return Universe;
}(typeSystem.Described));
exports.Universe = Universe;
function prop(name, desc, domain, range, custom) {
    var prop = new Property(name, desc);
    return prop.withDomain(domain, custom).withRange(range);
}
exports.prop = prop;
var ChildValueConstraint = /** @class */ (function () {
    function ChildValueConstraint(name, value) {
        this.name = name;
        this.value = value;
    }
    return ChildValueConstraint;
}());
exports.ChildValueConstraint = ChildValueConstraint;
var Property = /** @class */ (function (_super) {
    __extends(Property, _super);
    function Property() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._isFromParentValue = false;
        _this._isFromParentKey = false;
        _this._key = false;
        _this._declaresFields = false;
        _this._describes = null;
        _this._canBeDuplicator = false;
        _this._allowsNull = false;
        _this._canBeValue = false;
        _this._isInherited = false;
        _this._selfNode = false;
        _this._noDirectParse = false;
        _this._contextReq = [];
        _this.determinesChildValues = [];
        return _this;
    }
    Property.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            for (var _i = 0, _a = instance.getClassIdentifier(); _i < _a.length; _i++) {
                var currentIdentifier = _a[_i];
                if (currentIdentifier == Property.CLASS_IDENTIFIER_Property_def)
                    return true;
            }
        }
        return false;
    };
    Property.prototype.getClassIdentifier = function () {
        var superIdentifiers = _super.prototype.getClassIdentifier.call(this);
        return superIdentifiers.concat(Property.CLASS_IDENTIFIER_Property_def);
    };
    Property.prototype.isPrimitive = function () {
        return this.range().isValueType() && !(this.range() instanceof ReferenceType);
    };
    Property.prototype.withNoDirectParse = function () {
        this._noDirectParse = true;
    };
    Property.prototype.isNoDirectParse = function () {
        return this._noDirectParse;
    };
    Property.prototype.withSelfNode = function () {
        this._selfNode = true;
    };
    Property.prototype.isSelfNode = function () {
        return this._selfNode;
    };
    Property.prototype.matchKey = function (k) {
        if (this._groupName != null) {
            if (this.isAnnotation()) {
                if (k.charAt(0) == '(' && k.charAt(k.length - 1) == ')') {
                    return true;
                }
                return false;
            }
            return this._groupName == k;
        }
        else {
            return _super.prototype.matchKey.call(this, k);
        }
    };
    Property.prototype.valueDocProvider = function () {
        return this._vprovider;
    };
    Property.prototype.setValueDocProvider = function (v) {
        this._vprovider = v;
        return this;
    };
    Property.prototype.suggester = function () {
        return this._suggester;
    };
    Property.prototype.setValueSuggester = function (s) {
        this._suggester = s;
    };
    Property.prototype.enumOptions = function () {
        if (this._enumOptions && typeof this._enumOptions == 'string') {
            return [this._enumOptions + ""];
        }
        return this._enumOptions;
    };
    Property.prototype.getOftenKeys = function () {
        return this._oftenKeys;
    };
    Property.prototype.withOftenKeys = function (keys) {
        this._oftenKeys = keys;
        return this;
    };
    Property.prototype.withCanBeValue = function () {
        this._canBeValue = true;
        return this;
    };
    Property.prototype.withInherited = function (w) {
        this._isInherited = w;
    };
    Property.prototype.isInherited = function () {
        return this._isInherited;
    };
    Property.prototype.isAllowNull = function () {
        return this._allowsNull;
    };
    Property.prototype.withAllowNull = function () {
        this._allowsNull = true;
    };
    Property.prototype.getCanBeDuplicator = function () {
        return this._canBeDuplicator;
    };
    Property.prototype.canBeValue = function () {
        return this._canBeValue;
    };
    Property.prototype.setCanBeDuplicator = function () {
        this._canBeDuplicator = true;
        return true;
    };
    Property.prototype.inheritedContextValue = function () {
        return this._inheritsValueFromContext;
    };
    Property.prototype.withInheritedContextValue = function (v) {
        this._inheritsValueFromContext = v;
        return this;
    };
    Property.prototype.withContextRequirement = function (name, value) {
        this._contextReq.push({ name: name, value: value });
    };
    Property.prototype.getContextRequirements = function () {
        return this._contextReq;
    };
    Property.prototype.withDescribes = function (a) {
        this._describes = a;
        return this;
    };
    Property.prototype.describesAnnotation = function () {
        return this._describes != null;
    };
    Property.prototype.describedAnnotation = function () {
        return this._describes;
    };
    Property.prototype.isReference = function () {
        return this.range() instanceof ReferenceType;
    };
    Property.prototype.referencesTo = function () {
        return this.range().getReferencedType();
    };
    Property.prototype.newInstanceName = function () {
        if (this._newInstanceName) {
            return this._newInstanceName;
        }
        return this.range().nameId();
    };
    Property.prototype.withThisPropertyDeclaresFields = function (b) {
        if (b === void 0) { b = true; }
        this._declaresFields = b;
        return this;
    };
    Property.prototype.isThisPropertyDeclaresTypeFields = function () {
        return this._declaresFields;
    };
    Property.prototype.withNewInstanceName = function (name) {
        this._newInstanceName = name;
        return this;
    };
    Property.prototype.addChildValueConstraint = function (c) {
        this.determinesChildValues.push(c);
    };
    Property.prototype.getChildValueConstraints = function () {
        return this.determinesChildValues;
    };
    Property.prototype.childRestrictions = function () {
        return this.determinesChildValues;
    };
    Property.prototype.id = function () {
        if (this._id) {
            return this._id;
        }
        if (!this._groupName) {
            return null;
        }
        if (this.domain().getAdapter(RAMLService).getDeclaringNode()) {
            return null;
        }
        this._id = this._groupName + this.domain().nameId();
        return this._id;
    };
    Property.prototype.isAnnotation = function () {
        return this._groupName == "annotations" &&
            this.domain() && !this.domain().isUserDefined();
    };
    Property.prototype.withFromParentValue = function (v) {
        if (v === void 0) { v = true; }
        this._isFromParentValue = v;
        return this;
    };
    Property.prototype.withFromParentKey = function (v) {
        if (v === void 0) { v = true; }
        this._isFromParentKey = v;
        return this;
    };
    Property.prototype.isFromParentKey = function () {
        return this._isFromParentKey;
    };
    Property.prototype.isFromParentValue = function () {
        return this._isFromParentValue;
    };
    Property.prototype.withGroupName = function (gname) {
        this._groupName = gname;
        return this;
    };
    Property.prototype.unmerge = function () {
        this._groupName = this.nameId();
        return this;
    };
    Property.prototype.merge = function () {
        this._groupName = null;
        return this;
    };
    Property.prototype.withKey = function (isKey) {
        this._key = isKey;
        return this;
    };
    /**
     * TODO THIS STUFF SHOULD BE MORE ABSTRACT (LATER...)
     * @param keyShouldStartFrom
     * @returns {Property}
     */
    Property.prototype.isKey = function () {
        return this._key;
    };
    Property.prototype.isMerged = function () {
        return this._groupName == null;
    };
    Property.prototype.groupName = function () {
        return this._groupName;
    };
    Property.prototype.key = function () {
        //TODO implement that
        return null;
    };
    Property.CLASS_IDENTIFIER_Property_def = "definitionSystem.Property";
    return Property;
}(typeSystem.Property));
exports.Property = Property;
var UserDefinedProp = /** @class */ (function (_super) {
    __extends(UserDefinedProp, _super);
    function UserDefinedProp(name, source) {
        var _this = _super.call(this, name) || this;
        _this._node = source;
        return _this;
    }
    UserDefinedProp.isInstance = function (instance) {
        if (instance != null && instance.getClassIdentifier
            && typeof (instance.getClassIdentifier) == "function") {
            var identifiers = instance.getClassIdentifier();
            for (var i = 0; i < identifiers.length; i++) {
                if (identifiers[i] == UserDefinedProp.CLASS_IDENTIFIER)
                    return true;
            }
        }
        return false;
    };
    UserDefinedProp.prototype.getClassIdentifier = function () {
        var superIdentifiers = _super.prototype.getClassIdentifier.call(this);
        return superIdentifiers.concat(UserDefinedProp.CLASS_IDENTIFIER);
    };
    UserDefinedProp.prototype.withDisplayName = function (name) {
        this._displayName = name;
    };
    UserDefinedProp.prototype.getDisplayName = function () {
        return this._displayName;
    };
    UserDefinedProp.prototype.node = function () {
        if (!this._node && this.sourceProvider != null) {
            this._node = this.sourceProvider.getSource();
        }
        return this._node;
    };
    UserDefinedProp.prototype.setSourceProvider = function (sourceProvider) {
        this.sourceProvider = sourceProvider;
    };
    UserDefinedProp.CLASS_IDENTIFIER = "definitionSystem.UserDefinedProp";
    return UserDefinedProp;
}(Property));
exports.UserDefinedProp = UserDefinedProp;
var RAMLPropertyDocumentationService = /** @class */ (function () {
    function RAMLPropertyDocumentationService() {
    }
    RAMLPropertyDocumentationService.prototype.setDocTableName = function (val) {
        this._documentationTableName = val;
    };
    RAMLPropertyDocumentationService.prototype.docTableName = function () {
        return this._documentationTableName;
    };
    RAMLPropertyDocumentationService.prototype.setHidden = function (val) {
        this._isHidden = val;
    };
    RAMLPropertyDocumentationService.prototype.isHidden = function () {
        return this._isHidden;
    };
    RAMLPropertyDocumentationService.prototype.setMarkdownDescription = function (val) {
        this._markdownDescription = val;
    };
    RAMLPropertyDocumentationService.prototype.markdownDescription = function () {
        return this._markdownDescription;
    };
    RAMLPropertyDocumentationService.prototype.setValueDescription = function (val) {
        this._valueDescription = val;
    };
    RAMLPropertyDocumentationService.prototype.valueDescription = function () {
        return this._valueDescription;
    };
    return RAMLPropertyDocumentationService;
}());
exports.RAMLPropertyDocumentationService = RAMLPropertyDocumentationService;
var RAMLPropertyParserService = /** @class */ (function (_super) {
    __extends(RAMLPropertyParserService, _super);
    function RAMLPropertyParserService() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RAMLPropertyParserService.prototype.isSystem = function () {
        return this._isSystemProperty;
    };
    RAMLPropertyParserService.prototype.withSystem = function (s) {
        this._isSystemProperty = s;
        return this;
    };
    RAMLPropertyParserService.prototype.isEmbedMap = function () {
        return this._isEmbededMap;
    };
    RAMLPropertyParserService.prototype.withEmbedMap = function () {
        this._isEmbededMap = true;
        return this;
    };
    return RAMLPropertyParserService;
}(RAMLPropertyDocumentationService));
exports.RAMLPropertyParserService = RAMLPropertyParserService;
var RAMLPropertyService = /** @class */ (function (_super) {
    __extends(RAMLPropertyService, _super);
    function RAMLPropertyService(_property) {
        var _this = _super.call(this) || this;
        _this._property = _property;
        _this._meta = {};
        if (!_property) {
            throw new Error();
        }
        return _this;
    }
    RAMLPropertyService.prototype.valueDocProvider = function () {
        return this._property.valueDocProvider();
    };
    RAMLPropertyService.prototype.withPropertyGrammarType = function (pt) {
        this._propertyGrammarType = pt;
    };
    RAMLPropertyService.prototype.getPropertyGrammarType = function () {
        return this._propertyGrammarType;
    };
    RAMLPropertyService.prototype.id = function () {
        return this._property.nameId();
    };
    RAMLPropertyService.prototype.range = function () {
        return this._property.range();
    };
    RAMLPropertyService.prototype.domain = function () {
        return this._property.domain();
    };
    RAMLPropertyService.prototype.isAllowNull = function () {
        return this._property.isAllowNull();
    };
    RAMLPropertyService.prototype.referencesTo = function () {
        return this._property.referencesTo();
    };
    RAMLPropertyService.prototype.isReference = function () {
        return this._property.isReference();
    };
    RAMLPropertyService.prototype.nameId = function () {
        return this._property.nameId();
    };
    RAMLPropertyService.prototype.priority = function () {
        if (this.isKey())
            return 128;
        else if (this.isReference())
            return 64;
        else if (this.isTypeExpr())
            return 32;
        else if (this.nameId() == 'example')
            return 0;
        else
            return -1024;
    };
    RAMLPropertyService.prototype.isKey = function () {
        if (this._property instanceof Property) {
            return this._property.isKey();
        }
        return false;
    };
    RAMLPropertyService.prototype.isMerged = function () {
        if (this._property instanceof Property) {
            return this._property.isMerged();
        }
        return false;
    };
    RAMLPropertyService.prototype.isTypeExpr = function () {
        return this.texpr;
    };
    RAMLPropertyService.prototype.isExampleProperty = function () {
        return this.example;
    };
    RAMLPropertyService.prototype.setExample = function (e) {
        this.example = e;
    };
    RAMLPropertyService.prototype.setTypeExpression = function (e) {
        this.texpr = e;
    };
    RAMLPropertyService.prototype.isDescriminating = function () {
        return this._property.isDescriminator();
    };
    RAMLPropertyService.prototype.putMeta = function (key, value) {
        this._meta[key] = value;
    };
    RAMLPropertyService.prototype.meta = function (key) {
        return this._meta[key];
    };
    return RAMLPropertyService;
}(RAMLPropertyParserService));
exports.RAMLPropertyService = RAMLPropertyService;
var RAMLService = /** @class */ (function () {
    function RAMLService(d) {
        //!!!
        this._allowsOptionalProperties = false;
        this._possibleInterfaces = [];
        //!!!
        this._canInherit = [];
        this._declaredBy = [];
        //!!!
        this._aliases = [];
        //!!!???
        this._defining = [];
        this._runtimeExtenders = [];
        //!!!???
        this._declaresType = null;
        //!!!
        this._isTemplate = false;
        //!!!
        this._contextRequirements = [];
        this._type = d;
    }
    RAMLService.prototype.withAllowQuestion = function () {
        this._allowsOptionalProperties = true;
    };
    RAMLService.prototype.getAllowQuestion = function () {
        return this._allowsOptionalProperties;
    };
    RAMLService.prototype.withCanInherit = function (clazz) {
        this._canInherit.push(clazz);
    };
    RAMLService.prototype.getReferenceIs = function () {
        return this._referenceIs;
    };
    RAMLService.prototype.withReferenceIs = function (fname) {
        this._referenceIs = fname;
    };
    RAMLService.prototype.descriminatorValue = function () {
        if (this.valueRequirements().length == 0) {
            return this.nameId();
        }
        return this.valueRequirements()[0].value;
    };
    RAMLService.prototype.getCanInherit = function () {
        return this._canInherit;
    };
    RAMLService.prototype.withAllowAny = function () {
        this._allowsAnyChildren = true;
    };
    RAMLService.prototype.getAllowAny = function () {
        return this._allowsAnyChildren || this._type.isExternal();
    };
    RAMLService.prototype.globallyDeclaredBy = function () {
        return this._declaredBy;
    };
    RAMLService.prototype.setGloballyDeclaredBy = function (c) {
        this._declaredBy.push(c);
    };
    RAMLService.prototype.setDeclaringNode = function (n) {
        this._node = n;
    };
    RAMLService.prototype.nameId = function () {
        return this._type.nameId();
    };
    RAMLService.prototype.universe = function () {
        return this._type.universe();
    };
    RAMLService.prototype.isAssignableFrom = function (name) {
        return this._type.isAssignableFrom(name);
    };
    RAMLService.prototype.setConsumesRefs = function (b) {
        this._consumesRef = b;
    };
    RAMLService.prototype.definingPropertyIsEnough = function (v) {
        this._defining.push(v);
    };
    RAMLService.prototype.getDefining = function () {
        return this._defining;
    };
    RAMLService.prototype.getConsumesRefs = function () {
        return this._consumesRef;
    };
    RAMLService.prototype.addAlias = function (al) {
        this._aliases.push(al);
    };
    RAMLService.prototype.getAliases = function () {
        return this._aliases;
    };
    RAMLService.prototype.valueRequirements = function () {
        return this._type.valueRequirements();
    };
    RAMLService.prototype.isAnnotation = function () {
        if (this._annotationChecked) {
            return this._isAnnotation;
        }
        this._annotationChecked = true;
        this._isAnnotation = (this._type.allSuperTypes().some(function (x) { return x.key() && x.key().name == "AnnotationRef"; }));
        return this._isAnnotation;
    };
    RAMLService.prototype.allowValue = function () {
        if (this._allowsValueSet) {
            return this._allowsValue;
        }
        if (this._type.allProperties().some(function (x) { return x.isFromParentValue() || x.canBeValue(); })) {
            this._allowsValue = true;
            this._allowsValueSet = true;
            return true;
        }
        this._allowsValueSet = true;
        return false;
    };
    RAMLService.prototype.key = function () {
        return this._type.key();
    };
    RAMLService.prototype.getRepresentationOf = function () {
        return this._representationOf;
    };
    RAMLService.prototype.getPath = function () {
        return "";
    };
    RAMLService.prototype.isDeclaration = function () {
        if (this._isTemplate) {
            return true;
        }
        if (this._convertsToGlobal) {
            return true;
        }
        if (this._declaresType) {
            return true;
        }
        if (this.key() && this.key().name === "Library") {
            return true;
        }
        return false;
    };
    RAMLService.prototype.isGlobalDeclaration = function () {
        if (this._actuallyExports) {
            return true;
        }
        if (this._isTemplate) {
            return true;
        }
        if (this._declaresType) {
            return true;
        }
        return false;
    };
    RAMLService.prototype.isTypeSystemMember = function () {
        return this._declaresType != null;
    };
    RAMLService.prototype.getExtendedType = function () {
        return this.universe().type(this._declaresType);
    };
    RAMLService.prototype.setInlinedTemplates = function (b) {
        this._isTemplate = b;
        return this;
    };
    RAMLService.prototype.getRuntimeExtenders = function () {
        return this._runtimeExtenders;
    };
    RAMLService.prototype.isInlinedTemplates = function () {
        return this._isTemplate;
    };
    RAMLService.prototype.setExtendedTypeName = function (name) {
        this._declaresType = name;
        var tp = this.universe().type(name);
        if (tp instanceof NodeClass) {
            var nc = tp;
            nc.getAdapter(RAMLService)._runtimeExtenders.push(this._type);
        }
    };
    RAMLService.prototype.getKeyProp = function () {
        var c = this._type.allProperties();
        for (var i = 0; i < c.length; i++) {
            if (c[i].getAdapter(RAMLPropertyService).isKey()) {
                return c[i];
            }
        }
        return null;
    };
    RAMLService.prototype.withActuallyExports = function (pname) {
        this._actuallyExports = pname;
    };
    RAMLService.prototype.withConvertsToGlobal = function (pname) {
        this._convertsToGlobal = pname;
    };
    RAMLService.prototype.getConvertsToGlobal = function () {
        return this._convertsToGlobal;
    };
    RAMLService.prototype.getActuallyExports = function () {
        return this._actuallyExports;
    };
    RAMLService.prototype.isUserDefined = function () {
        if (this._type instanceof NodeClass) {
            return this._type.isUserDefined();
        }
        if (this._type instanceof AbstractType) {
            return this._type.isUserDefined();
        }
        return false;
    };
    RAMLService.prototype.withContextRequirement = function (name, value) {
        this._contextRequirements.push({ name: name, value: value });
    };
    RAMLService.prototype.getContextRequirements = function () {
        return this._contextRequirements;
    };
    RAMLService.prototype.findMembersDeterminer = function () {
        var c = this._type.allProperties();
        for (var i = 0; i < c.length; i++) {
            if (c[i].isThisPropertyDeclaresTypeFields()) {
                return c[i];
            }
        }
        return null;
    };
    RAMLService.prototype.getDeclaringNode = function () {
        if (this._node)
            return this._node;
        else if (this._type) {
            //if this service have no source registered,
            //checking if the type has source contributed via extras
            var sourceNode = this._type.getExtra(exports.SOURCE_EXTRA);
            if (!sourceNode)
                return null;
            if (sourceNode instanceof SourceProvider ||
                (sourceNode.getSource && typeof (sourceNode.getSource) == "function")) {
                return sourceNode.getSource();
            }
            else {
                return sourceNode;
            }
        }
        return null;
    };
    RAMLService.prototype.registerSupertypes = function (classNames) {
        var _this = this;
        var universe = this._type.universe();
        classNames.forEach(function (x) {
            var supertype = universe.type(x);
            if (!supertype) {
                return;
            }
            _this._type.addSuperType(supertype);
        });
    };
    RAMLService.prototype.registerPossibleInterfaces = function (classNames) {
        var universe = this._type.universe();
        for (var _i = 0, classNames_1 = classNames; _i < classNames_1.length; _i++) {
            var x = classNames_1[_i];
            var supertype = universe.type(x);
            if (!supertype) {
                return;
            }
            this._possibleInterfaces.push(supertype);
        }
    };
    RAMLService.prototype.possibleInterfaces = function () {
        return this._possibleInterfaces;
    };
    return RAMLService;
}());
exports.RAMLService = RAMLService;
var universes = {};
var ramlDS = require("./index");
var jsonDefinitions = ramlDS.universeDumps;
var ts2def = require("./tsStruct2Def");
var unDesc = require("./universe");
exports.universesInfo = unDesc;
exports.getUniverse = (function () {
    var x = function (key) {
        if (universes[key]) {
            return universes[key];
        }
        var src = jsonDefinitions[key];
        var universe = ts2def.toDefSystem(src, (key == "RAML08") ? unDesc["Universe08"] : unDesc["Universe10"]);
        if (universe) {
            universe.setUniverseVersion(key);
            universes[key] = universe;
        }
        return universe;
    };
    x.availableUniverses = function () { return Object.keys(jsonDefinitions); };
    return x;
})();
//# sourceMappingURL=definitionSystem.js.map