/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.MovingFunctionScript;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class MovFnPipelineAggregator
extends PipelineAggregator {
    private final DocValueFormat formatter;
    private final BucketHelpers.GapPolicy gapPolicy;
    private final Script script;
    private final String bucketsPath;
    private final int window;
    private final int shift;

    MovFnPipelineAggregator(String name, String bucketsPath, Script script, int window, int shift, DocValueFormat formatter, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, new String[]{bucketsPath}, metadata);
        this.bucketsPath = bucketsPath;
        this.script = script;
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.window = window;
        this.shift = shift;
    }

    public MovFnPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
        this.formatter = in.readNamedWriteable(DocValueFormat.class);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.bucketsPath = in.readString();
        this.window = in.readInt();
        this.shift = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readInt() : 0;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        out.writeNamedWriteable(this.formatter);
        this.gapPolicy.writeTo(out);
        out.writeString(this.bucketsPath);
        out.writeInt(this.window);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeInt(this.shift);
        }
    }

    @Override
    public String getWriteableName() {
        return "moving_fn";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)((Object)histo);
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>();
        MovingFunctionScript.Factory scriptFactory = reduceContext.scriptService().compile(this.script, MovingFunctionScript.CONTEXT);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (this.script.getParams() != null) {
            vars.putAll(this.script.getParams());
        }
        MovingFunctionScript executableScript = scriptFactory.newInstance();
        List<Double> values = buckets.stream().map(b -> BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, b, this.bucketsPaths()[0], this.gapPolicy)).filter(v -> v != null && !v.isNaN()).collect(Collectors.toList());
        int index = 0;
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            Double thisBucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)histo, bucket, this.bucketsPaths()[0], this.gapPolicy);
            MultiBucketsAggregation.Bucket newBucket = bucket;
            if (thisBucketValue != null && !thisBucketValue.isNaN()) {
                int fromIndex = this.clamp(index - this.window + this.shift, values);
                int toIndex = this.clamp(index + this.shift, values);
                double movavg = executableScript.execute(vars, values.subList(fromIndex, toIndex).stream().mapToDouble(Double::doubleValue).toArray());
                List<InternalAggregation> aggs = StreamSupport.stream(bucket.getAggregations().spliterator(), false).map(InternalAggregation.class::cast).collect(Collectors.toList());
                aggs.add(new InternalSimpleValue(this.name(), movavg, this.formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
                newBucket = factory.createBucket(factory.getKey(bucket), bucket.getDocCount(), new InternalAggregations(aggs));
                ++index;
            }
            newBuckets.add(newBucket);
        }
        return factory.createAggregation(newBuckets);
    }

    private int clamp(int index, List<Double> list) {
        if (index < 0) {
            return 0;
        }
        if (index > list.size()) {
            return list.size();
        }
        return index;
    }
}

