/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.common.event.SimpleProfilingStateAdapter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopup;
import org.netbeans.lib.profiler.ui.swing.StayOpenPopupMenu;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.actions.HeapDumpAction;
import org.netbeans.modules.profiler.actions.RunGCAction;
import org.netbeans.modules.profiler.actions.TakeThreadDumpAction;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.v2.Bundle;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerFeatures;
import org.netbeans.modules.profiler.v2.ProfilerPlugins;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.ProfilerSessions;
import org.netbeans.modules.profiler.v2.SnapshotsWindow;
import org.netbeans.modules.profiler.v2.impl.FeaturesView;
import org.netbeans.modules.profiler.v2.impl.ProfilerStatus;
import org.netbeans.modules.profiler.v2.impl.WelcomePanel;
import org.netbeans.modules.profiler.v2.ui.DropdownButton;
import org.netbeans.modules.profiler.v2.ui.ToggleButtonMenuItem;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class ProfilerWindow
extends ProfilerTopComponent {
    private final ProfilerSession session;
    private ProfilerFeatures features;
    private ProfilerPlugins plugins;
    private ProfilerToolbar toolbar;
    private ProfilerToolbar featureToolbar;
    private ProfilerToolbar applicationToolbar;
    private JPanel container;
    private FeaturesView featuresView;
    private PopupButton configure;
    private DropdownButton start;
    private JButton stop;
    private SettingsPresenter settingsButton;
    private AttachSettings attachSettings;
    private ProfilerStatus status;
    private boolean profilePopupVisible;
    private final String ID = "ProfilerWindow";
    boolean closing = false;
    private AccessibleContext accessibleContext;

    ProfilerWindow(ProfilerSession profilerSession) {
        this.session = profilerSession;
        this.updateWindowName();
        this.updateWindowIcon();
        this.createUI();
    }

    void updateSession() {
        this.updateWindowName();
        if (this.start != null) {
            this.start.setText(this.session.isAttach() ? Bundle.ProfilerWindow_attach() : Bundle.ProfilerWindow_profile());
        }
    }

    void selectFeature(ProfilerFeature profilerFeature) {
        if (this.featuresView != null) {
            this.featuresView.selectFeature(profilerFeature);
        }
    }

    private void createUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.setFocusable(false);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.add(this.toolbar.getComponent(), "North");
        final JLabel jLabel = new JLabel(Bundle.ProfilerWindow_loadingSession());
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.toolbar.add((Component)jLabel);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ProfilerWindow.this.loadSessionSettings();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerWindow.this.toolbar.remove((Component)jLabel);
                        ProfilerWindow.this.popupulateUI();
                    }
                });
            }
        });
    }

    private void loadSessionSettings() {
        this.features = this.session.getFeatures();
        this.plugins = this.session.getPlugins();
        Properties properties = new Properties();
        try {
            ProfilerStorage.loadProjectProperties((Properties)properties, (Lookup.Provider)this.session.getProject(), (String)"attach");
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (!properties.isEmpty()) {
            this.attachSettings = new AttachSettings();
            this.attachSettings.load((Map)properties);
        }
    }

    private void popupulateUI() {
        this.configure = new PopupButton(Bundle.ProfilerWindow_configure()){

            protected void displayPopup() {
                ProfilerWindow.this.displayPopupImpl();
            }
        };
        this.configure.setToolTipText(Bundle.ProfilerWindow_configureTooltip());
        if (UIUtils.isAquaLookAndFeel()) {
            this.configure.putClientProperty((Object)"JComponent.sizeVariant", (Object)"regular");
        }
        this.toolbar.add((Component)this.configure);
        String string = this.session.isAttach() ? Bundle.ProfilerWindow_attach() : Bundle.ProfilerWindow_profile();
        this.start = new DropdownButton(string, Icons.getIcon((String)"GeneralIcons.Start"), true){

            @Override
            public void displayPopup() {
                ProfilerWindow.this.displayPopupImpl();
            }

            @Override
            protected void performAction() {
                ProfilerWindow.this.performStartImpl();
            }
        };
        this.start.setToolTipText(Bundle.ProfilerWindow_profileTooltip());
        this.start.setPushedToolTipText(Bundle.ProfilerWindow_profileRunningTooltip());
        this.start.setPopupToolTipText(Bundle.ProfilerWindow_configureTooltip());
        this.toolbar.add((Component)this.start);
        this.stop = new JButton(ProfilerSessions.StopAction.getInstance());
        this.stop.setHideActionText(true);
        this.toolbar.add((Component)this.stop);
        this.toolbar.addFiller();
        this.settingsButton = new SettingsPresenter();
        this.toolbar.add((Component)this.settingsButton);
        this.container = new JPanel(new BorderLayout(0, 0));
        this.add(this.container, "Center");
        WelcomePanel welcomePanel = new WelcomePanel(this.configure.getText(), this.start.getText(), this.features.getAvailable()){

            @Override
            public void highlightItem(String string) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerWindow.this.configure.doClick(85);
                    }
                });
            }
        };
        boolean bl = ProfilerIDESettings.getInstance().getShowNoDataHint();
        this.featuresView = new FeaturesView(welcomePanel, bl ? string : null);
        this.container.add((Component)this.featuresView, "Center");
        this.features.addListener(new ProfilerFeatures.Listener(){

            @Override
            void featuresChanged(ProfilerFeature profilerFeature) {
                ProfilerWindow.this.updateFeatures(profilerFeature);
            }

            @Override
            void settingsChanged(boolean bl) {
                ProfilerWindow.this.updateSettings(bl);
            }
        });
        this.updateFeatures(null);
        this.updateSettings(this.features.settingsValid());
        this.featuresView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProfilerWindow.this.updateFeatureToolbar();
            }
        });
        this.updateFeatureToolbar();
        this.session.addListener((ProfilingStateListener)new SimpleProfilingStateAdapter(){

            public void update() {
                ProfilerWindow.this.updateWindowIcon();
                ProfilerWindow.this.updateButtons();
            }
        });
        this.updateButtons();
        this.registerActions();
        this.status = ProfilerStatus.forSession(this.session);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    if (ProfilerWindow.this.isShowing()) {
                        ProfilerWindow.this.status.startSessionLogging();
                    } else {
                        ProfilerWindow.this.status.stopSessionLogging();
                    }
                }
            }
        });
        if (this.isShowing()) {
            this.status.startSessionLogging();
        }
    }

    private void registerActions() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPanel jPanel;
                ProfilerFeature profilerFeature = ProfilerWindow.this.featuresView.getSelectedFeature();
                JPanel jPanel2 = jPanel = profilerFeature == null ? null : profilerFeature.getResultsUI();
                if (jPanel == null) {
                    return;
                }
                Action action = jPanel.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)abstractAction, (ActionMap)actionMap, (InputMap)inputMap);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPanel jPanel;
                ProfilerFeature profilerFeature = ProfilerWindow.this.featuresView.getSelectedFeature();
                JPanel jPanel2 = jPanel = profilerFeature == null ? null : profilerFeature.getResultsUI();
                if (jPanel == null) {
                    return;
                }
                Action action = jPanel.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)abstractAction2, (ActionMap)actionMap, (InputMap)inputMap);
    }

    private void updateWindowName() {
        Lookup.Provider provider = this.session.getProject();
        if (provider == null) {
            this.setDisplayName(Bundle.ProfilerWindow_captionExternal());
        } else {
            String string = ProjectUtilities.getDisplayName((Lookup.Provider)provider);
            FileObject fileObject = this.session.getFile();
            this.setDisplayName(fileObject == null ? Bundle.ProfilerWindow_captionProject(string) : Bundle.ProfilerWindow_captionFile(string, fileObject.getNameExt()));
        }
    }

    private void updateWindowIcon() {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProfilerWindow.this.session.inProgress()) {
                    ProfilerWindow.this.setIcon(Icons.getImage((String)"ProfilerIcons.ProfileRunning"));
                } else {
                    ProfilerWindow.this.setIcon(Icons.getImage((String)"ProfilerIcons.ProfileInactive"));
                }
            }
        });
    }

    private void updateButtons() {
        int n = this.session.getState();
        this.start.setPushed(n != 1);
        this.start.setPopupEnabled(n != 128);
    }

    private void updateFeatures(ProfilerFeature profilerFeature) {
        ProfilerFeature profilerFeature2 = this.featuresView.getSelectedFeature();
        this.featuresView.removeFeatures();
        Set<ProfilerFeature> set = this.features.getActivated();
        for (ProfilerFeature profilerFeature3 : set) {
            this.featuresView.addFeature(profilerFeature3);
        }
        if (profilerFeature != null && set.contains(profilerFeature)) {
            this.featuresView.selectFeature(profilerFeature);
        } else {
            this.featuresView.selectFeature(profilerFeature2);
        }
        this.featuresView.repaint();
    }

    private void updateSettings(boolean bl) {
        this.start.setEnabled(bl);
        boolean bl2 = this.features.getActivated().isEmpty();
        this.start.setVisible(!bl2);
        this.stop.setVisible(!bl2);
        this.configure.setVisible(bl2);
        new Timer(0, null){
            {
                this.setRepeats(false);
                this.setInitialDelay(50);
            }

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                ProfilerWindow.this.updateFocus();
            }
        }.start();
        if (this.session.inProgress()) {
            this.session.doModify(this.features.getSettings());
        }
    }

    private void updateFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component != null) {
                    if (ProfilerWindow.this.profilePopupVisible) {
                        return;
                    }
                    if (ProfilerPopup.isInPopup((Component)component)) {
                        return;
                    }
                    if (ProfilerWindow.this.isAncestorOf(component)) {
                        return;
                    }
                }
                Object object = ProfilerWindow.this.configure.isVisible() ? ProfilerWindow.this.configure : ProfilerWindow.this.start;
                SwingUtilities.invokeLater(new Runnable((Component)object){
                    final /* synthetic */ Component val$foc;
                    {
                        this.val$foc = component;
                    }

                    @Override
                    public void run() {
                        this.val$foc.requestFocusInWindow();
                    }
                });
            }
        });
    }

    private void updateFeatureToolbar() {
        ProfilerFeature profilerFeature;
        if (this.featureToolbar != null) {
            this.toolbar.remove(this.featureToolbar);
        }
        if (this.applicationToolbar != null) {
            this.toolbar.remove(this.applicationToolbar);
        }
        ProfilerToolbar profilerToolbar = this.featureToolbar = (profilerFeature = this.featuresView.getSelectedFeature()) == null ? null : profilerFeature.getToolbar();
        if (this.featureToolbar != null) {
            this.toolbar.add(this.featureToolbar, this.toolbar.getComponentCount() - 2);
        }
        this.settingsButton.setFeature(profilerFeature);
        if (profilerFeature != null) {
            this.toolbar.add(this.getApplicationToolbar(), this.toolbar.getComponentCount() - 2);
        } else {
            this.applicationToolbar = null;
        }
        this.doLayout();
        this.repaint();
    }

    private ProfilerToolbar getApplicationToolbar() {
        if (this.applicationToolbar == null) {
            this.applicationToolbar = ProfilerToolbar.create((boolean)true);
            this.applicationToolbar.addSpace(2);
            this.applicationToolbar.addSeparator();
            this.applicationToolbar.addSpace(5);
            GrayLabel grayLabel = new GrayLabel(Bundle.ProfilerWindow_application());
            this.applicationToolbar.add((Component)grayLabel);
            this.applicationToolbar.addSpace(2);
            JButton jButton = new JButton((Action)((Object)TakeThreadDumpAction.getInstance()));
            jButton.setHideActionText(true);
            this.applicationToolbar.add((Component)jButton);
            this.applicationToolbar.addSpace(3);
            JButton jButton2 = new JButton((Action)((Object)HeapDumpAction.getInstance()));
            jButton2.setHideActionText(true);
            this.applicationToolbar.add((Component)jButton2);
            this.applicationToolbar.addSpace(3);
            JButton jButton3 = new JButton((Action)((Object)RunGCAction.getInstance()));
            jButton3.setHideActionText(true);
            this.applicationToolbar.add((Component)jButton3);
        }
        return this.applicationToolbar;
    }

    private boolean configureAttachSettings(boolean bl) {
        AttachSettings attachSettings = AttachWizard.getDefault().configure(this.attachSettings, bl);
        if (attachSettings == null) {
            return false;
        }
        this.attachSettings = attachSettings;
        final AttachSettings attachSettings2 = new AttachSettings();
        this.attachSettings.copyInto(attachSettings2);
        final Lookup.Provider provider = this.session.getProject();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Properties properties = new Properties();
                attachSettings2.store((Map)properties);
                try {
                    ProfilerStorage.saveProjectProperties((Properties)properties, (Lookup.Provider)provider, (String)"attach");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
        return true;
    }

    private void performStartImpl() {
        this.featuresView.resetNoDataHint();
        this.start.setPushed(true);
        final ProfilingSettings profilingSettings = this.features.getSettings();
        if (profilingSettings == null) {
            ProfilerDialogs.displayError((String)Bundle.ProfilerWindow_noFeature());
            this.start.setPushed(false);
            return;
        }
        if (this.session.isAttach()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (AttachWizard.getDefault().configured(ProfilerWindow.this.attachSettings)) {
                        ProfilerWindow.this.performDoStartImpl(profilingSettings, ProfilerWindow.this.attachSettings);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!ProfilerWindow.this.configureAttachSettings(false)) {
                                    ProfilerWindow.this.start.setPushed(false);
                                } else {
                                    ProfilerWindow.this.performDoStartImpl(profilingSettings, ProfilerWindow.this.attachSettings);
                                }
                            }
                        });
                    }
                }
            });
        } else {
            this.performDoStartImpl(profilingSettings, null);
        }
    }

    private void performDoStartImpl(final ProfilingSettings profilingSettings, final AttachSettings attachSettings) {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ProfilerWindow.this.session.doStart(profilingSettings, attachSettings)) {
                    ProfilerWindow.this.start.setPushed(false);
                }
            }
        });
    }

    private void displayPopupImpl() {
        Object object;
        GridBagConstraints gridBagConstraints;
        JLabel jLabel;
        String string;
        final Set<ProfilerFeature> set = this.features.getAvailable();
        final Set<ProfilerFeature> set2 = this.features.getActivated();
        final ArrayList<19> arrayList = new ArrayList<19>();
        final ProfilerFeatures.Listener listener = new ProfilerFeatures.Listener(){

            @Override
            void featuresChanged(ProfilerFeature profilerFeature) {
                int n = 0;
                for (ProfilerFeature profilerFeature2 : set) {
                    ToggleButtonMenuItem toggleButtonMenuItem;
                    if ((toggleButtonMenuItem = (ToggleButtonMenuItem)((Object)arrayList.get(n++))) == null) {
                        toggleButtonMenuItem = (ToggleButtonMenuItem)((Object)arrayList.get(n++));
                    }
                    toggleButtonMenuItem.setPressed(set2.contains(profilerFeature2));
                }
            }

            @Override
            void settingsChanged(boolean bl) {
            }
        };
        final StayOpenPopupMenu stayOpenPopupMenu = new StayOpenPopupMenu(){

            public void setVisible(boolean bl) {
                if (bl) {
                    ProfilerWindow.this.features.addListener(listener);
                } else {
                    ProfilerWindow.this.features.removeListener(listener);
                }
                super.setVisible(bl);
                ProfilerWindow.this.profilePopupVisible = bl;
                if (!bl) {
                    ProfilerWindow.this.updateFocus();
                }
            }
        };
        stayOpenPopupMenu.setLayout((LayoutManager)new GridBagLayout());
        if (!UIUtils.isAquaLookAndFeel()) {
            stayOpenPopupMenu.setForceBackground(true);
            Color color = UIUtils.getProfilerResultsBackground();
            stayOpenPopupMenu.setBackground(new Color(color.getRGB()));
        }
        int n = -1;
        for (final ProfilerFeature profilerFeature : set) {
            int n2 = profilerFeature.getPosition();
            if (n == -1) {
                n = n2;
            }
            if (n2 - n > 1) {
                arrayList.add(null);
            }
            n = n2;
            arrayList.add(new ToggleButtonMenuItem(profilerFeature.getName(), profilerFeature.getIcon()){
                {
                    super(string, icon);
                    this.setPressed(set2.contains(profilerFeature));
                }

                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerWindow.this.features.toggleActivated(profilerFeature);
                    if (ProfilerWindow.this.features.isSingleFeatured() && this.isPressed()) {
                        stayOpenPopupMenu.setVisible(false);
                    }
                }
            });
        }
        boolean bl = this.session.getProject() != null;
        boolean bl2 = this.session.isAttach();
        JMenuItem jMenuItem = null;
        if (bl2) {
            string = bl ? Bundle.ProfilerWindow_setupAttachProject() : Bundle.ProfilerWindow_setupAttachProcess();
            jMenuItem = new JMenuItem(string){
                {
                    this.setEnabled(!ProfilerWindow.this.session.inProgress());
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerWindow.this.configureAttachSettings(true);
                }
            };
        }
        string = new StayOpenPopupMenu.CheckBoxItem(Bundle.ProfilerWindow_multipleFeatures()){
            {
                this.setSelected(!ProfilerWindow.this.features.isSingleFeatured());
            }

            protected void fireItemStateChanged(ItemEvent itemEvent) {
                ProfilerWindow.this.features.setSingleFeatured(!this.isSelected());
            }
        };
        StayOpenPopupMenu.CheckBoxItem checkBoxItem = new StayOpenPopupMenu.CheckBoxItem(Bundle.ProfilerWindow_usePPoints()){
            {
                this.setSelected(ProfilerWindow.this.features.getUseProfilingPoints());
                this.setEnabled(!ProfilerWindow.this.session.inProgress());
            }

            protected void fireItemStateChanged(ItemEvent itemEvent) {
                ProfilerWindow.this.features.setUseProfilingPoints(this.isSelected());
            }
        };
        int n3 = 12;
        int n4 = 5;
        int n5 = 0;
        if (bl2) {
            jLabel = new JLabel(Bundle.ProfilerWindow_targetSection(), 10);
            jLabel.setFont(stayOpenPopupMenu.getFont().deriveFont(1));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n5++;
            gridBagConstraints.insets = new Insets(5, n4, 5, 5);
            gridBagConstraints.fill = 2;
            stayOpenPopupMenu.add((Component)jLabel, (Object)gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n5++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, n3, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            stayOpenPopupMenu.add((Component)jMenuItem, (Object)gridBagConstraints);
        }
        jLabel = new JLabel(Bundle.ProfilerWindow_profileSection(), 10);
        jLabel.setFont(stayOpenPopupMenu.getFont().deriveFont(1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n5++;
        gridBagConstraints.insets = new Insets(bl2 ? 8 : 5, n4, 5, 5);
        gridBagConstraints.fill = 2;
        stayOpenPopupMenu.add((Component)jLabel, (Object)gridBagConstraints);
        for (ToggleButtonMenuItem object22 : arrayList) {
            if (object22 == null) {
                object = new JPanel(null);
                ((JComponent)object).setOpaque(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = n5++;
                gridBagConstraints.insets = new Insets(5, 0, 5, 0);
                gridBagConstraints.fill = 2;
                stayOpenPopupMenu.add((Component)object, (Object)gridBagConstraints);
                continue;
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n5++;
            gridBagConstraints.insets = new Insets(0, n3, 0, 5);
            gridBagConstraints.fill = 2;
            stayOpenPopupMenu.add((Component)((Object)object22), (Object)gridBagConstraints);
        }
        JLabel jLabel2 = new JLabel(Bundle.ProfilerWindow_settingsSection(), 10);
        jLabel2.setFont(stayOpenPopupMenu.getFont().deriveFont(1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n5++;
        gridBagConstraints.insets = new Insets(8, n4, 5, 5);
        gridBagConstraints.fill = 2;
        stayOpenPopupMenu.add((Component)jLabel2, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n5++;
        gridBagConstraints.insets = new Insets(0, n3, 0, 5);
        gridBagConstraints.fill = 2;
        stayOpenPopupMenu.add((Component)((Object)string), (Object)gridBagConstraints);
        if (bl) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n5++;
            gridBagConstraints.insets = new Insets(0, n3, 0, 5);
            gridBagConstraints.fill = 2;
            stayOpenPopupMenu.add((Component)checkBoxItem, (Object)gridBagConstraints);
        }
        if (this.plugins.hasPlugins()) {
            JLabel jLabel3 = new JLabel(Bundle.ProfilerWindow_pluginsSection(), 10);
            jLabel3.setFont(stayOpenPopupMenu.getFont().deriveFont(1));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n5++;
            gridBagConstraints.insets = new Insets(8, n4, 5, 5);
            gridBagConstraints.fill = 2;
            stayOpenPopupMenu.add((Component)jLabel3, (Object)gridBagConstraints);
            for (JMenuItem jMenuItem2 : this.plugins.menuItems()) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = n5++;
                gridBagConstraints.insets = new Insets(0, n3, 0, 5);
                gridBagConstraints.fill = 2;
                stayOpenPopupMenu.add((Component)jMenuItem2, (Object)gridBagConstraints);
            }
        }
        JPanel jPanel = new JPanel(null);
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n5++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        stayOpenPopupMenu.add((Component)jPanel, (Object)gridBagConstraints);
        object = this.start.isVisible() ? this.start : this.configure;
        stayOpenPopupMenu.show((Component)object, 0, ((JComponent)object).getHeight());
    }

    @Override
    protected Component defaultFocusOwner() {
        if (this.configure != null && this.configure.isVisible()) {
            return this.configure;
        }
        if (this.start != null) {
            return this.start;
        }
        return null;
    }

    public boolean canClose() {
        if (this.closing) {
            return true;
        }
        if (!super.canClose()) {
            return false;
        }
        this.closing = true;
        this.closing = this.session.close();
        return this.closing;
    }

    public void open() {
        Mode mode;
        WindowManager windowManager = WindowManager.getDefault();
        if (windowManager.findMode((TopComponent)this) == null && (mode = windowManager.findMode(Bundle.ProfilerWindow_mode())) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected void componentOpened() {
        super.componentOpened();
        SnapshotsWindow.instance().sessionOpened(this.session);
    }

    protected void componentShowing() {
        super.componentShowing();
        SnapshotsWindow.instance().sessionActivated(this.session);
    }

    protected void componentHidden() {
        super.componentHidden();
        SnapshotsWindow.instance().sessionDeactivated(this.session);
    }

    protected void componentClosed() {
        super.componentOpened();
        SnapshotsWindow.instance().sessionClosed(this.session);
    }

    @Override
    protected void componentActivated() {
        super.componentActivated();
        if (this.status != null) {
            this.status.startSessionLogging();
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return "ProfilerWindow";
    }

    public HelpCtx getHelpCtx() {
        String string;
        JPanel jPanel;
        ProfilerFeature profilerFeature = this.featuresView == null ? null : this.featuresView.getSelectedFeature();
        JPanel jPanel2 = jPanel = profilerFeature == null ? null : profilerFeature.getResultsUI();
        if (jPanel == null && profilerFeature != null) {
            jPanel = profilerFeature.getSettingsUI();
        }
        String string2 = string = jPanel == null ? null : (String)jPanel.getClientProperty("HelpCtx.Key");
        if (string == null) {
            string = "ProfileWindow.HelpCtx";
        }
        return new HelpCtx(string);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                @Override
                public String getAccessibleName() {
                    return Bundle.ProfilerWindow_accessName(ProfilerWindow.this.getDisplayName());
                }

                @Override
                public String getAccessibleDescription() {
                    ProfilerFeature profilerFeature = ProfilerWindow.this.featuresView == null ? null : ProfilerWindow.this.featuresView.getSelectedFeature();
                    return profilerFeature == null ? WelcomePanel.CAPTION : profilerFeature.getName() + " " + profilerFeature.getDescription();
                }
            };
        }
        return this.accessibleContext;
    }

    private static final class SettingsPresenter
    extends JToggleButton
    implements ComponentListener {
        private JPanel settings;

        SettingsPresenter() {
            super(Icons.getIcon((String)"GeneralIcons.Settings"));
            this.setToolTipText(Bundle.ProfilerWindow_settings());
            this.updateVisibility(false);
        }

        void setFeature(ProfilerFeature profilerFeature) {
            if (this.settings != null) {
                this.settings.removeComponentListener(this);
            }
            this.settings = profilerFeature == null ? null : profilerFeature.getSettingsUI();
            this.updateVisibility(false);
            if (this.settings != null) {
                this.settings.addComponentListener(this);
            }
        }

        @Override
        protected void fireActionPerformed(ActionEvent actionEvent) {
            if (this.settings != null) {
                this.settings.setVisible(this.isSelected());
                this.settings.getParent().setVisible(this.isSelected());
            }
        }

        void cleanup() {
            this.settings.removeComponentListener(this);
        }

        private void updateVisibility(boolean bl) {
            this.setVisible(this.settings != null);
            this.setSelected(this.settings != null && this.settings.isVisible());
            if (bl) {
                this.settings.getParent().setVisible(this.settings.isVisible());
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.updateVisibility(true);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            this.updateVisibility(true);
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }
    }
}

