/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.SingleTermsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.FuzzyTermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class FuzzyQuery
extends MultiTermQuery
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(AutomatonQuery.class);
    public static final int defaultMaxEdits = 2;
    public static final int defaultPrefixLength = 0;
    public static final int defaultMaxExpansions = 50;
    public static final boolean defaultTranspositions = true;
    private final int maxEdits;
    private final int maxExpansions;
    private final boolean transpositions;
    private final int prefixLength;
    private final Term term;
    private final int termLength;
    private final CompiledAutomaton[] automata;
    private final long ramBytesUsed;
    @Deprecated
    public static final float defaultMinSimilarity = 2.0f;

    public FuzzyQuery(Term term, int maxEdits, int prefixLength, int maxExpansions, boolean transpositions) {
        super(term.field());
        if (maxEdits < 0 || maxEdits > 2) {
            throw new IllegalArgumentException("maxEdits must be between 0 and 2");
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength cannot be negative.");
        }
        if (maxExpansions <= 0) {
            throw new IllegalArgumentException("maxExpansions must be positive.");
        }
        this.term = term;
        this.maxEdits = maxEdits;
        this.prefixLength = prefixLength;
        this.transpositions = transpositions;
        this.maxExpansions = maxExpansions;
        int[] codePoints = FuzzyTermsEnum.stringToUTF32(term.text());
        this.termLength = codePoints.length;
        this.automata = FuzzyTermsEnum.buildAutomata(term.text(), codePoints, prefixLength, transpositions, maxEdits);
        this.setRewriteMethod(new MultiTermQuery.TopTermsBlendedFreqScoringRewrite(maxExpansions));
        this.ramBytesUsed = FuzzyQuery.calculateRamBytesUsed(term, this.automata);
    }

    private static long calculateRamBytesUsed(Term term, CompiledAutomaton[] automata) {
        long bytes = BASE_RAM_BYTES + term.ramBytesUsed();
        for (CompiledAutomaton a : automata) {
            bytes += a.ramBytesUsed();
        }
        bytes += 16L;
        bytes += 8L;
        return ++bytes;
    }

    public FuzzyQuery(Term term, int maxEdits, int prefixLength) {
        this(term, maxEdits, prefixLength, 50, true);
    }

    public FuzzyQuery(Term term, int maxEdits) {
        this(term, maxEdits, 0);
    }

    public FuzzyQuery(Term term) {
        this(term, 2);
    }

    public int getMaxEdits() {
        return this.maxEdits;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public boolean getTranspositions() {
        return this.transpositions;
    }

    public CompiledAutomaton[] getAutomata() {
        return this.automata;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            if (this.maxEdits == 0 || this.prefixLength >= this.term.text().length()) {
                visitor.consumeTerms(this, this.term);
            } else {
                this.automata[this.automata.length - 1].visit(visitor, this, this.field);
            }
        }
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        if (this.maxEdits == 0 || this.prefixLength >= this.term.text().length()) {
            return new SingleTermsEnum(terms.iterator(), this.term.bytes());
        }
        return new FuzzyTermsEnum(terms, atts, this.getTerm(), this.termLength, this.maxEdits, this.automata);
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append('~');
        buffer.append(this.maxEdits);
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.maxEdits;
        result = 31 * result + this.prefixLength;
        result = 31 * result + this.maxExpansions;
        result = 31 * result + (this.transpositions ? 0 : 1);
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FuzzyQuery other = (FuzzyQuery)obj;
        if (this.maxEdits != other.maxEdits) {
            return false;
        }
        if (this.prefixLength != other.prefixLength) {
            return false;
        }
        if (this.maxExpansions != other.maxExpansions) {
            return false;
        }
        if (this.transpositions != other.transpositions) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    @Deprecated
    public static int floatToEdits(float minimumSimilarity, int termLen) {
        if (minimumSimilarity >= 1.0f) {
            return (int)Math.min(minimumSimilarity, 2.0f);
        }
        if (minimumSimilarity == 0.0f) {
            return 0;
        }
        return Math.min((int)((1.0 - (double)minimumSimilarity) * (double)termLen), 2);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }
}

