/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.MovingAverage;
import eu.hansolo.tilesfx.tools.Statistics;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.animation.FillTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;

public class StockTileSkin
extends TileSkin {
    private static final long MONTH = 2592000L;
    private static final long DAY = 86400L;
    private static final long HOUR = 3600L;
    private static final long MINUTE = 60L;
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    private Path triangle;
    private StackPane indicatorPane;
    private Text titleText;
    private Text valueText;
    private TextFlow valueUnitFlow;
    private Text highText;
    private Text lowText;
    private Text changePercentageText;
    private TextFlow changePercentageFlow;
    private Label changeText;
    private Text text;
    private Text timeSpanText;
    private Rectangle graphBounds;
    private Line referenceLine;
    private List<PathElement> pathElements;
    private Path sparkLine;
    private Circle dot;
    private double low;
    private double high;
    private int noOfDatapoints;
    private List<Double> dataList;
    private MovingAverage movingAverage;
    private InvalidationListener averagingListener;
    private State state;

    public StockTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.averagingListener = o -> this.handleEvents("AVERAGING_PERIOD");
        this.timeFormatter = DateTimeFormatter.ofPattern("HH:mm", this.tile.getLocale());
        this.state = State.CONSTANT;
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.low = this.tile.getMaxValue();
        this.high = this.tile.getMinValue();
        this.movingAverage = this.tile.getMovingAverage();
        this.noOfDatapoints = this.tile.getAveragingPeriod();
        this.dataList = new LinkedList<Double>();
        if (this.noOfDatapoints < 4) {
            throw new IllegalArgumentException("Please increase the averaging period to a value larger than 3.");
        }
        this.graphBounds = new Rectangle(12.5, 125.0, 225.0, 112.5);
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getValue()));
        this.valueText.setBoundsType(TextBoundsType.VISUAL);
        this.valueText.setFill(this.tile.getValueColor());
        Helper.enableNode(this.valueText, this.tile.isValueVisible());
        this.valueUnitFlow = new TextFlow(this.valueText);
        this.valueUnitFlow.setTextAlignment(TextAlignment.RIGHT);
        this.highText = new Text();
        this.highText.setTextOrigin(VPos.BOTTOM);
        this.highText.setFill(this.tile.getValueColor());
        this.lowText = new Text();
        this.lowText.setTextOrigin(VPos.TOP);
        this.lowText.setFill(this.tile.getValueColor());
        this.text = new Text(this.tile.getText());
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill(this.tile.getTextColor());
        this.timeSpanText = new Text("");
        this.timeSpanText.setTextOrigin(VPos.TOP);
        this.timeSpanText.setFill(this.tile.getTextColor());
        Helper.enableNode(this.timeSpanText, !this.tile.isTextVisible());
        this.referenceLine = new Line();
        this.referenceLine.getStrokeDashArray().addAll((Double[])new Double[]{3.0, 3.0});
        this.referenceLine.setVisible(false);
        this.pathElements = new ArrayList<PathElement>(this.noOfDatapoints);
        this.pathElements.add(0, new MoveTo());
        for (int i = 1; i < this.noOfDatapoints; ++i) {
            this.pathElements.add(i, new LineTo());
        }
        this.sparkLine = new Path();
        this.sparkLine.getElements().addAll((Collection<PathElement>)this.pathElements);
        this.sparkLine.setFill(null);
        this.sparkLine.setStroke(this.tile.getBarColor());
        this.sparkLine.setStrokeWidth(1.875);
        this.sparkLine.setStrokeLineCap(StrokeLineCap.ROUND);
        this.sparkLine.setStrokeLineJoin(StrokeLineJoin.ROUND);
        this.dot = new Circle();
        this.dot.setFill(this.tile.getBarColor());
        this.dot.setVisible(false);
        this.triangle = new Path();
        this.triangle.setStroke(null);
        this.triangle.setFill(this.state.color);
        this.indicatorPane = new StackPane(this.triangle);
        this.changeText = new Label(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getCurrentValue() - this.tile.getReferenceValue()));
        this.changeText.setTextFill(this.state.color);
        this.changeText.setAlignment(Pos.CENTER_RIGHT);
        this.changePercentageText = new Text(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getCurrentValue() / this.tile.getReferenceValue() * 100.0 - 100.0) + "%");
        this.changePercentageText.setFill(this.state.color);
        this.changePercentageFlow = new TextFlow(this.indicatorPane, this.changePercentageText);
        this.changePercentageFlow.setTextAlignment(TextAlignment.RIGHT);
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.valueUnitFlow, this.sparkLine, this.dot, this.referenceLine, this.highText, this.lowText, this.timeSpanText, this.text, this.changeText, this.changePercentageFlow});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.averagingPeriodProperty().addListener(this.averagingListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.valueText, this.tile.isValueVisible());
            Helper.enableNode(this.timeSpanText, !this.tile.isTextVisible());
            this.redraw();
        } else if ("VALUE".equals(EVENT_TYPE)) {
            if (this.tile.isAnimated()) {
                this.tile.setAnimated(false);
            }
            if (!this.tile.isAveragingEnabled()) {
                this.tile.setAveragingEnabled(true);
            }
            double value = Helper.clamp(this.minValue, this.maxValue, this.tile.getValue());
            this.addData(value);
            this.handleCurrentValue(value);
        } else if ("AVERAGING".equals(EVENT_TYPE)) {
            int i;
            this.noOfDatapoints = this.tile.getAveragingPeriod();
            if (this.noOfDatapoints < 4) {
                throw new IllegalArgumentException("Please increase the averaging period to a value larger than 3.");
            }
            for (i = 0; i < this.noOfDatapoints; ++i) {
                this.dataList.add(this.minValue);
            }
            this.pathElements.clear();
            this.pathElements.add(0, new MoveTo());
            for (i = 1; i < this.noOfDatapoints; ++i) {
                this.pathElements.add(i, new LineTo());
            }
            this.sparkLine.getElements().setAll((Collection<PathElement>)this.pathElements);
            this.redraw();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        this.low = Statistics.getMin(this.dataList);
        this.high = Statistics.getMax(this.dataList);
        if (Helper.equals(this.low, this.high)) {
            this.low = this.minValue;
            this.high = this.maxValue;
        }
        this.range = this.high - this.low;
        double minX = this.graphBounds.getX();
        double maxX = minX + this.graphBounds.getWidth();
        double minY = this.graphBounds.getY();
        double maxY = minY + this.graphBounds.getHeight();
        double stepX = this.graphBounds.getWidth() / (double)(this.noOfDatapoints - 1);
        double stepY = this.graphBounds.getHeight() / this.range;
        double referenceValue = this.tile.getReferenceValue();
        if (!this.dataList.isEmpty()) {
            MoveTo begin = (MoveTo)this.pathElements.get(0);
            begin.setX(minX);
            begin.setY(maxY - Math.abs(this.low - this.dataList.get(0)) * stepY);
            for (int i = 1; i < this.noOfDatapoints - 1; ++i) {
                LineTo lineTo = (LineTo)this.pathElements.get(i);
                lineTo.setX(minX + (double)i * stepX);
                lineTo.setY(maxY - Math.abs(this.low - this.dataList.get(i)) * stepY);
            }
            LineTo end = (LineTo)this.pathElements.get(this.noOfDatapoints - 1);
            end.setX(maxX);
            end.setY(maxY - Math.abs(this.low - this.dataList.get(this.noOfDatapoints - 1)) * stepY);
            this.dot.setCenterX(maxX);
            this.dot.setCenterY(end.getY());
            this.updateState(VALUE, referenceValue);
            this.referenceLine.setStartY(maxY - Math.abs(this.low - referenceValue) * stepY);
            this.referenceLine.setEndY(maxY - Math.abs(this.low - referenceValue) * stepY);
            this.changeText.setText(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", VALUE - referenceValue));
            StringBuilder changePercentageTextBuilder = new StringBuilder();
            if (Double.compare(this.tile.getReferenceValue(), 0.0) == 0) {
                changePercentageTextBuilder.append(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", 0.0));
            } else {
                changePercentageTextBuilder.append(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", VALUE / this.tile.getReferenceValue() * 100.0 - 100.0));
            }
            changePercentageTextBuilder.append("%");
            this.changePercentageText.setText(changePercentageTextBuilder.toString());
            RotateTransition rotateTransition = new RotateTransition(Duration.millis(200.0), this.triangle);
            rotateTransition.setFromAngle(this.triangle.getRotate());
            rotateTransition.setToAngle(this.state.angle);
            FillTransition fillIndicatorTransition = new FillTransition(Duration.millis(200.0), this.triangle);
            fillIndicatorTransition.setFromValue((Color)this.triangle.getFill());
            fillIndicatorTransition.setToValue(this.state.color);
            FillTransition fillReferenceTransition = new FillTransition(Duration.millis(200.0), this.changePercentageText);
            fillReferenceTransition.setFromValue((Color)this.triangle.getFill());
            fillReferenceTransition.setToValue(this.state.color);
            ParallelTransition parallelTransition = new ParallelTransition(rotateTransition, fillIndicatorTransition, fillReferenceTransition);
            parallelTransition.play();
        }
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        this.highText.setText(String.format(this.locale, this.formatString, this.high));
        this.lowText.setText(String.format(this.locale, this.formatString, this.low));
        if (!this.tile.isTextVisible() && null != this.movingAverage.getTimeSpan()) {
            this.timeSpanText.setText(this.createTimeSpanText());
            this.text.setText(this.timeFormatter.format(this.movingAverage.getLastEntry().getTimestampAsDateTime(this.tile.getZoneId())));
        }
        this.resizeDynamicText();
    }

    private void addData(double VALUE) {
        if (!this.dot.isVisible()) {
            this.dot.setVisible(true);
            this.referenceLine.setVisible(true);
        }
        if (this.dataList.isEmpty()) {
            double referenceValue = this.tile.getReferenceValue() != 0.0 ? this.tile.getReferenceValue() : VALUE;
            for (int i = 0; i < this.noOfDatapoints; ++i) {
                this.dataList.add(referenceValue);
            }
            if (this.tile.isAutoReferenceValue()) {
                this.tile.setReferenceValue(referenceValue);
            }
        }
        if (this.dataList.size() <= this.noOfDatapoints) {
            Collections.rotate(this.dataList, -1);
            this.dataList.set(this.noOfDatapoints - 1, VALUE);
            if (this.tile.isAutoReferenceValue()) {
                this.tile.setReferenceValue(this.dataList.get(0));
            }
        } else {
            this.dataList.add(VALUE);
        }
    }

    private void updateState(double VALUE, double REFERENCE_VALUE) {
        this.state = Double.compare(VALUE, REFERENCE_VALUE) > 0 ? State.INCREASE : (Double.compare(VALUE, REFERENCE_VALUE) < 0 ? State.DECREASE : State.CONSTANT);
        this.changeText.setTextFill(this.state.color);
        this.changePercentageText.setFill(this.state.color);
        this.triangle.setFill(this.state.color);
    }

    private void drawTriangle() {
        MoveTo moveTo = new MoveTo(0.056 * this.size * 0.5, 0.032 * this.size * 0.5);
        CubicCurveTo cubicCurveTo1 = new CubicCurveTo(0.06 * this.size * 0.5, 0.028 * this.size * 0.5, 0.064 * this.size * 0.5, 0.028 * this.size * 0.5, 0.068 * this.size * 0.5, 0.032 * this.size * 0.5);
        CubicCurveTo cubicCurveTo2 = new CubicCurveTo(0.068 * this.size * 0.5, 0.032 * this.size * 0.5, 0.12 * this.size * 0.5, 0.08 * this.size * 0.5, 0.12 * this.size * 0.5, 0.08 * this.size * 0.5);
        CubicCurveTo cubicCurveTo3 = new CubicCurveTo(0.128 * this.size * 0.5, 0.088 * this.size * 0.5, 0.124 * this.size * 0.5, 0.096 * this.size * 0.5, 0.112 * this.size * 0.5, 0.096 * this.size * 0.5);
        CubicCurveTo cubicCurveTo4 = new CubicCurveTo(0.112 * this.size * 0.5, 0.096 * this.size * 0.5, 0.012 * this.size * 0.5, 0.096 * this.size * 0.5, 0.012 * this.size * 0.5, 0.096 * this.size * 0.5);
        CubicCurveTo cubicCurveTo5 = new CubicCurveTo(0.0, 0.096 * this.size * 0.5, -0.004 * this.size * 0.5, 0.088 * this.size * 0.5, 0.004 * this.size * 0.5, 0.08 * this.size * 0.5);
        CubicCurveTo cubicCurveTo6 = new CubicCurveTo(0.004 * this.size * 0.5, 0.08 * this.size * 0.5, 0.056 * this.size * 0.5, 0.032 * this.size * 0.5, 0.056 * this.size * 0.5, 0.032 * this.size * 0.5);
        ClosePath closePath = new ClosePath();
        this.triangle.getElements().setAll((PathElement[])new PathElement[]{moveTo, cubicCurveTo1, cubicCurveTo2, cubicCurveTo3, cubicCurveTo4, cubicCurveTo5, cubicCurveTo6, closePath});
    }

    private String createTimeSpanText() {
        long timeSpan = this.movingAverage.getTimeSpan().getEpochSecond();
        StringBuilder timeSpanBuilder = new StringBuilder(this.movingAverage.isFilling() ? "\u22a2 " : "\u2190 ");
        if (timeSpan > 2592000L) {
            long months = timeSpan / 2592000L;
            double days = timeSpan % 2592000L;
            timeSpanBuilder.append(months).append("M").append(String.format(this.locale, "%.0f", days)).append("d").append(" \u2192");
        } else if (timeSpan > 86400L) {
            long days = timeSpan / 86400L;
            double hours = (timeSpan - days * 86400L) / 3600L;
            timeSpanBuilder.append(days).append("d").append(String.format(this.locale, "%.0f", hours)).append("h").append(" \u2192");
        } else if (timeSpan > 3600L) {
            long hours = timeSpan / 3600L;
            double minutes = (timeSpan - hours * 3600L) / 60L;
            timeSpanBuilder.append(hours).append("h").append(String.format(this.locale, "%.0f", minutes)).append("m").append(" \u2192");
        } else if (timeSpan > 60L) {
            long minutes = timeSpan / 60L;
            double seconds = timeSpan - minutes * 60L;
            timeSpanBuilder.append(minutes).append("m").append(String.format(this.locale, "%.0f", seconds)).append("s").append(" \u2192");
        } else {
            long seconds = timeSpan;
            timeSpanBuilder.append(seconds).append("s").append(" \u2192");
        }
        return timeSpanBuilder.toString();
    }

    @Override
    public void dispose() {
        this.tile.averagingPeriodProperty().removeListener(this.averagingListener);
        super.dispose();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        maxWidth = this.width - this.size * 0.55;
        fontSize = this.size * 0.06;
        this.changeText.setFont(Fonts.latoRegular(fontSize));
        this.changePercentageText.setFont(Fonts.latoRegular(fontSize));
        if (this.changePercentageText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.changePercentageText, maxWidth, fontSize);
        }
        maxWidth = this.width - this.size * 0.7;
        fontSize = this.size * 0.06;
        this.highText.setFont(Fonts.latoRegular(fontSize));
        if (this.highText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.highText, maxWidth, fontSize);
        }
        this.highText.setY(this.graphBounds.getY() - this.size * 0.0125);
        this.lowText.setFont(Fonts.latoRegular(fontSize));
        if (this.lowText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.lowText, maxWidth, fontSize);
        }
        this.lowText.setY(this.height - this.size * 0.1);
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        this.text.setFont(Fonts.latoRegular(fontSize));
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        this.text.relocate(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth(), this.height - this.size * 0.1);
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        this.timeSpanText.setFont(Fonts.latoRegular(fontSize));
        if (this.timeSpanText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.timeSpanText, maxWidth, fontSize);
        }
        this.timeSpanText.relocate((this.width - this.timeSpanText.getLayoutBounds().getWidth()) * 0.5, this.height - this.size * 0.1);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.highText.setX(this.size * 0.05);
        this.lowText.setX(this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.graphBounds = new Rectangle(this.inset, this.size * 0.6, this.width - this.doubleInset, this.height - this.size * 0.71);
        this.referenceLine.setStartX(this.graphBounds.getX());
        this.referenceLine.setEndX(this.graphBounds.getX() + this.graphBounds.getWidth());
        this.handleCurrentValue(this.tile.getValue());
        if (this.tile.getAveragingPeriod() < 250) {
            this.sparkLine.setStrokeWidth(this.size * 0.01);
            this.dot.setRadius(this.size * 0.014);
        } else if (this.tile.getAveragingPeriod() < 500) {
            this.sparkLine.setStrokeWidth(this.size * 0.0075);
            this.dot.setRadius(this.size * 0.0105);
        } else {
            this.sparkLine.setStrokeWidth(this.size * 0.005);
            this.dot.setRadius(this.size * 0.007);
        }
        this.drawTriangle();
        this.indicatorPane.setPadding(new Insets(0.0, this.size * 0.0175, 0.0, 0.0));
        this.resizeStaticText();
        this.resizeDynamicText();
        this.changeText.setPrefWidth(0.6 * this.width - this.size * 0.1);
        this.changeText.relocate(this.width - this.changeText.getPrefWidth() - this.size * 0.05, this.graphBounds.getY() - this.size * 0.175);
        this.changePercentageFlow.setPrefWidth(0.6 * this.width - this.size * 0.1);
        this.changePercentageFlow.relocate(this.width - this.changePercentageFlow.getPrefWidth() - this.inset, this.graphBounds.getY() - this.size * 0.085);
        this.valueUnitFlow.setMaxWidth(this.contentBounds.getWidth());
        this.valueUnitFlow.setMinWidth(this.contentBounds.getWidth());
        this.valueUnitFlow.setPrefWidth(this.contentBounds.getWidth());
        this.valueUnitFlow.relocate(this.contentBounds.getX(), this.contentBounds.getY());
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        if (!this.tile.getDescription().isEmpty()) {
            this.text.setText(this.tile.getDescription());
        }
        if (this.tile.isTextVisible()) {
            this.text.setText(this.tile.getText());
        } else if (!this.tile.isTextVisible() && null != this.movingAverage.getTimeSpan()) {
            this.timeSpanText.setText(this.createTimeSpanText());
            this.text.setText(this.timeFormatter.format(this.movingAverage.getLastEntry().getTimestampAsDateTime(this.tile.getZoneId())));
        }
        this.changeText.setText(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getCurrentValue() - this.tile.getReferenceValue()));
        StringBuilder changePercentageTextBuilder = new StringBuilder();
        if (Double.compare(this.tile.getReferenceValue(), 0.0) == 0) {
            changePercentageTextBuilder.append(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", 0.0));
        } else {
            changePercentageTextBuilder.append(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getCurrentValue() / this.tile.getReferenceValue() * 100.0 - 100.0));
        }
        changePercentageTextBuilder.append("%");
        this.changePercentageText.setText(changePercentageTextBuilder.toString());
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.valueText.setFill(this.tile.getValueColor());
        this.highText.setFill(this.tile.getValueColor());
        this.lowText.setFill(this.tile.getValueColor());
        this.text.setFill(this.tile.getTextColor());
        this.timeSpanText.setFill(this.tile.getTextColor());
        this.referenceLine.setStroke(this.tile.getThresholdColor());
        this.sparkLine.setStroke(this.tile.getBarColor());
        this.dot.setFill(this.tile.getBarColor());
        this.changeText.setTextFill(this.state.color);
        this.changePercentageText.setFill(this.state.color);
        this.triangle.setFill(this.state.color);
    }

    private static enum State {
        INCREASE(Tile.GREEN, 0.0),
        DECREASE(Tile.RED, 180.0),
        CONSTANT(Tile.ORANGE, 90.0);

        public final Color color;
        public final double angle;

        private State(Color COLOR, double ANGLE) {
            this.color = COLOR;
            this.angle = ANGLE;
        }
    }
}

