/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.models;

import java.util.Vector;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenFilmCaptions;
import mediathek.tool.Datum;
import mediathek.tool.MVFilmSize;
import mediathek.tool.models.TModel;

public class TModelFilm
extends TModel {
    private static final int COLUMN_COUNT = 15;

    @Override
    public int getIdxRow(int idxWert) {
        int ret = 0;
        for (Vector list : this.getDataVector()) {
            DatenFilm film = (DatenFilm)list.get(0);
            if (film.getFilmNr() == idxWert) {
                return ret;
            }
            ++ret;
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return 15;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class result;
        switch (columnIndex) {
            case 0: {
                result = Integer.class;
                break;
            }
            case 6: {
                result = Datum.class;
                break;
            }
            case 9: {
                result = MVFilmSize.class;
                break;
            }
            case 10: 
            case 11: {
                result = Boolean.class;
                break;
            }
            default: {
                result = String.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 4 || column == 5) {
            return "";
        }
        return DatenFilmCaptions.getTitleByFieldIndex(column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result;
        DatenFilm film = (DatenFilm)((Vector)this.dataVector.elementAt(row)).elementAt(0);
        switch (column) {
            case 0: {
                result = film.getFilmNr();
                break;
            }
            case 1: {
                result = film.getSender();
                break;
            }
            case 2: {
                result = film.getThema();
                break;
            }
            case 3: {
                result = film.getTitle();
                break;
            }
            case 4: 
            case 5: {
                result = "";
                break;
            }
            case 6: {
                result = film.getDatumFilm();
                break;
            }
            case 7: {
                result = film.getSendeZeit();
                break;
            }
            case 8: {
                result = film.getDauer();
                break;
            }
            case 9: {
                result = film.getFilmSize();
                break;
            }
            case 10: {
                result = film.isHighQuality();
                break;
            }
            case 11: {
                result = film.hasSubtitle();
                break;
            }
            case 12: {
                result = film.getGeo().orElse("");
                break;
            }
            case 13: {
                result = film.getUrl();
                break;
            }
            case 14: {
                result = film.getAboName();
                break;
            }
            case 19: {
                result = film.getUrlSubtitle();
                break;
            }
            case 20: {
                result = film.getUrlKlein();
                break;
            }
            case 18: {
                result = film.getHighQualityUrl();
                break;
            }
            case 16: {
                result = film.getUrl();
                break;
            }
            case 17: {
                result = film;
                break;
            }
            case 15: {
                result = film.getDatumLong();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("UNKNOWN COLUMN VALUE: " + column);
            }
        }
        return result;
    }
}

