/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.ui;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FilterJTextField
extends JTextField {
    private final String filterHint;
    private boolean showingHint;
    private Timer timer;

    public FilterJTextField(String hint) {
        super(hint);
        this.filterHint = hint;
        this.showingHint = true;
        this.updateStyle();
        this.timer = new Timer(1000, e -> {
            this.applyFilter();
            this.timer.stop();
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (FilterJTextField.this.getText().isEmpty()) {
                    FilterJTextField.this.showingHint = true;
                }
                FilterJTextField.this.updateStyle();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (FilterJTextField.this.showingHint) {
                    FilterJTextField.this.showingHint = false;
                    FilterJTextField.this.setText("");
                }
                FilterJTextField.this.updateStyle();
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FilterJTextField.this.spawnTimer();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilterJTextField.this.spawnTimer();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.addActionListener(e -> {
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            this.applyFilter();
        });
    }

    private void spawnTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
    }

    public void applyFilter() {
        String filter = this.showingHint ? "" : this.getText();
        filter = filter.toLowerCase();
        filter = filter.replaceAll("[^\\x30-\\x39^\\x61-\\x7a^\\x3a]", " ");
        this.onFilter(filter.split(" "));
    }

    protected void onFilter(String[] strings) {
    }

    private void updateStyle() {
        if (this.showingHint) {
            this.setText(this.filterHint);
            this.setForeground(Color.gray);
            this.setFont(this.getFont().deriveFont(2));
        } else {
            this.setForeground(UIManager.getColor("TextField.foreground"));
            this.setFont(this.getFont().deriveFont(0));
        }
    }

    @Override
    public void paste() {
        if (!this.isEditable() || !this.isEnabled()) {
            return;
        }
        if (this.showingHint) {
            this.showingHint = false;
            this.setText("");
            this.updateStyle();
        }
        super.paste();
    }
}

