/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.DoubleByte;

public abstract class ByteToCharDBCS_ASCII
extends ByteToCharConverter {
    private boolean savedBytePresent = false;
    private int savedByte;
    private DoubleByte.Decoder dec;

    public ByteToCharDBCS_ASCII(DoubleByte.Decoder dec) {
        this.dec = dec;
    }

    char decodeSingle(int b) {
        return this.dec.decodeSingle(b);
    }

    char decodeDouble(int b1, int b2) {
        return this.dec.decodeDouble(b1, b2);
    }

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.savedBytePresent) {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int outputChar = 65533;
        this.charOff = outOff;
        this.byteOff = inOff;
        while (this.byteOff < inEnd) {
            int inputSize;
            int byte1;
            if (!this.savedBytePresent) {
                byte1 = input[this.byteOff] & 0xFF;
                inputSize = 1;
            } else {
                byte1 = this.savedByte;
                this.savedBytePresent = false;
                inputSize = 0;
            }
            outputChar = this.decodeSingle(byte1);
            if (outputChar == 65533) {
                if (this.byteOff + inputSize >= inEnd) {
                    this.savedByte = byte1;
                    this.savedBytePresent = true;
                    this.byteOff += inputSize;
                    break;
                }
                outputChar = this.decodeDouble(byte1, input[this.byteOff + inputSize] & 0xFF);
                ++inputSize;
            }
            if (outputChar == 65533) {
                if (this.subMode) {
                    outputChar = this.subChars[0];
                } else {
                    this.badInputLength = inputSize;
                    throw new UnknownCharacterException();
                }
            }
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            output[this.charOff++] = outputChar;
            this.byteOff += inputSize;
        }
        return this.charOff - outOff;
    }

    public void reset() {
        this.byteOff = 0;
        this.charOff = 0;
        this.savedBytePresent = false;
    }
}

