/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.EUC_JP;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Solaris_Encoder;
import sun.nio.cs.ext.JIS_X_0212_Solaris_Decoder;
import sun.nio.cs.ext.JIS_X_0212_Solaris_Encoder;

public class EUC_JP_Open
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP_Open() {
        super("x-eucJP-Open", ExtendedCharsets.aliasesFor("x-eucJP-Open"));
    }

    @Override
    public String historicalName() {
        return "EUC_JP_Solaris";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof JIS_X_0201 || cs instanceof EUC_JP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        byte[] replacementBytes = new byte[]{63};
        return new Encoder(this).replaceWith(replacementBytes);
    }

    private static class Encoder
    extends EUC_JP.Encoder {
        JIS_X_0201.Encoder encoderJ0201;
        JIS_X_0212_Solaris_Encoder encoderJ0212;
        private static final short[] j0208Index1 = JIS_X_0208_Solaris_Encoder.getIndex1();
        private static final String[] j0208Index2 = JIS_X_0208_Solaris_Encoder.getIndex2();
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset cs) {
            super(cs);
            this.encoderJ0201 = new JIS_X_0201.Encoder(cs);
            this.encoderJ0212 = new JIS_X_0212_Solaris_Encoder(cs);
        }

        @Override
        protected int encodeSingle(char inputChar, byte[] outputByte) {
            if (inputChar == '\u0000') {
                outputByte[0] = 0;
                return 1;
            }
            byte b = this.encoderJ0201.encode(inputChar);
            if (b == 0) {
                return 0;
            }
            if (b > 0 && b < 128) {
                outputByte[0] = b;
                return 1;
            }
            outputByte[0] = -114;
            outputByte[1] = b;
            return 2;
        }

        @Override
        protected int encodeDouble(char ch) {
            int r = super.encodeDouble(ch);
            if (r != 0) {
                return r;
            }
            int offset = j0208Index1[(ch & 0xFF00) >> 8] << 8;
            r = j0208Index2[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
            if (r > 29952) {
                return 0x8F8080 + this.encoderJ0212.encodeDouble(ch);
            }
            return r == 0 ? 0 : r + 32896;
        }
    }

    private static class Decoder
    extends EUC_JP.Decoder {
        JIS_X_0201.Decoder decoderJ0201;
        JIS_X_0212_Solaris_Decoder decodeMappingJ0212;
        JIS_X_0208_Solaris_Decoder decodeMappingJ0208;
        private static final short[] j0208Index1 = JIS_X_0208_Solaris_Decoder.getIndex1();
        private static final String[] j0208Index2 = JIS_X_0208_Solaris_Decoder.getIndex2();
        private static final int start = 161;
        private static final int end = 254;
        protected final char REPLACE_CHAR = (char)65533;

        private Decoder(Charset cs) {
            super(cs);
            this.decoderJ0201 = new JIS_X_0201.Decoder(cs);
            this.decodeMappingJ0212 = new JIS_X_0212_Solaris_Decoder(cs);
        }

        @Override
        protected char decode0212(int byte1, int byte2) {
            return this.decodeMappingJ0212.decodeDouble(byte1, byte2);
        }

        @Override
        protected char decodeDouble(int byte1, int byte2) {
            if (byte1 == 142) {
                return this.decoderJ0201.decode(byte2 - 256);
            }
            if (byte1 < 0 || byte1 > j0208Index1.length || byte2 < 161 || byte2 > 254) {
                return '\ufffd';
            }
            char result = super.decodeDouble(byte1, byte2);
            if (result != '\ufffd') {
                return result;
            }
            int n = (j0208Index1[byte1 - 128] & 0xF) * 94 + (byte2 - 161);
            return j0208Index2[j0208Index1[byte1 - 128] >> 4].charAt(n);
        }
    }
}

