/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    long clientHandle;
    long labelHandle;
    String text = "";
    GdkRGBA foreground;

    public Group(Composite composite, int n) {
        super(composite, Group.checkStyle(n));
    }

    static int checkStyle(int n) {
        return (n |= 0x80000) & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    long clientHandle() {
        return this.clientHandle;
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        Point point = super.computeSizeInPixels(n, n2, bl);
        int n3 = this.computeNativeSize((long)this.handle, (int)-1, (int)-1, (boolean)false).x;
        point.x = Math.max(point.x, n3);
        return point;
    }

    @Override
    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.forceResize();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.clientHandle, gtkAllocation);
        int n5 = gtkAllocation.x;
        int n6 = gtkAllocation.y;
        return new Rectangle(n -= n5, n2 -= n6, n3 += n5 + n5, n4 += n5 + n6);
    }

    @Override
    Rectangle getClientAreaInPixels() {
        Rectangle rectangle = super.getClientAreaInPixels();
        rectangle.x = 0;
        rectangle.y = 0;
        return rectangle;
    }

    @Override
    GdkColor getContextColor() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            if (this.foreground != null) {
                return this.display.toGdkColor(this.foreground);
            }
            return this.display.COLOR_WIDGET_FOREGROUND;
        }
        return super.getContextColor();
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_frame_new(null);
        if (this.handle == 0L) {
            this.error(2);
        }
        this.labelHandle = OS.gtk_label_new(null);
        if (this.labelHandle == 0L) {
            this.error(2);
        }
        OS.g_object_ref(this.labelHandle);
        OS.g_object_ref_sink(this.labelHandle);
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.clientHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.clientHandle, true);
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_container_add(this.handle, this.clientHandle);
        if ((this.style & 4) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 1);
        }
        if ((this.style & 8) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 2);
        }
        if ((this.style & 0x10) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 3);
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 4);
        }
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    @Override
    int applyThemeBackground() {
        return 1;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.labelHandle);
    }

    @Override
    void enableWidget(boolean bl) {
        OS.gtk_widget_set_sensitive(this.labelHandle, bl);
    }

    @Override
    long eventHandle() {
        return this.clientHandle;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean mnemonicHit(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        boolean bl = super.mnemonicHit(this.labelHandle, c);
        if (bl) {
            this.setFocus();
        }
        return bl;
    }

    @Override
    boolean mnemonicMatch(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, c);
    }

    @Override
    long parentingHandle() {
        return this.clientHandle;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.labelHandle, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0L;
        this.clientHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.labelHandle != 0L) {
            OS.g_object_unref(this.labelHandle);
        }
        this.text = null;
    }

    @Override
    void setBackgroundColor(GdkColor gdkColor) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            this.setBackgroundColor(this.fixedHandle, gdkColor);
            return;
        }
        super.setBackgroundColor(gdkColor);
        this.setBackgroundColor(this.fixedHandle, gdkColor);
        this.setBackgroundColor(this.clientHandle, gdkColor);
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        this.setFontDescription(this.labelHandle, l);
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            GdkRGBA gdkRGBA = null;
            if (gdkColor != null) {
                gdkRGBA = this.display.toGdkRGBA(gdkColor);
            }
            if (this.text.isEmpty()) {
                this.foreground = gdkRGBA;
            } else {
                this.setForegroundColor(this.labelHandle, gdkRGBA);
                this.foreground = gdkRGBA;
            }
        } else {
            super.setForegroundColor(gdkColor);
            this.setForegroundColor(this.labelHandle, gdkColor);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n = (this.style & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.labelHandle, n);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            if (OS.gtk_frame_get_label_widget(this.handle) == 0L) {
                OS.gtk_frame_set_label_widget(this.handle, this.labelHandle);
            }
        } else {
            OS.gtk_frame_set_label_widget(this.handle, 0L);
        }
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            this.setForegroundColor(this.labelHandle, this.foreground);
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.clientHandle != 0L) {
            OS.gtk_widget_show(this.clientHandle);
        }
        if (this.labelHandle != 0L) {
            OS.gtk_widget_show(this.labelHandle);
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (OS.GTK3) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            OS.gtk_widget_get_preferred_size(this.handle, gtkRequisition, null);
            n3 = Math.max(gtkRequisition.width, n3);
        }
        return super.setBounds(n, n2, n3, n4, bl, bl2);
    }

    @Override
    long paintHandle() {
        if (OS.GTK3) {
            return super.paintHandle();
        }
        long l = this.topHandle();
        long l2 = this.clientHandle;
        while (l2 != l && !OS.gtk_widget_get_has_window(l2)) {
            l2 = OS.gtk_widget_get_parent(l2);
        }
        return l2;
    }

    @Override
    long paintWindow() {
        long l = this.clientHandle;
        OS.gtk_widget_realize(l);
        return this.gtk_widget_get_window(l);
    }
}

