/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaIndex {
    private static volatile Map<File, MetaIndex> jarMap;
    private String[] contents;
    private boolean isClassOnlyJar;

    public static MetaIndex forJar(File jar2) {
        return MetaIndex.getJarMap().get(jar2);
    }

    public static synchronized void registerDirectory(File dir) {
        File indexFile = new File(dir, "meta-index");
        if (indexFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(indexFile));
                String line = null;
                String curJarName = null;
                boolean isCurJarContainClassOnly = false;
                ArrayList<String> contents = new ArrayList<String>();
                Map<File, MetaIndex> map = MetaIndex.getJarMap();
                dir = dir.getCanonicalFile();
                line = reader.readLine();
                if (line == null || !line.equals("% VERSION 2")) {
                    reader.close();
                    return;
                }
                block6: while ((line = reader.readLine()) != null) {
                    switch (line.charAt(0)) {
                        case '!': 
                        case '#': 
                        case '@': {
                            if (curJarName != null && contents.size() > 0) {
                                map.put(new File(dir, curJarName), new MetaIndex(contents, isCurJarContainClassOnly));
                                contents.clear();
                            }
                            curJarName = line.substring(2);
                            if (line.charAt(0) == '!') {
                                isCurJarContainClassOnly = true;
                                continue block6;
                            }
                            if (!isCurJarContainClassOnly) continue block6;
                            isCurJarContainClassOnly = false;
                            continue block6;
                        }
                        case '%': {
                            continue block6;
                        }
                    }
                    contents.add(line);
                }
                if (curJarName != null && contents.size() > 0) {
                    map.put(new File(dir, curJarName), new MetaIndex(contents, isCurJarContainClassOnly));
                }
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean mayContain(String entry) {
        if (this.isClassOnlyJar && !entry.endsWith(".class")) {
            return false;
        }
        String[] conts = this.contents;
        for (int i = 0; i < conts.length; ++i) {
            if (!entry.startsWith(conts[i])) continue;
            return true;
        }
        return false;
    }

    private MetaIndex(List<String> entries, boolean isClassOnlyJar) throws IllegalArgumentException {
        if (entries == null) {
            throw new IllegalArgumentException();
        }
        this.contents = entries.toArray(new String[0]);
        this.isClassOnlyJar = isClassOnlyJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Map<File, MetaIndex> getJarMap() {
        if (jarMap == null) {
            Class<MetaIndex> clazz = MetaIndex.class;
            // MONITORENTER : sun.misc.MetaIndex.class
            if (jarMap == null) {
                jarMap = new HashMap<File, MetaIndex>();
            }
            // MONITOREXIT : clazz
        }
        if ($assertionsDisabled) return jarMap;
        if (jarMap != null) return jarMap;
        throw new AssertionError();
    }
}

