/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class ByteWrangler {
    public static final int MAX_VALUE_LENGTH = 255;
    public static final int MAX_DATA_LENGTH = 256;
    public static final byte[] NO_VALUE = new byte[0];
    public static final byte[] EMPTY_TXT = new byte[]{0};

    public static void writeUTF(OutputStream out, String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c >> 0 & 0x3F);
        }
    }

    public static String readUTF(byte[] data) {
        return ByteWrangler.readUTF(data, 0, data.length);
    }

    public static String readUTF(byte[] data, int off, int len) {
        int offset = off;
        StringBuilder sb = new StringBuilder();
        int end = offset + len;
        while (offset < end) {
            int ch = data[offset++] & 0xFF;
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    if (offset >= len) {
                        return null;
                    }
                    ch = (ch & 0x1F) << 6 | data[offset++] & 0x3F;
                    break;
                }
                case 14: {
                    if (offset + 2 >= len) {
                        return null;
                    }
                    ch = (ch & 0xF) << 12 | (data[offset++] & 0x3F) << 6 | data[offset++] & 0x3F;
                    break;
                }
                default: {
                    if (offset + 1 >= len) {
                        return null;
                    }
                    ch = (ch & 0x3F) << 4 | data[offset++] & 0xF;
                }
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static void readProperties(Map<String, byte[]> properties, byte[] textBytes) throws Exception {
        if (textBytes != null) {
            int len;
            for (int off = 0; off < textBytes.length; off += len) {
                int i;
                if ((len = textBytes[off++] & 0xFF) == 0 || off + len > textBytes.length) {
                    properties.clear();
                    break;
                }
                for (i = 0; i < len && textBytes[off + i] != 61; ++i) {
                }
                String name = ByteWrangler.readUTF(textBytes, off, i);
                if (name == null) {
                    properties.clear();
                    break;
                }
                if (i == len) {
                    properties.put(name, NO_VALUE);
                    continue;
                }
                byte[] value = new byte[len - ++i];
                System.arraycopy(textBytes, off + i, value, 0, len - i);
                properties.put(name, value);
            }
        }
    }

    public static byte[] textFromProperties(Map<String, ?> props) {
        byte[] text = null;
        if (props != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                for (Map.Entry<String, ?> entry : props.entrySet()) {
                    byte[] data;
                    String key = entry.getKey();
                    Object val = entry.getValue();
                    ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
                    ByteWrangler.writeUTF(out2, key);
                    if (val != null) {
                        if (val instanceof String) {
                            out2.write(61);
                            ByteWrangler.writeUTF(out2, (String)val);
                        } else if (val instanceof byte[]) {
                            byte[] bval = (byte[])val;
                            if (bval.length > 0) {
                                out2.write(61);
                                out2.write(bval, 0, bval.length);
                            } else {
                                val = null;
                            }
                        } else {
                            throw new IllegalArgumentException("Invalid property value: " + val);
                        }
                    }
                    if ((data = out2.toByteArray()).length > 255) {
                        throw new IOException("Cannot have individual values larger that 255 chars. Offending value: " + key + (val != null ? "" : "=" + val));
                    }
                    out.write((byte)data.length);
                    out.write(data, 0, data.length);
                }
                text = out.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected exception: " + e);
            }
        }
        return text != null && text.length > 0 ? text : EMPTY_TXT;
    }

    public static byte[] encodeText(String text) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
        ByteWrangler.writeUTF(out2, text);
        byte[] data = out2.toByteArray();
        if (data.length > 255) {
            throw new IOException("Cannot have individual values larger that 255 chars. Offending value: " + text);
        }
        out.write((byte)data.length);
        out.write(data, 0, data.length);
        byte[] encodedText = out.toByteArray();
        return encodedText.length > 0 ? encodedText : EMPTY_TXT;
    }
}

