/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsAEADCipher
implements TlsCipher {
    public static final int NONCE_RFC5288 = 1;
    public static final int NONCE_RFC7905 = 2;
    protected final TlsCryptoParameters cryptoParams;
    protected final int macSize;
    protected final int record_iv_length;
    protected final TlsAEADCipherImpl decryptCipher;
    protected final TlsAEADCipherImpl encryptCipher;
    protected final byte[] encryptImplicitNonce;
    protected final byte[] decryptImplicitNonce;
    protected final int nonceMode;

    public TlsAEADCipher(TlsCryptoParameters tlsCryptoParameters, TlsAEADCipherImpl tlsAEADCipherImpl, TlsAEADCipherImpl tlsAEADCipherImpl2, int n, int n2) throws IOException {
        this(tlsCryptoParameters, tlsAEADCipherImpl, tlsAEADCipherImpl2, n, n2, 1);
    }

    public TlsAEADCipher(TlsCryptoParameters tlsCryptoParameters, TlsAEADCipherImpl tlsAEADCipherImpl, TlsAEADCipherImpl tlsAEADCipherImpl2, int n, int n2, int n3) throws IOException {
        TlsAEADCipherImpl tlsAEADCipherImpl3;
        TlsAEADCipherImpl tlsAEADCipherImpl4;
        int n4;
        if (!TlsImplUtils.isTLSv12(tlsCryptoParameters)) {
            throw new TlsFatalAlert(80);
        }
        this.nonceMode = n3;
        switch (n3) {
            case 1: {
                n4 = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                n4 = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.cryptoParams = tlsCryptoParameters;
        this.macSize = n2;
        this.encryptCipher = tlsAEADCipherImpl;
        this.decryptCipher = tlsAEADCipherImpl2;
        if (tlsCryptoParameters.isServer()) {
            tlsAEADCipherImpl4 = tlsAEADCipherImpl2;
            tlsAEADCipherImpl3 = tlsAEADCipherImpl;
        } else {
            tlsAEADCipherImpl4 = tlsAEADCipherImpl;
            tlsAEADCipherImpl3 = tlsAEADCipherImpl2;
        }
        int n5 = 2 * n + 2 * n4;
        byte[] byArray = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n5);
        int n6 = 0;
        tlsAEADCipherImpl4.setKey(byArray, n6, n);
        tlsAEADCipherImpl3.setKey(byArray, n6 += n, n);
        byte[] byArray2 = Arrays.copyOfRange((byte[])byArray, (int)(n6 += n), (int)(n6 + n4));
        byte[] byArray3 = Arrays.copyOfRange((byte[])byArray, (int)(n6 += n4), (int)(n6 + n4));
        if ((n6 += n4) != n5) {
            throw new TlsFatalAlert(80);
        }
        if (tlsCryptoParameters.isServer()) {
            this.encryptImplicitNonce = byArray3;
            this.decryptImplicitNonce = byArray2;
        } else {
            this.encryptImplicitNonce = byArray2;
            this.decryptImplicitNonce = byArray3;
        }
        byte[] byArray4 = new byte[n4 + this.record_iv_length];
        this.encryptCipher.init(byArray4, n2, null);
        this.decryptCipher.init(byArray4, n2, null);
    }

    @Override
    public int getCiphertextLimit(int n) {
        return n + this.macSize + this.record_iv_length;
    }

    @Override
    public int getPlaintextLimit(int n) {
        return n - this.macSize - this.record_iv_length;
    }

    @Override
    public byte[] encodePlaintext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        byte[] byArray2 = new byte[this.encryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptImplicitNonce, 0, byArray2, 0, this.encryptImplicitNonce.length);
                TlsUtils.writeUint64(l, byArray2, this.encryptImplicitNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(l, byArray2, byArray2.length - 8);
                for (n3 = 0; n3 < this.encryptImplicitNonce.length; ++n3) {
                    int n4 = n3;
                    byArray2[n4] = (byte)(byArray2[n4] ^ this.encryptImplicitNonce[n3]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n3 = n;
        int n5 = n2;
        int n6 = this.encryptCipher.getOutputSize(n5);
        byte[] byArray3 = new byte[this.record_iv_length + n6];
        if (this.record_iv_length != 0) {
            System.arraycopy(byArray2, byArray2.length - this.record_iv_length, byArray3, 0, this.record_iv_length);
        }
        int n7 = this.record_iv_length;
        byte[] byArray4 = this.getAdditionalData(l, s, n5);
        try {
            this.encryptCipher.init(byArray2, this.macSize, byArray4);
            n7 += this.encryptCipher.doFinal(byArray, n3, n5, byArray3, n7);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80, (Throwable)exception);
        }
        if (n7 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    @Override
    public byte[] decodeCiphertext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.getPlaintextLimit(n2) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray2 = new byte[this.decryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.decryptImplicitNonce, 0, byArray2, 0, this.decryptImplicitNonce.length);
                System.arraycopy(byArray, n, byArray2, byArray2.length - this.record_iv_length, this.record_iv_length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(l, byArray2, byArray2.length - 8);
                for (n3 = 0; n3 < this.decryptImplicitNonce.length; ++n3) {
                    int n4 = n3;
                    byArray2[n4] = (byte)(byArray2[n4] ^ this.decryptImplicitNonce[n3]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n3 = n + this.record_iv_length;
        int n5 = n2 - this.record_iv_length;
        int n6 = this.decryptCipher.getOutputSize(n5);
        byte[] byArray3 = new byte[n6];
        int n7 = 0;
        byte[] byArray4 = this.getAdditionalData(l, s, n6);
        try {
            this.decryptCipher.init(byArray2, this.macSize, byArray4);
            n7 += this.decryptCipher.doFinal(byArray, n3, n5, byArray3, n7);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(20, (Throwable)exception);
        }
        if (n7 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    protected byte[] getAdditionalData(long l, short s, int n) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(l, byArray, 0);
        TlsUtils.writeUint8(s, byArray, 8);
        TlsUtils.writeVersion(this.cryptoParams.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(n, byArray, 11);
        return byArray;
    }
}

