/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.encoder2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.encoder.Encoder;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.encoder2.EncodeDecodeParam;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapTextArea;

public class EncodeDecodeDialog
extends AbstractFrame {
    private static final long serialVersionUID = 1L;
    public static final String ENCODE_DECODE_FIELD = "EncodeDecodeInputField";
    public static final String ENCODE_DECODE_RESULTFIELD = "EncodeDecodeResultField";
    private static final Logger log = Logger.getLogger(EncodeDecodeDialog.class);
    private JTabbedPane jTabbed = null;
    private JPanel jPanel = null;
    private ZapTextArea inputField = null;
    private ZapTextArea base64EncodeField = null;
    private ZapTextArea base64DecodeField = null;
    private ZapTextArea base64urlEncodeField = null;
    private ZapTextArea base64urlDecodeField = null;
    private ZapTextArea urlEncodeField = null;
    private ZapTextArea urlDecodeField = null;
    private ZapTextArea asciiHexEncodeField = null;
    private ZapTextArea asciiHexDecodeField = null;
    private ZapTextArea HTMLEncodeField = null;
    private ZapTextArea HTMLDecodeField = null;
    private ZapTextArea JavaScriptEncodeField = null;
    private ZapTextArea JavaScriptDecodeField = null;
    private ZapTextArea sha1HashField = null;
    private ZapTextArea md5HashField = null;
    private ZapTextArea illegalUTF82ByteField = null;
    private ZapTextArea illegalUTF83ByteField = null;
    private ZapTextArea illegalUTF84ByteField = null;
    private ZapTextArea escapedTextField = null;
    private ZapTextArea unescapedTextField = null;
    private Encoder encoder = null;

    public EncodeDecodeDialog() throws HeadlessException {
        this.initialize();
    }

    private void initialize() {
        this.setAlwaysOnTop(false);
        this.setContentPane(this.getJTabbed());
        this.setTitle(Constant.messages.getString("enc2.title"));
    }

    private void addField(JPanel parent, int index, JComponent c, String title) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = index;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(c);
        jsp.setHorizontalScrollBarPolicy(31);
        jsp.setBorder(BorderFactory.createTitledBorder(null, title, 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
        parent.add((Component)jsp, gbc);
    }

    private JPanel getJTabbed() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setPreferredSize(new Dimension(800, 800));
            this.jPanel.setLayout(new GridBagLayout());
            this.jTabbed = new JTabbedPane();
            this.jTabbed.setPreferredSize(new Dimension(800, 700));
            JPanel jPanel1 = new JPanel();
            jPanel1.setLayout(new GridBagLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new GridBagLayout());
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridBagLayout());
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new GridBagLayout());
            this.addField(jPanel1, 1, this.getBase64EncodeField(), Constant.messages.getString("enc2.label.b64Enc"));
            this.addField(jPanel1, 2, this.getBase64urlEncodeField(), Constant.messages.getString("enc2.label.b64urlEnc"));
            this.addField(jPanel1, 3, this.getUrlEncodeField(), Constant.messages.getString("enc2.label.urlEnc"));
            this.addField(jPanel1, 4, this.getAsciiHexEncodeField(), Constant.messages.getString("enc2.label.asciiEnc"));
            this.addField(jPanel1, 5, this.getHTMLEncodeField(), Constant.messages.getString("enc2.label.HTMLEnc"));
            this.addField(jPanel1, 6, this.getJavaScriptEncodeField(), Constant.messages.getString("enc2.label.JavaScriptEnc"));
            this.addField(jPanel2, 1, this.getBase64DecodeField(), Constant.messages.getString("enc2.label.b64Dec"));
            this.addField(jPanel2, 2, this.getBase64urlDecodeField(), Constant.messages.getString("enc2.label.b64urlDec"));
            this.addField(jPanel2, 3, this.getUrlDecodeField(), Constant.messages.getString("enc2.label.urlDec"));
            this.addField(jPanel2, 4, this.getAsciiHexDecodeField(), Constant.messages.getString("enc2.label.asciiDec"));
            this.addField(jPanel2, 5, this.getHTMLDecodeField(), Constant.messages.getString("enc2.label.HTMLDec"));
            this.addField(jPanel2, 6, this.getJavaScriptDecodeField(), Constant.messages.getString("enc2.label.JavaScriptDec"));
            this.addField(jPanel3, 1, this.getSha1HashField(), Constant.messages.getString("enc2.label.sha1Hash"));
            this.addField(jPanel3, 2, this.getMd5HashField(), Constant.messages.getString("enc2.label.md5Hash"));
            this.addField(jPanel4, 1, this.getIllegalUTF82ByteField(), Constant.messages.getString("enc2.label.illegalUTF8.2byte"));
            this.addField(jPanel4, 2, this.getIllegalUTF83ByteField(), Constant.messages.getString("enc2.label.illegalUTF8.3byte"));
            this.addField(jPanel4, 3, this.getIllegalUTF84ByteField(), Constant.messages.getString("enc2.label.illegalUTF8.4byte"));
            this.addField(jPanel5, 1, this.getEscapedTextField(), Constant.messages.getString("enc2.label.unicode.escapedText"));
            this.addField(jPanel5, 2, this.getUnescapedTextField(), Constant.messages.getString("enc2.label.unicode.unescapedText"));
            this.jTabbed.addTab(Constant.messages.getString("enc2.tab.encode"), jPanel1);
            this.jTabbed.addTab(Constant.messages.getString("enc2.tab.decode"), jPanel2);
            this.jTabbed.addTab(Constant.messages.getString("enc2.tab.hash"), jPanel3);
            this.jTabbed.addTab(Constant.messages.getString("enc2.tab.illegalUTF8"), jPanel4);
            this.jTabbed.addTab(Constant.messages.getString("enc2.tab.unicode"), jPanel5);
            GridBagConstraints gbc1 = new GridBagConstraints();
            gbc1.gridx = 0;
            gbc1.gridy = 1;
            gbc1.insets = new Insets(1, 1, 1, 1);
            gbc1.anchor = 18;
            gbc1.fill = 1;
            gbc1.weightx = 1.0;
            gbc1.weighty = 0.25;
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.gridx = 0;
            gbc2.gridy = 2;
            gbc2.insets = new Insets(1, 1, 1, 1);
            gbc2.anchor = 18;
            gbc2.fill = 1;
            gbc2.weightx = 1.0;
            gbc2.weighty = 1.0;
            JScrollPane jsp = new JScrollPane();
            jsp.setViewportView(this.getInputField());
            jsp.setHorizontalScrollBarPolicy(31);
            jsp.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("enc2.label.text"), 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            this.jPanel.add((Component)jsp, gbc1);
            this.jPanel.add((Component)this.jTabbed, gbc2);
            jPanel2.requestFocus();
        }
        return this.jPanel;
    }

    private ZapTextArea newField(boolean editable) {
        ZapTextArea field = new ZapTextArea();
        field.setLineWrap(true);
        field.setBorder(BorderFactory.createEtchedBorder());
        field.setEditable(editable);
        field.setName(ENCODE_DECODE_RESULTFIELD);
        field.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    View.getSingleton().getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return field;
    }

    private ZapTextArea getInputField() {
        if (this.inputField == null) {
            this.inputField = this.newField(true);
            this.inputField.setName(ENCODE_DECODE_FIELD);
            this.inputField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    EncodeDecodeDialog.this.updateEncodeDecodeFields();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    EncodeDecodeDialog.this.updateEncodeDecodeFields();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            });
            this.inputField.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        View.getSingleton().getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        return this.inputField;
    }

    private ZapTextArea getBase64EncodeField() {
        if (this.base64EncodeField == null) {
            this.base64EncodeField = this.newField(false);
        }
        return this.base64EncodeField;
    }

    private ZapTextArea getBase64DecodeField() {
        if (this.base64DecodeField == null) {
            this.base64DecodeField = this.newField(false);
        }
        return this.base64DecodeField;
    }

    private ZapTextArea getBase64urlEncodeField() {
        if (this.base64urlEncodeField == null) {
            this.base64urlEncodeField = this.newField(false);
        }
        return this.base64urlEncodeField;
    }

    private ZapTextArea getBase64urlDecodeField() {
        if (this.base64urlDecodeField == null) {
            this.base64urlDecodeField = this.newField(false);
        }
        return this.base64urlDecodeField;
    }

    private ZapTextArea getUrlEncodeField() {
        if (this.urlEncodeField == null) {
            this.urlEncodeField = this.newField(false);
        }
        return this.urlEncodeField;
    }

    private ZapTextArea getUrlDecodeField() {
        if (this.urlDecodeField == null) {
            this.urlDecodeField = this.newField(false);
        }
        return this.urlDecodeField;
    }

    private ZapTextArea getAsciiHexEncodeField() {
        if (this.asciiHexEncodeField == null) {
            this.asciiHexEncodeField = this.newField(false);
        }
        return this.asciiHexEncodeField;
    }

    private ZapTextArea getAsciiHexDecodeField() {
        if (this.asciiHexDecodeField == null) {
            this.asciiHexDecodeField = this.newField(false);
        }
        return this.asciiHexDecodeField;
    }

    private ZapTextArea getHTMLEncodeField() {
        if (this.HTMLEncodeField == null) {
            this.HTMLEncodeField = this.newField(false);
        }
        return this.HTMLEncodeField;
    }

    private ZapTextArea getHTMLDecodeField() {
        if (this.HTMLDecodeField == null) {
            this.HTMLDecodeField = this.newField(false);
        }
        return this.HTMLDecodeField;
    }

    private ZapTextArea getJavaScriptEncodeField() {
        if (this.JavaScriptEncodeField == null) {
            this.JavaScriptEncodeField = this.newField(false);
        }
        return this.JavaScriptEncodeField;
    }

    private ZapTextArea getJavaScriptDecodeField() {
        if (this.JavaScriptDecodeField == null) {
            this.JavaScriptDecodeField = this.newField(false);
        }
        return this.JavaScriptDecodeField;
    }

    private ZapTextArea getSha1HashField() {
        if (this.sha1HashField == null) {
            this.sha1HashField = this.newField(false);
        }
        return this.sha1HashField;
    }

    private ZapTextArea getMd5HashField() {
        if (this.md5HashField == null) {
            this.md5HashField = this.newField(false);
        }
        return this.md5HashField;
    }

    private ZapTextArea getIllegalUTF82ByteField() {
        if (this.illegalUTF82ByteField == null) {
            this.illegalUTF82ByteField = this.newField(false);
        }
        return this.illegalUTF82ByteField;
    }

    private ZapTextArea getIllegalUTF83ByteField() {
        if (this.illegalUTF83ByteField == null) {
            this.illegalUTF83ByteField = this.newField(false);
        }
        return this.illegalUTF83ByteField;
    }

    private ZapTextArea getIllegalUTF84ByteField() {
        if (this.illegalUTF84ByteField == null) {
            this.illegalUTF84ByteField = this.newField(false);
        }
        return this.illegalUTF84ByteField;
    }

    private ZapTextArea getEscapedTextField() {
        if (this.escapedTextField == null) {
            this.escapedTextField = this.newField(false);
        }
        return this.escapedTextField;
    }

    private ZapTextArea getUnescapedTextField() {
        if (this.unescapedTextField == null) {
            this.unescapedTextField = this.newField(false);
        }
        return this.unescapedTextField;
    }

    private Encoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new Encoder();
        }
        return this.encoder;
    }

    public String decodeHexString(String hexText) {
        String decodedText = "";
        String chunk = null;
        if (hexText != null && hexText.length() > 0) {
            int numBytes = hexText.length() / 2;
            byte[] rawToByte = new byte[numBytes];
            int offset = 0;
            for (int i = 0; i < numBytes; ++i) {
                chunk = hexText.substring(offset, offset + 2);
                offset += 2;
                rawToByte[i] = (byte)(Integer.parseInt(chunk, 16) & 0xFF);
            }
            decodedText = new String(rawToByte);
        }
        return decodedText;
    }

    public String decodeHTMLString(String HTMLText) {
        return StringEscapeUtils.unescapeHtml((String)HTMLText);
    }

    public String decodeJavaScriptString(String JavaScriptText) {
        return StringEscapeUtils.unescapeJavaScript((String)JavaScriptText);
    }

    private static String encodeUnicodeString(String str) {
        str = str == null ? "" : str;
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            sb.append("%u");
            int j = c >>> 8;
            String tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append('0');
            }
            sb.append(tmp);
            j = c & 0xFF;
            tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append('0');
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    private static String decodeUnicodeString(String str) {
        String string = str = str == null ? "" : str;
        if (str.indexOf("%u") == -1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= str.length() - 6; i += 6) {
            String strTemp = str.substring(i, i + 6);
            String value = strTemp.substring(2);
            int c = 0;
            for (int j = 0; j < value.length(); ++j) {
                char tempChar = value.charAt(j);
                int t = 0;
                switch (tempChar) {
                    case 'a': {
                        t = 10;
                        break;
                    }
                    case 'b': {
                        t = 11;
                        break;
                    }
                    case 'c': {
                        t = 12;
                        break;
                    }
                    case 'd': {
                        t = 13;
                        break;
                    }
                    case 'e': {
                        t = 14;
                        break;
                    }
                    case 'f': {
                        t = 15;
                        break;
                    }
                    default: {
                        t = tempChar - 48;
                    }
                }
                c += t * (int)Math.pow(16.0, value.length() - j - 1);
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    private void updateEncodeDecodeFields() {
        try {
            this.base64EncodeField.setText(this.getEncoder().getBase64Encode(this.getInputField().getText()));
        }
        catch (IOException | NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.base64DecodeField.setText(this.getEncoder().getBase64Decode(this.getInputField().getText()));
            this.base64DecodeField.setEnabled(this.base64DecodeField.getText().length() > 0);
        }
        catch (IOException | IllegalArgumentException e) {
            this.base64DecodeField.setText(e.getMessage());
            this.base64DecodeField.setEnabled(false);
        }
        try {
            this.base64urlEncodeField.setText(this.getEncoder().getBase64urlEncode(this.getInputField().getText()));
        }
        catch (IOException | NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.base64urlDecodeField.setText(this.getEncoder().getBase64urlDecode(this.getInputField().getText()));
            this.base64urlDecodeField.setEnabled(this.base64urlDecodeField.getText().length() > 0);
        }
        catch (IOException | IllegalArgumentException e) {
            this.base64urlDecodeField.setText(e.getMessage());
            this.base64urlDecodeField.setEnabled(false);
        }
        this.urlEncodeField.setText(this.getEncoder().getURLEncode(this.getInputField().getText()));
        try {
            this.urlDecodeField.setText(this.getEncoder().getURLDecode(this.getInputField().getText()));
        }
        catch (Exception e) {
            this.urlDecodeField.setText("");
        }
        this.urlDecodeField.setEnabled(this.urlDecodeField.getText().length() > 0);
        this.asciiHexEncodeField.setText(this.getEncoder().getHexString(this.getInputField().getText().getBytes()));
        try {
            this.asciiHexDecodeField.setText(this.decodeHexString(this.getInputField().getText()));
        }
        catch (Exception e) {
            this.asciiHexDecodeField.setText("");
        }
        this.asciiHexDecodeField.setEnabled(this.asciiHexDecodeField.getText().length() > 0);
        this.HTMLEncodeField.setText(this.getEncoder().getHTMLString(this.getInputField().getText()));
        try {
            this.HTMLDecodeField.setText(this.decodeHTMLString(this.getInputField().getText()));
        }
        catch (Exception e) {
            this.HTMLDecodeField.setText("");
        }
        this.HTMLDecodeField.setEnabled(this.HTMLDecodeField.getText().length() > 0);
        this.JavaScriptEncodeField.setText(this.getEncoder().getJavaScriptString(this.getInputField().getText()));
        try {
            this.JavaScriptDecodeField.setText(this.decodeJavaScriptString(this.getInputField().getText()));
        }
        catch (Exception e) {
            this.JavaScriptDecodeField.setText("");
        }
        this.JavaScriptDecodeField.setEnabled(this.JavaScriptDecodeField.getText().length() > 0);
        try {
            this.sha1HashField.setText(this.getEncoder().getHexString(this.getEncoder().getHashSHA1(this.getInputField().getText().getBytes())));
        }
        catch (Exception e) {
            this.sha1HashField.setText("");
        }
        try {
            this.md5HashField.setText(this.getEncoder().getHexString(this.getEncoder().getHashMD5(this.getInputField().getText().getBytes())));
        }
        catch (Exception e) {
            this.md5HashField.setText("");
        }
        try {
            this.illegalUTF82ByteField.setText(this.getEncoder().getIllegalUTF8Encode(this.getInputField().getText(), 2));
        }
        catch (Exception e) {
            this.illegalUTF82ByteField.setText("");
        }
        try {
            this.illegalUTF83ByteField.setText(this.getEncoder().getIllegalUTF8Encode(this.getInputField().getText(), 3));
        }
        catch (Exception e) {
            this.illegalUTF83ByteField.setText("");
        }
        try {
            this.illegalUTF84ByteField.setText(this.getEncoder().getIllegalUTF8Encode(this.getInputField().getText(), 4));
        }
        catch (Exception e) {
            this.illegalUTF84ByteField.setText("");
        }
        try {
            this.escapedTextField.setText(EncodeDecodeDialog.encodeUnicodeString(this.getInputField().getText()));
        }
        catch (Exception e) {
            this.escapedTextField.setText("");
        }
        try {
            this.unescapedTextField.setText(EncodeDecodeDialog.decodeUnicodeString(this.getInputField().getText()));
        }
        catch (Exception e) {
            this.unescapedTextField.setText("");
        }
    }

    public void setInputField(String text) {
        this.getInputField().setText(text);
        this.updateEncodeDecodeFields();
    }

    public void updateOptions(EncodeDecodeParam options) {
        this.getEncoder().setBase64Charset(options.getBase64Charset());
        this.getEncoder().setBase64DoBreakLines(options.isBase64DoBreakLines());
        this.updateEncodeDecodeFields();
    }
}

