/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.WebAnnotationSet;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.IOTools;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.res.StringManager;

public class Tomcat {
    private static final StringManager sm = StringManager.getManager(Tomcat.class);
    private final Map<String, Logger> pinnedLoggers = new HashMap<String, Logger>();
    protected Server server;
    protected Service service;
    protected Engine engine;
    protected Connector connector;
    protected Host host;
    protected int port = 8080;
    protected String hostname = "localhost";
    protected String basedir;
    @Deprecated
    protected Realm defaultRealm;
    private final Map<String, String> userPass = new HashMap<String, String>();
    private final Map<String, List<String>> userRoles = new HashMap<String, List<String>>();
    private final Map<String, Principal> userPrincipals = new HashMap<String, Principal>();
    private boolean addDefaultWebXmlToWebapp = true;
    static final String[] silences = new String[]{"org.apache.coyote.http11.Http11Protocol", "org.apache.catalina.core.StandardService", "org.apache.catalina.core.StandardEngine", "org.apache.catalina.startup.ContextConfig", "org.apache.catalina.core.ApplicationContext", "org.apache.catalina.core.AprLifecycleListener"};
    private boolean silent = false;

    public Tomcat() {
        ExceptionUtils.preload();
    }

    public void setBaseDir(String basedir) {
        this.basedir = basedir;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostname(String s) {
        this.hostname = s;
    }

    public Context addWebapp(String contextPath, String docBase) {
        return this.addWebapp(this.getHost(), contextPath, docBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context addWebapp(String contextPath, URL source) throws IOException {
        ContextName cn = new ContextName(contextPath, null);
        Host h = this.getHost();
        if (h.findChild(cn.getName()) != null) {
            throw new IllegalArgumentException(sm.getString("tomcat.addWebapp.conflictChild", new Object[]{source, contextPath, cn.getName()}));
        }
        File targetWar = new File(h.getAppBase(), cn.getBaseName() + ".war");
        File targetDir = new File(h.getAppBase(), cn.getBaseName());
        if (targetWar.exists()) {
            throw new IllegalArgumentException(sm.getString("tomcat.addWebapp.conflictFile", new Object[]{source, contextPath, targetWar.getAbsolutePath()}));
        }
        if (targetDir.exists()) {
            throw new IllegalArgumentException(sm.getString("tomcat.addWebapp.conflictFile", new Object[]{source, contextPath, targetDir.getAbsolutePath()}));
        }
        URLConnection uConn = source.openConnection();
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = uConn.getInputStream();
            os = new FileOutputStream(targetWar);
            IOTools.flow(is, os);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {}
            }
        }
        return this.addWebapp(contextPath, targetWar.getAbsolutePath());
    }

    public Context addContext(String contextPath, String docBase) {
        return this.addContext(this.getHost(), contextPath, docBase);
    }

    public Wrapper addServlet(String contextPath, String servletName, String servletClass) {
        Container ctx = this.getHost().findChild(contextPath);
        return Tomcat.addServlet((Context)ctx, servletName, servletClass);
    }

    public static Wrapper addServlet(Context ctx, String servletName, String servletClass) {
        Wrapper sw = ctx.createWrapper();
        sw.setServletClass(servletClass);
        sw.setName(servletName);
        ctx.addChild(sw);
        return sw;
    }

    public Wrapper addServlet(String contextPath, String servletName, Servlet servlet) {
        Container ctx = this.getHost().findChild(contextPath);
        return Tomcat.addServlet((Context)ctx, servletName, servlet);
    }

    public static Wrapper addServlet(Context ctx, String servletName, Servlet servlet) {
        ExistingStandardWrapper sw = new ExistingStandardWrapper(servlet);
        sw.setName(servletName);
        ctx.addChild(sw);
        return sw;
    }

    public void init() throws LifecycleException {
        this.getServer();
        this.getConnector();
        this.server.init();
    }

    public void start() throws LifecycleException {
        this.getServer();
        this.getConnector();
        this.server.start();
    }

    public void stop() throws LifecycleException {
        this.getServer();
        this.server.stop();
    }

    public void destroy() throws LifecycleException {
        this.getServer();
        this.server.destroy();
    }

    public void addUser(String user, String pass) {
        this.userPass.put(user, pass);
    }

    public void addRole(String user, String role) {
        List<String> roles = this.userRoles.get(user);
        if (roles == null) {
            roles = new ArrayList<String>();
            this.userRoles.put(user, roles);
        }
        roles.add(role);
    }

    public Connector getConnector() {
        this.getServer();
        if (this.connector != null) {
            return this.connector;
        }
        this.connector = new Connector("HTTP/1.1");
        this.connector.setPort(this.port);
        this.service.addConnector(this.connector);
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Service getService() {
        this.getServer();
        return this.service;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public Host getHost() {
        if (this.host == null) {
            this.host = new StandardHost();
            this.host.setName(this.hostname);
            this.getEngine().addChild(this.host);
        }
        return this.host;
    }

    @Deprecated
    public void setDefaultRealm(Realm realm) {
        this.defaultRealm = realm;
    }

    public Engine getEngine() {
        if (this.engine == null) {
            this.getServer();
            this.engine = new StandardEngine();
            this.engine.setName("Tomcat");
            this.engine.setDefaultHost(this.hostname);
            if (this.defaultRealm == null) {
                this.initSimpleAuth();
            }
            this.engine.setRealm(this.defaultRealm);
            this.service.setContainer(this.engine);
        }
        return this.engine;
    }

    public Server getServer() {
        if (this.server != null) {
            return this.server;
        }
        this.initBaseDir();
        System.setProperty("catalina.useNaming", "false");
        this.server = new StandardServer();
        this.server.setPort(-1);
        this.service = new StandardService();
        this.service.setName("Tomcat");
        this.server.addService(this.service);
        return this.server;
    }

    public Context addContext(Host host, String contextPath, String dir) {
        return this.addContext(host, contextPath, contextPath, dir);
    }

    public Context addContext(Host host, String contextPath, String contextName, String dir) {
        this.silence(host, contextName);
        Context ctx = this.createContext(host, contextPath);
        ctx.setName(contextName);
        ctx.setPath(contextPath);
        ctx.setDocBase(dir);
        ctx.addLifecycleListener(new FixContextListener());
        if (host == null) {
            this.getHost().addChild(ctx);
        } else {
            host.addChild(ctx);
        }
        return ctx;
    }

    public Context addWebapp(Host host, String contextPath, String docBase) {
        LifecycleListener listener = null;
        try {
            Class<?> clazz = Class.forName(this.getHost().getConfigClass());
            listener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return this.addWebapp(host, contextPath, docBase, listener);
    }

    @Deprecated
    public Context addWebapp(Host host, String contextPath, String name, String docBase) {
        return this.addWebapp(host, contextPath, docBase);
    }

    public Context addWebapp(Host host, String contextPath, String docBase, LifecycleListener config) {
        this.silence(host, contextPath);
        Context ctx = this.createContext(host, contextPath);
        ctx.setPath(contextPath);
        ctx.setDocBase(docBase);
        if (this.addDefaultWebXmlToWebapp) {
            ctx.addLifecycleListener(this.getDefaultWebXmlListener());
        }
        ctx.setConfigFile(this.getWebappConfigFile(docBase, contextPath));
        ctx.addLifecycleListener(config);
        if (this.addDefaultWebXmlToWebapp && config instanceof ContextConfig) {
            ((ContextConfig)config).setDefaultWebXml(this.noDefaultWebXmlPath());
        }
        if (host == null) {
            this.getHost().addChild(ctx);
        } else {
            host.addChild(ctx);
        }
        return ctx;
    }

    public LifecycleListener getDefaultWebXmlListener() {
        return new DefaultWebXmlListener();
    }

    public String noDefaultWebXmlPath() {
        return "org/apache/catalina/startup/NO_DEFAULT_XML";
    }

    @Deprecated
    public Realm getDefaultRealm() {
        if (this.defaultRealm == null) {
            this.initSimpleAuth();
        }
        return this.defaultRealm;
    }

    @Deprecated
    protected void initSimpleAuth() {
        this.defaultRealm = new RealmBase(){

            @Override
            protected String getName() {
                return "Simple";
            }

            @Override
            protected String getPassword(String username) {
                return (String)Tomcat.this.userPass.get(username);
            }

            @Override
            protected Principal getPrincipal(String username) {
                String pass;
                Principal p = (Principal)Tomcat.this.userPrincipals.get(username);
                if (p == null && (pass = (String)Tomcat.this.userPass.get(username)) != null) {
                    p = new GenericPrincipal(username, pass, (List)Tomcat.this.userRoles.get(username));
                    Tomcat.this.userPrincipals.put(username, p);
                }
                return p;
            }
        };
    }

    protected void initBaseDir() {
        String catalinaHome = System.getProperty("catalina.home");
        if (this.basedir == null) {
            this.basedir = System.getProperty("catalina.base");
        }
        if (this.basedir == null) {
            this.basedir = catalinaHome;
        }
        if (this.basedir == null) {
            this.basedir = System.getProperty("user.dir") + "/tomcat." + this.port;
            File home = new File(this.basedir);
            home.mkdir();
            if (!home.isAbsolute()) {
                try {
                    this.basedir = home.getCanonicalPath();
                }
                catch (IOException e) {
                    this.basedir = home.getAbsolutePath();
                }
            }
        }
        if (catalinaHome == null) {
            System.setProperty("catalina.home", this.basedir);
        }
        System.setProperty("catalina.base", this.basedir);
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        for (String s : silences) {
            Logger logger = Logger.getLogger(s);
            this.pinnedLoggers.put(s, logger);
            if (silent) {
                logger.setLevel(Level.WARNING);
                continue;
            }
            logger.setLevel(Level.INFO);
        }
    }

    private void silence(Host host, String contextPath) {
        String loggerName = this.getLoggerName(host, contextPath);
        Logger logger = Logger.getLogger(loggerName);
        this.pinnedLoggers.put(loggerName, logger);
        if (this.silent) {
            logger.setLevel(Level.WARNING);
        } else {
            logger.setLevel(Level.INFO);
        }
    }

    public void setAddDefaultWebXmlToWebapp(boolean addDefaultWebXmlToWebapp) {
        this.addDefaultWebXmlToWebapp = addDefaultWebXmlToWebapp;
    }

    private String getLoggerName(Host host, String contextName) {
        if (host == null) {
            host = this.getHost();
        }
        StringBuilder loggerName = new StringBuilder();
        loggerName.append(ContainerBase.class.getName());
        loggerName.append(".[");
        loggerName.append(host.getParent().getName());
        loggerName.append("].[");
        loggerName.append(host.getName());
        loggerName.append("].[");
        if (contextName == null || contextName.equals("")) {
            loggerName.append("/");
        } else if (contextName.startsWith("##")) {
            loggerName.append("/");
            loggerName.append(contextName);
        }
        loggerName.append(']');
        return loggerName.toString();
    }

    private Context createContext(Host host, String url) {
        String contextClass = StandardContext.class.getName();
        if (host == null) {
            host = this.getHost();
        }
        if (host instanceof StandardHost) {
            contextClass = ((StandardHost)host).getContextClass();
        }
        try {
            return (Context)Class.forName(contextClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url, e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url, e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url, e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url, e);
        }
    }

    public void enableNaming() {
        this.getServer();
        this.server.addLifecycleListener(new NamingContextListener());
        System.setProperty("catalina.useNaming", "true");
        String value = "org.apache.naming";
        String oldValue = System.getProperty("java.naming.factory.url.pkgs");
        if (oldValue != null) {
            value = oldValue.contains(value) ? oldValue : value + ":" + oldValue;
        }
        System.setProperty("java.naming.factory.url.pkgs", value);
        value = System.getProperty("java.naming.factory.initial");
        if (value == null) {
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        }
    }

    public void initWebappDefaults(String contextPath) {
        Container ctx = this.getHost().findChild(contextPath);
        Tomcat.initWebappDefaults((Context)ctx);
    }

    public static void initWebappDefaults(Context ctx) {
        Wrapper servlet = Tomcat.addServlet(ctx, "default", "org.apache.catalina.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.setOverridable(true);
        servlet = Tomcat.addServlet(ctx, "jsp", "org.apache.jasper.servlet.JspServlet");
        servlet.addInitParameter("fork", "false");
        servlet.setLoadOnStartup(3);
        servlet.setOverridable(true);
        ctx.addServletMapping("/", "default");
        ctx.addServletMapping("*.jsp", "jsp");
        ctx.addServletMapping("*.jspx", "jsp");
        ctx.setSessionTimeout(30);
        Tomcat.addDefaultMimeTypeMappings(ctx);
        ctx.addWelcomeFile("index.html");
        ctx.addWelcomeFile("index.htm");
        ctx.addWelcomeFile("index.jsp");
    }

    public static void addDefaultMimeTypeMappings(Context context) {
        Properties defaultMimeMappings = new Properties();
        InputStream is = null;
        try {
            is = Tomcat.class.getResourceAsStream("MimeTypeMappings.properties");
            defaultMimeMappings.load(is);
            for (Map.Entry<Object, Object> entry : defaultMimeMappings.entrySet()) {
                context.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(sm.getString("tomcat.defaultMimeTypeMappingsFail"), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected URL getWebappConfigFile(String path, String contextName) {
        File docBase = new File(path);
        if (docBase.isDirectory()) {
            return this.getWebappConfigFileFromDirectory(docBase, contextName);
        }
        return this.getWebappConfigFileFromWar(docBase, contextName);
    }

    private URL getWebappConfigFileFromDirectory(File docBase, String contextName) {
        URL result = null;
        File webAppContextXml = new File(docBase, "META-INF/context.xml");
        if (webAppContextXml.exists()) {
            try {
                result = webAppContextXml.toURI().toURL();
            }
            catch (MalformedURLException e) {
                Logger.getLogger(this.getLoggerName(this.getHost(), contextName)).log(Level.WARNING, "Unable to determine web application context.xml " + docBase, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getWebappConfigFileFromWar(File docBase, String contextName) {
        URL result = null;
        JarFile jar = null;
        try {
            jar = new JarFile(docBase);
            JarEntry entry = jar.getJarEntry("META-INF/context.xml");
            if (entry != null) {
                result = UriUtil.buildJarUrl((File)docBase, (String)"META-INF/context.xml");
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getLoggerName(this.getHost(), contextName)).log(Level.WARNING, "Unable to determine web application context.xml " + docBase, e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public static class ExistingStandardWrapper
    extends StandardWrapper {
        private final Servlet existing;

        public ExistingStandardWrapper(Servlet existing) {
            this.existing = existing;
            if (existing instanceof SingleThreadModel) {
                this.singleThreadModel = true;
                this.instancePool = new Stack();
            }
        }

        @Override
        public synchronized Servlet loadServlet() throws ServletException {
            if (this.singleThreadModel) {
                Servlet instance;
                try {
                    instance = (Servlet)this.existing.getClass().newInstance();
                }
                catch (InstantiationException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ServletException((Throwable)e);
                }
                instance.init((ServletConfig)this.facade);
                return instance;
            }
            if (!this.instanceInitialized) {
                this.existing.init((ServletConfig)this.facade);
                this.instanceInitialized = true;
            }
            return this.existing;
        }

        @Override
        public long getAvailable() {
            return 0L;
        }

        @Override
        public boolean isUnavailable() {
            return false;
        }

        @Override
        public Servlet getServlet() {
            return this.existing;
        }

        @Override
        public String getServletClass() {
            return this.existing.getClass().getName();
        }
    }

    public static class DefaultWebXmlListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            if ("before_start".equals(event.getType())) {
                Tomcat.initWebappDefaults((Context)event.getLifecycle());
            }
        }
    }

    public static class FixContextListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            try {
                Context context = (Context)event.getLifecycle();
                if (event.getType().equals("configure_start")) {
                    context.setConfigured(true);
                    WebAnnotationSet.loadApplicationAnnotations(context);
                    if (context.getLoginConfig() == null) {
                        context.setLoginConfig(new LoginConfig("NONE", null, null, null));
                        context.getPipeline().addValve(new NonLoginAuthenticator());
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

