# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
"""
Endpoints and datatypes for Cloud Docs.
"""

try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (ImportError, SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

try:
    from . import (
        files,
    )
except (ImportError, SystemError, ValueError):
    import files

class CloudDocsAccessError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar cloud_docs.CloudDocsAccessError.invalid_doc_id: The Cloud Doc ID is
        invalid.
    :ivar cloud_docs.CloudDocsAccessError.not_found: A Cloud Doc could not be
        found for the given ID.
    :ivar cloud_docs.CloudDocsAccessError.permission_denied: Permission denied
        for the Cloud Doc with the given ID.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_doc_id = None
    # Attribute is overwritten below the class definition
    not_found = None
    # Attribute is overwritten below the class definition
    permission_denied = None
    # Attribute is overwritten below the class definition
    other = None

    def is_invalid_doc_id(self):
        """
        Check if the union tag is ``invalid_doc_id``.

        :rtype: bool
        """
        return self._tag == 'invalid_doc_id'

    def is_not_found(self):
        """
        Check if the union tag is ``not_found``.

        :rtype: bool
        """
        return self._tag == 'not_found'

    def is_permission_denied(self):
        """
        Check if the union tag is ``permission_denied``.

        :rtype: bool
        """
        return self._tag == 'permission_denied'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(CloudDocsAccessError, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'CloudDocsAccessError(%r, %r)' % (self._tag, self._value)

CloudDocsAccessError_validator = bv.Union(CloudDocsAccessError)

class Content(bb.Struct):
    """
    :ivar cloud_docs.Content.content_key: The key returned from an
        upload_additional_content response.
    """

    __slots__ = [
        '_purpose_value',
        '_purpose_present',
        '_content_key_value',
        '_content_key_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 purpose=None,
                 content_key=None):
        self._purpose_value = None
        self._purpose_present = False
        self._content_key_value = None
        self._content_key_present = False
        if purpose is not None:
            self.purpose = purpose
        if content_key is not None:
            self.content_key = content_key

    @property
    def purpose(self):
        """
        :rtype: ContentPurpose
        """
        if self._purpose_present:
            return self._purpose_value
        else:
            raise AttributeError("missing required field 'purpose'")

    @purpose.setter
    def purpose(self, val):
        self._purpose_validator.validate_type_only(val)
        self._purpose_value = val
        self._purpose_present = True

    @purpose.deleter
    def purpose(self):
        self._purpose_value = None
        self._purpose_present = False

    @property
    def content_key(self):
        """
        The key returned from an upload_additional_content response.

        :rtype: str
        """
        if self._content_key_present:
            return self._content_key_value
        else:
            raise AttributeError("missing required field 'content_key'")

    @content_key.setter
    def content_key(self, val):
        val = self._content_key_validator.validate(val)
        self._content_key_value = val
        self._content_key_present = True

    @content_key.deleter
    def content_key(self):
        self._content_key_value = None
        self._content_key_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(Content, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'Content(purpose={!r}, content_key={!r})'.format(
            self._purpose_value,
            self._content_key_value,
        )

Content_validator = bv.Struct(Content)

class ContentPurpose(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    search = None
    # Attribute is overwritten below the class definition
    preview = None
    # Attribute is overwritten below the class definition
    other = None

    def is_search(self):
        """
        Check if the union tag is ``search``.

        :rtype: bool
        """
        return self._tag == 'search'

    def is_preview(self):
        """
        Check if the union tag is ``preview``.

        :rtype: bool
        """
        return self._tag == 'preview'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(ContentPurpose, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'ContentPurpose(%r, %r)' % (self._tag, self._value)

ContentPurpose_validator = bv.Union(ContentPurpose)

class GenericErrorTag(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar cloud_docs.GenericErrorTag.invalid_argument: Invalid argument
        supplied.
    :ivar cloud_docs.GenericErrorTag.unauthenticated: User is unauthenticated.
    :ivar cloud_docs.GenericErrorTag.permission_denied: User does not have
        access to the specified doc.
    :ivar cloud_docs.GenericErrorTag.doc_not_found: Doc could not be found based
        on the supplied doc ID.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_argument = None
    # Attribute is overwritten below the class definition
    unauthenticated = None
    # Attribute is overwritten below the class definition
    permission_denied = None
    # Attribute is overwritten below the class definition
    doc_not_found = None
    # Attribute is overwritten below the class definition
    other = None

    def is_invalid_argument(self):
        """
        Check if the union tag is ``invalid_argument``.

        :rtype: bool
        """
        return self._tag == 'invalid_argument'

    def is_unauthenticated(self):
        """
        Check if the union tag is ``unauthenticated``.

        :rtype: bool
        """
        return self._tag == 'unauthenticated'

    def is_permission_denied(self):
        """
        Check if the union tag is ``permission_denied``.

        :rtype: bool
        """
        return self._tag == 'permission_denied'

    def is_doc_not_found(self):
        """
        Check if the union tag is ``doc_not_found``.

        :rtype: bool
        """
        return self._tag == 'doc_not_found'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GenericErrorTag, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GenericErrorTag(%r, %r)' % (self._tag, self._value)

GenericErrorTag_validator = bv.Union(GenericErrorTag)

class GetContentArg(bb.Struct):

    __slots__ = [
        '_file_id_value',
        '_file_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 file_id=None):
        self._file_id_value = None
        self._file_id_present = False
        if file_id is not None:
            self.file_id = file_id

    @property
    def file_id(self):
        """
        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            raise AttributeError("missing required field 'file_id'")

    @file_id.setter
    def file_id(self, val):
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GetContentArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GetContentArg(file_id={!r})'.format(
            self._file_id_value,
        )

GetContentArg_validator = bv.Struct(GetContentArg)

class GetMetadataArg(bb.Struct):
    """
    :ivar cloud_docs.GetMetadataArg.file_id: API ID ("id:...") associated with
        the Cloud Doc.
    """

    __slots__ = [
        '_file_id_value',
        '_file_id_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 file_id=None):
        self._file_id_value = None
        self._file_id_present = False
        if file_id is not None:
            self.file_id = file_id

    @property
    def file_id(self):
        """
        API ID ("id:...") associated with the Cloud Doc.

        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            return u''

    @file_id.setter
    def file_id(self, val):
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GetMetadataArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GetMetadataArg(file_id={!r})'.format(
            self._file_id_value,
        )

GetMetadataArg_validator = bv.Struct(GetMetadataArg)

class GetMetadataError(bb.Struct):

    __slots__ = [
        '_get_metadata_error_tag_value',
        '_get_metadata_error_tag_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 get_metadata_error_tag=None):
        self._get_metadata_error_tag_value = None
        self._get_metadata_error_tag_present = False
        if get_metadata_error_tag is not None:
            self.get_metadata_error_tag = get_metadata_error_tag

    @property
    def get_metadata_error_tag(self):
        """
        :rtype: GetMetadataErrorTagUnion
        """
        if self._get_metadata_error_tag_present:
            return self._get_metadata_error_tag_value
        else:
            return None

    @get_metadata_error_tag.setter
    def get_metadata_error_tag(self, val):
        if val is None:
            del self.get_metadata_error_tag
            return
        self._get_metadata_error_tag_validator.validate_type_only(val)
        self._get_metadata_error_tag_value = val
        self._get_metadata_error_tag_present = True

    @get_metadata_error_tag.deleter
    def get_metadata_error_tag(self):
        self._get_metadata_error_tag_value = None
        self._get_metadata_error_tag_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GetMetadataError, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GetMetadataError(get_metadata_error_tag={!r})'.format(
            self._get_metadata_error_tag_value,
        )

GetMetadataError_validator = bv.Struct(GetMetadataError)

class GetMetadataResult(bb.Struct):
    """
    :ivar cloud_docs.GetMetadataResult.title: Title of the Cloud Doc without
        extension.
    :ivar cloud_docs.GetMetadataResult.mime_type: MIME type of the Cloud Doc.
    :ivar cloud_docs.GetMetadataResult.version: Opaque string representing the
        version of the document stored in Dropbox (only set for Dropbox-stored
        Documents).
    :ivar cloud_docs.GetMetadataResult.provider_version: Application specific
        string representing the revision of a document (only set for App-stored
        Documents).
    :ivar cloud_docs.GetMetadataResult.user: User identified by the auth token.
    :ivar cloud_docs.GetMetadataResult.is_deleted: true if the document is
        deleted or purged.
    :ivar cloud_docs.GetMetadataResult.user_permissions: Actions that the user
        identified by the auth token can performn. This message will not be
        populated for deleted documents.
    """

    __slots__ = [
        '_file_id_value',
        '_file_id_present',
        '_title_value',
        '_title_present',
        '_mime_type_value',
        '_mime_type_present',
        '_version_value',
        '_version_present',
        '_provider_version_value',
        '_provider_version_present',
        '_user_value',
        '_user_present',
        '_is_deleted_value',
        '_is_deleted_present',
        '_user_permissions_value',
        '_user_permissions_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 file_id=None,
                 title=None,
                 mime_type=None,
                 version=None,
                 provider_version=None,
                 user=None,
                 is_deleted=None,
                 user_permissions=None):
        self._file_id_value = None
        self._file_id_present = False
        self._title_value = None
        self._title_present = False
        self._mime_type_value = None
        self._mime_type_present = False
        self._version_value = None
        self._version_present = False
        self._provider_version_value = None
        self._provider_version_present = False
        self._user_value = None
        self._user_present = False
        self._is_deleted_value = None
        self._is_deleted_present = False
        self._user_permissions_value = None
        self._user_permissions_present = False
        if file_id is not None:
            self.file_id = file_id
        if title is not None:
            self.title = title
        if mime_type is not None:
            self.mime_type = mime_type
        if version is not None:
            self.version = version
        if provider_version is not None:
            self.provider_version = provider_version
        if user is not None:
            self.user = user
        if is_deleted is not None:
            self.is_deleted = is_deleted
        if user_permissions is not None:
            self.user_permissions = user_permissions

    @property
    def file_id(self):
        """
        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            return u''

    @file_id.setter
    def file_id(self, val):
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    @property
    def title(self):
        """
        Title of the Cloud Doc without extension.

        :rtype: str
        """
        if self._title_present:
            return self._title_value
        else:
            return u''

    @title.setter
    def title(self, val):
        val = self._title_validator.validate(val)
        self._title_value = val
        self._title_present = True

    @title.deleter
    def title(self):
        self._title_value = None
        self._title_present = False

    @property
    def mime_type(self):
        """
        MIME type of the Cloud Doc.

        :rtype: str
        """
        if self._mime_type_present:
            return self._mime_type_value
        else:
            return u''

    @mime_type.setter
    def mime_type(self, val):
        val = self._mime_type_validator.validate(val)
        self._mime_type_value = val
        self._mime_type_present = True

    @mime_type.deleter
    def mime_type(self):
        self._mime_type_value = None
        self._mime_type_present = False

    @property
    def version(self):
        """
        Opaque string representing the version of the document stored in Dropbox
        (only set for Dropbox-stored Documents).

        :rtype: str
        """
        if self._version_present:
            return self._version_value
        else:
            return u''

    @version.setter
    def version(self, val):
        val = self._version_validator.validate(val)
        self._version_value = val
        self._version_present = True

    @version.deleter
    def version(self):
        self._version_value = None
        self._version_present = False

    @property
    def provider_version(self):
        """
        Application specific string representing the revision of a document
        (only set for App-stored Documents).

        :rtype: str
        """
        if self._provider_version_present:
            return self._provider_version_value
        else:
            return u''

    @provider_version.setter
    def provider_version(self, val):
        val = self._provider_version_validator.validate(val)
        self._provider_version_value = val
        self._provider_version_present = True

    @provider_version.deleter
    def provider_version(self):
        self._provider_version_value = None
        self._provider_version_present = False

    @property
    def user(self):
        """
        User identified by the auth token.

        :rtype: UserInfo
        """
        if self._user_present:
            return self._user_value
        else:
            return None

    @user.setter
    def user(self, val):
        if val is None:
            del self.user
            return
        self._user_validator.validate_type_only(val)
        self._user_value = val
        self._user_present = True

    @user.deleter
    def user(self):
        self._user_value = None
        self._user_present = False

    @property
    def is_deleted(self):
        """
        true if the document is deleted or purged.

        :rtype: bool
        """
        if self._is_deleted_present:
            return self._is_deleted_value
        else:
            return False

    @is_deleted.setter
    def is_deleted(self, val):
        val = self._is_deleted_validator.validate(val)
        self._is_deleted_value = val
        self._is_deleted_present = True

    @is_deleted.deleter
    def is_deleted(self):
        self._is_deleted_value = None
        self._is_deleted_present = False

    @property
    def user_permissions(self):
        """
        Actions that the user identified by the auth token can performn. This
        message will not be populated for deleted documents.

        :rtype: UserPermissions
        """
        if self._user_permissions_present:
            return self._user_permissions_value
        else:
            return None

    @user_permissions.setter
    def user_permissions(self, val):
        if val is None:
            del self.user_permissions
            return
        self._user_permissions_validator.validate_type_only(val)
        self._user_permissions_value = val
        self._user_permissions_present = True

    @user_permissions.deleter
    def user_permissions(self):
        self._user_permissions_value = None
        self._user_permissions_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GetMetadataResult, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GetMetadataResult(file_id={!r}, title={!r}, mime_type={!r}, version={!r}, provider_version={!r}, user={!r}, is_deleted={!r}, user_permissions={!r})'.format(
            self._file_id_value,
            self._title_value,
            self._mime_type_value,
            self._version_value,
            self._provider_version_value,
            self._user_value,
            self._is_deleted_value,
            self._user_permissions_value,
        )

GetMetadataResult_validator = bv.Struct(GetMetadataResult)

class LockArg(bb.Struct):
    """
    :ivar cloud_docs.LockArg.file_id: The API ID ("id:...") associated with the
        Cloud Doc
    """

    __slots__ = [
        '_file_id_value',
        '_file_id_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 file_id=None):
        self._file_id_value = None
        self._file_id_present = False
        if file_id is not None:
            self.file_id = file_id

    @property
    def file_id(self):
        """
        The API ID ("id:...") associated with the Cloud Doc

        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            return u''

    @file_id.setter
    def file_id(self, val):
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(LockArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'LockArg(file_id={!r})'.format(
            self._file_id_value,
        )

LockArg_validator = bv.Struct(LockArg)

class LockResult(bb.Struct):
    """
    :ivar cloud_docs.LockResult.expires_at: The timestamp after which the lock
        will expire, measured in seconds since 1970-01-01 00:00:00 UTC
    """

    __slots__ = [
        '_file_id_value',
        '_file_id_present',
        '_expires_at_value',
        '_expires_at_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 file_id=None,
                 expires_at=None):
        self._file_id_value = None
        self._file_id_present = False
        self._expires_at_value = None
        self._expires_at_present = False
        if file_id is not None:
            self.file_id = file_id
        if expires_at is not None:
            self.expires_at = expires_at

    @property
    def file_id(self):
        """
        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            return u''

    @file_id.setter
    def file_id(self, val):
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    @property
    def expires_at(self):
        """
        The timestamp after which the lock will expire, measured in seconds
        since 1970-01-01 00:00:00 UTC

        :rtype: int
        """
        if self._expires_at_present:
            return self._expires_at_value
        else:
            return 0

    @expires_at.setter
    def expires_at(self, val):
        val = self._expires_at_validator.validate(val)
        self._expires_at_value = val
        self._expires_at_present = True

    @expires_at.deleter
    def expires_at(self):
        self._expires_at_value = None
        self._expires_at_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(LockResult, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'LockResult(file_id={!r}, expires_at={!r})'.format(
            self._file_id_value,
            self._expires_at_value,
        )

LockResult_validator = bv.Struct(LockResult)

class LockingError(bb.Struct):

    __slots__ = [
        '_locking_error_tag_value',
        '_locking_error_tag_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 locking_error_tag=None):
        self._locking_error_tag_value = None
        self._locking_error_tag_present = False
        if locking_error_tag is not None:
            self.locking_error_tag = locking_error_tag

    @property
    def locking_error_tag(self):
        """
        :rtype: LockingErrorTagUnion
        """
        if self._locking_error_tag_present:
            return self._locking_error_tag_value
        else:
            return None

    @locking_error_tag.setter
    def locking_error_tag(self, val):
        if val is None:
            del self.locking_error_tag
            return
        self._locking_error_tag_validator.validate_type_only(val)
        self._locking_error_tag_value = val
        self._locking_error_tag_present = True

    @locking_error_tag.deleter
    def locking_error_tag(self):
        self._locking_error_tag_value = None
        self._locking_error_tag_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(LockingError, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'LockingError(locking_error_tag={!r})'.format(
            self._locking_error_tag_value,
        )

LockingError_validator = bv.Struct(LockingError)

class LockingErrorTag(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar cloud_docs.LockingErrorTag.conflict: A lock on the doc is held by
        another editor
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    conflict = None
    # Attribute is overwritten below the class definition
    other = None

    def is_conflict(self):
        """
        Check if the union tag is ``conflict``.

        :rtype: bool
        """
        return self._tag == 'conflict'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(LockingErrorTag, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'LockingErrorTag(%r, %r)' % (self._tag, self._value)

LockingErrorTag_validator = bv.Union(LockingErrorTag)

class RenameArg(bb.Struct):
    """
    :ivar cloud_docs.RenameArg.file_id: The API ID ("id:...") associated with
        the Cloud Doc
    :ivar cloud_docs.RenameArg.title: The new title of the doc, excluding
        extension
    """

    __slots__ = [
        '_file_id_value',
        '_file_id_present',
        '_title_value',
        '_title_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 file_id=None,
                 title=None):
        self._file_id_value = None
        self._file_id_present = False
        self._title_value = None
        self._title_present = False
        if file_id is not None:
            self.file_id = file_id
        if title is not None:
            self.title = title

    @property
    def file_id(self):
        """
        The API ID ("id:...") associated with the Cloud Doc

        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            return u''

    @file_id.setter
    def file_id(self, val):
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    @property
    def title(self):
        """
        The new title of the doc, excluding extension

        :rtype: str
        """
        if self._title_present:
            return self._title_value
        else:
            return u''

    @title.setter
    def title(self, val):
        val = self._title_validator.validate(val)
        self._title_value = val
        self._title_present = True

    @title.deleter
    def title(self):
        self._title_value = None
        self._title_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(RenameArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'RenameArg(file_id={!r}, title={!r})'.format(
            self._file_id_value,
            self._title_value,
        )

RenameArg_validator = bv.Struct(RenameArg)

class RenameError(bb.Struct):

    __slots__ = [
        '_rename_error_tag_value',
        '_rename_error_tag_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 rename_error_tag=None):
        self._rename_error_tag_value = None
        self._rename_error_tag_present = False
        if rename_error_tag is not None:
            self.rename_error_tag = rename_error_tag

    @property
    def rename_error_tag(self):
        """
        :rtype: RenameErrorTagUnion
        """
        if self._rename_error_tag_present:
            return self._rename_error_tag_value
        else:
            return None

    @rename_error_tag.setter
    def rename_error_tag(self, val):
        if val is None:
            del self.rename_error_tag
            return
        self._rename_error_tag_validator.validate_type_only(val)
        self._rename_error_tag_value = val
        self._rename_error_tag_present = True

    @rename_error_tag.deleter
    def rename_error_tag(self):
        self._rename_error_tag_value = None
        self._rename_error_tag_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(RenameError, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'RenameError(rename_error_tag={!r})'.format(
            self._rename_error_tag_value,
        )

RenameError_validator = bv.Struct(RenameError)

class RenameErrorTag(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar cloud_docs.RenameErrorTag.invalid_title: The supplied title is
        invalid, e.g. the length of the title is longer than max length (255
        characters); the title contains illegal characters.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    invalid_title = None
    # Attribute is overwritten below the class definition
    other = None

    def is_invalid_title(self):
        """
        Check if the union tag is ``invalid_title``.

        :rtype: bool
        """
        return self._tag == 'invalid_title'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(RenameErrorTag, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'RenameErrorTag(%r, %r)' % (self._tag, self._value)

RenameErrorTag_validator = bv.Union(RenameErrorTag)

class RenameResult(bb.Struct):
    """
    :ivar cloud_docs.RenameResult.title: The updated title of the doc without
        extension, which could be different from the supplied title in the
        request because Dropbox may remove/replace charaters that are not
        supported in Dropbox Filesystem.
    """

    __slots__ = [
        '_title_value',
        '_title_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 title=None):
        self._title_value = None
        self._title_present = False
        if title is not None:
            self.title = title

    @property
    def title(self):
        """
        The updated title of the doc without extension, which could be different
        from the supplied title in the request because Dropbox may
        remove/replace charaters that are not supported in Dropbox Filesystem.

        :rtype: str
        """
        if self._title_present:
            return self._title_value
        else:
            return u''

    @title.setter
    def title(self, val):
        val = self._title_validator.validate(val)
        self._title_value = val
        self._title_present = True

    @title.deleter
    def title(self):
        self._title_value = None
        self._title_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(RenameResult, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'RenameResult(title={!r})'.format(
            self._title_value,
        )

RenameResult_validator = bv.Struct(RenameResult)

class UnlockArg(bb.Struct):
    """
    :ivar cloud_docs.UnlockArg.file_id: The API ID ("id:...") associated with
        the Cloud Doc
    """

    __slots__ = [
        '_file_id_value',
        '_file_id_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 file_id=None):
        self._file_id_value = None
        self._file_id_present = False
        if file_id is not None:
            self.file_id = file_id

    @property
    def file_id(self):
        """
        The API ID ("id:...") associated with the Cloud Doc

        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            return u''

    @file_id.setter
    def file_id(self, val):
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UnlockArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UnlockArg(file_id={!r})'.format(
            self._file_id_value,
        )

UnlockArg_validator = bv.Struct(UnlockArg)

class UnlockResult(bb.Struct):
    """
    Empty message for unlock
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UnlockResult, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UnlockResult()'

UnlockResult_validator = bv.Struct(UnlockResult)

class UpdateContentArg(bb.Struct):
    """
    :ivar cloud_docs.UpdateContentArg.actor_tokens: A list of auth_tokens, one
        for each editor who made changes to the document since the last call to
        update_content.
    :ivar cloud_docs.UpdateContentArg.additional_contents: Currently, this will
        always be empty until we implement upload_additional_content.
    """

    __slots__ = [
        '_file_id_value',
        '_file_id_present',
        '_actor_tokens_value',
        '_actor_tokens_present',
        '_additional_contents_value',
        '_additional_contents_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 file_id=None,
                 actor_tokens=None,
                 additional_contents=None):
        self._file_id_value = None
        self._file_id_present = False
        self._actor_tokens_value = None
        self._actor_tokens_present = False
        self._additional_contents_value = None
        self._additional_contents_present = False
        if file_id is not None:
            self.file_id = file_id
        if actor_tokens is not None:
            self.actor_tokens = actor_tokens
        if additional_contents is not None:
            self.additional_contents = additional_contents

    @property
    def file_id(self):
        """
        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            raise AttributeError("missing required field 'file_id'")

    @file_id.setter
    def file_id(self, val):
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    @property
    def actor_tokens(self):
        """
        A list of auth_tokens, one for each editor who made changes to the
        document since the last call to update_content.

        :rtype: list of [str]
        """
        if self._actor_tokens_present:
            return self._actor_tokens_value
        else:
            raise AttributeError("missing required field 'actor_tokens'")

    @actor_tokens.setter
    def actor_tokens(self, val):
        val = self._actor_tokens_validator.validate(val)
        self._actor_tokens_value = val
        self._actor_tokens_present = True

    @actor_tokens.deleter
    def actor_tokens(self):
        self._actor_tokens_value = None
        self._actor_tokens_present = False

    @property
    def additional_contents(self):
        """
        Currently, this will always be empty until we implement
        upload_additional_content.

        :rtype: list of [Content]
        """
        if self._additional_contents_present:
            return self._additional_contents_value
        else:
            return None

    @additional_contents.setter
    def additional_contents(self, val):
        if val is None:
            del self.additional_contents
            return
        val = self._additional_contents_validator.validate(val)
        self._additional_contents_value = val
        self._additional_contents_present = True

    @additional_contents.deleter
    def additional_contents(self):
        self._additional_contents_value = None
        self._additional_contents_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UpdateContentArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UpdateContentArg(file_id={!r}, actor_tokens={!r}, additional_contents={!r})'.format(
            self._file_id_value,
            self._actor_tokens_value,
            self._additional_contents_value,
        )

UpdateContentArg_validator = bv.Struct(UpdateContentArg)

class UpdateContentError(CloudDocsAccessError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar cloud_docs.UpdateContentError.upload_size_too_large: Upload payload
        exceeds maximum allowed size of 150MB.
    :ivar cloud_docs.UpdateContentError.conflict: A lock on the document
        identified by path_or_id is held by another editor.
    :ivar cloud_docs.UpdateContentError.unlocked: A lock is not held on the
        document identified by path_or_id. Acquire lock before uploading content
        for the document.
    """

    # Attribute is overwritten below the class definition
    upload_size_too_large = None
    # Attribute is overwritten below the class definition
    conflict = None
    # Attribute is overwritten below the class definition
    unlocked = None

    def is_upload_size_too_large(self):
        """
        Check if the union tag is ``upload_size_too_large``.

        :rtype: bool
        """
        return self._tag == 'upload_size_too_large'

    def is_conflict(self):
        """
        Check if the union tag is ``conflict``.

        :rtype: bool
        """
        return self._tag == 'conflict'

    def is_unlocked(self):
        """
        Check if the union tag is ``unlocked``.

        :rtype: bool
        """
        return self._tag == 'unlocked'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UpdateContentError, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UpdateContentError(%r, %r)' % (self._tag, self._value)

UpdateContentError_validator = bv.Union(UpdateContentError)

class UpdateContentResult(bb.Struct):
    """
    :ivar cloud_docs.UpdateContentResult.version: Version of the document stored
        in Dropbox.
    """

    __slots__ = [
        '_version_value',
        '_version_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 version=None):
        self._version_value = None
        self._version_present = False
        if version is not None:
            self.version = version

    @property
    def version(self):
        """
        Version of the document stored in Dropbox.

        :rtype: str
        """
        if self._version_present:
            return self._version_value
        else:
            raise AttributeError("missing required field 'version'")

    @version.setter
    def version(self, val):
        val = self._version_validator.validate(val)
        self._version_value = val
        self._version_present = True

    @version.deleter
    def version(self):
        self._version_value = None
        self._version_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UpdateContentResult, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UpdateContentResult(version={!r})'.format(
            self._version_value,
        )

UpdateContentResult_validator = bv.Struct(UpdateContentResult)

class UserInfo(bb.Struct):
    """
    :ivar cloud_docs.UserInfo.id: ID associated with the user.
    :ivar cloud_docs.UserInfo.email: Email associated with the user.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_email_value',
        '_email_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 id=None,
                 email=None):
        self._id_value = None
        self._id_present = False
        self._email_value = None
        self._email_present = False
        if id is not None:
            self.id = id
        if email is not None:
            self.email = email

    @property
    def id(self):
        """
        ID associated with the user.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            return u''

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def email(self):
        """
        Email associated with the user.

        :rtype: str
        """
        if self._email_present:
            return self._email_value
        else:
            return u''

    @email.setter
    def email(self, val):
        val = self._email_validator.validate(val)
        self._email_value = val
        self._email_present = True

    @email.deleter
    def email(self):
        self._email_value = None
        self._email_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UserInfo, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UserInfo(id={!r}, email={!r})'.format(
            self._id_value,
            self._email_value,
        )

UserInfo_validator = bv.Struct(UserInfo)

class UserPermissions(bb.Struct):
    """
    :ivar cloud_docs.UserPermissions.can_edit: true if the user can edit the
        content of this document
    :ivar cloud_docs.UserPermissions.can_rename: true if the user can edit the
        title of this document
    :ivar cloud_docs.UserPermissions.can_comment: true if the user can comment
        on this document
    :ivar cloud_docs.UserPermissions.can_download: true if the user can download
        the contents of this document. currently always true if the user has
        view access to the document.
    """

    __slots__ = [
        '_can_edit_value',
        '_can_edit_present',
        '_can_rename_value',
        '_can_rename_present',
        '_can_comment_value',
        '_can_comment_present',
        '_can_download_value',
        '_can_download_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 can_edit=None,
                 can_rename=None,
                 can_comment=None,
                 can_download=None):
        self._can_edit_value = None
        self._can_edit_present = False
        self._can_rename_value = None
        self._can_rename_present = False
        self._can_comment_value = None
        self._can_comment_present = False
        self._can_download_value = None
        self._can_download_present = False
        if can_edit is not None:
            self.can_edit = can_edit
        if can_rename is not None:
            self.can_rename = can_rename
        if can_comment is not None:
            self.can_comment = can_comment
        if can_download is not None:
            self.can_download = can_download

    @property
    def can_edit(self):
        """
        true if the user can edit the content of this document

        :rtype: bool
        """
        if self._can_edit_present:
            return self._can_edit_value
        else:
            return False

    @can_edit.setter
    def can_edit(self, val):
        val = self._can_edit_validator.validate(val)
        self._can_edit_value = val
        self._can_edit_present = True

    @can_edit.deleter
    def can_edit(self):
        self._can_edit_value = None
        self._can_edit_present = False

    @property
    def can_rename(self):
        """
        true if the user can edit the title of this document

        :rtype: bool
        """
        if self._can_rename_present:
            return self._can_rename_value
        else:
            return False

    @can_rename.setter
    def can_rename(self, val):
        val = self._can_rename_validator.validate(val)
        self._can_rename_value = val
        self._can_rename_present = True

    @can_rename.deleter
    def can_rename(self):
        self._can_rename_value = None
        self._can_rename_present = False

    @property
    def can_comment(self):
        """
        true if the user can comment on this document

        :rtype: bool
        """
        if self._can_comment_present:
            return self._can_comment_value
        else:
            return False

    @can_comment.setter
    def can_comment(self, val):
        val = self._can_comment_validator.validate(val)
        self._can_comment_value = val
        self._can_comment_present = True

    @can_comment.deleter
    def can_comment(self):
        self._can_comment_value = None
        self._can_comment_present = False

    @property
    def can_download(self):
        """
        true if the user can download the contents of this document. currently
        always true if the user has view access to the document.

        :rtype: bool
        """
        if self._can_download_present:
            return self._can_download_value
        else:
            return False

    @can_download.setter
    def can_download(self, val):
        val = self._can_download_validator.validate(val)
        self._can_download_value = val
        self._can_download_present = True

    @can_download.deleter
    def can_download(self):
        self._can_download_value = None
        self._can_download_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(UserPermissions, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'UserPermissions(can_edit={!r}, can_rename={!r}, can_comment={!r}, can_download={!r})'.format(
            self._can_edit_value,
            self._can_rename_value,
            self._can_comment_value,
            self._can_download_value,
        )

UserPermissions_validator = bv.Struct(UserPermissions)

class GetMetadataErrorTagUnion(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def generic_error(cls, val):
        """
        Create an instance of this class set to the ``generic_error`` tag with
        value ``val``.

        :param GenericErrorTag val:
        :rtype: GetMetadataErrorTagUnion
        """
        return cls('generic_error', val)

    def is_generic_error(self):
        """
        Check if the union tag is ``generic_error``.

        :rtype: bool
        """
        return self._tag == 'generic_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_generic_error(self):
        """
        Only call this if :meth:`is_generic_error` is true.

        :rtype: GenericErrorTag
        """
        if not self.is_generic_error():
            raise AttributeError("tag 'generic_error' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(GetMetadataErrorTagUnion, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'GetMetadataErrorTagUnion(%r, %r)' % (self._tag, self._value)

GetMetadataErrorTagUnion_validator = bv.Union(GetMetadataErrorTagUnion)

class LockingErrorTagUnion(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def locking_error(cls, val):
        """
        Create an instance of this class set to the ``locking_error`` tag with
        value ``val``.

        :param LockingErrorTag val:
        :rtype: LockingErrorTagUnion
        """
        return cls('locking_error', val)

    @classmethod
    def generic_error(cls, val):
        """
        Create an instance of this class set to the ``generic_error`` tag with
        value ``val``.

        :param GenericErrorTag val:
        :rtype: LockingErrorTagUnion
        """
        return cls('generic_error', val)

    def is_locking_error(self):
        """
        Check if the union tag is ``locking_error``.

        :rtype: bool
        """
        return self._tag == 'locking_error'

    def is_generic_error(self):
        """
        Check if the union tag is ``generic_error``.

        :rtype: bool
        """
        return self._tag == 'generic_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_locking_error(self):
        """
        Only call this if :meth:`is_locking_error` is true.

        :rtype: LockingErrorTag
        """
        if not self.is_locking_error():
            raise AttributeError("tag 'locking_error' not set")
        return self._value

    def get_generic_error(self):
        """
        Only call this if :meth:`is_generic_error` is true.

        :rtype: GenericErrorTag
        """
        if not self.is_generic_error():
            raise AttributeError("tag 'generic_error' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(LockingErrorTagUnion, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'LockingErrorTagUnion(%r, %r)' % (self._tag, self._value)

LockingErrorTagUnion_validator = bv.Union(LockingErrorTagUnion)

class RenameErrorTagUnion(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def rename_error(cls, val):
        """
        Create an instance of this class set to the ``rename_error`` tag with
        value ``val``.

        :param RenameErrorTag val:
        :rtype: RenameErrorTagUnion
        """
        return cls('rename_error', val)

    @classmethod
    def generic_error(cls, val):
        """
        Create an instance of this class set to the ``generic_error`` tag with
        value ``val``.

        :param GenericErrorTag val:
        :rtype: RenameErrorTagUnion
        """
        return cls('generic_error', val)

    @classmethod
    def locking_error(cls, val):
        """
        Create an instance of this class set to the ``locking_error`` tag with
        value ``val``.

        :param LockingErrorTag val:
        :rtype: RenameErrorTagUnion
        """
        return cls('locking_error', val)

    def is_rename_error(self):
        """
        Check if the union tag is ``rename_error``.

        :rtype: bool
        """
        return self._tag == 'rename_error'

    def is_generic_error(self):
        """
        Check if the union tag is ``generic_error``.

        :rtype: bool
        """
        return self._tag == 'generic_error'

    def is_locking_error(self):
        """
        Check if the union tag is ``locking_error``.

        :rtype: bool
        """
        return self._tag == 'locking_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_rename_error(self):
        """
        Only call this if :meth:`is_rename_error` is true.

        :rtype: RenameErrorTag
        """
        if not self.is_rename_error():
            raise AttributeError("tag 'rename_error' not set")
        return self._value

    def get_generic_error(self):
        """
        Only call this if :meth:`is_generic_error` is true.

        :rtype: GenericErrorTag
        """
        if not self.is_generic_error():
            raise AttributeError("tag 'generic_error' not set")
        return self._value

    def get_locking_error(self):
        """
        Only call this if :meth:`is_locking_error` is true.

        :rtype: LockingErrorTag
        """
        if not self.is_locking_error():
            raise AttributeError("tag 'locking_error' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(RenameErrorTagUnion, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'RenameErrorTagUnion(%r, %r)' % (self._tag, self._value)

RenameErrorTagUnion_validator = bv.Union(RenameErrorTagUnion)

CloudDocsAccessError._invalid_doc_id_validator = bv.Void()
CloudDocsAccessError._not_found_validator = bv.Void()
CloudDocsAccessError._permission_denied_validator = bv.Void()
CloudDocsAccessError._other_validator = bv.Void()
CloudDocsAccessError._tagmap = {
    'invalid_doc_id': CloudDocsAccessError._invalid_doc_id_validator,
    'not_found': CloudDocsAccessError._not_found_validator,
    'permission_denied': CloudDocsAccessError._permission_denied_validator,
    'other': CloudDocsAccessError._other_validator,
}

CloudDocsAccessError.invalid_doc_id = CloudDocsAccessError('invalid_doc_id')
CloudDocsAccessError.not_found = CloudDocsAccessError('not_found')
CloudDocsAccessError.permission_denied = CloudDocsAccessError('permission_denied')
CloudDocsAccessError.other = CloudDocsAccessError('other')

Content._purpose_validator = ContentPurpose_validator
Content._content_key_validator = bv.String()
Content._all_field_names_ = set([
    'purpose',
    'content_key',
])
Content._all_fields_ = [
    ('purpose', Content._purpose_validator),
    ('content_key', Content._content_key_validator),
]

ContentPurpose._search_validator = bv.Void()
ContentPurpose._preview_validator = bv.Void()
ContentPurpose._other_validator = bv.Void()
ContentPurpose._tagmap = {
    'search': ContentPurpose._search_validator,
    'preview': ContentPurpose._preview_validator,
    'other': ContentPurpose._other_validator,
}

ContentPurpose.search = ContentPurpose('search')
ContentPurpose.preview = ContentPurpose('preview')
ContentPurpose.other = ContentPurpose('other')

GenericErrorTag._invalid_argument_validator = bv.Void()
GenericErrorTag._unauthenticated_validator = bv.Void()
GenericErrorTag._permission_denied_validator = bv.Void()
GenericErrorTag._doc_not_found_validator = bv.Void()
GenericErrorTag._other_validator = bv.Void()
GenericErrorTag._tagmap = {
    'invalid_argument': GenericErrorTag._invalid_argument_validator,
    'unauthenticated': GenericErrorTag._unauthenticated_validator,
    'permission_denied': GenericErrorTag._permission_denied_validator,
    'doc_not_found': GenericErrorTag._doc_not_found_validator,
    'other': GenericErrorTag._other_validator,
}

GenericErrorTag.invalid_argument = GenericErrorTag('invalid_argument')
GenericErrorTag.unauthenticated = GenericErrorTag('unauthenticated')
GenericErrorTag.permission_denied = GenericErrorTag('permission_denied')
GenericErrorTag.doc_not_found = GenericErrorTag('doc_not_found')
GenericErrorTag.other = GenericErrorTag('other')

GetContentArg._file_id_validator = files.FileId_validator
GetContentArg._all_field_names_ = set(['file_id'])
GetContentArg._all_fields_ = [('file_id', GetContentArg._file_id_validator)]

GetMetadataArg._file_id_validator = bv.String()
GetMetadataArg._all_field_names_ = set(['file_id'])
GetMetadataArg._all_fields_ = [('file_id', GetMetadataArg._file_id_validator)]

GetMetadataError._get_metadata_error_tag_validator = bv.Nullable(GetMetadataErrorTagUnion_validator)
GetMetadataError._all_field_names_ = set(['get_metadata_error_tag'])
GetMetadataError._all_fields_ = [('get_metadata_error_tag', GetMetadataError._get_metadata_error_tag_validator)]

GetMetadataResult._file_id_validator = bv.String()
GetMetadataResult._title_validator = bv.String()
GetMetadataResult._mime_type_validator = bv.String()
GetMetadataResult._version_validator = bv.String()
GetMetadataResult._provider_version_validator = bv.String()
GetMetadataResult._user_validator = bv.Nullable(UserInfo_validator)
GetMetadataResult._is_deleted_validator = bv.Boolean()
GetMetadataResult._user_permissions_validator = bv.Nullable(UserPermissions_validator)
GetMetadataResult._all_field_names_ = set([
    'file_id',
    'title',
    'mime_type',
    'version',
    'provider_version',
    'user',
    'is_deleted',
    'user_permissions',
])
GetMetadataResult._all_fields_ = [
    ('file_id', GetMetadataResult._file_id_validator),
    ('title', GetMetadataResult._title_validator),
    ('mime_type', GetMetadataResult._mime_type_validator),
    ('version', GetMetadataResult._version_validator),
    ('provider_version', GetMetadataResult._provider_version_validator),
    ('user', GetMetadataResult._user_validator),
    ('is_deleted', GetMetadataResult._is_deleted_validator),
    ('user_permissions', GetMetadataResult._user_permissions_validator),
]

LockArg._file_id_validator = bv.String()
LockArg._all_field_names_ = set(['file_id'])
LockArg._all_fields_ = [('file_id', LockArg._file_id_validator)]

LockResult._file_id_validator = bv.String()
LockResult._expires_at_validator = bv.Int64()
LockResult._all_field_names_ = set([
    'file_id',
    'expires_at',
])
LockResult._all_fields_ = [
    ('file_id', LockResult._file_id_validator),
    ('expires_at', LockResult._expires_at_validator),
]

LockingError._locking_error_tag_validator = bv.Nullable(LockingErrorTagUnion_validator)
LockingError._all_field_names_ = set(['locking_error_tag'])
LockingError._all_fields_ = [('locking_error_tag', LockingError._locking_error_tag_validator)]

LockingErrorTag._conflict_validator = bv.Void()
LockingErrorTag._other_validator = bv.Void()
LockingErrorTag._tagmap = {
    'conflict': LockingErrorTag._conflict_validator,
    'other': LockingErrorTag._other_validator,
}

LockingErrorTag.conflict = LockingErrorTag('conflict')
LockingErrorTag.other = LockingErrorTag('other')

RenameArg._file_id_validator = bv.String()
RenameArg._title_validator = bv.String()
RenameArg._all_field_names_ = set([
    'file_id',
    'title',
])
RenameArg._all_fields_ = [
    ('file_id', RenameArg._file_id_validator),
    ('title', RenameArg._title_validator),
]

RenameError._rename_error_tag_validator = bv.Nullable(RenameErrorTagUnion_validator)
RenameError._all_field_names_ = set(['rename_error_tag'])
RenameError._all_fields_ = [('rename_error_tag', RenameError._rename_error_tag_validator)]

RenameErrorTag._invalid_title_validator = bv.Void()
RenameErrorTag._other_validator = bv.Void()
RenameErrorTag._tagmap = {
    'invalid_title': RenameErrorTag._invalid_title_validator,
    'other': RenameErrorTag._other_validator,
}

RenameErrorTag.invalid_title = RenameErrorTag('invalid_title')
RenameErrorTag.other = RenameErrorTag('other')

RenameResult._title_validator = bv.String()
RenameResult._all_field_names_ = set(['title'])
RenameResult._all_fields_ = [('title', RenameResult._title_validator)]

UnlockArg._file_id_validator = bv.String()
UnlockArg._all_field_names_ = set(['file_id'])
UnlockArg._all_fields_ = [('file_id', UnlockArg._file_id_validator)]

UnlockResult._all_field_names_ = set([])
UnlockResult._all_fields_ = []

UpdateContentArg._file_id_validator = files.FileId_validator
UpdateContentArg._actor_tokens_validator = bv.List(bv.String())
UpdateContentArg._additional_contents_validator = bv.Nullable(bv.List(Content_validator))
UpdateContentArg._all_field_names_ = set([
    'file_id',
    'actor_tokens',
    'additional_contents',
])
UpdateContentArg._all_fields_ = [
    ('file_id', UpdateContentArg._file_id_validator),
    ('actor_tokens', UpdateContentArg._actor_tokens_validator),
    ('additional_contents', UpdateContentArg._additional_contents_validator),
]

UpdateContentError._upload_size_too_large_validator = bv.Void()
UpdateContentError._conflict_validator = bv.Void()
UpdateContentError._unlocked_validator = bv.Void()
UpdateContentError._tagmap = {
    'upload_size_too_large': UpdateContentError._upload_size_too_large_validator,
    'conflict': UpdateContentError._conflict_validator,
    'unlocked': UpdateContentError._unlocked_validator,
}
UpdateContentError._tagmap.update(CloudDocsAccessError._tagmap)

UpdateContentError.upload_size_too_large = UpdateContentError('upload_size_too_large')
UpdateContentError.conflict = UpdateContentError('conflict')
UpdateContentError.unlocked = UpdateContentError('unlocked')

UpdateContentResult._version_validator = bv.String()
UpdateContentResult._all_field_names_ = set(['version'])
UpdateContentResult._all_fields_ = [('version', UpdateContentResult._version_validator)]

UserInfo._id_validator = bv.String()
UserInfo._email_validator = bv.String()
UserInfo._all_field_names_ = set([
    'id',
    'email',
])
UserInfo._all_fields_ = [
    ('id', UserInfo._id_validator),
    ('email', UserInfo._email_validator),
]

UserPermissions._can_edit_validator = bv.Boolean()
UserPermissions._can_rename_validator = bv.Boolean()
UserPermissions._can_comment_validator = bv.Boolean()
UserPermissions._can_download_validator = bv.Boolean()
UserPermissions._all_field_names_ = set([
    'can_edit',
    'can_rename',
    'can_comment',
    'can_download',
])
UserPermissions._all_fields_ = [
    ('can_edit', UserPermissions._can_edit_validator),
    ('can_rename', UserPermissions._can_rename_validator),
    ('can_comment', UserPermissions._can_comment_validator),
    ('can_download', UserPermissions._can_download_validator),
]

GetMetadataErrorTagUnion._generic_error_validator = GenericErrorTag_validator
GetMetadataErrorTagUnion._other_validator = bv.Void()
GetMetadataErrorTagUnion._tagmap = {
    'generic_error': GetMetadataErrorTagUnion._generic_error_validator,
    'other': GetMetadataErrorTagUnion._other_validator,
}

GetMetadataErrorTagUnion.other = GetMetadataErrorTagUnion('other')

LockingErrorTagUnion._locking_error_validator = LockingErrorTag_validator
LockingErrorTagUnion._generic_error_validator = GenericErrorTag_validator
LockingErrorTagUnion._other_validator = bv.Void()
LockingErrorTagUnion._tagmap = {
    'locking_error': LockingErrorTagUnion._locking_error_validator,
    'generic_error': LockingErrorTagUnion._generic_error_validator,
    'other': LockingErrorTagUnion._other_validator,
}

LockingErrorTagUnion.other = LockingErrorTagUnion('other')

RenameErrorTagUnion._rename_error_validator = RenameErrorTag_validator
RenameErrorTagUnion._generic_error_validator = GenericErrorTag_validator
RenameErrorTagUnion._locking_error_validator = LockingErrorTag_validator
RenameErrorTagUnion._other_validator = bv.Void()
RenameErrorTagUnion._tagmap = {
    'rename_error': RenameErrorTagUnion._rename_error_validator,
    'generic_error': RenameErrorTagUnion._generic_error_validator,
    'locking_error': RenameErrorTagUnion._locking_error_validator,
    'other': RenameErrorTagUnion._other_validator,
}

RenameErrorTagUnion.other = RenameErrorTagUnion('other')

get_content = bb.Route(
    'get_content',
    1,
    False,
    GetContentArg_validator,
    bv.Void(),
    CloudDocsAccessError_validator,
    {'host': u'content',
     'style': u'download'},
)
get_metadata = bb.Route(
    'get_metadata',
    1,
    False,
    GetMetadataArg_validator,
    GetMetadataResult_validator,
    GetMetadataError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
lock = bb.Route(
    'lock',
    1,
    False,
    LockArg_validator,
    LockResult_validator,
    LockingError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
rename = bb.Route(
    'rename',
    1,
    False,
    RenameArg_validator,
    RenameResult_validator,
    RenameError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
unlock = bb.Route(
    'unlock',
    1,
    False,
    UnlockArg_validator,
    UnlockResult_validator,
    LockingError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
update_content = bb.Route(
    'update_content',
    1,
    False,
    UpdateContentArg_validator,
    UpdateContentResult_validator,
    UpdateContentError_validator,
    {'host': u'content',
     'style': u'upload'},
)

ROUTES = {
    'get_content': get_content,
    'get_metadata': get_metadata,
    'lock': lock,
    'rename': rename,
    'unlock': unlock,
    'update_content': update_content,
}

