/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.netbeans.lib.profiler.wireprotocol.Response;

public class MonitoredNumbersResponse
extends Response {
    public static final int FREE_MEMORY_IDX = 0;
    public static final int TOTAL_MEMORY_IDX = 1;
    public static final int USER_THREADS_IDX = 2;
    public static final int SYSTEM_THREADS_IDX = 3;
    public static final int SURVIVING_GENERATIONS_IDX = 4;
    public static final int GC_TIME_IDX = 5;
    public static final int GC_PAUSE_IDX = 6;
    public static final int LOADED_CLASSES_IDX = 7;
    public static final int CPU_TIME_IDX = 8;
    public static final int TIMESTAMP_IDX = 9;
    public static final int GENERAL_NUMBERS_SIZE = 10;
    private long[] gcFinishs;
    private long[] gcStarts;
    private long[] generalNumbers = new long[10];
    private String[] newThreadClassNames;
    private int[] newThreadIds;
    private String[] newThreadNames;
    private long[] stateTimestamps = new long[10];
    private int[] threadIds = new int[10];
    private byte[] threadStates = new byte[100];
    private int nNewThreads;
    private int nThreadStates;
    private int nThreads;
    private int[] exactThreadIds;
    private byte[] exactThreadStates;
    private long[] exactTimeStamps;
    private int mode = 0;
    private int serverState = 0;
    private int serverProgress = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MonitoredNumbersResponse(long[] lArray, int n, int n2) {
        super(true, 9);
        this.generalNumbers = lArray;
        this.nNewThreads = 0;
        this.serverState = n;
        this.serverProgress = n2;
    }

    MonitoredNumbersResponse() {
        super(true, 9);
    }

    public void setDataOnNewThreads(int n, int[] nArray, String[] stringArray, String[] stringArray2) {
        this.nNewThreads = n;
        this.newThreadIds = nArray;
        this.newThreadNames = stringArray;
        this.newThreadClassNames = stringArray2;
    }

    public void setDataOnThreads(int n, int n2, int[] nArray, long[] lArray, byte[] byArray) {
        this.mode = 1;
        this.nThreads = n;
        this.nThreadStates = n2;
        this.threadIds = nArray;
        this.stateTimestamps = lArray;
        this.threadStates = byArray;
    }

    public void setExplicitDataOnThreads(int[] nArray, byte[] byArray, long[] lArray) {
        if (!($assertionsDisabled || byArray.length == nArray.length && nArray.length == lArray.length)) {
            throw new AssertionError();
        }
        this.mode = 2;
        this.exactThreadIds = nArray;
        this.exactThreadStates = byArray;
        this.exactTimeStamps = lArray;
    }

    public long[] getGCFinishs() {
        return this.gcFinishs;
    }

    public long[] getGCStarts() {
        return this.gcStarts;
    }

    public void setGCstartFinishData(long[] lArray, long[] lArray2) {
        this.gcStarts = lArray;
        this.gcFinishs = lArray2;
    }

    public long[] getGeneralMonitoredNumbers() {
        return this.generalNumbers;
    }

    public int getNNewThreads() {
        return this.nNewThreads;
    }

    public int getNThreadStates() {
        return this.nThreadStates;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public String[] getNewThreadClassNames() {
        return this.newThreadClassNames;
    }

    public int[] getNewThreadIds() {
        return this.newThreadIds;
    }

    public String[] getNewThreadNames() {
        return this.newThreadNames;
    }

    public long[] getStateTimestamps() {
        return this.stateTimestamps;
    }

    public int[] getThreadIds() {
        return this.threadIds;
    }

    public byte[] getThreadStates() {
        return this.threadStates;
    }

    public int getThreadsDataMode() {
        return this.mode;
    }

    public int[] getExactThreadIds() {
        return this.exactThreadIds;
    }

    public byte[] getExactThreadStates() {
        return this.exactThreadStates;
    }

    public long[] getExactStateTimestamps() {
        return this.exactTimeStamps;
    }

    public int getServerState() {
        return this.serverState;
    }

    public int getServerProgress() {
        return this.serverProgress;
    }

    public String toString() {
        return super.toString() + ", mode=" + this.mode + ", serverState=" + this.serverState + ", serverProgress=" + this.serverProgress;
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        int n2;
        this.mode = objectInputStream.readInt();
        for (n2 = 0; n2 < this.generalNumbers.length; ++n2) {
            this.generalNumbers[n2] = objectInputStream.readLong();
        }
        if (this.mode == 1) {
            this.nThreads = objectInputStream.readInt();
            this.nThreadStates = objectInputStream.readInt();
            if (this.threadIds.length < this.nThreads) {
                this.threadIds = new int[this.nThreads];
            }
            if (this.stateTimestamps.length < this.nThreadStates) {
                this.stateTimestamps = new long[this.nThreadStates];
            }
            if (this.threadStates.length < (n2 = this.nThreads * this.nThreadStates)) {
                this.threadStates = new byte[n2];
            }
            for (n = 0; n < this.nThreads; ++n) {
                this.threadIds[n] = objectInputStream.readInt();
            }
            for (n = 0; n < this.nThreadStates; ++n) {
                this.stateTimestamps[n] = objectInputStream.readLong();
            }
            objectInputStream.readFully(this.threadStates, 0, n2);
        } else if (this.mode == 2) {
            n2 = objectInputStream.readInt();
            this.exactThreadIds = new int[n2];
            this.exactThreadStates = new byte[n2];
            this.exactTimeStamps = new long[n2];
            for (n = 0; n < n2; ++n) {
                this.exactThreadIds[n] = objectInputStream.readInt();
                this.exactThreadStates[n] = objectInputStream.readByte();
                this.exactTimeStamps[n] = objectInputStream.readLong();
            }
        }
        this.nNewThreads = objectInputStream.readInt();
        if (this.nNewThreads > 0) {
            if (this.newThreadIds == null || this.newThreadIds.length < this.nNewThreads) {
                this.newThreadIds = new int[this.nNewThreads];
                this.newThreadNames = new String[this.nNewThreads];
                this.newThreadClassNames = new String[this.nNewThreads];
            }
            for (n2 = 0; n2 < this.nNewThreads; ++n2) {
                this.newThreadIds[n2] = objectInputStream.readInt();
                this.newThreadNames[n2] = objectInputStream.readUTF();
                this.newThreadClassNames[n2] = objectInputStream.readUTF();
            }
        }
        int n3 = objectInputStream.readInt();
        this.gcStarts = new long[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.gcStarts[n2] = objectInputStream.readLong();
        }
        n3 = objectInputStream.readInt();
        this.gcFinishs = new long[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.gcFinishs[n2] = objectInputStream.readLong();
        }
        Arrays.sort(this.gcStarts);
        Arrays.sort(this.gcFinishs);
        this.serverState = objectInputStream.readInt();
        this.serverProgress = objectInputStream.readInt();
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.writeInt(this.mode);
        for (n = 0; n < this.generalNumbers.length; ++n) {
            objectOutputStream.writeLong(this.generalNumbers[n]);
        }
        if (this.mode == 1) {
            objectOutputStream.writeInt(this.nThreads);
            objectOutputStream.writeInt(this.nThreadStates);
            for (n = 0; n < this.nThreads; ++n) {
                objectOutputStream.writeInt(this.threadIds[n]);
            }
            for (n = 0; n < this.nThreadStates; ++n) {
                objectOutputStream.writeLong(this.stateTimestamps[n]);
            }
            n = this.nThreads * this.nThreadStates;
            objectOutputStream.write(this.threadStates, 0, n);
        } else if (this.mode == 2) {
            objectOutputStream.writeInt(this.exactThreadStates.length);
            for (n = 0; n < this.exactThreadIds.length; ++n) {
                objectOutputStream.writeInt(this.exactThreadIds[n]);
                objectOutputStream.writeByte(this.exactThreadStates[n]);
                objectOutputStream.writeLong(this.exactTimeStamps[n]);
            }
        }
        if (this.nNewThreads == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.nNewThreads);
            for (n = 0; n < this.nNewThreads; ++n) {
                objectOutputStream.writeInt(this.newThreadIds[n]);
                objectOutputStream.writeUTF(this.newThreadNames[n]);
                objectOutputStream.writeUTF(this.newThreadClassNames[n]);
            }
        }
        objectOutputStream.writeInt(this.gcStarts.length);
        for (n = 0; n < this.gcStarts.length; ++n) {
            objectOutputStream.writeLong(this.gcStarts[n]);
        }
        objectOutputStream.writeInt(this.gcFinishs.length);
        for (n = 0; n < this.gcFinishs.length; ++n) {
            objectOutputStream.writeLong(this.gcFinishs[n]);
        }
        objectOutputStream.writeInt(this.serverState);
        objectOutputStream.writeInt(this.serverProgress);
    }

    static {
        $assertionsDisabled = !MonitoredNumbersResponse.class.desiredAssertionStatus();
    }
}

