/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsMAC;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class TlsSuiteHMac
implements TlsSuiteMac {
    protected final TlsCryptoParameters cryptoParams;
    protected final TlsHMAC mac;
    protected final int digestBlockSize;
    protected final int digestOverhead;
    protected final int macSize;

    static int getMacSize(TlsCryptoParameters tlsCryptoParameters, TlsMAC tlsMAC) {
        int n = tlsMAC.getMacLength();
        if (tlsCryptoParameters.getSecurityParametersHandshake().isTruncatedHMac()) {
            n = Math.min(n, 10);
        }
        return n;
    }

    public TlsSuiteHMac(TlsCryptoParameters tlsCryptoParameters, TlsHMAC tlsHMAC) {
        this.cryptoParams = tlsCryptoParameters;
        this.mac = tlsHMAC;
        this.macSize = TlsSuiteHMac.getMacSize(tlsCryptoParameters, tlsHMAC);
        this.digestBlockSize = tlsHMAC.getInternalBlockSize();
        this.digestOverhead = this.digestBlockSize / 8;
    }

    public int getSize() {
        return this.macSize;
    }

    public byte[] calculateMac(long l, short s, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[13];
        TlsUtils.writeUint64(l, byArray2, 0);
        TlsUtils.writeUint8(s, byArray2, 8);
        TlsUtils.writeVersion(this.cryptoParams.getServerVersion(), byArray2, 9);
        TlsUtils.writeUint16(n2, byArray2, byArray2.length - 2);
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.update(byArray, n, n2);
        return this.truncate(this.mac.calculateMAC());
    }

    public byte[] calculateMacConstantTime(long l, short s, byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
        byte[] byArray3 = this.calculateMac(l, s, byArray, n, n2);
        int n4 = 13;
        int n5 = this.getDigestBlockCount(n4 + n3) - this.getDigestBlockCount(n4 + n2);
        while (--n5 >= 0) {
            this.mac.update(byArray2, 0, this.digestBlockSize);
        }
        this.mac.update(byArray2, 0, 1);
        this.mac.reset();
        return byArray3;
    }

    protected int getDigestBlockCount(int n) {
        return (n + this.digestOverhead) / this.digestBlockSize;
    }

    protected byte[] truncate(byte[] byArray) {
        if (byArray.length <= this.macSize) {
            return byArray;
        }
        return Arrays.copyOf((byte[])byArray, (int)this.macSize);
    }
}

