/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.konan.KlibModuleOriginKt;
import org.jetbrains.kotlin.library.metadata.DeserializedSourceFile;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializedPackageFragment;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\r\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0086\u0010\u001a\n\u0010\u0010\u001a\u00020\t*\u00020\u000b\u001a\n\u0010\u0011\u001a\u00020\u0002*\u00020\u0002\u001a!\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\b\b\u0000\u0010\u0014*\u00020\u000b*\u0002H\u0014H\u0000\u00a2\u0006\u0002\u0010\u0015\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0016"}, d2={"isExpectMember", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isForwardDeclarationModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Z", "isSerializableExpectClass", "sourceByIndex", "Lorg/jetbrains/kotlin/descriptors/SourceFile;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "index", "", "findPackage", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "findSourceFile", "findTopLevelDescriptor", "resolveFakeOverrideMaybeAbstract", "", "T", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Ljava/util/Set;", "ir.serialization.common"})
public final class LegacyDescriptorUtilsKt {
    public static final boolean isExpectMember(@NotNull DeclarationDescriptor $this$isExpectMember) {
        Intrinsics.checkParameterIsNotNull($this$isExpectMember, "$this$isExpectMember");
        return $this$isExpectMember instanceof MemberDescriptor && ((MemberDescriptor)$this$isExpectMember).isExpect();
    }

    public static final boolean isSerializableExpectClass(@NotNull DeclarationDescriptor $this$isSerializableExpectClass) {
        Intrinsics.checkParameterIsNotNull($this$isSerializableExpectClass, "$this$isSerializableExpectClass");
        return $this$isSerializableExpectClass instanceof ClassDescriptor && ExpectedActualDeclarationChecker.Companion.shouldGenerateExpectClass((ClassDescriptor)$this$isSerializableExpectClass);
    }

    @NotNull
    public static final PackageFragmentDescriptor findPackage(@NotNull DeclarationDescriptor $this$findPackage) {
        while (true) {
            Intrinsics.checkParameterIsNotNull($this$findPackage, "$this$findPackage");
            if ($this$findPackage instanceof PackageFragmentDescriptor) break;
            if ($this$findPackage.getContainingDeclaration() == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull($this$findPackage, "this.containingDeclaration!!");
        }
        return (PackageFragmentDescriptor)$this$findPackage;
    }

    @NotNull
    public static final DeclarationDescriptor findTopLevelDescriptor(@NotNull DeclarationDescriptor $this$findTopLevelDescriptor) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull($this$findTopLevelDescriptor, "$this$findTopLevelDescriptor");
        if ($this$findTopLevelDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            declarationDescriptor = org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt.getPropertyIfAccessor($this$findTopLevelDescriptor);
        } else {
            DeclarationDescriptor declarationDescriptor2 = $this$findTopLevelDescriptor.getContainingDeclaration();
            if (declarationDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "this.containingDeclaration!!");
            declarationDescriptor = LegacyDescriptorUtilsKt.findTopLevelDescriptor(declarationDescriptor2);
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final <T extends CallableMemberDescriptor> Set<T> resolveFakeOverrideMaybeAbstract(@NotNull T $this$resolveFakeOverrideMaybeAbstract) {
        Set<CallableMemberDescriptor> filtered;
        Intrinsics.checkParameterIsNotNull($this$resolveFakeOverrideMaybeAbstract, "$this$resolveFakeOverrideMaybeAbstract");
        CallableMemberDescriptor.Kind kind = $this$resolveFakeOverrideMaybeAbstract.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)kind, "this.kind");
        if (kind.isReal()) {
            return SetsKt.setOf($this$resolveFakeOverrideMaybeAbstract);
        }
        Set<CallableMemberDescriptor> set = OverridingUtil.getOverriddenDeclarations($this$resolveFakeOverrideMaybeAbstract);
        Intrinsics.checkExpressionValueIsNotNull(set, "OverridingUtil.getOverriddenDeclarations(this)");
        Set<CallableMemberDescriptor> overridden = set;
        Set<CallableMemberDescriptor> set2 = OverridingUtil.filterOutOverridden(overridden);
        Intrinsics.checkExpressionValueIsNotNull(set2, "OverridingUtil.filterOutOverridden(overridden)");
        Set<CallableMemberDescriptor> set3 = filtered = set2;
        if (set3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<T>");
        }
        return set3;
    }

    public static final boolean isForwardDeclarationModule(@NotNull ModuleDescriptor $this$isForwardDeclarationModule) {
        Intrinsics.checkParameterIsNotNull($this$isForwardDeclarationModule, "$this$isForwardDeclarationModule");
        return Intrinsics.areEqual($this$isForwardDeclarationModule.getName(), Name.special("<forward declarations>"));
    }

    private static final SourceFile sourceByIndex(CallableMemberDescriptor descriptor2, int index2) {
        String fileName;
        PackageFragmentDescriptor packageFragmentDescriptor = LegacyDescriptorUtilsKt.findPackage(descriptor2);
        if (packageFragmentDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializedPackageFragment");
        }
        KlibMetadataDeserializedPackageFragment fragment = (KlibMetadataDeserializedPackageFragment)packageFragmentDescriptor;
        ProtoBuf.StringTable stringTable = fragment.getProto().getStrings();
        Intrinsics.checkExpressionValueIsNotNull(stringTable, "fragment.proto.strings");
        String string2 = fileName = (String)stringTable.getStringList().get(index2);
        Intrinsics.checkExpressionValueIsNotNull(string2, "fileName");
        return new DeserializedSourceFile(string2, KlibModuleOriginKt.getKotlinLibrary(DescriptorUtilsKt.getModule(descriptor2)));
    }

    @NotNull
    public static final SourceFile findSourceFile(@NotNull CallableMemberDescriptor $this$findSourceFile) {
        SourceFile sourceFile;
        Intrinsics.checkParameterIsNotNull($this$findSourceFile, "$this$findSourceFile");
        SourceElement sourceElement = $this$findSourceFile.getSource();
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "this.source");
        SourceFile sourceFile2 = sourceElement.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull(sourceFile2, "this.source.containingFile");
        SourceFile source = sourceFile2;
        if (Intrinsics.areEqual(source, SourceFile.NO_SOURCE_FILE) ^ true) {
            return source;
        }
        if ($this$findSourceFile instanceof DeserializedSimpleFunctionDescriptor && ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.functionFile)) {
            Integer n = ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.functionFile);
            Intrinsics.checkExpressionValueIsNotNull(n, "proto.getExtension(KlibM\u2026ataProtoBuf.functionFile)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)n).intValue());
        } else if ($this$findSourceFile instanceof DeserializedPropertyDescriptor && ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.propertyFile)) {
            Integer n = ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.propertyFile);
            Intrinsics.checkExpressionValueIsNotNull(n, "proto.getExtension(KlibM\u2026ataProtoBuf.propertyFile)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)n).intValue());
        } else {
            boolean bl = false;
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return sourceFile;
    }
}

