
#ifndef KNEWSTUFF_EXPORT_H
#define KNEWSTUFF_EXPORT_H

#ifdef KNEWSTUFF_STATIC_DEFINE
#  define KNEWSTUFF_EXPORT
#  define KNEWSTUFF_NO_EXPORT
#else
#  ifndef KNEWSTUFF_EXPORT
#    ifdef KF5NewStuff_EXPORTS
        /* We are building this library */
#      define KNEWSTUFF_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KNEWSTUFF_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KNEWSTUFF_NO_EXPORT
#    define KNEWSTUFF_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KNEWSTUFF_DECL_DEPRECATED
#  define KNEWSTUFF_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KNEWSTUFF_DECL_DEPRECATED_EXPORT
#  define KNEWSTUFF_DECL_DEPRECATED_EXPORT KNEWSTUFF_EXPORT KNEWSTUFF_DECL_DEPRECATED
#endif

#ifndef KNEWSTUFF_DECL_DEPRECATED_NO_EXPORT
#  define KNEWSTUFF_DECL_DEPRECATED_NO_EXPORT KNEWSTUFF_NO_EXPORT KNEWSTUFF_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KNEWSTUFF_NO_DEPRECATED
#    define KNEWSTUFF_NO_DEPRECATED
#  endif
#endif

#define KNEWSTUFF_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KNEWSTUFF_NO_DEPRECATED) && !defined(KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KNEWSTUFF_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KNEWSTUFF_NO_DEPRECATED_WARNINGS) && !defined(KNEWSTUFF_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KNEWSTUFF_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KNEWSTUFF_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KNEWSTUFF_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KNEWSTUFF_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KNEWSTUFF_NO_DEPRECATED)
#  undef KNEWSTUFF_DEPRECATED
#  define KNEWSTUFF_DEPRECATED_EXPORT KNEWSTUFF_EXPORT
#  define KNEWSTUFF_DEPRECATED_NO_EXPORT KNEWSTUFF_NO_EXPORT
#elif defined(KNEWSTUFF_NO_DEPRECATED_WARNINGS)
#  define KNEWSTUFF_DEPRECATED
#  define KNEWSTUFF_DEPRECATED_EXPORT KNEWSTUFF_EXPORT
#  define KNEWSTUFF_DEPRECATED_NO_EXPORT KNEWSTUFF_NO_EXPORT
#else
#  define KNEWSTUFF_DEPRECATED KNEWSTUFF_DECL_DEPRECATED
#  define KNEWSTUFF_DEPRECATED_EXPORT KNEWSTUFF_DECL_DEPRECATED_EXPORT
#  define KNEWSTUFF_DEPRECATED_NO_EXPORT KNEWSTUFF_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KNEWSTUFF_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KNEWSTUFF_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KNEWSTUFF_NO_DEPRECATED
#  define KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT 0x54700
#endif
#ifdef KNEWSTUFF_NO_DEPRECATED_WARNINGS
#  define KNEWSTUFF_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KNEWSTUFF_DEPRECATED_WARNINGS_SINCE
#  ifdef KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KNEWSTUFF_DEPRECATED_WARNINGS_SINCE KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KNEWSTUFF_DEPRECATED_WARNINGS_SINCE 0x54700
#  endif
#endif

#ifndef KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KNEWSTUFF_DEPRECATED
#  define KNEWSTUFF_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KNEWSTUFF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KNEWSTUFF_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KNEWSTUFF_DEPRECATED_WARNINGS_SINCE >= 0x51d00
#  define KNEWSTUFF_DEPRECATED_VERSION_5_29(text) KNEWSTUFF_DECL_DEPRECATED_TEXT(text)
#else
#  define KNEWSTUFF_DEPRECATED_VERSION_5_29(text)
#endif
#define KNEWSTUFF_DEPRECATED_VERSION_5(minor, text)      KNEWSTUFF_DEPRECATED_VERSION_5_##minor(text)
#define KNEWSTUFF_DEPRECATED_VERSION(major, minor, text) KNEWSTUFF_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KNEWSTUFF_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KNEWSTUFF_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)

#endif /* KNEWSTUFF_EXPORT_H */
